/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.advisors;

import com.lowagie.text.DocumentException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.events.QueryEncoderBackend;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.FreeTime;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.base.BaseAdvisorCourseRequest;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.advisors.AdvisorConfirmationPDF;
import org.unitime.timetable.onlinesectioning.custom.CriticalCoursesProvider;
import org.unitime.timetable.onlinesectioning.custom.CustomCriticalCoursesHolder;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;

public class AdvisorCourseRequestsSubmit
implements OnlineSectioningAction<OnlineSectioningInterface.AdvisorCourseRequestSubmission> {
    private static final long serialVersionUID = 1L;
    protected static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    protected static StudentSectioningConstants CONST = Localization.create(StudentSectioningConstants.class);
    private OnlineSectioningInterface.AdvisingStudentDetails iDetails;

    public AdvisorCourseRequestsSubmit withDetails(OnlineSectioningInterface.AdvisingStudentDetails details) {
        this.iDetails = details;
        return this;
    }

    public OnlineSectioningInterface.AdvisingStudentDetails getDetails() {
        return this.iDetails;
    }

    @Override
    public OnlineSectioningInterface.AdvisorCourseRequestSubmission execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        try {
            OnlineSectioningInterface.AdvisorCourseRequestSubmission ret = new OnlineSectioningInterface.AdvisorCourseRequestSubmission();
            ret.setName("crf-" + server.getAcademicSession().getTerm() + server.getAcademicSession().getYear() + "-" + this.getDetails().getStudentName().replaceAll("[&$\\+,/:;=\\?@<>\\[\\]\\{\\}\\|\\^\\~%#`\\t\\s\\n\\r \\\\]", "") + "-" + this.getDetails().getStudentExternalId());
            ret.setLink("export?q=" + QueryEncoderBackend.encode("output=acrf.pdf&sid=" + server.getAcademicSession().getUniqueId() + "&user=" + helper.getUser().getExternalId() + "&id=" + this.getDetails().getStudentExternalId()));
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getDetails().getStudentId()).setExternalId(this.getDetails().getStudentExternalId()).setName(this.getDetails().getStudentName()));
            if (this.getDetails().getStatus() != null && this.getDetails().getStatus().getUniqueId() != null) {
                action.addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getDetails().getStatus().getUniqueId()).setName(this.getDetails().getStatus().getLabel()).setExternalId(this.getDetails().getStatus().getReference()).setType(OnlineSectioningLog.Entity.EntityType.OTHER));
            }
            if (this.getDetails().getRequest() != null) {
                for (OnlineSectioningLog.Request r : OnlineSectioningHelper.toProto(this.getDetails().getRequest())) {
                    action.addRecommendation(r);
                }
            }
            boolean reCheckStudent = false;
            if (this.getDetails().isCanUpdate()) {
                Date ts = new Date();
                OnlineSectioningServer.Lock lock = server.lockStudent(this.getDetails().getStudentId(), null, this.name());
                try {
                    helper.beginTransaction();
                    XStudent student = server.getStudent(this.getDetails().getStudentId());
                    Student dbStudent = (Student)StudentDAO.getInstance().get(this.getDetails().getStudentId(), helper.getHibSession());
                    if (dbStudent != null) {
                        CriticalCoursesProvider.CriticalCourses critical = null;
                        try {
                            if (CustomCriticalCoursesHolder.hasProvider()) {
                                critical = CustomCriticalCoursesHolder.getProvider().getCriticalCourses(server, helper, new XStudentId(dbStudent, helper));
                            }
                        }
                        catch (Exception e) {
                            helper.warn("Failed to lookup critical courses: " + e.getMessage(), e);
                        }
                        if (critical != null && critical instanceof CriticalCoursesProvider.AdvisorCriticalCourses) {
                            reCheckStudent = true;
                        }
                        ArrayList<AdvisorCourseRequest> acrs = new ArrayList<AdvisorCourseRequest>();
                        if (dbStudent.getAdvisorCourseRequests() == null) {
                            dbStudent.setAdvisorCourseRequests(new HashSet<AdvisorCourseRequest>());
                        } else {
                            acrs.addAll(dbStudent.getAdvisorCourseRequests());
                            Collections.sort(acrs);
                        }
                        if (this.getDetails().getRequest() != null) {
                            AdvisorCourseRequest adept;
                            Iterator<Object> i;
                            XCourseId course;
                            AdvisorCourseRequest adept2;
                            Iterator i2;
                            AdvisorCourseRequest acr;
                            int priority = 0;
                            for (CourseRequestInterface.Request request : this.getDetails().getRequest().getCourses()) {
                                if (request.hasRequestedCourse()) {
                                    int alt = 0;
                                    for (CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                                        if (rc.isFreeTime()) {
                                            for (CourseRequestInterface.FreeTime ft : rc.getFreeTime()) {
                                                BaseAdvisorCourseRequest acr2 = null;
                                                Iterator i3 = acrs.iterator();
                                                while (i3.hasNext()) {
                                                    AdvisorCourseRequest adept3 = (AdvisorCourseRequest)i3.next();
                                                    if (adept3.getFreeTime() == null) continue;
                                                    acr2 = adept3;
                                                    i3.remove();
                                                    break;
                                                }
                                                if (acr2 == null) {
                                                    acr2 = new AdvisorCourseRequest();
                                                    acr2.setStudent(dbStudent);
                                                    acr2.setChangedBy(helper.getUser().getExternalId());
                                                    acr2.setTimestamp(ts);
                                                    dbStudent.getAdvisorCourseRequests().add((AdvisorCourseRequest)acr2);
                                                } else if (acr2.getPreferences() != null) {
                                                    acr2.getPreferences().clear();
                                                }
                                                FreeTime free = acr2.getFreeTime();
                                                if (free == null) {
                                                    free = new FreeTime();
                                                    acr2.setFreeTime(free);
                                                }
                                                free.setCategory(0);
                                                free.setDayCode(DayCode.toInt(DayCode.toDayCodes(ft.getDays())));
                                                free.setStartSlot(ft.getStart());
                                                free.setLength(ft.getLength());
                                                free.setSession(dbStudent.getSession());
                                                free.setName(ft.toString());
                                                acr2.setCourseOffering(null);
                                                acr2.setCourse(CONST.freePrefix() + ft.toString(CONST.shortDays(), CONST.useAmPm()));
                                                acr2.setPriority(priority);
                                                acr2.setAlternative(alt);
                                                acr2.setSubstitute(false);
                                                acr2.setWaitlist(null);
                                                acr2.setNoSub(null);
                                                if (alt == 0) {
                                                    acr2.setCredit(request.getAdvisorCredit());
                                                    acr2.setNotes(request.getAdvisorNote());
                                                } else {
                                                    acr2.setCredit(null);
                                                    acr2.setNotes(null);
                                                }
                                                acr2.setCritical(0);
                                                helper.getHibSession().saveOrUpdate((Object)free);
                                                helper.getHibSession().saveOrUpdate((Object)acr2);
                                                ++alt;
                                            }
                                            continue;
                                        }
                                        acr = null;
                                        i2 = acrs.iterator();
                                        while (i2.hasNext()) {
                                            adept2 = (AdvisorCourseRequest)i2.next();
                                            if (rc.hasCourseId() && adept2.getCourseOffering() != null && rc.getCourseId().equals(adept2.getCourseOffering().getUniqueId())) {
                                                acr = adept2;
                                                i2.remove();
                                                break;
                                            }
                                            if (rc.hasCourseId() || adept2.getCourseOffering() != null || !rc.getCourseName().equals(adept2.getCourse())) continue;
                                            acr = adept2;
                                            i2.remove();
                                            break;
                                        }
                                        if (acr == null) {
                                            acr = new AdvisorCourseRequest();
                                            acr.setStudent(dbStudent);
                                            acr.setChangedBy(helper.getUser().getExternalId());
                                            acr.setTimestamp(ts);
                                            dbStudent.getAdvisorCourseRequests().add(acr);
                                        }
                                        acr.setCourseOffering(rc.hasCourseId() ? (CourseOffering)CourseOfferingDAO.getInstance().get(rc.getCourseId(), helper.getHibSession()) : null);
                                        if (acr.getCourseOffering() != null && !acr.getCourseOffering().getInstructionalOffering().getSessionId().equals(server.getAcademicSession().getUniqueId())) {
                                            course = server.getCourse(acr.getCourseOffering().getCourseName());
                                            helper.warn(acr.getCourseOffering().getCourseName() + " is from a wrong academic session" + (course == null ? ", course link removed." : ", found " + course.getCourseName() + " instead."));
                                            acr.setCourseOffering(course == null ? null : (CourseOffering)CourseOfferingDAO.getInstance().get(course.getCourseId(), helper.getHibSession()));
                                        }
                                        acr.setCourse(rc.getCourseName());
                                        acr.setPriority(priority);
                                        acr.setAlternative(alt);
                                        acr.setSubstitute(false);
                                        if (acr.getFreeTime() != null) {
                                            helper.getHibSession().delete((Object)acr.getFreeTime());
                                            acr.setFreeTime(null);
                                        }
                                        if (alt == 0) {
                                            acr.setCredit(request.getAdvisorCredit());
                                            acr.setNotes(request.getAdvisorNote());
                                            if (request.hasWaitList()) {
                                                acr.setWaitlist(request.isWaitList());
                                            } else {
                                                acr.setWaitlist(null);
                                            }
                                            if (request.hasNoSub()) {
                                                acr.setNoSub(request.isNoSub());
                                            } else {
                                                acr.setNoSub(null);
                                            }
                                        } else {
                                            acr.setCredit(null);
                                            acr.setNotes(null);
                                            acr.setWaitlist(null);
                                            acr.setNoSub(null);
                                        }
                                        if (this.iDetails.hasCriticalCheck()) {
                                            if (alt == 0) {
                                                acr.setCritical(request.getCritical());
                                            } else {
                                                acr.setCritical(null);
                                            }
                                        } else {
                                            acr.setCritical(acr.isCritical(critical));
                                        }
                                        acr.updatePreferences(rc, helper.getHibSession());
                                        helper.getHibSession().saveOrUpdate((Object)acr);
                                        ++alt;
                                    }
                                } else {
                                    BaseAdvisorCourseRequest acr3 = null;
                                    i = acrs.iterator();
                                    while (i.hasNext()) {
                                        adept = (AdvisorCourseRequest)i.next();
                                        if (adept.getCourseOffering() != null || adept.getFreeTime() != null || adept.getCourse() != null) continue;
                                        acr3 = adept;
                                        i.remove();
                                        break;
                                    }
                                    if (acr3 == null) {
                                        acr3 = new AdvisorCourseRequest();
                                        acr3.setStudent(dbStudent);
                                        dbStudent.getAdvisorCourseRequests().add((AdvisorCourseRequest)acr3);
                                    } else if (acr3.getPreferences() != null) {
                                        acr3.getPreferences().clear();
                                    }
                                    if (acr3.getFreeTime() != null) {
                                        helper.getHibSession().delete((Object)acr3.getFreeTime());
                                        acr3.setFreeTime(null);
                                    }
                                    acr3.setFreeTime(null);
                                    acr3.setCourse(null);
                                    acr3.setCourseOffering(null);
                                    acr3.setPriority(priority);
                                    acr3.setAlternative(0);
                                    acr3.setSubstitute(false);
                                    acr3.setCredit(request.getAdvisorCredit());
                                    acr3.setNotes(request.getAdvisorNote());
                                    acr3.setChangedBy(helper.getUser().getExternalId());
                                    acr3.setTimestamp(ts);
                                    acr3.setCritical(0);
                                    acr3.setWaitlist(null);
                                    acr3.setNoSub(null);
                                    helper.getHibSession().saveOrUpdate((Object)acr3);
                                }
                                ++priority;
                            }
                            for (CourseRequestInterface.Request request : this.getDetails().getRequest().getAlternatives()) {
                                if (request.hasRequestedCourse()) {
                                    int alt = 0;
                                    for (CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                                        acr = null;
                                        i2 = acrs.iterator();
                                        while (i2.hasNext()) {
                                            adept2 = (AdvisorCourseRequest)i2.next();
                                            if (rc.hasCourseId() && adept2.getCourseOffering() != null && rc.getCourseId().equals(adept2.getCourseOffering().getUniqueId())) {
                                                acr = adept2;
                                                i2.remove();
                                                break;
                                            }
                                            if (rc.hasCourseId() || adept2.getCourseOffering() != null || !rc.getCourseName().equals(adept2.getCourse())) continue;
                                            acr = adept2;
                                            i2.remove();
                                            break;
                                        }
                                        if (acr == null) {
                                            acr = new AdvisorCourseRequest();
                                            acr.setStudent(dbStudent);
                                            acr.setChangedBy(helper.getUser().getExternalId());
                                            acr.setTimestamp(ts);
                                            dbStudent.getAdvisorCourseRequests().add(acr);
                                        }
                                        acr.setCourseOffering(rc.hasCourseId() ? (CourseOffering)CourseOfferingDAO.getInstance().get(rc.getCourseId(), helper.getHibSession()) : null);
                                        if (acr.getCourseOffering() != null && !acr.getCourseOffering().getInstructionalOffering().getSessionId().equals(server.getAcademicSession().getUniqueId())) {
                                            course = server.getCourse(acr.getCourseOffering().getCourseName());
                                            helper.warn(acr.getCourseOffering().getCourseName() + " is from a wrong academic session" + (course == null ? ", course link removed." : ", found " + course.getCourseName() + " instead."));
                                            acr.setCourseOffering(course == null ? null : (CourseOffering)CourseOfferingDAO.getInstance().get(course.getCourseId(), helper.getHibSession()));
                                        }
                                        acr.setCourse(rc.getCourseName());
                                        acr.setPriority(priority);
                                        acr.setAlternative(alt);
                                        acr.setSubstitute(true);
                                        if (alt == 0) {
                                            acr.setCredit(request.getAdvisorCredit());
                                            acr.setNotes(request.getAdvisorNote());
                                        } else {
                                            acr.setCredit(null);
                                            acr.setNotes(null);
                                        }
                                        if (acr.getFreeTime() != null) {
                                            helper.getHibSession().delete((Object)acr.getFreeTime());
                                            acr.setFreeTime(null);
                                        }
                                        if (this.iDetails.hasCriticalCheck()) {
                                            if (alt == 0) {
                                                acr.setCritical(request.getCritical());
                                            } else {
                                                acr.setCritical(null);
                                            }
                                        } else {
                                            acr.setCritical(acr.isCritical(critical));
                                        }
                                        acr.setWaitlist(null);
                                        acr.setNoSub(null);
                                        acr.updatePreferences(rc, helper.getHibSession());
                                        helper.getHibSession().saveOrUpdate((Object)acr);
                                        ++alt;
                                    }
                                } else {
                                    BaseAdvisorCourseRequest acr4 = null;
                                    i = acrs.iterator();
                                    while (i.hasNext()) {
                                        adept = (AdvisorCourseRequest)i.next();
                                        if (adept.getCourseOffering() != null || adept.getFreeTime() != null || adept.getCourse() != null) continue;
                                        acr4 = adept;
                                        i.remove();
                                        break;
                                    }
                                    if (acr4 == null) {
                                        acr4 = new AdvisorCourseRequest();
                                        acr4.setStudent(dbStudent);
                                        dbStudent.getAdvisorCourseRequests().add((AdvisorCourseRequest)acr4);
                                    } else if (acr4.getPreferences() != null) {
                                        acr4.getPreferences().clear();
                                    }
                                    if (acr4.getFreeTime() != null) {
                                        helper.getHibSession().delete((Object)acr4.getFreeTime());
                                        acr4.setFreeTime(null);
                                    }
                                    acr4.setCourse(null);
                                    acr4.setCourseOffering(null);
                                    acr4.setPriority(priority);
                                    acr4.setAlternative(0);
                                    acr4.setSubstitute(true);
                                    acr4.setCredit(request.getAdvisorCredit());
                                    acr4.setNotes(request.getAdvisorNote());
                                    acr4.setChangedBy(helper.getUser().getExternalId());
                                    acr4.setTimestamp(ts);
                                    acr4.setCritical(0);
                                    acr4.setWaitlist(null);
                                    acr4.setNoSub(null);
                                    helper.getHibSession().saveOrUpdate((Object)acr4);
                                }
                                ++priority;
                            }
                            if (this.getDetails().getRequest().hasCreditNote()) {
                                AdvisorCourseRequest acr5 = null;
                                Iterator i4 = acrs.iterator();
                                while (i4.hasNext()) {
                                    AdvisorCourseRequest adept4 = (AdvisorCourseRequest)i4.next();
                                    if (adept4.getPriority() != -1) continue;
                                    acr5 = adept4;
                                    i4.remove();
                                    break;
                                }
                                if (acr5 == null) {
                                    acr5 = new AdvisorCourseRequest();
                                    acr5.setStudent(dbStudent);
                                    dbStudent.getAdvisorCourseRequests().add(acr5);
                                } else if (acr5.getPreferences() != null) {
                                    acr5.getPreferences().clear();
                                }
                                if (acr5.getFreeTime() != null) {
                                    helper.getHibSession().delete((Object)acr5.getFreeTime());
                                    acr5.setFreeTime(null);
                                }
                                acr5.setCourse(null);
                                acr5.setCourseOffering(null);
                                acr5.setPriority(-1);
                                acr5.setAlternative(0);
                                acr5.setSubstitute(false);
                                acr5.setCredit(null);
                                acr5.setNotes(this.getDetails().getRequest().getCreditNote());
                                acr5.setChangedBy(helper.getUser().getExternalId());
                                acr5.setTimestamp(ts);
                                acr5.setCritical(0);
                                acr5.setWaitlist(null);
                                acr5.setNoSub(null);
                                helper.getHibSession().saveOrUpdate((Object)acr5);
                            }
                        }
                        for (AdvisorCourseRequest acr5 : acrs) {
                            if (acr5.getFreeTime() != null) {
                                helper.getHibSession().delete((Object)acr5.getFreeTime());
                            }
                            helper.getHibSession().delete((Object)acr5);
                            dbStudent.getAdvisorCourseRequests().remove(acr5);
                        }
                        if (this.getDetails().getStatus() != null && student != null) {
                            String current;
                            String string = current = student.getStatus() == null ? "" : student.getStatus();
                            if (!this.getDetails().getStatus().getReference().equals(current)) {
                                String newStatus;
                                String oldStatus;
                                StudentSectioningStatus status;
                                StudentSectioningStatus studentSectioningStatus = status = this.getDetails().getStatus().getReference().isEmpty() ? null : StudentSectioningStatus.getStatus(this.getDetails().getStatus().getReference(), server.getAcademicSession().getUniqueId(), helper.getHibSession());
                                String string2 = dbStudent.getSectioningStatus() != null ? dbStudent.getSectioningStatus().getReference() : (oldStatus = dbStudent.getSession().getDefaultSectioningStatus() != null ? MSG.studentStatusSessionDefault(dbStudent.getSession().getDefaultSectioningStatus().getReference()) : MSG.studentStatusSystemDefault());
                                if (dbStudent.getSectioningStatus() != null) {
                                    action.addOptionBuilder().setKey("old-status").setValue(dbStudent.getSectioningStatus().getReference());
                                }
                                student.setStatus(status == null ? null : status.getReference());
                                dbStudent.setSectioningStatus(status);
                                String string3 = dbStudent.getSectioningStatus() != null ? dbStudent.getSectioningStatus().getReference() : (newStatus = dbStudent.getSession().getDefaultSectioningStatus() != null ? MSG.studentStatusSessionDefault(dbStudent.getSession().getDefaultSectioningStatus().getReference()) : MSG.studentStatusSystemDefault());
                                if (dbStudent.getSectioningStatus() != null) {
                                    action.addOptionBuilder().setKey("new-status").setValue(dbStudent.getSectioningStatus().getReference());
                                }
                                if (oldStatus.equals(newStatus)) {
                                    action.addMessage(OnlineSectioningLog.Message.newBuilder().setText(oldStatus).setTimeStamp(ts.getTime()).setLevel(OnlineSectioningLog.Message.Level.INFO));
                                } else {
                                    action.addMessage(OnlineSectioningLog.Message.newBuilder().setText(oldStatus + " &rarr; " + newStatus).setTimeStamp(ts.getTime()).setLevel(OnlineSectioningLog.Message.Level.INFO));
                                }
                                helper.getHibSession().saveOrUpdate((Object)dbStudent);
                                action.setResult(OnlineSectioningLog.Action.ResultType.TRUE);
                            } else {
                                action.setResult(OnlineSectioningLog.Action.ResultType.FALSE);
                            }
                        }
                        if (this.getDetails().getRequest().hasPin()) {
                            student.setPinReleased(this.getDetails().getRequest().isPinReleased());
                            student.setPin(this.getDetails().getRequest().getPin());
                            dbStudent.setPinReleased(this.getDetails().getRequest().isPinReleased());
                            dbStudent.setPin(this.getDetails().getRequest().getPin());
                            action.addOptionBuilder().setKey("PIN").setValue(this.getDetails().getRequest().getPin() + (this.getDetails().getRequest().isPinReleased() ? "" : " NOT RELEASED"));
                            helper.getHibSession().saveOrUpdate((Object)dbStudent);
                        }
                        if (student != null) {
                            student.setAdvisorRequests(dbStudent, helper, server.getAcademicSession().getFreeTimePattern());
                            server.update(student, false);
                        }
                        ret.setName("crf-" + server.getAcademicSession().getTerm() + server.getAcademicSession().getYear() + "-" + dbStudent.getLastName() + (dbStudent.getFirstName() == null ? "" : "-" + dbStudent.getFirstName()) + (dbStudent.getMiddleName() == null ? "" : "-" + dbStudent.getMiddleName()) + "-" + dbStudent.getExternalUniqueId());
                    }
                    helper.commitTransaction();
                    ret.setUpdated(true);
                }
                catch (Exception e) {
                    helper.rollbackTransaction();
                    if (e instanceof SectioningException) {
                        throw (SectioningException)e;
                    }
                    throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                }
                finally {
                    lock.release();
                }
            }
            if (reCheckStudent) {
                server.execute(server.createAction(CustomCriticalCoursesHolder.CheckCriticalCourses.class).forStudents(this.getDetails().getStudentId()), helper.getUser(), new OnlineSectioningServer.ServerCallback<Boolean>(){

                    @Override
                    public void onFailure(Throwable exception) {
                    }

                    @Override
                    public void onSuccess(Boolean result) {
                    }
                });
            }
            this.generatePdfConfirmation(ret, server, helper);
            return ret;
        }
        catch (Exception e) {
            helper.error("Failed to produce confirmation PDF: " + e.getMessage(), e);
            throw new SectioningException("Failed to produce confirmation PDF: " + e.getMessage(), e);
        }
    }

    protected void generatePdfConfirmation(OnlineSectioningInterface.AdvisorCourseRequestSubmission ret, OnlineSectioningServer server, OnlineSectioningHelper helper) throws IOException, DocumentException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new AdvisorConfirmationPDF(this.getDetails()).generatePdfConfirmation(out);
        ret.setPdf(out.toByteArray());
    }

    @Override
    public String name() {
        return "advisor-submit";
    }
}

