/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.EventServiceProvider;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.NonUniversityLocationPicture;
import org.unitime.timetable.model.RoomType;

public abstract class BaseNonUniversityLocation
extends Location
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String iName;
    private RoomType iRoomType;
    private Set<NonUniversityLocationPicture> iPictures;
    private Set<EventServiceProvider> iAllowedServices;
    public static String PROP_NAME = "name";

    public BaseNonUniversityLocation() {
        this.initialize();
    }

    public BaseNonUniversityLocation(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    @Override
    protected void initialize() {
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Override
    public RoomType getRoomType() {
        return this.iRoomType;
    }

    @Override
    public void setRoomType(RoomType roomType) {
        this.iRoomType = roomType;
    }

    public Set<NonUniversityLocationPicture> getPictures() {
        return this.iPictures;
    }

    public void setPictures(Set<NonUniversityLocationPicture> pictures) {
        this.iPictures = pictures;
    }

    public void addTopictures(NonUniversityLocationPicture nonUniversityLocationPicture) {
        if (this.iPictures == null) {
            this.iPictures = new HashSet<NonUniversityLocationPicture>();
        }
        this.iPictures.add(nonUniversityLocationPicture);
    }

    @Override
    public Set<EventServiceProvider> getAllowedServices() {
        return this.iAllowedServices;
    }

    @Override
    public void setAllowedServices(Set<EventServiceProvider> allowedServices) {
        this.iAllowedServices = allowedServices;
    }

    public void addToallowedServices(EventServiceProvider eventServiceProvider) {
        if (this.iAllowedServices == null) {
            this.iAllowedServices = new HashSet<EventServiceProvider>();
        }
        this.iAllowedServices.add(eventServiceProvider);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof NonUniversityLocation)) {
            return false;
        }
        if (this.getUniqueId() == null || ((NonUniversityLocation)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((NonUniversityLocation)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "NonUniversityLocation[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    @Override
    public String toDebugString() {
        return "NonUniversityLocation[\n\tArea: " + this.getArea() + "\n\tBreakTime: " + this.getBreakTime() + "\n\tCapacity: " + this.getCapacity() + "\n\tCoordinateX: " + this.getCoordinateX() + "\n\tCoordinateY: " + this.getCoordinateY() + "\n\tDisplayName: " + this.getDisplayName() + "\n\tEventAvailability: " + this.getEventAvailability() + "\n\tEventDepartment: " + this.getEventDepartment() + "\n\tEventStatus: " + this.getEventStatus() + "\n\tExamCapacity: " + this.getExamCapacity() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tIgnoreRoomCheck: " + this.getIgnoreRoomCheck() + "\n\tIgnoreTooFar: " + this.getIgnoreTooFar() + "\n\tManagerIds: " + this.getManagerIds() + "\n\tName: " + this.getName() + "\n\tNote: " + this.getNote() + "\n\tPattern: " + this.getPattern() + "\n\tPermanentId: " + this.getPermanentId() + "\n\tRoomType: " + this.getRoomType() + "\n\tSession: " + this.getSession() + "\n\tShareNote: " + this.getShareNote() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

