/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.model.ItypeDesc;

public class SimpleItypeConfig
implements Serializable,
Comparable<SimpleItypeConfig> {
    private static final long serialVersionUID = 1L;
    private static long currId = 0L;
    private long id;
    private long subpartId;
    private ItypeDesc itype;
    private SimpleItypeConfig parent;
    private List<SimpleItypeConfig> subparts;
    private int numClasses;
    private int numRooms;
    private int minLimitPerClass;
    private int maxLimitPerClass;
    private int minPerWeek;
    private float roomRatio;
    private boolean disabled;
    private boolean notOwned;
    private boolean hasError;
    private long managingDeptId;
    public static String CONFIGS_ATTR_NAME = SessionAttribute.InstructionalOfferingConfigList.key();

    public SimpleItypeConfig(ItypeDesc itype) {
        this(itype, -1L);
    }

    public SimpleItypeConfig(ItypeDesc itype, long subpartId) {
        if (currId > Long.MAX_VALUE) {
            currId = 0L;
        }
        this.id = ++currId;
        this.subpartId = subpartId;
        this.itype = itype;
        this.numClasses = -1;
        this.numRooms = 1;
        this.minLimitPerClass = -1;
        this.maxLimitPerClass = -1;
        this.roomRatio = 1.0f;
        this.minPerWeek = -1;
        this.managingDeptId = -1L;
        this.subparts = new ArrayList<SimpleItypeConfig>();
        this.disabled = false;
        this.notOwned = false;
        this.hasError = false;
    }

    public void addSubpart(SimpleItypeConfig config) {
        config.setParent(this);
        this.subparts.add(config);
    }

    public List<SimpleItypeConfig> getSubparts() {
        return this.subparts;
    }

    public void setSubparts(List<SimpleItypeConfig> subparts) {
        this.subparts = subparts;
    }

    public ItypeDesc getItype() {
        return this.itype;
    }

    public void setItype(ItypeDesc itype) {
        this.itype = itype;
    }

    public int getMinLimitPerClass() {
        return this.minLimitPerClass;
    }

    public void setMinLimitPerClass(int minLimitPerClass) {
        this.minLimitPerClass = minLimitPerClass;
    }

    public int getMaxLimitPerClass() {
        return this.maxLimitPerClass;
    }

    public void setMaxLimitPerClass(int maxLimitPerClass) {
        this.maxLimitPerClass = maxLimitPerClass;
    }

    public int getMinPerWeek() {
        return this.minPerWeek;
    }

    public void setMinPerWeek(int minPerWeek) {
        this.minPerWeek = minPerWeek;
    }

    public int getNumClasses() {
        return this.numClasses;
    }

    public void setNumClasses(int numClasses) {
        this.numClasses = numClasses;
    }

    public long getId() {
        return this.id;
    }

    public SimpleItypeConfig getParent() {
        return this.parent;
    }

    public void setParent(SimpleItypeConfig parent) {
        this.parent = parent;
    }

    public float getRoomRatio() {
        return this.roomRatio;
    }

    public void setRoomRatio(float roomRatio) {
        this.roomRatio = roomRatio;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isNotOwned() {
        return this.notOwned;
    }

    public void setNotOwned(boolean notOwned) {
        this.notOwned = notOwned;
    }

    public long getSubpartId() {
        return this.subpartId;
    }

    public void setSubpartId(long subpartId) {
        this.subpartId = subpartId;
    }

    public boolean getHasError() {
        return this.hasError;
    }

    public void setHasError(boolean hasError) {
        this.hasError = hasError;
    }

    public int getNumRooms() {
        return this.numRooms;
    }

    public void setNumRooms(int numRooms) {
        this.numRooms = numRooms;
    }

    public long getManagingDeptId() {
        return this.managingDeptId;
    }

    public void setManagingDeptId(long managingDeptId) {
        this.managingDeptId = managingDeptId;
    }

    @Override
    public int compareTo(SimpleItypeConfig sic) {
        return this.getItype().getItype().compareTo(sic.getItype().getItype());
    }
}

