/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.Session;
import org.unitime.timetable.model.base.BaseEventServiceProvider;
import org.unitime.timetable.model.dao.EventServiceProviderDAO;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.UserQualifier;
import org.unitime.timetable.security.rights.Right;

public class EventServiceProvider
extends BaseEventServiceProvider
implements Comparable<EventServiceProvider> {
    private static final long serialVersionUID = 1L;

    public static EventServiceProvider getEventServiceProvider(String reference, Session hibSession) {
        if (reference == null || reference.isEmpty()) {
            return null;
        }
        return (EventServiceProvider)hibSession.createQuery("from EventServiceProvider where reference = :reference").setString("reference", reference).setMaxResults(1).setCacheable(true).uniqueResult();
    }

    public boolean isUsed() {
        return ((Number)EventServiceProviderDAO.getInstance().getSession().createQuery("select count(e) from Event e inner join e.requestedServices p where p.uniqueId = :providerId").setLong("providerId", this.getUniqueId().longValue()).uniqueResult()).intValue() > 0;
    }

    @Override
    public int compareTo(EventServiceProvider p) {
        int cmp = this.getLabel().compareToIgnoreCase(p.getLabel());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(p.getUniqueId() == null ? -1L : p.getUniqueId());
    }

    public static TreeSet<EventServiceProvider> getServiceProviders(UserContext user) {
        TreeSet<EventServiceProvider> providers = new TreeSet<EventServiceProvider>();
        providers.addAll(EventServiceProviderDAO.getInstance().getSession().createQuery("from EventServiceProvider where visible = true and session is null").setCacheable(true).list());
        if (user == null || user.getCurrentAuthority() == null) {
            return providers;
        }
        if (user.getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
            providers.addAll(EventServiceProviderDAO.getInstance().getSession().createQuery("from EventServiceProvider where visible = true and session = :sessionId").setLong("sessionId", user.getCurrentAcademicSessionId().longValue()).setCacheable(true).list());
        } else {
            providers.addAll(EventServiceProviderDAO.getInstance().getSession().createQuery("from EventServiceProvider where visible = true and session = :sessionId and department is null").setLong("sessionId", user.getCurrentAcademicSessionId().longValue()).setCacheable(true).list());
            for (UserQualifier userQualifier : user.getCurrentAuthority().getQualifiers("Department")) {
                providers.addAll(EventServiceProviderDAO.getInstance().getSession().createQuery("from EventServiceProvider where visible = true and department = :departmentId").setLong("departmentId", ((Long)userQualifier.getQualifierId()).longValue()).setCacheable(true).list());
            }
        }
        return providers;
    }

    public EventServiceProvider findInSession(Session hibSession, Long sessionId) {
        if (hibSession == null) {
            hibSession = EventServiceProviderDAO.getInstance().getSession();
        }
        if (this.getSession() == null) {
            return this;
        }
        if (this.getDepartment() == null) {
            return (EventServiceProvider)hibSession.createQuery("from EventServiceProvider where session = :sessionId and department is null and reference = :reference").setLong("sessionId", sessionId.longValue()).setString("reference", this.getReference()).setMaxResults(1).setCacheable(true).uniqueResult();
        }
        return (EventServiceProvider)hibSession.createQuery("from EventServiceProvider where session = :sessionId and department.deptCode = :deptCode and reference = :reference").setLong("sessionId", sessionId.longValue()).setString("deptCode", this.getDepartment().getDeptCode()).setString("reference", this.getReference()).setMaxResults(1).setCacheable(true).uniqueResult();
    }

    public EventServiceProvider findInSession(Long sessionId) {
        return this.findInSession(null, sessionId);
    }

    public static List<EventServiceProvider> findAll(Long sessionId) {
        return EventServiceProviderDAO.getInstance().getSession().createQuery("from EventServiceProvider where visible = true and (session is null or session = :sessionId)").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
    }

    public Set<Long> getLocationIds(Long sessionId) {
        if (this.getSession() == null) {
            if (this.isAllRooms().booleanValue()) {
                return null;
            }
            HashSet<Long> ids = new HashSet<Long>(EventServiceProviderDAO.getInstance().getSession().createQuery("select l.uniqueId from Room l inner join l.allowedServices s where s.uniqueId = :serviceId and l.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setLong("serviceId", this.getUniqueId().longValue()).setCacheable(true).list());
            ids.addAll(EventServiceProviderDAO.getInstance().getSession().createQuery("select l.uniqueId from NonUniversityLocation l inner join l.allowedServices s where s.uniqueId = :serviceId and l.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setLong("serviceId", this.getUniqueId().longValue()).setCacheable(true).list());
            return ids;
        }
        if (this.getDepartment() == null) {
            if (this.isAllRooms().booleanValue()) {
                return null;
            }
            HashSet<Long> ids = new HashSet<Long>(EventServiceProviderDAO.getInstance().getSession().createQuery("select l.uniqueId from Room l inner join l.allowedServices s where s.uniqueId = :serviceId and l.session.uniqueId = :sessionId").setLong("sessionId", this.getSession().getUniqueId().longValue()).setLong("serviceId", this.getUniqueId().longValue()).setCacheable(true).list());
            ids.addAll(EventServiceProviderDAO.getInstance().getSession().createQuery("select l.uniqueId from NonUniversityLocation l inner join l.allowedServices s where s.uniqueId = :serviceId and l.session.uniqueId = :sessionId").setLong("sessionId", this.getSession().getUniqueId().longValue()).setLong("serviceId", this.getUniqueId().longValue()).setCacheable(true).list());
            return ids;
        }
        if (this.isAllRooms().booleanValue()) {
            return new HashSet<Long>(EventServiceProviderDAO.getInstance().getSession().createQuery("select l.uniqueId from Location l where l.eventDepartment = :departmentId").setLong("departmentId", this.getDepartment().getUniqueId().longValue()).setCacheable(true).list());
        }
        HashSet<Long> ids = new HashSet<Long>(EventServiceProviderDAO.getInstance().getSession().createQuery("select l.uniqueId from Room l inner join l.allowedServices s where s.uniqueId = :serviceId and l.eventDepartment = s.department").setLong("serviceId", this.getUniqueId().longValue()).setCacheable(true).list());
        ids.addAll(EventServiceProviderDAO.getInstance().getSession().createQuery("select l.uniqueId from NonUniversityLocation l inner join l.allowedServices s where s.uniqueId = :serviceId and l.eventDepartment = s.department").setLong("serviceId", this.getUniqueId().longValue()).setCacheable(true).list());
        return ids;
    }
}

