/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.base.BaseClassEvent;
import org.unitime.timetable.model.dao.ClassEventDAO;
import org.unitime.timetable.model.dao.RelatedCourseInfoDAO;

public class ClassEvent
extends BaseClassEvent {
    private static final long serialVersionUID = 1L;

    public ClassEvent() {
    }

    public ClassEvent(Long uniqueId) {
        super(uniqueId);
    }

    @Override
    public Set<Student> getStudents() {
        HashSet<Student> students = new HashSet<Student>();
        Iterator<StudentClassEnrollment> i = this.getClazz().getStudentEnrollments().iterator();
        while (i.hasNext()) {
            students.add(i.next().getStudent());
        }
        return students;
    }

    @Override
    public Collection<Long> getStudentIds() {
        return new RelatedCourseInfoDAO().getSession().createQuery("select distinct e.student.uniqueId from StudentClassEnrollment e where e.clazz.uniqueId = :classId").setLong("classId", this.getClazz().getUniqueId().longValue()).setCacheable(true).list();
    }

    @Override
    public Set<DepartmentalInstructor> getInstructors() {
        HashSet<DepartmentalInstructor> instructors = new HashSet<DepartmentalInstructor>();
        for (ClassInstructor ci : this.getClazz().getClassInstructors()) {
            if (!ci.isLead().booleanValue()) continue;
            instructors.add(ci.getInstructor());
        }
        return instructors;
    }

    @Override
    public int getEventType() {
        return 0;
    }

    @Override
    public Session getSession() {
        return this.getClazz().getSession();
    }

    @Override
    public Collection<StudentClassEnrollment> getStudentClassEnrollments() {
        return ClassEventDAO.getInstance().getSession().createQuery("select distinct e from StudentClassEnrollment e, StudentClassEnrollment f where f.clazz.uniqueId = :classId and e.courseOffering.instructionalOffering = f.courseOffering.instructionalOffering and e.student = f.student").setLong("classId", this.getClazz().getUniqueId().longValue()).list();
    }
}

