/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.shared.EventInterface;

public class CurriculumInterface
implements IsSerializable,
Comparable<CurriculumInterface>,
Serializable {
    private static final long serialVersionUID = -7778597635593318762L;
    private Long iId;
    private String iAbbv;
    private String iName;
    private boolean iEditable = false;
    private String iLastChange = null;
    private boolean iMultipleMajors = false;
    private boolean iSessionHasSnapshotData = false;
    private AcademicAreaInterface iAcademicArea;
    private TreeSet<MajorInterface> iMajors;
    private DepartmentInterface iDept;
    private TreeSet<CurriculumClassificationInterface> iClasf;
    private TreeSet<CourseInterface> iCourses;

    public Long getId() {
        return this.iId;
    }

    public void setId(Long id) {
        this.iId = id;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getAbbv() {
        return this.iAbbv;
    }

    public void setAbbv(String abbv) {
        this.iAbbv = abbv;
    }

    public String getLastChange() {
        return this.iLastChange;
    }

    public void setLastChange(String lastChange) {
        this.iLastChange = lastChange;
    }

    public boolean hasLastChange() {
        return this.iLastChange != null && !this.iLastChange.isEmpty();
    }

    public AcademicAreaInterface getAcademicArea() {
        return this.iAcademicArea;
    }

    public void setAcademicArea(AcademicAreaInterface area) {
        this.iAcademicArea = area;
    }

    public boolean isMultipleMajors() {
        return this.iMultipleMajors;
    }

    public void setMultipleMajors(boolean multipleMajors) {
        this.iMultipleMajors = multipleMajors;
    }

    public boolean isSessionHasSnapshotData() {
        return this.iSessionHasSnapshotData;
    }

    public void setSessionHasSnapshotData(boolean sessionHasSnapshotData) {
        this.iSessionHasSnapshotData = sessionHasSnapshotData;
    }

    public TreeSet<MajorInterface> getMajors() {
        return this.iMajors;
    }

    public boolean hasMajors() {
        return this.iMajors != null && !this.iMajors.isEmpty();
    }

    public void addMajor(MajorInterface major) {
        if (this.iMajors == null) {
            this.iMajors = new TreeSet();
        }
        this.iMajors.add(major);
    }

    public String getMajorNames(String delim) {
        String ret = "";
        if (this.iMajors == null) {
            return ret;
        }
        for (MajorInterface major : this.iMajors) {
            if (!ret.isEmpty()) {
                ret = ret + delim;
            }
            ret = ret + major.getName();
        }
        return ret;
    }

    public String getMajorCodes(String delim) {
        String ret = "";
        if (this.iMajors == null) {
            return ret;
        }
        for (MajorInterface major : this.iMajors) {
            if (!ret.isEmpty()) {
                ret = ret + delim;
            }
            ret = ret + major.getCode();
        }
        return ret;
    }

    public String getCodeMajorNames(String delim) {
        String ret = "";
        if (this.iMajors == null) {
            return ret;
        }
        for (MajorInterface major : this.iMajors) {
            if (!ret.isEmpty()) {
                ret = ret + delim;
            }
            ret = ret + major.getCode() + " - " + major.getName();
        }
        return ret;
    }

    public DepartmentInterface getDepartment() {
        return this.iDept;
    }

    public void setDepartment(DepartmentInterface dept) {
        this.iDept = dept;
    }

    public TreeSet<CurriculumClassificationInterface> getClassifications() {
        return this.iClasf;
    }

    public boolean hasClassifications() {
        return this.iClasf != null;
    }

    public void addClassification(CurriculumClassificationInterface clasf) {
        if (this.iClasf == null) {
            this.iClasf = new TreeSet();
        }
        this.iClasf.add(clasf);
    }

    public CurriculumClassificationInterface getClassification(Long academicClassificationId) {
        if (this.iClasf == null) {
            return null;
        }
        for (CurriculumClassificationInterface clasf : this.iClasf) {
            if (!clasf.getAcademicClassification().getId().equals(academicClassificationId)) continue;
            return clasf;
        }
        return null;
    }

    public CurriculumClassificationInterface getClassification(String academicClassificationCode) {
        if (this.iClasf == null) {
            return null;
        }
        for (CurriculumClassificationInterface clasf : this.iClasf) {
            if (!clasf.getAcademicClassification().getCode().equals(academicClassificationCode)) continue;
            return clasf;
        }
        return null;
    }

    public TreeSet<CourseInterface> getCourses() {
        return this.iCourses;
    }

    public boolean hasCourses() {
        return this.iCourses != null && !this.iCourses.isEmpty();
    }

    public void addCourse(CourseInterface course) {
        if (this.iCourses == null) {
            this.iCourses = new TreeSet();
        }
        this.iCourses.add(course);
    }

    public CourseInterface getCourse(Long courseOfferingId) {
        if (this.iCourses == null) {
            return null;
        }
        for (CourseInterface course : this.iCourses) {
            if (!course.getId().equals(courseOfferingId)) continue;
            return course;
        }
        return null;
    }

    public CourseInterface getCourse(String courseName) {
        if (this.iCourses == null) {
            return null;
        }
        for (CourseInterface course : this.iCourses) {
            if (!course.getCourseName().equals(courseName)) continue;
            return course;
        }
        return null;
    }

    public Integer getExpected() {
        if (!this.hasClassifications()) {
            return null;
        }
        int ret = 0;
        for (CurriculumClassificationInterface c : this.getClassifications()) {
            ret += c.getExpected() == null ? 0 : c.getExpected();
        }
        return ret;
    }

    public Integer getEnrollment() {
        if (!this.hasClassifications()) {
            return null;
        }
        int ret = 0;
        for (CurriculumClassificationInterface c : this.getClassifications()) {
            ret += c.getEnrollment() == null ? 0 : c.getEnrollment();
        }
        return ret;
    }

    public Integer getLastLike() {
        if (!this.hasClassifications()) {
            return null;
        }
        int ret = 0;
        for (CurriculumClassificationInterface c : this.getClassifications()) {
            ret += c.getLastLike() == null ? 0 : c.getLastLike();
        }
        return ret;
    }

    public Integer getProjection() {
        if (!this.hasClassifications()) {
            return null;
        }
        int ret = 0;
        for (CurriculumClassificationInterface c : this.getClassifications()) {
            ret += c.getProjection() == null ? 0 : c.getProjection();
        }
        return ret;
    }

    public Integer getSnapshotExpected() {
        if (!this.isSessionHasSnapshotData()) {
            return null;
        }
        if (!this.hasClassifications()) {
            return null;
        }
        int ret = 0;
        for (CurriculumClassificationInterface c : this.getClassifications()) {
            ret += c.getSnapshotExpected() == null ? 0 : c.getSnapshotExpected();
        }
        return ret;
    }

    public Integer getSnapshotProjection() {
        if (!this.isSessionHasSnapshotData()) {
            return null;
        }
        if (!this.hasClassifications()) {
            return null;
        }
        int ret = 0;
        for (CurriculumClassificationInterface c : this.getClassifications()) {
            ret += c.getSnapshotProjection() == null ? 0 : c.getSnapshotProjection();
        }
        return ret;
    }

    public Integer getRequested() {
        if (!this.hasClassifications()) {
            return null;
        }
        int ret = 0;
        for (CurriculumClassificationInterface c : this.getClassifications()) {
            ret += c.getRequested() == null ? 0 : c.getRequested();
        }
        return ret;
    }

    public String getExpectedString() {
        if (!this.hasClassifications()) {
            return "?";
        }
        Integer count = this.getExpected();
        return count == null ? "N/A" : count.toString();
    }

    public String getSnapshotExpectedString() {
        if (!this.hasClassifications()) {
            return "?";
        }
        Integer count = this.getSnapshotExpected();
        return count == null ? "N/A" : count.toString();
    }

    public String getLastLikeString() {
        if (!this.hasClassifications()) {
            return "?";
        }
        Integer count = this.getLastLike();
        return count == null ? "N/A" : count.toString();
    }

    public String getProjectionString() {
        if (!this.hasClassifications()) {
            return "?";
        }
        Integer count = this.getProjection();
        return count == null ? "N/A" : count.toString();
    }

    public String getSnapshotProjectionString() {
        if (!this.hasClassifications()) {
            return "?";
        }
        Integer count = this.getSnapshotProjection();
        return count == null ? "N/A" : count.toString();
    }

    public String getEnrollmentString() {
        if (!this.hasClassifications()) {
            return "?";
        }
        Integer count = this.getEnrollment();
        return count == null ? "N/A" : count.toString();
    }

    public String getRequestedString() {
        if (!this.hasClassifications()) {
            return "?";
        }
        Integer count = this.getRequested();
        return count == null ? "N/A" : count.toString();
    }

    public void setEditable(boolean editable) {
        this.iEditable = editable;
    }

    public boolean isEditable() {
        return this.iEditable;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CurriculumInterface)) {
            return false;
        }
        return this.getId().equals(((CurriculumInterface)o).getId());
    }

    public int hashCode() {
        return this.getId() == null ? 0 : this.getId().hashCode();
    }

    @Override
    public int compareTo(CurriculumInterface curriculum) {
        int cmp = this.getAbbv().compareTo(curriculum.getAbbv());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getId() == null ? Long.valueOf(-1L) : this.getId()).compareTo(curriculum.getId() == null ? -1L : curriculum.getId());
    }

    public static int count(Map<Long, Double> col) {
        if (col == null) {
            return 0;
        }
        double total = 0.0;
        for (Double w : col.values()) {
            total += w.doubleValue();
        }
        return (int)Math.round(total);
    }

    public static double addAll(Map<Long, Double> students, Map<Long, Double> other) {
        double total = 0.0;
        for (Map.Entry<Long, Double> e : other.entrySet()) {
            Double w = students.get(e.getKey());
            if (w == null) {
                students.put(e.getKey(), e.getValue());
            } else {
                students.put(e.getKey(), Math.min(e.getValue() + w, 1.0));
            }
            total += e.getValue().doubleValue();
        }
        return total;
    }

    public static void retainAll(Map<Long, Double> students, Map<Long, Double> other) {
        Iterator<Map.Entry<Long, Double>> i = students.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Long, Double> e = i.next();
            Double w = other.get(e.getKey());
            if (w == null) {
                i.remove();
                continue;
            }
            students.put(e.getKey(), e.getValue() + w);
        }
    }

    public static void removeAll(Map<Long, Double> students, Map<Long, Double> other) {
        for (Map.Entry<Long, Double> e : other.entrySet()) {
            students.remove(e.getKey());
        }
    }

    public static class CurriculumFilterRpcRequest
    extends EventInterface.FilterRpcRequest {
        private static final long serialVersionUID = 1L;
    }

    public static class CurriculumStudentsInterface
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1987135351832935825L;
        private Map<Long, Double> iEnrollment = null;
        private Map<Long, Double> iRequested = null;
        private HashMap<Long, Map<String, Double>> iLastLike = null;
        private HashMap<String, Float> iProjection = null;
        private HashMap<String, Float> iSnapshotProjection = null;
        private boolean iSessionHasSnapshotData = false;

        public int getEnrollment() {
            return this.iEnrollment == null || this.iEnrollment.isEmpty() ? 0 : CurriculumInterface.count(this.iEnrollment);
        }

        public int getLastLike() {
            if (this.iLastLike == null || this.iLastLike.isEmpty()) {
                return 0;
            }
            double total = 0.0;
            for (Map.Entry<Long, Map<String, Double>> e : this.iLastLike.entrySet()) {
                double w = 0.0;
                for (Double d : e.getValue().values()) {
                    w += d.doubleValue();
                }
                total += Math.min(w, 1.0);
            }
            return (int)Math.round(total);
        }

        public boolean isSessionHasSnapshotData() {
            return this.iSessionHasSnapshotData;
        }

        public void setSessionHasSnapshotData(boolean sessionHasSnapshotData) {
            this.iSessionHasSnapshotData = sessionHasSnapshotData;
        }

        public int getProjection() {
            if (this.iLastLike == null || this.iLastLike.isEmpty()) {
                return 0;
            }
            if (this.iProjection == null) {
                return this.getLastLike();
            }
            double proj = 0.0;
            for (Map.Entry<Long, Map<String, Double>> entry : this.iLastLike.entrySet()) {
                double weight = 0.0;
                double total = 0.0;
                for (Map.Entry<String, Double> major : entry.getValue().entrySet()) {
                    Float f = this.iProjection.get(major.getKey());
                    if (f == null) {
                        f = this.iProjection.get("");
                    }
                    weight = f != null ? (weight += major.getValue() * (double)f.floatValue()) : (weight += major.getValue().doubleValue());
                    total += major.getValue().doubleValue();
                }
                if (total > 1.0) {
                    proj += weight / total;
                    continue;
                }
                proj += weight;
            }
            return (int)Math.round(proj);
        }

        public int getSnapshotProjection() {
            if (!this.iSessionHasSnapshotData) {
                return 0;
            }
            if (this.iLastLike == null || this.iLastLike.isEmpty()) {
                return 0;
            }
            if (this.iSnapshotProjection == null) {
                return this.getLastLike();
            }
            double proj = 0.0;
            for (Map.Entry<Long, Map<String, Double>> entry : this.iLastLike.entrySet()) {
                double weight = 0.0;
                double total = 0.0;
                for (Map.Entry<String, Double> major : entry.getValue().entrySet()) {
                    Float f = this.iSnapshotProjection.get(major.getKey());
                    if (f == null) {
                        f = this.iSnapshotProjection.get("");
                    }
                    weight = f != null ? (weight += major.getValue() * (double)f.floatValue()) : (weight += major.getValue().doubleValue());
                    total += major.getValue().doubleValue();
                }
                if (total > 1.0) {
                    proj += weight / total;
                    continue;
                }
                proj += weight;
            }
            return (int)Math.round(proj);
        }

        public int getRequested() {
            return this.iRequested == null || this.iRequested.isEmpty() ? 0 : CurriculumInterface.count(this.iRequested);
        }

        public Map<Long, Double> getEnrolledStudents() {
            return this.iEnrollment;
        }

        public Map<Long, Double> getLastLikeStudents() {
            if (this.iLastLike == null || this.iLastLike.isEmpty()) {
                return null;
            }
            HashMap<Long, Double> ret = new HashMap<Long, Double>();
            for (Map.Entry<Long, Map<String, Double>> e : this.iLastLike.entrySet()) {
                double total = 0.0;
                for (Double w : e.getValue().values()) {
                    total += w.doubleValue();
                }
                ret.put(e.getKey(), total);
            }
            return ret;
        }

        public Map<Long, Double> getProjectedStudents() {
            return this.getLastLikeStudents();
        }

        public int countProjectedStudents(Map<Long, Double> students) {
            if (this.iLastLike == null || this.iLastLike.isEmpty()) {
                return 0;
            }
            if (this.iProjection == null) {
                return students.size();
            }
            double proj = 0.0;
            for (Map.Entry<Long, Double> student : students.entrySet()) {
                Map<String, Double> majors = this.iLastLike.get(student.getKey());
                if (majors == null) continue;
                double weight = 1.0;
                int cnt = 0;
                for (Map.Entry<String, Double> major : majors.entrySet()) {
                    Float f = this.iProjection.get(major.getKey());
                    if (f == null) {
                        f = this.iProjection.get("");
                    }
                    if (f != null) {
                        weight *= (double)f.floatValue() * major.getValue();
                    }
                    ++cnt;
                }
                proj += student.getValue() * (cnt == 0 ? 1.0 : (cnt == 1 ? weight : Math.pow(weight, 1.0 / (double)cnt)));
            }
            return (int)Math.round(proj);
        }

        public int countSnapshotProjectedStudents(Map<Long, Double> students) {
            if (!this.iSessionHasSnapshotData) {
                return 0;
            }
            if (this.iLastLike == null || this.iLastLike.isEmpty()) {
                return 0;
            }
            if (this.iSnapshotProjection == null) {
                return students.size();
            }
            double ssproj = 0.0;
            for (Map.Entry<Long, Double> student : students.entrySet()) {
                Map<String, Double> majors = this.iLastLike.get(student.getKey());
                if (majors == null) continue;
                double weight = 1.0;
                int cnt = 0;
                for (Map.Entry<String, Double> major : majors.entrySet()) {
                    Float f = this.iSnapshotProjection.get(major.getKey());
                    if (f == null) {
                        f = this.iSnapshotProjection.get("");
                    }
                    if (f != null) {
                        weight *= (double)f.floatValue() * major.getValue();
                    }
                    ++cnt;
                }
                ssproj += student.getValue() * (cnt == 0 ? 1.0 : (cnt == 1 ? weight : Math.pow(weight, 1.0 / (double)cnt)));
            }
            return (int)Math.round(ssproj);
        }

        public int countProjectedStudents(Set<Long> students, Map<Long, Double> weights) {
            if (this.iLastLike == null || this.iLastLike.isEmpty()) {
                return 0;
            }
            if (this.iProjection == null) {
                return students.size();
            }
            double proj = 0.0;
            for (Long student : students) {
                Map<String, Double> majors = this.iLastLike.get(student);
                if (majors == null) continue;
                double weight = 1.0;
                int cnt = 0;
                for (Map.Entry<String, Double> major : majors.entrySet()) {
                    Float f = this.iProjection.get(major.getKey());
                    if (f == null) {
                        f = this.iProjection.get("");
                    }
                    if (f != null) {
                        weight *= (double)f.floatValue() * major.getValue();
                    }
                    ++cnt;
                }
                Double w = weights.get(student);
                proj += (w == null ? 1.0 : w) * (cnt == 0 ? 1.0 : (cnt == 1 ? weight : Math.pow(weight, 1.0 / (double)cnt)));
            }
            return (int)Math.round(proj);
        }

        public int countSnapshotProjectedStudents(Set<Long> students, Map<Long, Double> weights) {
            if (!this.iSessionHasSnapshotData) {
                return 0;
            }
            if (this.iLastLike == null || this.iLastLike.isEmpty()) {
                return 0;
            }
            if (this.iSnapshotProjection == null) {
                return students.size();
            }
            double ssproj = 0.0;
            for (Long student : students) {
                Map<String, Double> majors = this.iLastLike.get(student);
                if (majors == null) continue;
                double weight = 1.0;
                int cnt = 0;
                for (Map.Entry<String, Double> major : majors.entrySet()) {
                    Float f = this.iSnapshotProjection.get(major.getKey());
                    if (f == null) {
                        f = this.iSnapshotProjection.get("");
                    }
                    if (f != null) {
                        weight *= (double)f.floatValue() * major.getValue();
                    }
                    ++cnt;
                }
                Double w = weights.get(student);
                ssproj += (w == null ? 1.0 : w) * (cnt == 0 ? 1.0 : (cnt == 1 ? weight : Math.pow(weight, 1.0 / (double)cnt)));
            }
            return (int)Math.round(ssproj);
        }

        public Map<Long, Double> getRequestedStudents() {
            return this.iRequested;
        }

        public void setEnrolledStudents(Map<Long, Double> students) {
            this.iEnrollment = students;
        }

        public void setLastLikeStudents(HashMap<String, Map<Long, Double>> students) {
            if (students == null) {
                this.iLastLike = null;
            } else {
                this.iLastLike = new HashMap();
                for (Map.Entry<String, Map<Long, Double>> entry : students.entrySet()) {
                    for (Map.Entry<Long, Double> student : entry.getValue().entrySet()) {
                        Map<String, Double> majors = this.iLastLike.get(student.getKey());
                        if (majors == null) {
                            majors = new HashMap<String, Double>();
                            this.iLastLike.put(student.getKey(), majors);
                        }
                        majors.put(entry.getKey(), student.getValue());
                    }
                }
            }
        }

        public void setProjection(HashMap<String, Float> projection) {
            this.iProjection = projection;
        }

        public void setSnapshotProjection(HashMap<String, Float> snapshotProjection) {
            this.iSnapshotProjection = snapshotProjection;
        }

        public void setRequestedStudents(Map<Long, Double> students) {
            this.iRequested = students;
        }
    }

    public static class CurriculumCourseGroupInterface
    implements IsSerializable,
    Comparable<CurriculumCourseGroupInterface>,
    Serializable {
        private static final long serialVersionUID = 5795862880607152603L;
        private Long iId;
        private String iName;
        private String iColor;
        private int iType;
        private boolean iEditable = true;

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getColor() {
            return this.iColor;
        }

        public void setColor(String color) {
            this.iColor = color;
        }

        public int getType() {
            return this.iType;
        }

        public void setType(int type) {
            this.iType = type;
        }

        public boolean isEditable() {
            return this.iEditable;
        }

        public void setEditable(boolean editable) {
            this.iEditable = editable;
        }

        public int hashCode() {
            return this.iName.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CurriculumCourseGroupInterface)) {
                return false;
            }
            return this.getName().equals(((CurriculumCourseGroupInterface)o).getName());
        }

        @Override
        public int compareTo(CurriculumCourseGroupInterface g) {
            return this.getName().compareTo(g.getName());
        }
    }

    public static class CurriculumCourseInterface
    implements IsSerializable,
    Comparable<CurriculumCourseInterface>,
    Serializable {
        private static final long serialVersionUID = 6406423279718484339L;
        private Long iId;
        private Long iCourseId;
        private Long iClasfId;
        private String iCourseName;
        private Float iShare = null;
        private Float iDefaultShare = null;
        private Float iSnapshotShare = null;
        private Float iDefaultSnapshotShare = null;
        private Integer iLastLike = null;
        private Integer iEnrollment = null;
        private Integer iProjection = null;
        private Integer iRequested = null;
        private Integer iSnapshotProjection = null;
        private TreeSet<String> iTemplates = null;
        private boolean iSessionHasSnapshotData = false;

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public Long getCourseOfferingId() {
            return this.iCourseId;
        }

        public void setCourseOfferingId(Long courseId) {
            this.iCourseId = courseId;
        }

        public Long getCurriculumClassificationId() {
            return this.iClasfId;
        }

        public void setCurriculumClassificationId(Long clasfId) {
            this.iClasfId = clasfId;
        }

        public String getCourseName() {
            return this.iCourseName;
        }

        public void setCourseName(String courseName) {
            this.iCourseName = courseName;
        }

        public float getShare() {
            return this.iShare == null ? 0.0f : this.iShare.floatValue();
        }

        public boolean hasShare() {
            return this.iShare != null;
        }

        public void setShare(Float share) {
            this.iShare = share;
        }

        public Float getSnapshotShare() {
            return this.iSnapshotShare;
        }

        public boolean hasSnapshotShare() {
            return this.iSnapshotShare != null;
        }

        public void setSnapshotShare(Float snapshotShare) {
            this.iSnapshotShare = snapshotShare;
        }

        public Float getDefaultShare() {
            return this.iDefaultShare;
        }

        public void setDefaultShare(Float share) {
            this.iDefaultShare = share;
        }

        public Float getDefaultSnapshotShare() {
            return this.iDefaultSnapshotShare;
        }

        public void setDefaultSnapshotShare(Float snapshotShare) {
            this.iDefaultSnapshotShare = snapshotShare;
        }

        public TreeSet<String> getTemplates() {
            return this.iTemplates;
        }

        public boolean hasTemplates() {
            return this.iTemplates != null && !this.iTemplates.isEmpty();
        }

        public void addTemplate(String template) {
            if (this.iTemplates == null) {
                this.iTemplates = new TreeSet();
            }
            this.iTemplates.add(template);
        }

        public boolean isSessionHasSnapshotData() {
            return this.iSessionHasSnapshotData;
        }

        public void setSessionHasSnapshotData(boolean sessionHasSnapshotData) {
            this.iSessionHasSnapshotData = sessionHasSnapshotData;
        }

        public float getDisplayedShare() {
            return this.iShare != null ? this.iShare.floatValue() : (this.iDefaultShare != null ? this.iDefaultShare.floatValue() : 0.0f);
        }

        public Integer getLastLike() {
            return this.iLastLike;
        }

        public void setLastLike(Integer lastLike) {
            this.iLastLike = lastLike;
        }

        public Integer getEnrollment() {
            return this.iEnrollment;
        }

        public void setEnrollment(Integer enrollment) {
            this.iEnrollment = enrollment;
        }

        public Integer getRequested() {
            return this.iRequested;
        }

        public void setRequested(Integer requested) {
            this.iRequested = requested;
        }

        public Integer getProjection() {
            return this.iProjection;
        }

        public void setProjection(Integer projection) {
            this.iProjection = projection;
        }

        public Integer getSnapshotProjection() {
            return this.iSnapshotProjection;
        }

        public void setSnapshotProjection(Integer snapshotProjection) {
            this.iSnapshotProjection = snapshotProjection;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CurriculumCourseInterface)) {
                return false;
            }
            return this.getId().equals(((CurriculumCourseInterface)o).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        @Override
        public int compareTo(CurriculumCourseInterface course) {
            return this.getCourseName().compareTo(course.getCourseName());
        }
    }

    public static class CourseInterface
    implements IsSerializable,
    Comparable<CourseInterface>,
    Serializable {
        private static final long serialVersionUID = -6178340017813768582L;
        private Long iCourseId;
        private String iCourseName;
        private List<CurriculumCourseInterface> iCurriculumCourses;
        private TreeSet<CurriculumCourseGroupInterface> iGroups;

        public Long getId() {
            return this.iCourseId;
        }

        public void setId(Long id) {
            this.iCourseId = id;
        }

        public String getCourseName() {
            return this.iCourseName;
        }

        public void setCourseName(String courseName) {
            this.iCourseName = courseName;
        }

        public boolean hasCurriculumCourses() {
            return this.iCurriculumCourses != null && !this.iCurriculumCourses.isEmpty();
        }

        public void setCurriculumCourse(int idx, CurriculumCourseInterface course) {
            if (this.iCurriculumCourses == null) {
                this.iCurriculumCourses = new ArrayList<CurriculumCourseInterface>();
            }
            if (idx < this.iCurriculumCourses.size()) {
                this.iCurriculumCourses.set(idx, course);
            } else {
                while (this.iCurriculumCourses.size() < idx) {
                    this.iCurriculumCourses.add(null);
                }
                this.iCurriculumCourses.add(course);
            }
        }

        public CurriculumCourseInterface getCurriculumCourse(int idx) {
            if (this.iCurriculumCourses == null || idx >= this.iCurriculumCourses.size()) {
                return null;
            }
            return this.iCurriculumCourses.get(idx);
        }

        public List<CurriculumCourseInterface> getCurriculumCourses() {
            return this.iCurriculumCourses;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CourseInterface)) {
                return false;
            }
            return this.getId().equals(((CourseInterface)o).getId());
        }

        public boolean hasGroups() {
            return this.iGroups != null && !this.iGroups.isEmpty();
        }

        public void addGroup(CurriculumCourseGroupInterface group) {
            if (this.iGroups == null) {
                this.iGroups = new TreeSet();
            }
            this.iGroups.add(group);
        }

        public TreeSet<CurriculumCourseGroupInterface> getGroups() {
            return this.iGroups;
        }

        public CurriculumCourseGroupInterface getGroup(String name) {
            if (this.iGroups == null) {
                return null;
            }
            for (CurriculumCourseGroupInterface group : this.iGroups) {
                if (!group.getName().equals(name)) continue;
                return group;
            }
            return null;
        }

        public CurriculumCourseGroupInterface getGroup(Long groupId) {
            if (this.iGroups == null) {
                return null;
            }
            for (CurriculumCourseGroupInterface group : this.iGroups) {
                if (!group.getId().equals(groupId)) continue;
                return group;
            }
            return null;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        private int firstClassification() {
            if (!this.hasCurriculumCourses()) {
                return -1;
            }
            for (int i = 0; i < this.iCurriculumCourses.size(); ++i) {
                CurriculumCourseInterface c = this.iCurriculumCourses.get(i);
                if (c == null || !(c.getDisplayedShare() > 0.0f)) continue;
                return i;
            }
            return this.iCurriculumCourses.size();
        }

        private int highestClassification() {
            if (!this.hasCurriculumCourses()) {
                return -1;
            }
            int best = this.iCurriculumCourses.size();
            double bestShare = -1.0;
            for (int i = 0; i < this.iCurriculumCourses.size(); ++i) {
                CurriculumCourseInterface c = this.iCurriculumCourses.get(i);
                if (c == null || !((double)c.getDisplayedShare() > bestShare)) continue;
                bestShare = c.getDisplayedShare();
                best = i;
            }
            return best;
        }

        public boolean hasDefaultShare() {
            if (this.iCurriculumCourses == null) {
                return false;
            }
            for (CurriculumCourseInterface c : this.iCurriculumCourses) {
                if (c == null || c.getDefaultShare() == null) continue;
                return true;
            }
            return false;
        }

        public boolean hasDefaultSnapshotShare() {
            if (this.iCurriculumCourses == null) {
                return false;
            }
            for (CurriculumCourseInterface c : this.iCurriculumCourses) {
                if (!c.isSessionHasSnapshotData()) {
                    return false;
                }
                if (c == null || c.getDefaultShare() == null) continue;
                return true;
            }
            return false;
        }

        public boolean hasTemplate() {
            if (this.iCurriculumCourses == null) {
                return false;
            }
            for (CurriculumCourseInterface c : this.iCurriculumCourses) {
                if (c == null || !c.hasTemplates()) continue;
                return true;
            }
            return false;
        }

        public String getTemplate() {
            if (this.iCurriculumCourses == null) {
                return null;
            }
            TreeSet<String> templates = new TreeSet<String>();
            for (CurriculumCourseInterface c : this.iCurriculumCourses) {
                if (c == null || !c.hasTemplates()) continue;
                templates.addAll(c.getTemplates());
            }
            if (templates.isEmpty()) {
                return null;
            }
            String ret = "";
            for (String template : templates) {
                ret = ret + (ret.isEmpty() ? "" : ", ") + template;
            }
            return ret;
        }

        @Override
        public int compareTo(CourseInterface course) {
            if (this.hasCurriculumCourses()) {
                int cmp;
                CurriculumCourseInterface d;
                CurriculumCourseInterface c;
                int b;
                int a = this.highestClassification();
                if (a < (b = course.highestClassification())) {
                    return -1;
                }
                if (a > b) {
                    return 1;
                }
                if (a <= this.iCurriculumCourses.size()) {
                    c = this.getCurriculumCourse(a);
                    d = course.getCurriculumCourse(a);
                    cmp = Double.compare(d == null ? 0.0 : (double)d.getDisplayedShare(), c == null ? 0.0 : (double)c.getDisplayedShare());
                    if (cmp != 0) {
                        return cmp;
                    }
                }
                if ((a = this.firstClassification()) < (b = course.firstClassification())) {
                    return -1;
                }
                if (a > b) {
                    return 1;
                }
                while (a <= this.iCurriculumCourses.size()) {
                    c = this.getCurriculumCourse(a);
                    d = course.getCurriculumCourse(a);
                    cmp = Double.compare(d == null ? 0.0 : (double)d.getDisplayedShare(), c == null ? 0.0 : (double)c.getDisplayedShare());
                    if (cmp != 0) {
                        return cmp;
                    }
                    ++a;
                }
            }
            return this.getCourseName().compareTo(course.getCourseName());
        }
    }

    public static class CurriculumClassificationInterface
    implements IsSerializable,
    Comparable<CurriculumClassificationInterface>,
    Serializable {
        private static final long serialVersionUID = -1102123315199715576L;
        private Long iCurriculumId;
        private Long iClasfId;
        private String iName;
        private Integer iNrStudents = null;
        private Integer iEnrollment = null;
        private Integer iLastLike = null;
        private Integer iProjection = null;
        private Integer iRequested = null;
        private Integer iSnapshotProjection = null;
        private Integer iSnapshotNrStudents = null;
        private AcademicClassificationInterface iClasf;
        private TreeSet<CurriculumCourseInterface> iCourses = null;
        private boolean iSessionHasSnapshotData = false;

        public Long getId() {
            return this.iClasfId;
        }

        public void setId(Long id) {
            this.iClasfId = id;
        }

        public Long getCurriculumId() {
            return this.iCurriculumId;
        }

        public void setCurriculumId(Long curriculumId) {
            this.iCurriculumId = curriculumId;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public Integer getExpected() {
            return this.iNrStudents;
        }

        public void setExpected(Integer nrStudents) {
            this.iNrStudents = nrStudents;
        }

        public Integer getSnapshotExpected() {
            return this.iSnapshotNrStudents;
        }

        public void setSnapshotExpected(Integer snapshotNrStudents) {
            this.iSnapshotNrStudents = snapshotNrStudents;
        }

        public Integer getEnrollment() {
            return this.iEnrollment;
        }

        public void setEnrollment(Integer enrollment) {
            this.iEnrollment = enrollment;
        }

        public Integer getRequested() {
            return this.iRequested;
        }

        public void setRequested(Integer requested) {
            this.iRequested = requested;
        }

        public Integer getLastLike() {
            return this.iLastLike;
        }

        public void setLastLike(Integer lastLike) {
            this.iLastLike = lastLike;
        }

        public Integer getProjection() {
            return this.iProjection;
        }

        public void setProjection(Integer projection) {
            this.iProjection = projection;
        }

        public Integer getSnapshotProjection() {
            return this.iSnapshotProjection;
        }

        public void setSnapshotProjection(Integer snapshotProjection) {
            this.iSnapshotProjection = snapshotProjection;
        }

        public AcademicClassificationInterface getAcademicClassification() {
            return this.iClasf;
        }

        public void setAcademicClassification(AcademicClassificationInterface clasf) {
            this.iClasf = clasf;
        }

        public boolean isSessionHasSnapshotData() {
            return this.iSessionHasSnapshotData;
        }

        public void setSessionHasSnapshotData(boolean sessionHasSnapshotData) {
            this.iSessionHasSnapshotData = sessionHasSnapshotData;
        }

        public TreeSet<CurriculumCourseInterface> getCourses() {
            return this.iCourses;
        }

        public boolean hasCourses() {
            return this.iCourses != null && !this.iCourses.isEmpty();
        }

        public void addCourse(CurriculumCourseInterface course) {
            if (this.iCourses == null) {
                this.iCourses = new TreeSet();
            }
            this.iCourses.add(course);
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CurriculumClassificationInterface)) {
                return false;
            }
            return this.getId().equals(((CurriculumClassificationInterface)o).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        @Override
        public int compareTo(CurriculumClassificationInterface clasf) {
            return this.getAcademicClassification().compareTo(clasf.getAcademicClassification());
        }
    }

    public static class AcademicClassificationInterface
    implements IsSerializable,
    Comparable<AcademicClassificationInterface>,
    Serializable {
        private static final long serialVersionUID = 7862712863727551194L;
        private Long iClasfId;
        private String iClasfCode;
        private String iClasfName;

        public Long getId() {
            return this.iClasfId;
        }

        public void setId(Long id) {
            this.iClasfId = id;
        }

        public String getCode() {
            return this.iClasfCode;
        }

        public void setCode(String code) {
            this.iClasfCode = code;
        }

        public String getName() {
            return this.iClasfName;
        }

        public void setName(String name) {
            this.iClasfName = name;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof AcademicClassificationInterface)) {
                return false;
            }
            return this.getId().equals(((AcademicClassificationInterface)o).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        @Override
        public int compareTo(AcademicClassificationInterface clasf) {
            int cmp = this.getCode().compareTo(clasf.getCode());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.getName().compareTo(clasf.getName());
            if (cmp != 0) {
                return cmp;
            }
            return this.getId().compareTo(clasf.getId());
        }
    }

    public static class DepartmentInterface
    implements IsSerializable,
    Comparable<DepartmentInterface>,
    Serializable {
        private static final long serialVersionUID = -6699851066950644850L;
        private Long iDeptId;
        private String iDeptCode;
        private String iDeptAbbv;
        private String iDeptName;

        public Long getId() {
            return this.iDeptId;
        }

        public void setId(Long id) {
            this.iDeptId = id;
        }

        public String getCode() {
            return this.iDeptCode;
        }

        public void setCode(String code) {
            this.iDeptCode = code;
        }

        public String getAbbv() {
            return this.iDeptAbbv;
        }

        public void setAbbv(String abbv) {
            this.iDeptAbbv = abbv;
        }

        public String getName() {
            return this.iDeptName;
        }

        public void setName(String name) {
            this.iDeptName = name;
        }

        public String getLabel() {
            return this.iDeptCode + " - " + this.iDeptName;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof DepartmentInterface)) {
                return false;
            }
            return this.getId().equals(((DepartmentInterface)o).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        @Override
        public int compareTo(DepartmentInterface dept) {
            int cmp = this.getLabel().compareTo(dept.getLabel());
            if (cmp != 0) {
                return cmp;
            }
            return this.getId().compareTo(dept.getId());
        }
    }

    public static class MajorInterface
    implements IsSerializable,
    Comparable<MajorInterface>,
    Serializable {
        private static final long serialVersionUID = -7971546071734945667L;
        private Long iMajorId;
        private String iMajorCode;
        private String iMajorName;

        public Long getId() {
            return this.iMajorId;
        }

        public void setId(Long id) {
            this.iMajorId = id;
        }

        public String getCode() {
            return this.iMajorCode;
        }

        public void setCode(String code) {
            this.iMajorCode = code;
        }

        public String getName() {
            return this.iMajorName;
        }

        public void setName(String name) {
            this.iMajorName = name;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof MajorInterface)) {
                return false;
            }
            return this.getId().equals(((MajorInterface)o).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        @Override
        public int compareTo(MajorInterface major) {
            int cmp;
            if (this.getCode() != null && (cmp = this.getCode().compareTo(major.getCode())) != 0) {
                return cmp;
            }
            return this.getId().compareTo(major.getId());
        }
    }

    public static class AcademicAreaInterface
    implements IsSerializable,
    Comparable<AcademicAreaInterface>,
    Serializable {
        private static final long serialVersionUID = 6293058295434940938L;
        private Long iAreaId;
        private String iAreaAbbv;
        private String iAreaName;

        public Long getId() {
            return this.iAreaId;
        }

        public void setId(Long id) {
            this.iAreaId = id;
        }

        public String getAbbv() {
            return this.iAreaAbbv;
        }

        public void setAbbv(String abbv) {
            this.iAreaAbbv = abbv;
        }

        public String getName() {
            return this.iAreaName;
        }

        public void setName(String name) {
            this.iAreaName = name;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof AcademicAreaInterface)) {
                return false;
            }
            return this.getId().equals(((AcademicAreaInterface)o).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        @Override
        public int compareTo(AcademicAreaInterface area) {
            int cmp = this.getAbbv().compareTo(area.getAbbv());
            if (cmp != 0) {
                return cmp;
            }
            return this.getId().compareTo(area.getId());
        }
    }
}

