/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.unitime.timetable.gwt.client.GwtHint;
import org.unitime.timetable.gwt.client.instructor.InstructorAvailabilityWidget;
import org.unitime.timetable.gwt.client.rooms.RoomCookie;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.shared.InstructorInterface;

public class TimePreferenceCell
extends P
implements UniTimeTable.HasRefresh {
    private InstructorInterface.TeachingRequestsPagePropertiesResponse iProperties;
    private String iPattern = null;
    private List<InstructorInterface.PreferenceInfo> iPreferences = null;
    private static InstructorAvailabilityWidget sAvailability = new InstructorAvailabilityWidget();

    public TimePreferenceCell(InstructorInterface.TeachingRequestsPagePropertiesResponse properties) {
        super("preferences");
        this.iProperties = properties;
        this.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TimePreferenceCell.this.iPattern != null) {
                    TimePreferenceCell.this.iProperties.getInstructorAvailabilityModel().setPattern(TimePreferenceCell.this.iPattern);
                    sAvailability.setModel(TimePreferenceCell.this.iProperties.getInstructorAvailabilityModel());
                    GwtHint.showHint((Element)TimePreferenceCell.this.getElement(), (Widget)sAvailability);
                }
            }
        });
        this.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                GwtHint.hideHint();
            }
        });
    }

    public TimePreferenceCell(InstructorInterface.TeachingRequestsPagePropertiesResponse properties, InstructorInterface.InstructorInfo instructor) {
        this(properties);
        this.setValue(instructor);
    }

    public void setValue(InstructorInterface.InstructorInfo instructor) {
        this.iPattern = instructor.getAvailability();
        this.iPreferences = instructor.getTimePreferences();
        this.refresh();
    }

    @Override
    public void refresh() {
        this.clear();
        RoomCookie cookie = RoomCookie.getInstance();
        if (this.iPattern != null && !this.iPattern.isEmpty() && !cookie.isGridAsText()) {
            Image availability = new Image(GWT.getHostPageBaseURL() + "pattern?pref=" + this.iPattern + "&v=" + (cookie.areRoomsHorizontal() ? "0" : "1") + (cookie.hasMode() ? "&s=" + cookie.getMode() : ""));
            availability.setStyleName("grid");
            this.add((Widget)availability);
        } else {
            for (InstructorInterface.PreferenceInfo p : this.iPreferences) {
                P prf = new P("prf");
                prf.setText(p.getOwnerName());
                InstructorInterface.PreferenceInterface preference = this.iProperties.getPreference(p.getPreference());
                if (preference != null) {
                    prf.getElement().getStyle().setColor(preference.getColor());
                    prf.setTitle(preference.getName() + " " + p.getOwnerName());
                }
                this.add((Widget)prf);
            }
        }
    }
}

