/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverPredefinedSetting;
import org.unitime.timetable.model.dao.SolverParameterDefDAO;
import org.unitime.timetable.util.ComboBoxLookup;

public class SolverSettingsForm
implements UniTimeForm {
    private static final long serialVersionUID = -9205033432561871308L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String op;
    private Long uniqueId;
    private String name;
    private String description;
    private String appearance;
    private Map<Long, String> params;
    private Map<Long, Boolean> useDefaults;

    public SolverSettingsForm() {
        this.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
        if (this.name == null || this.name.isEmpty()) {
            action.addFieldError("form.name", MSG.errorRequiredField(MSG.fieldReference()));
        } else {
            SolverPredefinedSetting set = SolverPredefinedSetting.findByName(this.name);
            if (this.uniqueId != null) {
                if (set != null && !set.getUniqueId().equals(this.uniqueId)) {
                    action.addFieldError("form.name", MSG.errorAlreadyExists(this.name));
                }
            } else if (set != null) {
                action.addFieldError("form.name", MSG.errorAlreadyExists(this.name));
            }
        }
        if (this.description == null || this.description.isEmpty()) {
            action.addFieldError("form.description", MSG.errorRequiredField(MSG.fieldName()));
        }
        if (this.appearance == null || this.appearance.isEmpty()) {
            action.addFieldError("form.appearance", MSG.errorRequiredField(MSG.fieldAppearance()));
        }
        for (Map.Entry<Long, String> entry : this.params.entrySet()) {
            Long parm = entry.getKey();
            String val = entry.getValue();
            Boolean useDefault = this.useDefaults.get(parm);
            if (useDefault.booleanValue() || val != null && !val.isEmpty()) continue;
            action.addFieldError("form.parameter[" + parm + "]", MSG.errorRequiredField(((SolverParameterDef)SolverParameterDefDAO.getInstance().get(parm)).getDescription()));
        }
    }

    @Override
    public void reset() {
        this.name = "";
        this.description = "";
        this.op = null;
        this.uniqueId = null;
        this.appearance = SolverPredefinedSetting.Appearance.SOLVER.name();
        this.params = new HashMap<Long, String>();
        this.useDefaults = new HashMap<Long, Boolean>();
    }

    public void loadDefaults() {
        this.params.clear();
        this.useDefaults.clear();
        for (SolverParameterDef def : SolverParameterDefDAO.getInstance().findAll()) {
            if (!def.isVisible().booleanValue()) continue;
            this.params.put(def.getUniqueId(), def.getDefault());
            this.useDefaults.put(def.getUniqueId(), Boolean.TRUE);
        }
    }

    public void loadDefaults(HttpServletRequest request) {
        this.params.clear();
        this.useDefaults.clear();
        for (SolverParameterDef def : SolverParameterDefDAO.getInstance().findAll()) {
            if (!def.isVisible().booleanValue()) continue;
            this.params.put(def.getUniqueId(), request.getParameter("parameter[" + def.getUniqueId() + "]") == null ? def.getDefault() : request.getParameter("parameter[" + def.getUniqueId() + "]"));
            this.useDefaults.put(def.getUniqueId(), request.getParameter("useDefault[" + def.getUniqueId() + "]") == null || "false".equals(request.getParameter("useDefault[" + def.getUniqueId() + "]")) ? Boolean.FALSE : Boolean.TRUE);
        }
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public Long getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAppearance() {
        return this.appearance;
    }

    public void setAppearance(String appearance) {
        this.appearance = appearance;
    }

    public SolverPredefinedSetting.Appearance getAppearanceType() {
        for (SolverPredefinedSetting.Appearance a : SolverPredefinedSetting.Appearance.values()) {
            if (!a.name().equals(this.appearance)) continue;
            return a;
        }
        return null;
    }

    public void setAppearanceType(SolverPredefinedSetting.Appearance appearance) {
        if (appearance == null) {
            this.appearance = "";
        }
        this.appearance = appearance.name();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getUseDefault(Long id) {
        return this.useDefaults.get(id);
    }

    public void setUseDefault(Long id, Boolean useDefault) {
        this.useDefaults.put(id, useDefault);
    }

    public String getParameter(Long id) {
        return this.params.get(id);
    }

    public void setParameter(Long id, String value) {
        this.params.put(id, value);
    }

    public List<ComboBoxLookup> getAppearances() {
        ArrayList<ComboBoxLookup> ret = new ArrayList<ComboBoxLookup>();
        for (SolverPredefinedSetting.Appearance a : SolverPredefinedSetting.Appearance.values()) {
            ret.add(new ComboBoxLookup(a.getLabel(), a.name()));
        }
        return ret;
    }

    public Collection getEnum(String type) {
        Vector<String> options = new Vector<String>();
        StringTokenizer stk = new StringTokenizer(type, ",");
        while (stk.hasMoreTokens()) {
            options.add(stk.nextToken());
        }
        return options;
    }
}

