/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unitime.timetable.export.Exporter;

public class JSONPrinter
implements Exporter.Printer {
    private PrintWriter iOut;
    private Set<Integer> iHiddenColumns = new HashSet<Integer>();
    private String[] iHeader = null;
    private List<Map<String, Object>> iList = new ArrayList<Map<String, Object>>();

    public JSONPrinter(PrintWriter writer) {
        this.iOut = writer;
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public void hideColumn(int col) {
        this.iHiddenColumns.add(col);
    }

    @Override
    public void printHeader(String ... fields) {
        this.iHeader = fields;
    }

    @Override
    public void printLine(String ... fields) {
        HashMap<String, Object> entry = new HashMap<String, Object>();
        for (int idx = 0; idx < fields.length; ++idx) {
            if (this.iHiddenColumns.contains(idx)) continue;
            String f = fields[idx];
            String h = this.iHeader[idx];
            if (f == null) continue;
            try {
                entry.put(h, Integer.parseInt(f));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    entry.put(h, Double.parseDouble(f));
                    continue;
                }
                catch (NumberFormatException numberFormatException2) {
                    if ("true".equals(f)) {
                        entry.put(h, Boolean.TRUE);
                        continue;
                    }
                    if ("false".equals(f)) {
                        entry.put(h, Boolean.FALSE);
                        continue;
                    }
                    entry.put(h, f);
                }
            }
        }
        this.iList.add(entry);
    }

    protected Gson createGson() {
        return new GsonBuilder().setPrettyPrinting().create();
    }

    @Override
    public void flush() {
        this.iOut.print(this.createGson().toJson(this.iList));
        this.iOut.flush();
    }

    @Override
    public void close() {
    }
}

