/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.Element;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.CurriculumCourse;
import org.unitime.timetable.model.CurriculumCourseGroup;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseAcademicClassification;
import org.unitime.timetable.util.Constants;

public class CurriculaImport
extends BaseImport {
    @Override
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("curricula")) {
            throw new Exception("Given XML file is not a Curricula load file.");
        }
        try {
            this.beginTransaction();
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            String created = root.attributeValue("created");
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            if (created != null) {
                ChangeLog.addChange(this.getHibSession(), this.getManager(), session, session, created, ChangeLog.Source.DATA_IMPORT_CURRICULA, ChangeLog.Operation.UPDATE, null, null);
            }
            this.info("Deleting existing curricula...");
            Iterator i = this.getHibSession().createQuery("select c from Curriculum c where c.department.session=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list().iterator();
            while (i.hasNext()) {
                this.getHibSession().delete(i.next());
            }
            this.flush(false);
            this.info("Loading areas, departments, majors, and classifications...");
            Hashtable<String, AcademicArea> areasByAbbv = new Hashtable<String, AcademicArea>();
            Hashtable<String, AcademicArea> areasByExtId = new Hashtable<String, AcademicArea>();
            for (AcademicArea area : this.getHibSession().createQuery("select a from AcademicArea a where a.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                areasByAbbv.put(area.getAcademicAreaAbbreviation(), area);
                if (area.getExternalUniqueId() == null) continue;
                areasByExtId.put(area.getExternalUniqueId(), area);
            }
            Hashtable<String, Department> departmentsByCode = new Hashtable<String, Department>();
            Hashtable<String, Department> departmentsByExtId = new Hashtable<String, Department>();
            for (Department dept : this.getHibSession().createQuery("select a from Department a where a.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                departmentsByCode.put(dept.getDeptCode(), dept);
                if (dept.getExternalUniqueId() == null) continue;
                departmentsByExtId.put(dept.getExternalUniqueId(), dept);
            }
            Hashtable<String, PosMajor> majorsByCode = new Hashtable<String, PosMajor>();
            Hashtable<String, PosMajor> majorsByExtId = new Hashtable<String, PosMajor>();
            for (PosMajor major : this.getHibSession().createQuery("select a from PosMajor a where a.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                for (AcademicArea area : major.getAcademicAreas()) {
                    majorsByCode.put(area.getAcademicAreaAbbreviation() + ":" + major.getCode(), major);
                }
                if (major.getExternalUniqueId() == null) continue;
                majorsByExtId.put(major.getExternalUniqueId(), major);
            }
            Hashtable<String, AcademicClassification> clasfsByCode = new Hashtable<String, AcademicClassification>();
            Hashtable<String, AcademicClassification> clasfsByExtId = new Hashtable<String, AcademicClassification>();
            for (AcademicClassification clasf : this.getHibSession().createQuery("select a from AcademicClassification a where a.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                clasfsByCode.put(clasf.getCode(), clasf);
                if (clasf.getExternalUniqueId() == null) continue;
                clasfsByExtId.put(clasf.getExternalUniqueId(), clasf);
            }
            this.info("Loading courses...");
            Hashtable<String, CourseOffering> corusesByExtId = new Hashtable<String, CourseOffering>();
            Hashtable<String, CourseOffering> corusesBySubjectCourseNbr = new Hashtable<String, CourseOffering>();
            for (CourseOffering course : this.getHibSession().createQuery("select a from CourseOffering a where a.subjectArea.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                corusesBySubjectCourseNbr.put(course.getSubjectArea().getSubjectAreaAbbreviation() + "|" + course.getCourseNbr(), course);
                if (course.getExternalUniqueId() == null) continue;
                corusesByExtId.put(course.getExternalUniqueId(), course);
            }
            this.info("Importing curricula...");
            Iterator i2 = root.elementIterator();
            block9: while (i2.hasNext()) {
                Element curriculumElement = (Element)i2.next();
                Curriculum curriculum = new Curriculum();
                String abbv = curriculumElement.attributeValue("abbreviation");
                String name = curriculumElement.attributeValue("name");
                AcademicArea area = null;
                Iterator j = curriculumElement.elementIterator("academicArea");
                while (j.hasNext()) {
                    Element areaElement = (Element)j.next();
                    String externalId = areaElement.attributeValue("externalId");
                    String abbreviation = areaElement.attributeValue("abbreviation");
                    area = externalId != null ? (AcademicArea)areasByExtId.get(externalId) : (AcademicArea)areasByAbbv.get(abbreviation);
                    if (area != null) continue;
                    this.error("Academic area " + areaElement.asXML() + " does not exist.");
                    continue block9;
                }
                if (area == null) {
                    this.error("No academic area provided for a curriculum.");
                    continue;
                }
                curriculum.setAcademicArea(area);
                Department dept = null;
                Iterator j2 = curriculumElement.elementIterator("department");
                while (j2.hasNext()) {
                    Element deptElement = (Element)j2.next();
                    String externalId = deptElement.attributeValue("externalId");
                    String code = deptElement.attributeValue("code");
                    dept = externalId != null ? (Department)departmentsByExtId.get(externalId) : (Department)departmentsByCode.get(code);
                    if (dept != null) continue;
                    this.error("Department " + deptElement.asXML() + " does not exist.");
                }
                curriculum.setMajors(new HashSet<PosMajor>());
                ArrayList<PosMajor> majors = new ArrayList<PosMajor>();
                Iterator j3 = curriculumElement.elementIterator("major");
                while (j3.hasNext()) {
                    PosMajor major;
                    Element majorElement = (Element)j3.next();
                    String externalId = majorElement.attributeValue("externalId");
                    String code = majorElement.attributeValue("code");
                    PosMajor posMajor = major = externalId != null ? (PosMajor)majorsByExtId.get(externalId) : (PosMajor)majorsByCode.get(area.getAcademicAreaAbbreviation() + ":" + code);
                    if (major == null) {
                        this.error("Major " + majorElement.asXML() + " does not exist.");
                        continue;
                    }
                    curriculum.getMajors().add(major);
                    majors.add(major);
                }
                if (abbv == null) {
                    abbv = area.getAcademicAreaAbbreviation() + (majors.isEmpty() ? "" : "/");
                    for (PosMajor major : majors) {
                        if (!abbv.endsWith("/")) {
                            abbv = abbv + ",";
                        }
                        abbv = abbv + major.getCode();
                    }
                }
                if (abbv.length() > 20) {
                    abbv = abbv.substring(0, 20);
                }
                curriculum.setAbbv(abbv);
                if (name == null) {
                    name = Constants.curriculaToInitialCase(area.getTitle()) + (majors.isEmpty() ? "" : " / ");
                    for (PosMajor major : majors) {
                        if (!name.endsWith(" / ")) {
                            name = name + ", ";
                        }
                        name = name + Constants.curriculaToInitialCase(major.getName());
                    }
                }
                if (name.length() > 60) {
                    name = name.substring(0, 60);
                }
                curriculum.setName(name);
                curriculum.setMultipleMajors("true".equalsIgnoreCase(curriculumElement.attributeValue("multipleMajors", "false")));
                Hashtable<String, CurriculumCourseGroup> groups = new Hashtable<String, CurriculumCourseGroup>();
                int clasfOrd = 0;
                curriculum.setClassifications(new HashSet<CurriculumClassification>());
                Iterator j4 = curriculumElement.elementIterator("classification");
                block15: while (j4.hasNext()) {
                    Element clasfElement = (Element)j4.next();
                    String clasfName = clasfElement.attributeValue("name");
                    CurriculumClassification clasf = new CurriculumClassification();
                    BaseAcademicClassification acadClasf = null;
                    Iterator k = clasfElement.elementIterator("academicClassification");
                    while (k.hasNext()) {
                        Element acadClasfElement = (Element)k.next();
                        String externalId = acadClasfElement.attributeValue("externalId");
                        String code = acadClasfElement.attributeValue("code");
                        acadClasf = externalId != null ? (AcademicClassification)clasfsByExtId.get(externalId) : (AcademicClassification)clasfsByCode.get(code);
                        if (acadClasf != null) continue;
                        this.error("Academic classification " + acadClasfElement.asXML() + " does not exist.");
                        continue block15;
                    }
                    if (acadClasf == null) {
                        this.error("No academic classification provided for a curriculum classification.");
                        continue;
                    }
                    clasf.setAcademicClassification((AcademicClassification)acadClasf);
                    if (clasfName == null) {
                        clasfName = acadClasf.getCode();
                    }
                    clasf.setName(clasfName);
                    clasf.setOrd(clasfOrd++);
                    curriculum.getClassifications().add(clasf);
                    clasf.setCurriculum(curriculum);
                    String enrollment = clasfElement.attributeValue("enrollment", "0");
                    clasf.setNrStudents(Integer.parseInt(enrollment));
                    clasf.setCourses(new HashSet<CurriculumCourse>());
                    int courseOrd = 0;
                    Iterator k2 = clasfElement.elementIterator("course");
                    while (k2.hasNext()) {
                        CourseOffering courseOffering;
                        Element courseElement = (Element)k2.next();
                        String externalId = courseElement.attributeValue("externalId");
                        String subjectCourseNbr = courseElement.attributeValue("subject") + "|" + courseElement.attributeValue("courseNbr");
                        CourseOffering courseOffering2 = courseOffering = externalId != null ? (CourseOffering)corusesByExtId.get(externalId) : (CourseOffering)corusesBySubjectCourseNbr.get(subjectCourseNbr);
                        if (courseOffering == null) {
                            this.error("Course " + courseElement.asXML() + " does not exist.");
                            continue;
                        }
                        CurriculumCourse course = new CurriculumCourse();
                        course.setCourse(courseOffering);
                        course.setOrd(courseOrd++);
                        String share = courseElement.attributeValue("share", "1.0");
                        course.setPercShare(Float.valueOf(Float.parseFloat(share)));
                        course.setClassification(clasf);
                        clasf.getCourses().add(course);
                        course.setGroups(new HashSet<CurriculumCourseGroup>());
                        Iterator l = courseElement.elementIterator("group");
                        while (l.hasNext()) {
                            Element groupElement = (Element)l.next();
                            CurriculumCourseGroup group = (CurriculumCourseGroup)groups.get(groupElement.attributeValue("id"));
                            if (group == null) {
                                group = new CurriculumCourseGroup();
                                group.setCurriculum(curriculum);
                                groups.put(groupElement.attributeValue("id"), group);
                                group.setType(0);
                                group.setName(groupElement.attributeValue("id"));
                            }
                            course.getGroups().add(group);
                            String grName = groupElement.attributeValue("name");
                            String grType = groupElement.attributeValue("type");
                            if (grName != null) {
                                group.setName(grName);
                            }
                            if (grType == null) continue;
                            group.setType("OPT".equalsIgnoreCase(grType) ? 0 : 1);
                        }
                    }
                }
                if (curriculum.getDepartment() == null) {
                    Hashtable<Department, Float> dept2enrl = new Hashtable<Department, Float>();
                    for (CurriculumClassification clasf : curriculum.getClassifications()) {
                        for (CurriculumCourse course : clasf.getCourses()) {
                            Department d = course.getCourse().getSubjectArea().getDepartment();
                            Float x = (Float)dept2enrl.get(d);
                            dept2enrl.put(d, Float.valueOf(course.getPercShare().floatValue() * (float)clasf.getNrStudents().intValue() + (x == null ? 0.0f : x.floatValue())));
                        }
                    }
                    float best = 0.0f;
                    for (Map.Entry entry : dept2enrl.entrySet()) {
                        if (dept != null && !(((Float)entry.getValue()).floatValue() > best)) continue;
                        dept = (Department)entry.getKey();
                        best = ((Float)entry.getValue()).floatValue();
                    }
                    if (dept == null) {
                        this.error("Unable to guess department for curriculum " + curriculum.getName() + ", it has no courses.");
                        continue;
                    }
                    curriculum.setDepartment(dept);
                }
                this.getHibSession().saveOrUpdate((Object)curriculum);
                for (CurriculumCourseGroup group : groups.values()) {
                    this.getHibSession().saveOrUpdate((Object)group);
                }
                this.flushIfNeeded(false);
            }
            this.info("All done.");
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                args = new String[]{"curricula.xml"};
            }
            ToolBox.configureLogging();
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            new CurriculaImport().loadXml(args[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

