/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.BlankForm;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.context.UniTimeUserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Formats;

@Action(value="sessionList", results={@Result(name={"showSessionList"}, type="tiles", location="sessionList.tiles")})
@TilesDefinition(name="sessionList.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Academic Sessions"), @TilesPutAttribute(name="body", value="/admin/sessionList.jsp")})
public class SessionListAction
extends UniTimeAction<BlankForm> {
    private static final long serialVersionUID = -6663444732727632201L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    public String execute() throws Exception {
        this.sessionContext.checkPermission(Right.AcademicSessions);
        WebTable webTable = new WebTable(12, "", "sessionList.action?order=%%", new String[]{MSG.columnAcademicSessionDefault().replace("\n", "<br>"), MSG.columnAcademicSessionTermYear().replace("\n", "<br>"), MSG.columnAcademicSessionInitiative().replace("\n", "<br>"), MSG.columnAcademicSessionStartDate().replace("\n", "<br>"), MSG.columnAcademicSessionClassesEndDate().replace("\n", "<br>"), MSG.columnAcademicSessionEndDate().replace("\n", "<br>"), MSG.columnAcademicSessionExamStartDate().replace("\n", "<br>"), MSG.columnAcademicSessionDefaultDatePattern().replace("\n", "<br>"), MSG.columnAcademicSessionCurrentStatus().replace("\n", "<br>"), MSG.columnAcademicSessionClassDuration().replace("\n", "<br>"), MSG.columnAcademicSessionEventStartDate().replace("\n", "<br>"), MSG.columnAcademicSessionEventEndDate().replace("\n", "<br>"), MSG.columnAcademicSessionEnrollmentAddDeadline().replace("\n", "<br>"), MSG.columnAcademicSessionEnrollmentChangeDeadline().replace("\n", "<br>"), MSG.columnAcademicSessionEnrollmentDropDeadline().replace("\n", "<br>"), MSG.columnAcademicSessionSectioningStatus().replace("\n", "<br>"), MSG.columnAcademicSessionDefaultInstructionalMethod().replace("\n", "<br>")}, new String[]{"center", "left", "left", "left", "left", "left", "left", "left", "left", "right", "left", "left", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, false, false, false, true, false, true, true, true, true, true, true, true, true});
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.SESSION_DATE);
        TreeSet<Session> sessions = new TreeSet<Session>(SessionDAO.getInstance().findAll());
        Session defaultSession = UniTimeUserContext.defaultSession(sessions, this.sessionContext.getUser().getCurrentAuthority(), UserProperty.PrimaryCampus.get(this.sessionContext.getUser()));
        for (Session s : SessionDAO.getInstance().findAll()) {
            Calendar ce = Calendar.getInstance(Locale.US);
            ce.setTime(s.getSessionBeginDateTime());
            ce.add(3, s.getLastWeekToEnroll());
            ce.add(6, -1);
            Calendar cc = Calendar.getInstance(Locale.US);
            cc.setTime(s.getSessionBeginDateTime());
            cc.add(3, s.getLastWeekToChange());
            cc.add(6, -1);
            Calendar cd = Calendar.getInstance(Locale.US);
            cd.setTime(s.getSessionBeginDateTime());
            cd.add(3, s.getLastWeekToDrop());
            cd.add(6, -1);
            webTable.addLine(this.sessionContext.hasPermission(s, Right.AcademicSessionEdit) ? "onClick=\"document.location='sessionEdit.action?op=editSession&sessionId=" + s.getSessionId() + "';\"" : null, new String[]{s.equals(defaultSession) ? "<img src='images/accept.png'> " : "&nbsp; ", s.getAcademicTerm() + " " + s.getSessionStartYear(), s.academicInitiativeDisplayString(), df.format(s.getSessionBeginDateTime()).replace(" ", "&nbsp;"), df.format(s.getClassesEndDateTime()).replace(" ", "&nbsp;"), df.format(s.getSessionEndDateTime()).replace(" ", "&nbsp;"), s.getExamBeginDate() == null ? "N/A" : df.format(s.getExamBeginDate()).replace(" ", "&nbsp;"), s.getDefaultDatePattern() != null ? s.getDefaultDatePattern().getName() : "-", s.statusDisplayString(), s.getDefaultClassDurationType() == null ? "&nbsp;" : s.getDefaultClassDurationType().getAbbreviation(), s.getEventBeginDate() == null ? "N/A" : df.format(s.getEventBeginDate()).replace(" ", "&nbsp;"), s.getEventEndDate() == null ? "N/A" : df.format(s.getEventEndDate()).replace(" ", "&nbsp;"), df.format(ce.getTime()).replace(" ", "&nbsp;"), df.format(cc.getTime()).replace(" ", "&nbsp;"), df.format(cd.getTime()).replace(" ", "&nbsp;"), s.getDefaultSectioningStatus() == null ? "&nbsp;" : s.getDefaultSectioningStatus().getReference(), s.getDefaultInstructionalMethod() == null ? "&nbsp;" : s.getDefaultInstructionalMethod().getReference()}, new Comparable[]{s.equals(defaultSession) ? "<img src='images/accept.png'>" : "", s.getLabel(), s.academicInitiativeDisplayString(), s.getSessionBeginDateTime(), s.getClassesEndDateTime(), s.getSessionEndDateTime(), s.getExamBeginDate(), s.getDefaultDatePattern() != null ? s.getDefaultDatePattern().getName() : "-", s.statusDisplayString(), s.getDefaultClassDurationType() == null ? " " : s.getDefaultClassDurationType().getAbbreviation(), s.getEventBeginDate(), s.getEventEndDate(), ce.getTime(), cc.getTime(), cd.getTime(), s.getDefaultSectioningStatus() == null ? " " : s.getDefaultSectioningStatus().getReference(), s.getDefaultInstructionalMethod() == null ? "" : s.getDefaultInstructionalMethod().getReference()});
        }
        webTable.enableHR("#9CB0CE");
        int orderCol = 4;
        if (this.request.getParameter("order") != null) {
            try {
                orderCol = Integer.parseInt(this.request.getParameter("order"));
            }
            catch (Exception e) {
                orderCol = 4;
            }
        }
        this.request.setAttribute("table", (Object)webTable.printTable(orderCol));
        return "showSessionList";
    }
}

