/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.dom4j.Document;
import org.hibernate.MappingException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.hql.internal.QueryExecutionRequestException;
import org.hibernate.hql.internal.ast.ASTQueryTranslatorFactory;
import org.hibernate.hql.spi.QueryTranslator;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;
import org.unitime.commons.Debug;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.export.BufferedPrinter;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.hql.TestHqlExportToCSV;
import org.unitime.timetable.form.HibernateQueryTestForm;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.Navigation;

@Action(value="hibernateQueryTest", results={@Result(name={"displayQueryForm"}, type="tiles", location="hibernateQueryTest.tiles")})
@TilesDefinition(name="hibernateQueryTest.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Test HQL"), @TilesPutAttribute(name="body", value="/admin/hibernateQueryTest.jsp")})
public class HibernateQueryTestAction
extends UniTimeAction<HibernateQueryTestForm> {
    private static final long serialVersionUID = 4379704237143143345L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    public String execute() throws Exception {
        String url;
        String q;
        this.sessionContext.checkPermission(Right.TestHQL);
        if (this.form == null) {
            this.form = new HibernateQueryTestForm();
        }
        if (this.op == null) {
            return "displayQueryForm";
        }
        if (MSG.actionClearCache().equals(this.op)) {
            HibernateUtil.clearCache();
            return "displayQueryForm";
        }
        if (("Back".equals(this.op) || MSG.actionBackToDetail().equals(this.op)) && (((HibernateQueryTestForm)this.form).getQuery() == null || ((HibernateQueryTestForm)this.form).getQuery().isEmpty()) && (q = (String)this.request.getSession().getAttribute("TestHQL.LastQuery")) != null) {
            ((HibernateQueryTestForm)this.form).setQuery(q);
        }
        ((HibernateQueryTestForm)this.form).validate(this);
        if (MSG.actionNextQueryResults().equals(this.op)) {
            ((HibernateQueryTestForm)this.form).setStart(((HibernateQueryTestForm)this.form).getStart() + ApplicationProperty.TestHQLMaxLines.intValue());
        }
        if (MSG.actionPreviousQueryResults().equals(this.op)) {
            ((HibernateQueryTestForm)this.form).setStart(Math.max(0, ((HibernateQueryTestForm)this.form).getStart() - ApplicationProperty.TestHQLMaxLines.intValue()));
        }
        if (MSG.actionSubmitQuery().equals(this.op)) {
            ((HibernateQueryTestForm)this.form).setStart(0);
        }
        if (MSG.actionExportCsv().equals(this.op) && !this.hasFieldErrors()) {
            String query = ((HibernateQueryTestForm)this.form).getQuery();
            for (SavedHQL.Option o : SavedHQL.Option.values()) {
                if (query.indexOf("%" + o.name() + "%") < 0) continue;
                String value = null;
                if (value == null || value.isEmpty()) {
                    Map<Long, String> vals = o.values(this.sessionContext.getUser());
                    if (vals == null || vals.isEmpty()) {
                        this.addFieldError("form.query", MSG.errorCannotSetQueryParameterNoValues());
                        return "displayQueryForm";
                    }
                    value = "";
                    for (Long id : vals.keySet()) {
                        if (!value.isEmpty()) {
                            value = value + ",";
                        }
                        value = value + id.toString();
                    }
                }
                query = query.replace("%" + o.name() + "%", "(" + value + ")");
            }
            if (query.indexOf("%USER%") >= 0) {
                query = query.replace("%USER%", HibernateUtil.escapeSql(this.sessionContext.getUser().getExternalUserId()));
            }
            BufferedPrinter out = new BufferedPrinter(new CSVPrinter(this.response.getWriter(), false));
            this.response.setContentType(out.getContentType() + "; charset=UTF-8");
            this.response.setCharacterEncoding("UTF-8");
            this.response.setHeader("Pragma", "no-cache");
            this.response.addHeader("Cache-Control", "must-revalidate");
            this.response.addHeader("Cache-Control", "no-cache");
            this.response.addHeader("Cache-Control", "no-store");
            this.response.setDateHeader("Date", new Date().getTime());
            this.response.setDateHeader("Expires", 0L);
            this.response.setHeader("Content-Disposition", "attachment; filename=\"hql-test.csv\"");
            TestHqlExportToCSV.execute(this.sessionContext.getUser(), out, query, 0, -1);
            out.close();
            return null;
        }
        ((HibernateQueryTestForm)this.form).setExport(false);
        if (!this.hasFieldErrors()) {
            try {
                int limit = ApplicationProperty.TestHQLMaxLines.intValue();
                String query = ((HibernateQueryTestForm)this.form).getQuery();
                for (SavedHQL.Option o : SavedHQL.Option.values()) {
                    if (query.indexOf("%" + o.name() + "%") < 0) continue;
                    String value = null;
                    if (value == null || value.isEmpty()) {
                        Map<Long, String> vals = o.values(this.sessionContext.getUser());
                        if (vals == null || vals.isEmpty()) {
                            this.addFieldError("form.query", MSG.errorCannotSetQueryParameterNoValues());
                            return "displayQueryForm";
                        }
                        value = "";
                        for (Long id : vals.keySet()) {
                            if (!value.isEmpty()) {
                                value = value + ",";
                            }
                            value = value + id.toString();
                        }
                    }
                    query = query.replace("%" + o.name() + "%", "(" + value + ")");
                }
                if (query.indexOf("%USER%") >= 0) {
                    query = query.replace("%USER%", HibernateUtil.escapeSql(this.sessionContext.getUser().getExternalUserId()));
                }
                _RootDAO rdao = new _RootDAO();
                Session hibSession = rdao.getSession();
                Query q2 = hibSession.createQuery(query);
                try {
                    String hqlQueryString = q2.getQueryString();
                    ASTQueryTranslatorFactory queryTranslatorFactory = new ASTQueryTranslatorFactory();
                    QueryTranslator queryTranslator = queryTranslatorFactory.createQueryTranslator("", hqlQueryString, Collections.EMPTY_MAP, (SessionFactoryImplementor)hibSession.getSessionFactory(), null);
                    queryTranslator.compile(Collections.EMPTY_MAP, false);
                    this.request.setAttribute("sql", (Object)queryTranslator.getSQLString());
                }
                catch (Exception e) {
                    Debug.error(e);
                }
                q2.setFirstResult(((HibernateQueryTestForm)this.form).getStart());
                if (limit > 0) {
                    q2.setMaxResults(limit + 1);
                }
                try {
                    List l = q2.list();
                    String[] alias = q2.getReturnAliases();
                    ArrayList<Long> ids = new ArrayList<Long>();
                    StringBuffer s = new StringBuffer();
                    Iterator i = l.iterator();
                    for (int line = 0; i.hasNext() && (limit <= 0 || line < limit); ++line) {
                        Object o = i.next();
                        if (s.length() == 0) {
                            this.printHeader(s, o, alias);
                        }
                        this.printLine(s, o, (SessionImplementor)hibSession, alias);
                        if (o == null || !(o instanceof Object[]) || ((Object[])o).length <= 0 || ((Object[])o)[0] == null || !(((Object[])o)[0] instanceof Long)) continue;
                        ids.add((Long)((Object[])o)[0]);
                    }
                    if (s.length() > 0) {
                        this.printFooter(s);
                        this.request.setAttribute("result", (Object)s.toString());
                    }
                    if (((HibernateQueryTestForm)this.form).getStart() == 0) {
                        if (limit > 0 && l.size() > limit) {
                            ((HibernateQueryTestForm)this.form).setListSize(limit + "+ " + MSG.queryLines());
                        } else {
                            ((HibernateQueryTestForm)this.form).setListSize(l.size() + " " + MSG.queryLines());
                        }
                    } else if (limit > 0 && l.size() > limit) {
                        ((HibernateQueryTestForm)this.form).setListSize(MSG.queryLines() + " " + ((HibernateQueryTestForm)this.form).getStart() + " ... " + (((HibernateQueryTestForm)this.form).getStart() + limit));
                    } else {
                        ((HibernateQueryTestForm)this.form).setListSize(MSG.queryLines() + " " + ((HibernateQueryTestForm)this.form).getStart() + " ... " + (((HibernateQueryTestForm)this.form).getStart() + l.size()));
                    }
                    ((HibernateQueryTestForm)this.form).setExport(!l.isEmpty());
                    ((HibernateQueryTestForm)this.form).setNext(limit > 0 && l.size() > limit);
                    if (!ids.isEmpty() && alias != null && alias.length > 0 && alias[0].startsWith("__")) {
                        if ("__Class".equals(alias[0])) {
                            Navigation.set(this.sessionContext, Navigation.sClassLevel, ids);
                        } else if ("__Offering".equals(alias[0])) {
                            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, ids);
                        } else if ("__Subpart".equals(alias[0])) {
                            Navigation.set(this.sessionContext, Navigation.sSchedulingSubpartLevel, ids);
                        } else if ("__Room".equals(alias[0])) {
                            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, ids);
                        } else if ("__Instructor".equals(alias[0])) {
                            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, ids);
                        } else if ("__Exam".equals(alias[0])) {
                            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, ids);
                        } else if ("__Event".equals(alias[0])) {
                            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, ids);
                        }
                    }
                }
                catch (QueryExecutionRequestException e) {
                    Transaction tx = null;
                    try {
                        tx = hibSession.beginTransaction();
                        int i = q2.executeUpdate();
                        this.request.setAttribute("result", (Object)MSG.queryLinesUpdated(i));
                        ((HibernateQueryTestForm)this.form).setListSize(MSG.queryLinesUpdated(i));
                        tx.commit();
                    }
                    catch (Exception ex) {
                        if (tx != null && tx.isActive()) {
                            tx.rollback();
                        }
                        throw ex;
                    }
                    hibSession.flush();
                    HibernateUtil.clearCache();
                }
            }
            catch (SQLGrammarException e) {
                if (e.getSQLException() != null) {
                    this.addFieldError("form.query", e.getSQLException().getMessage());
                } else {
                    this.addFieldError("form.query", e.getMessage());
                }
            }
            catch (Exception e) {
                this.addFieldError("form.query", e.getMessage());
                Debug.error(e);
            }
        }
        if ((url = "hibernateQueryTest.action?form.query=" + URLEncoder.encode(((HibernateQueryTestForm)this.form).getQuery(), "utf-8") + "&form.start=" + ((HibernateQueryTestForm)this.form).getStart() + "&op=Back").length() <= 2000) {
            this.request.getSession().removeAttribute("TestHQL.LastQuery");
            BackTracker.markForBack(this.request, url, "HQL", true, true);
        } else {
            this.request.getSession().setAttribute("TestHQL.LastQuery", (Object)((HibernateQueryTestForm)this.form).getQuery());
            BackTracker.markForBack(this.request, "hibernateQueryTest.action?form.start=" + ((HibernateQueryTestForm)this.form).getStart() + "&op=Back", "HQL", true, true);
        }
        return "displayQueryForm";
    }

    private void header(StringBuffer s, int idx, String text) {
        block4: {
            s.append("<td class='WebTableHeader'><i>");
            if (text == null || text.length() <= 0) {
                s.append("Col " + idx);
            } else {
                try {
                    s.append("Col " + (1 + Integer.parseInt(text)));
                }
                catch (NumberFormatException e) {
                    s.append(text.substring(0, 1).toUpperCase());
                    if (text.length() <= 1) break block4;
                    s.append(text.substring(1).replace('_', ' '));
                }
            }
        }
        s.append("</i></td>");
    }

    private boolean skip(Type t, boolean lazy) {
        try {
            if (t.isCollectionType()) {
                if (!lazy) {
                    return true;
                }
                SessionFactory hibSessionFactory = new _RootDAO().getSession().getSessionFactory();
                Type w = ((CollectionType)t).getElementType((SessionFactoryImplementor)hibSessionFactory);
                Class<?> ts = w.getReturnedClass().getMethod("toString", new Class[0]).getDeclaringClass();
                return ts.equals(Object.class) || ts.getName().startsWith("org.unitime.timetable.model.base.Base");
            }
        }
        catch (MappingException e) {
            return true;
        }
        catch (NoSuchMethodException e) {
            return true;
        }
        try {
            Class<?> ts = t.getReturnedClass().getMethod("toString", new Class[0]).getDeclaringClass();
            return ts.equals(Object.class) || ts.getName().startsWith("org.unitime.timetable.model.base.Base");
        }
        catch (NoSuchMethodException e) {
            return true;
        }
    }

    public void printHeader(StringBuffer s, Object o, String[] alias) {
        s.append("<table width='100%' border='0' cellspacing='0' cellpadding='3' class='unitime-HQLTable'>");
        s.append("<tr align='left'>");
        SessionFactory hibSessionFactory = new _RootDAO().getSession().getSessionFactory();
        boolean hasLink = false;
        if (alias != null && alias.length > 0 && alias[0].startsWith("__")) {
            if ("__Class".equals(alias[0])) {
                hasLink = true;
            } else if ("__Offering".equals(alias[0])) {
                hasLink = true;
            } else if ("__Subpart".equals(alias[0])) {
                hasLink = true;
            } else if ("__Room".equals(alias[0])) {
                hasLink = true;
            } else if ("__Instructor".equals(alias[0])) {
                hasLink = true;
            } else if ("__Exam".equals(alias[0])) {
                hasLink = true;
            } else if ("__Event".equals(alias[0])) {
                hasLink = true;
            }
        }
        int idx = 1;
        if (o == null) {
            this.header(s, idx++, alias != null && alias.length > 0 && alias[0] != null && !alias[0].isEmpty() ? alias[0] : null);
        } else if (o instanceof Object[]) {
            Object[] x = (Object[])o;
            for (int i = 0; i < x.length; ++i) {
                String a;
                if (hasLink && i == 0) continue;
                String string = a = alias != null && alias.length > i && alias[i] != null && !alias[i].isEmpty() ? alias[i] : null;
                if (x[i] == null) {
                    this.header(s, idx++, a);
                    continue;
                }
                ClassMetadata meta = hibSessionFactory.getClassMetadata(x[i].getClass());
                if (meta == null) {
                    this.header(s, idx++, a);
                    continue;
                }
                this.header(s, idx++, meta.getIdentifierPropertyName());
                for (int j = 0; j < meta.getPropertyNames().length; ++j) {
                    if (this.skip(meta.getPropertyTypes()[j], meta.getPropertyLaziness()[j])) continue;
                    this.header(s, idx++, meta.getPropertyNames()[j]);
                }
            }
        } else {
            ClassMetadata meta = hibSessionFactory.getClassMetadata(o.getClass());
            if (meta == null) {
                this.header(s, idx++, alias != null && alias.length > 0 && alias[0] != null && !alias[0].isEmpty() ? alias[0] : null);
            } else {
                this.header(s, idx++, meta.getIdentifierPropertyName());
                for (int i = 0; i < meta.getPropertyNames().length; ++i) {
                    if (this.skip(meta.getPropertyTypes()[i], meta.getPropertyLaziness()[i])) continue;
                    this.header(s, idx++, meta.getPropertyNames()[i]);
                }
            }
        }
        s.append("</tr>");
    }

    private void line(StringBuffer s, Object text) {
        s.append("<td>");
        if (text != null) {
            if (text instanceof Document) {
                s.append(StringEscapeUtils.escapeHtml4((String)((Document)text).asXML()));
            } else {
                s.append(text.toString());
            }
        }
        s.append("</td>");
    }

    public void printLine(StringBuffer s, Object o, SessionImplementor session, String[] alias) {
        String link = null;
        if (alias != null && alias.length > 0 && alias[0].startsWith("__") && o != null && o instanceof Object[]) {
            if ("__Class".equals(alias[0])) {
                link = "classDetail.action?cid=" + ((Object[])o)[0];
            } else if ("__Offering".equals(alias[0])) {
                link = "instructionalOfferingDetail.action?op=view&io=" + ((Object[])o)[0];
            } else if ("__Subpart".equals(alias[0])) {
                link = "schedulingSubpartDetail.action?ssuid=" + ((Object[])o)[0];
            } else if ("__Room".equals(alias[0])) {
                link = "gwt.jsp?page=rooms&back=1&id=" + ((Object[])o)[0];
            } else if ("__Instructor".equals(alias[0])) {
                link = "instructorDetail.action?instructorId=" + ((Object[])o)[0];
            } else if ("__Exam".equals(alias[0])) {
                link = "examDetail.action?examId=" + ((Object[])o)[0];
            } else if ("__Event".equals(alias[0])) {
                link = "gwt.jsp?page=events#event=" + ((Object[])o)[0];
            }
        }
        s.append("<tr align='left' onmouseover=\"this.style.backgroundColor='rgb(223,231,242)';\" onmouseout=\"this.style.backgroundColor='transparent';\" " + (link == null ? "" : "onClick=\"document.location='" + link + "';\"") + ">");
        SessionFactory hibSessionFactory = new _RootDAO().getSession().getSessionFactory();
        if (o == null) {
            this.line(s, null);
        } else if (o instanceof Object[]) {
            Object[] x = (Object[])o;
            for (int i = 0; i < x.length; ++i) {
                if (link != null && i == 0) continue;
                if (x[i] == null) {
                    this.line(s, null);
                    continue;
                }
                ClassMetadata meta = hibSessionFactory.getClassMetadata(x[i].getClass());
                if (meta == null) {
                    this.line(s, x[i]);
                    continue;
                }
                this.line(s, meta.getIdentifier(x[i], session));
                for (int j = 0; j < meta.getPropertyNames().length; ++j) {
                    if (this.skip(meta.getPropertyTypes()[j], meta.getPropertyLaziness()[j])) continue;
                    this.line(s, meta.getPropertyValue(x[i], meta.getPropertyNames()[j]));
                }
            }
        } else {
            ClassMetadata meta = hibSessionFactory.getClassMetadata(o.getClass());
            if (meta == null) {
                this.line(s, o);
            } else {
                this.line(s, meta.getIdentifier(o, session));
                for (int i = 0; i < meta.getPropertyNames().length; ++i) {
                    if (this.skip(meta.getPropertyTypes()[i], meta.getPropertyLaziness()[i])) continue;
                    this.line(s, meta.getPropertyValue(o, meta.getPropertyNames()[i]));
                }
            }
        }
        s.append("</tr>");
    }

    public void printFooter(StringBuffer s) {
        s.append("</table>");
    }
}

