/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.hibernate.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.exception.spi.Configurable;
import org.hibernate.service.spi.Stoppable;
import org.unitime.timetable.model.base._BaseRootDAO;

public class DBCPConnectionProvider
implements ConnectionProvider,
Stoppable,
Configurable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DBCPConnectionProvider.class);
    private static final String PREFIX = "hibernate.dbcp.";
    private BasicDataSource ds;
    private static final String DBCP_PS_MAXACTIVE = "hibernate.dbcp.ps.maxActive";
    private static final Set SPECIAL_PROPERTIES = new HashSet();

    public void configure(Properties props) throws HibernateException {
        try {
            String value;
            Properties driverProps;
            String autocommit;
            log.debug((Object)"Configure DBCPConnectionProvider");
            Properties dbcpProperties = new Properties();
            String jdbcDriverClass = props.getProperty("hibernate.connection.driver_class");
            String jdbcUrl = props.getProperty("hibernate.connection.url");
            dbcpProperties.put("driverClassName", jdbcDriverClass);
            dbcpProperties.put("url", jdbcUrl);
            String username = props.getProperty("hibernate.connection.username");
            String password = props.getProperty("hibernate.connection.password");
            dbcpProperties.put("username", username);
            dbcpProperties.put("password", password);
            String isolationLevel = props.getProperty("hibernate.connection.isolation");
            if (isolationLevel != null && isolationLevel.trim().length() > 0) {
                dbcpProperties.put("defaultTransactionIsolation", isolationLevel);
            }
            if ((autocommit = props.getProperty("hibernate.connection.autocommit")) != null && autocommit.trim().length() > 0) {
                dbcpProperties.put("defaultAutoCommit", autocommit);
            } else {
                dbcpProperties.put("defaultAutoCommit", String.valueOf(Boolean.FALSE));
            }
            String poolSize = props.getProperty("hibernate.connection.pool_size");
            if (poolSize != null && poolSize.trim().length() > 0 && Integer.parseInt(poolSize) > 0) {
                dbcpProperties.put("maxActive", poolSize);
            }
            if ((driverProps = DBCPConnectionProvider.getConnectionProperties(props)).size() > 0) {
                StringBuffer connectionProperties = new StringBuffer();
                Iterator<Object> iter = driverProps.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    value = driverProps.getProperty(key);
                    connectionProperties.append(key).append('=').append(value);
                    if (!iter.hasNext()) continue;
                    connectionProperties.append(';');
                }
                dbcpProperties.put("connectionProperties", connectionProperties.toString());
            }
            Iterator<Object> iter = props.keySet().iterator();
            while (iter.hasNext()) {
                String key = String.valueOf(iter.next());
                if (!key.startsWith(PREFIX)) continue;
                String property = key.substring(PREFIX.length());
                value = props.getProperty(key);
                dbcpProperties.put(property, value);
            }
            if (props.getProperty(DBCP_PS_MAXACTIVE) != null) {
                dbcpProperties.put("poolPreparedStatements", String.valueOf(Boolean.TRUE));
                dbcpProperties.put("maxOpenPreparedStatements", props.getProperty(DBCP_PS_MAXACTIVE));
            }
            this.ds = (BasicDataSource)BasicDataSourceFactory.createDataSource((Properties)dbcpProperties);
            Connection conn = this.ds.getConnection();
            conn.close();
            this.logStatistics();
        }
        catch (Exception e) {
            String message = "Could not create a DBCP pool";
            log.fatal((Object)message, (Throwable)e);
            if (this.ds != null) {
                try {
                    this.ds.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.ds = null;
            }
            throw new HibernateException(message, (Throwable)e);
        }
        log.debug((Object)"Configure DBCPConnectionProvider complete");
    }

    public static Properties getConnectionProperties(Properties properties) {
        Iterator<Object> iter = properties.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            String prop = (String)iter.next();
            if (prop.indexOf("hibernate.connection") <= -1 || SPECIAL_PROPERTIES.contains(prop)) continue;
            result.setProperty(prop.substring("hibernate.connection".length() + 1), properties.getProperty(prop));
        }
        String userName = properties.getProperty("hibernate.connection.username");
        if (userName != null) {
            result.setProperty("user", userName);
        }
        return result;
    }

    public Connection getConnection() throws SQLException {
        if (this.ds == null) {
            this.configure(_BaseRootDAO.getConfiguration().getProperties());
        }
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
        }
        finally {
            this.logStatistics();
        }
        return conn;
    }

    public void closeConnection(Connection conn) throws SQLException {
        try {
            conn.close();
        }
        finally {
            this.logStatistics();
        }
    }

    public void stop() throws HibernateException {
        log.debug((Object)"Close DBCPConnectionProvider");
        this.logStatistics();
        try {
            if (this.ds != null) {
                this.ds.close();
                this.ds = null;
            } else {
                log.warn((Object)"Cannot close DBCP pool (not initialized)");
            }
        }
        catch (Exception e) {
            throw new HibernateException("Could not close DBCP pool", (Throwable)e);
        }
        log.debug((Object)"Close DBCPConnectionProvider complete");
    }

    protected void logStatistics() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("active: " + this.ds.getNumActive() + " (max: " + this.ds.getMaxActive() + ")   idle: " + this.ds.getNumIdle() + "(max: " + this.ds.getMaxIdle() + ")"));
        }
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public boolean isUnwrappableAs(Class arg0) {
        return false;
    }

    public <T> T unwrap(Class<T> arg0) {
        return null;
    }

    static {
        SPECIAL_PROPERTIES.add("hibernate.connection.datasource");
        SPECIAL_PROPERTIES.add("hibernate.connection.url");
        SPECIAL_PROPERTIES.add("hibernate.connection.provider_class");
        SPECIAL_PROPERTIES.add("hibernate.connection.pool_size");
        SPECIAL_PROPERTIES.add("hibernate.connection.isolation");
        SPECIAL_PROPERTIES.add("hibernate.connection.driver_class");
        SPECIAL_PROPERTIES.add("hibernate.connection.username");
    }
}

