/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.criteria.TimetablingCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.util.DataProperties;

public class BackToBackInstructorPreferences
extends TimetablingCriterion {
    public BackToBackInstructorPreferences() {
        this.setValueUpdateType(AbstractCriterion.ValueUpdateType.NoUpdate);
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return (double)Constants.sPreferenceLevelDiscouraged * config.getPropertyDouble("Comparator.DistanceInstructorPreferenceWeight", 1.0);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.DistanceInstructorPreferenceWeight";
    }

    protected int penalty(Assignment<Lecture, Placement> assignment, Placement value) {
        int ret = 0;
        for (InstructorConstraint ic : ((Lecture)value.variable()).getInstructorConstraints()) {
            ret += ic.getPreference(assignment, value);
        }
        return ret;
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        double ret = this.penalty(assignment, value);
        if (conflicts != null) {
            for (Placement conflict : conflicts) {
                ret -= (double)this.penalty(assignment, conflict);
            }
        }
        return ret;
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        double ret = 0.0;
        HashSet<InstructorConstraint> constraints = new HashSet<InstructorConstraint>();
        for (Lecture lect : variables) {
            for (InstructorConstraint ic : lect.getInstructorConstraints()) {
                if (!constraints.add(ic)) continue;
                ret += (double)ic.getPreference(assignment);
            }
        }
        return ret;
    }

    @Override
    protected double[] computeBounds(Assignment<Lecture, Placement> assignment) {
        double[] bounds = new double[]{0.0, 0.0};
        for (InstructorConstraint ic : ((TimetableModel)this.getModel()).getInstructorConstraints()) {
            bounds[1] = bounds[1] + (double)ic.getWorstPreference();
        }
        return bounds;
    }

    @Override
    public double[] getBounds(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        HashSet<InstructorConstraint> constraints = new HashSet<InstructorConstraint>();
        for (Lecture lect : variables) {
            for (InstructorConstraint ic : lect.getInstructorConstraints()) {
                if (!constraints.add(ic)) continue;
                bounds[1] = bounds[1] + (double)ic.getWorstPreference();
            }
        }
        return bounds;
    }
}

