/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.JChannel;
import org.jgroups.blocks.executor.ExecutionCompletionService;
import org.jgroups.blocks.executor.ExecutionRunner;
import org.jgroups.blocks.executor.ExecutionService;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class ExecutionServiceDemo {
    protected String props;
    protected JChannel ch;
    protected ExecutionService execution_service;
    protected String name;
    protected ExecutionRunner runner;
    protected int size;
    protected boolean printValues;
    protected Random random;
    protected ExecutorService executor;
    protected Queue<Future<?>> queue;

    public ExecutionServiceDemo(String props, String name, int size) {
        this.props = props;
        this.name = name;
        this.queue = new ArrayDeque();
        this.executor = Executors.newCachedThreadPool(new ThreadFactory(){
            AtomicInteger poolNumber = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "Consumer-" + this.poolNumber.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            }
        });
        this.size = size;
    }

    public static void main(String[] args) throws Exception {
        String props = null;
        String name = null;
        String size = "1000";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-name")) {
                name = args[++i];
                continue;
            }
            ExecutionServiceDemo.help();
            return;
        }
        ExecutionServiceDemo demo = new ExecutionServiceDemo(props, name, Integer.valueOf(size));
        demo.start();
    }

    public void start() throws Exception {
        this.ch = new JChannel(this.props);
        if (this.name != null) {
            this.ch.setName(this.name);
        }
        this.execution_service = new ExecutionService(this.ch);
        this.runner = new ExecutionRunner(this.ch);
        this.ch.connect("executing-cluster");
        JmxConfigurator.registerChannel(this.ch, Util.getMBeanServer(), "execution-service", this.ch.getClusterName(), true);
        this.queue.add(this.executor.submit(this.runner));
        this.random = new Random();
        this.printValues = false;
        try {
            this.loop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Util.close((Closeable)this.ch);
        }
    }

    protected void loop() throws Exception {
        String line;
        while (this.ch.isConnected() && !(line = Util.readStringFromStdin(": ")).startsWith("quit") && !line.startsWith("exit")) {
            if (line.startsWith("submit")) {
                Future finalValue;
                int randomNumbers = Integer.parseInt(line.substring("submit".length()).trim());
                byte[] numbers = new byte[randomNumbers];
                for (int i = 0; i < randomNumbers; ++i) {
                    numbers[i] = (byte)this.random.nextInt(256);
                }
                if (this.printValues) {
                    System.out.println("Original Numbers: " + Arrays.toString(numbers));
                }
                ExecutionCompletionService<ByteBufferStreamable> completion = new ExecutionCompletionService<ByteBufferStreamable>(this.execution_service);
                long beginDistributed = System.nanoTime();
                int chunks = numbers.length / this.size;
                for (int i = 0; i < chunks; ++i) {
                    completion.submit(new SortingByteCallable(numbers, this.size * i, this.size));
                }
                int futureNumber = chunks;
                int leftOver = numbers.length % this.size;
                if (leftOver != 0) {
                    completion.submit(new SortingByteCallable(numbers, numbers.length - leftOver, leftOver));
                    ++futureNumber;
                }
                if (futureNumber > 1) {
                    Future result = null;
                    while (true) {
                        result = completion.take();
                        if (--futureNumber < 1) break;
                        Future result2 = completion.take();
                        completion.submit(new SortingTwoByteCallable((ByteBufferStreamable)result.get(), (ByteBufferStreamable)result2.get()));
                    }
                    finalValue = result;
                } else {
                    finalValue = completion.take();
                }
                ByteBufferStreamable results = (ByteBufferStreamable)finalValue.get();
                long totalDistributed = System.nanoTime() - beginDistributed;
                if (this.printValues) {
                    System.out.println("Sorted values: " + Arrays.toString(results.buffer.array()));
                }
                System.out.println("Distributed Sort Took: " + Util.printTime(totalDistributed, TimeUnit.NANOSECONDS));
                long beginLocal = System.nanoTime();
                Arrays.sort(numbers);
                System.out.println("      Local Sort Took: " + Util.printTime(System.nanoTime() - beginLocal, TimeUnit.NANOSECONDS));
                continue;
            }
            if (line.startsWith("consumer")) {
                if (line.contains("start")) {
                    this.queue.add(this.executor.submit(this.runner));
                    System.out.println("Started Consumer - running " + this.queue.size() + " consumers");
                    continue;
                }
                if (line.contains("stop")) {
                    this.queue.remove().cancel(true);
                    System.out.println("Stopped Consumer - running " + this.queue.size() + " consumers");
                    continue;
                }
                System.out.println("Consumers Running Locally: " + this.queue.size());
                continue;
            }
            if (line.startsWith("size")) {
                String thresholdSize = line.substring("size".length()).trim();
                if (thresholdSize.length() > 0) {
                    int size;
                    this.size = size = Integer.parseInt(thresholdSize);
                    System.out.println("Changed sort threshold size to " + size);
                    continue;
                }
                System.out.println("Threshold Size: " + this.size);
                continue;
            }
            if (line.startsWith("print")) {
                this.printValues = !this.printValues;
                System.out.println("Print Arrays: " + this.printValues);
                continue;
            }
            if (line.startsWith("view")) {
                System.out.println("View: " + this.ch.getView());
                continue;
            }
            if (!line.startsWith("help")) continue;
            ExecutionServiceDemo.help();
        }
    }

    protected static void help() {
        System.out.println("\nExecutionServiceDemo [-props properties] [-name name]\nDefault Values:\n\nOne Consumer\nThreshold size: 1000\nPrint disabled\n\nValid commands:\n\nsubmit (amount of numbers to generate)\nconsumer (start) | (stop)\nsize (value)\nprint");
        System.out.println("\nExample:\nsubmit 2000000\nconsumer start\nconsumer stop\nsize 1000000\nprint");
    }

    public static class SortingTwoByteCallable
    implements Callable<ByteBufferStreamable>,
    Streamable {
        protected ByteBuffer bytes1;
        protected ByteBuffer bytes2;

        public SortingTwoByteCallable() {
        }

        public SortingTwoByteCallable(ByteBufferStreamable bytes1, ByteBufferStreamable bytes2) {
            this.bytes1 = bytes1.buffer;
            this.bytes2 = bytes2.buffer;
        }

        @Override
        public ByteBufferStreamable call() throws Exception {
            ByteBuffer results = ByteBuffer.allocate(this.bytes1.remaining() + this.bytes2.remaining());
            int i = this.bytes1.position();
            int j = this.bytes2.position();
            byte[] byteArray1 = this.bytes1.array();
            byte[] byteArray2 = this.bytes2.array();
            int byte1Max = this.bytes1.limit();
            int byte2Max = this.bytes2.limit();
            while (i < byte1Max && j < byte2Max) {
                if (byteArray1[i] < byteArray2[j]) {
                    results.put(byteArray1[i++]);
                    continue;
                }
                results.put(byteArray2[j++]);
            }
            if (i < byte1Max) {
                results.put(byteArray1, i, byte1Max - i);
            } else if (j < byte2Max) {
                results.put(byteArray2, j, byte2Max - j);
            }
            results.flip();
            return new ByteBufferStreamable(results);
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            Util.writeStreamable(new ByteBufferStreamable(this.bytes1), out);
            Util.writeStreamable(new ByteBufferStreamable(this.bytes2), out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.bytes1 = ((ByteBufferStreamable)Util.readStreamable(ByteBufferStreamable.class, (DataInput)in)).buffer;
            this.bytes2 = ((ByteBufferStreamable)Util.readStreamable(ByteBufferStreamable.class, (DataInput)in)).buffer;
        }
    }

    public static class SortingByteCallable
    implements Callable<ByteBufferStreamable>,
    Streamable {
        protected ByteBuffer buffer;

        public SortingByteCallable() {
        }

        public SortingByteCallable(byte[] bytes, int offset, int size) {
            this.buffer = ByteBuffer.wrap(bytes, offset, size);
        }

        @Override
        public ByteBufferStreamable call() throws Exception {
            Arrays.sort(this.buffer.array(), this.buffer.position(), this.buffer.limit());
            return new ByteBufferStreamable(this.buffer);
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            Util.writeStreamable(new ByteBufferStreamable(this.buffer), out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.buffer = ((ByteBufferStreamable)Util.readStreamable(ByteBufferStreamable.class, (DataInput)in)).buffer;
        }
    }

    protected static class ByteBufferStreamable
    implements Streamable {
        protected ByteBuffer buffer;

        public ByteBufferStreamable() {
        }

        protected ByteBufferStreamable(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            int size = this.buffer.limit() - this.buffer.position();
            out.writeInt(size);
            out.write(this.buffer.array(), this.buffer.position(), size);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.buffer = ByteBuffer.allocate(in.readInt());
            in.readFully(this.buffer.array());
        }
    }
}

