/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitime.commons.Email;

public class MockupEmail
extends Email {
    private static Log sLog = LogFactory.getLog(MockupEmail.class);
    private String iSubject = null;
    private String iFrom = null;
    private List<String> iReplyTo = new ArrayList<String>();
    private List<String> iRecipient = new ArrayList<String>();
    private List<String> iRecipientCC = new ArrayList<String>();
    private List<String> iRecipientBCC = new ArrayList<String>();
    private String iBody = null;
    private List<String> iAttachments = new ArrayList<String>();

    @Override
    public void setSubject(String subject) throws Exception {
        this.iSubject = subject;
    }

    protected String format(String email, String name) {
        if (name == null || name.isEmpty()) {
            return email;
        }
        return name + " <" + email + ">";
    }

    @Override
    public void setFrom(String email, String name) throws Exception {
        this.iFrom = this.format(email, name);
    }

    @Override
    public void setReplyTo(String email, String name) throws Exception {
        this.iReplyTo.clear();
        this.iReplyTo.add(this.format(email, name));
    }

    @Override
    public void addReplyTo(String email, String name) throws Exception {
        this.iReplyTo.add(this.format(email, name));
    }

    @Override
    public void addRecipient(String email, String name) throws Exception {
        this.iRecipient.add(this.format(email, name));
    }

    @Override
    public void addRecipientCC(String email, String name) throws Exception {
        this.iRecipientCC.add(this.format(email, name));
    }

    @Override
    public void addRecipientBCC(String email, String name) throws Exception {
        this.iRecipientBCC.add(this.format(email, name));
    }

    @Override
    public void setBody(String message, String type) throws Exception {
        this.iBody = message;
    }

    @Override
    public void addAttachment(String name, DataHandler data) throws Exception {
        int size = 0;
        int read = 0;
        byte[] buffer = new byte[1024];
        InputStream in = data.getInputStream();
        while ((read = in.read(buffer)) > 0) {
            size += read;
        }
        in.close();
        this.iAttachments.add(name + " (" + data.getContentType() + ", " + size + " bytes)");
    }

    protected void space(StringBuffer s, int len) {
        for (int i = 0; i < len; ++i) {
            s.append(' ');
        }
    }

    protected String format(String name, List<String> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                ret.append(name);
            } else {
                this.space(ret, name.length());
            }
            ret.append(list.get(i));
            ret.append('\n');
        }
        return ret.toString();
    }

    @Override
    public void send() throws Exception {
        StringBuffer message = new StringBuffer("\n");
        if (this.iSubject != null) {
            message.append("Subject:  " + this.iSubject + "\n");
        }
        if (this.iFrom != null) {
            message.append("From:     " + this.iFrom + "\n");
        }
        message.append(this.format("Reply-To: ", this.iReplyTo));
        message.append(this.format("To:       ", this.iRecipient));
        message.append(this.format("CC:       ", this.iRecipientCC));
        message.append(this.format("BCC:      ", this.iRecipientBCC));
        message.append(this.format("Attached: ", this.iAttachments));
        if (this.iBody != null) {
            message.append(this.iBody);
        }
        message.append("\n----- END OF EMAIL MESSAGE -----------------------------");
        sLog.info((Object)message.toString());
    }

    @Override
    public void setInReplyTo(String messageId) throws Exception {
    }

    @Override
    public String getMessageId() throws Exception {
        return "MESSAGE-ID";
    }
}

