/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.instructor.InstructorAvailabilityWidget;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.webutil.RequiredTimeTable;

@GwtRpcImplements(value=InstructorAvailabilityWidget.InstructorAvailabilityRequest.class)
public class InstructorAvailabilityBackend
implements GwtRpcImplementation<InstructorAvailabilityWidget.InstructorAvailabilityRequest, InstructorAvailabilityWidget.InstructorAvailabilityModel> {
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public InstructorAvailabilityWidget.InstructorAvailabilityModel execute(InstructorAvailabilityWidget.InstructorAvailabilityRequest request, SessionContext context) {
        String mode;
        InstructorAvailabilityWidget.InstructorAvailabilityModel model = new InstructorAvailabilityWidget.InstructorAvailabilityModel();
        int i = 0;
        while ((mode = ApplicationProperty.RoomSharingMode.value(String.valueOf(1 + i), i < CONSTANTS.roomSharingModes().length ? CONSTANTS.roomSharingModes()[i] : null)) != null && !mode.isEmpty()) {
            model.addMode(new RoomInterface.RoomSharingDisplayMode(mode));
            ++i;
        }
        model.setDefaultEditable(true);
        for (PreferenceLevel pref : PreferenceLevel.getPreferenceLevelList(request.isIncludeNotAvailable())) {
            if (PreferenceLevel.sRequired.equals(pref.getPrefProlog())) continue;
            RoomInterface.RoomSharingOption option = new RoomInterface.RoomSharingOption(model.char2id(PreferenceLevel.prolog2char(pref.getPrefProlog())), pref.prefcolor(), "", pref.getPrefName(), true);
            model.addOption(option);
            if (!PreferenceLevel.sNeutral.equals(pref.getPrefProlog())) continue;
            model.setDefaultOption(option);
        }
        String defaultGridSize = RequiredTimeTable.getTimeGridSize(context.getUser());
        if (defaultGridSize != null) {
            for (int i2 = 0; i2 < model.getModes().size(); ++i2) {
                if (!model.getModes().get(i2).getName().equals(defaultGridSize)) continue;
                model.setDefaultMode(i2);
                break;
            }
        }
        model.setDefaultHorizontal(CommonValues.HorizontalGrid.eq(context.getUser().getProperty(UserProperty.GridOrientation)));
        model.setNoteEditable(false);
        if (request.getInstructorId() != null) {
            if (request.getInstructorId().length() > 200) {
                model.setPattern(request.getInstructorId());
            } else {
                DepartmentalInstructor instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(Long.valueOf(request.getInstructorId()));
                for (Preference pref : instructor.getPreferences()) {
                    if (!(pref instanceof TimePref)) continue;
                    model.setPattern(((TimePref)pref).getPreference());
                    break;
                }
            }
        }
        return model;
    }
}

