/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.reports.AbstractReport;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;

public class ExamScheduleByPeriodReport
extends PdfLegacyExamReport {
    private static Log sLog = LogFactory.getLog(ExamScheduleByPeriodReport.class);

    public ExamScheduleByPeriodReport(int mode, File file, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, file, MSG.legacyReportScheduleByPeriod(), session, examType, subjectAreas, exams);
    }

    @Override
    public void printReport() throws DocumentException {
        this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrDateAndTime(), 30), this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnID() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 10), this.rpad(MSG.lrMeetingTimes(), 35), this.lpad(MSG.lrEnrl(), 5), this.iDispRooms ? this.rpad(MSG.lrRoom(), 11) : NULL, this.iDispRooms ? this.lpad(MSG.lrCap(), 5) : NULL, this.iDispRooms ? this.lpad(MSG.lrExCap(), 6) : NULL), new AbstractReport.Line(this.lpad("", '-', 30), this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 10), this.lpad("", '-', 35), this.lpad("", '-', 5), this.iDispRooms ? this.lpad("", '-', 11) : NULL, this.iDispRooms ? this.lpad("", '-', 5) : NULL, this.iDispRooms ? this.lpad("", '-', 6) : NULL));
        this.printHeader();
        sLog.debug((Object)MSG.statusSortingExams());
        TreeSet<ExamAssignmentInfo> exams = new TreeSet<ExamAssignmentInfo>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            if (exam.getPeriod() == null || !this.hasSubjectArea(exam)) continue;
            exams.add(exam);
        }
        sLog.debug((Object)MSG.statusPrintingReport());
        Iterator<ExamPeriod> p = ExamPeriod.findAll(this.getSession().getUniqueId(), this.getExamType()).iterator();
        while (p.hasNext()) {
            ExamPeriod period = p.next();
            this.iPeriodPrinted = false;
            this.setPageName(this.formatPeriod(period));
            this.setCont(this.formatPeriod(period));
            for (ExamAssignmentInfo exam : exams) {
                if (!period.equals(exam.getPeriod())) continue;
                if (this.iPeriodPrinted && !this.iNewPage) {
                    this.println(new AbstractReport.Line());
                }
                ExamInfo.ExamSectionInfo lastSection = null;
                for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                    if (!this.hasSubjectArea(section)) continue;
                    this.iStudentPrinted = false;
                    this.iCoursePrinted = false;
                    this.iSubjectPrinted = false;
                    if (lastSection != null && section.getSubject().equals(lastSection.getSubject())) {
                        this.iSubjectPrinted = true;
                        if (section.getCourseNbr().equals(lastSection.getCourseNbr())) {
                            this.iCoursePrinted = true;
                            if (section.getItype().equals(lastSection.getItype())) {
                                this.iStudentPrinted = true;
                            }
                        }
                    }
                    lastSection = section;
                    if (!this.iDispRooms) {
                        this.println(this.rpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : this.formatPeriod(period), 30), this.rpad(this.iSubjectPrinted && this.isSkipRepeating() ? "" : section.getSubject(), 7), this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iStudentPrinted && this.isSkipRepeating() ? "" : section.getItype(), 6) : NULL, this.formatSection10(section.getSection()), this.rpad(this.getMeetingTime(section), 35), this.lpad(String.valueOf(section.getNrStudents()), 5));
                        this.iPeriodPrinted = !this.iNewPage;
                        continue;
                    }
                    if (section.getExamAssignment().getRooms() == null || section.getExamAssignment().getRooms().isEmpty()) {
                        this.println(this.rpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : this.formatPeriod(period), 30), this.rpad(this.iSubjectPrinted && this.isSkipRepeating() ? "" : section.getSubject(), 7), this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iStudentPrinted && this.isSkipRepeating() ? "" : section.getItype(), 6) : NULL, this.formatSection10(section.getSection()), this.rpad(this.getMeetingTime(section), 35), this.lpad(String.valueOf(section.getNrStudents()), 5), new AbstractReport.Cell(this.iNoRoom).withColSpan(3));
                        this.iPeriodPrinted = !this.iNewPage;
                        continue;
                    }
                    if (this.getLineNumber() + section.getExamAssignment().getRooms().size() > this.getNrLinesPerPage() && this.getNrLinesPerPage() > 0) {
                        this.newPage();
                    }
                    boolean firstRoom = true;
                    for (ExamRoomInfo room : section.getExamAssignment().getRooms()) {
                        this.println(this.rpad(!firstRoom || this.iPeriodPrinted && this.isSkipRepeating() ? "" : this.formatPeriod(period), 30), this.rpad(!firstRoom || this.iSubjectPrinted && this.isSkipRepeating() ? "" : section.getSubject(), 7), this.rpad(!firstRoom || this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(!firstRoom || this.iStudentPrinted && this.isSkipRepeating() ? "" : section.getItype(), 6) : NULL, this.formatSection10(!firstRoom && this.isSkipRepeating() ? "" : section.getSection()), this.rpad(!firstRoom ? new AbstractReport.Cell("") : this.getMeetingTime(section), 35), this.lpad(!firstRoom && this.isSkipRepeating() ? "" : String.valueOf(section.getNrStudents()), 5), this.formatRoom(room), this.lpad("" + room.getCapacity(), 5), this.lpad("" + room.getExamCapacity(), 6));
                        firstRoom = false;
                    }
                    this.iPeriodPrinted = !this.iNewPage;
                }
            }
            this.setCont(null);
            if (!this.iPeriodPrinted || !p.hasNext()) continue;
            this.newPage();
        }
        if (this.iPeriodPrinted) {
            this.lastPage();
        }
    }
}

