/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.Meeting;

public abstract class BaseMeeting
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Date iMeetingDate;
    private Integer iStartPeriod;
    private Integer iStartOffset;
    private Integer iStopPeriod;
    private Integer iStopOffset;
    private Long iLocationPermanentId;
    private Boolean iClassCanOverride;
    private Integer iApprovalStatus;
    private Date iApprovalDate;
    private Event iEvent;
    private Set<EventContact> iMeetingContacts;
    public static String PROP_UNIQUEID = "uniqueId";
    public static String PROP_MEETING_DATE = "meetingDate";
    public static String PROP_START_PERIOD = "startPeriod";
    public static String PROP_START_OFFSET = "startOffset";
    public static String PROP_STOP_PERIOD = "stopPeriod";
    public static String PROP_STOP_OFFSET = "stopOffset";
    public static String PROP_LOCATION_PERM_ID = "locationPermanentId";
    public static String PROP_CLASS_CAN_OVERRIDE = "classCanOverride";
    public static String PROP_APPROVAL_STATUS = "approvalStatus";
    public static String PROP_APPROVAL_DATE = "approvalDate";

    public BaseMeeting() {
        this.initialize();
    }

    public BaseMeeting(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    protected void initialize() {
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public Date getMeetingDate() {
        return this.iMeetingDate;
    }

    public void setMeetingDate(Date meetingDate) {
        this.iMeetingDate = meetingDate;
    }

    public Integer getStartPeriod() {
        return this.iStartPeriod;
    }

    public void setStartPeriod(Integer startPeriod) {
        this.iStartPeriod = startPeriod;
    }

    public Integer getStartOffset() {
        return this.iStartOffset;
    }

    public void setStartOffset(Integer startOffset) {
        this.iStartOffset = startOffset;
    }

    public Integer getStopPeriod() {
        return this.iStopPeriod;
    }

    public void setStopPeriod(Integer stopPeriod) {
        this.iStopPeriod = stopPeriod;
    }

    public Integer getStopOffset() {
        return this.iStopOffset;
    }

    public void setStopOffset(Integer stopOffset) {
        this.iStopOffset = stopOffset;
    }

    public Long getLocationPermanentId() {
        return this.iLocationPermanentId;
    }

    public void setLocationPermanentId(Long locationPermanentId) {
        this.iLocationPermanentId = locationPermanentId;
    }

    public Boolean isClassCanOverride() {
        return this.iClassCanOverride;
    }

    public Boolean getClassCanOverride() {
        return this.iClassCanOverride;
    }

    public void setClassCanOverride(Boolean classCanOverride) {
        this.iClassCanOverride = classCanOverride;
    }

    public Integer getApprovalStatus() {
        return this.iApprovalStatus;
    }

    public void setApprovalStatus(Integer approvalStatus) {
        this.iApprovalStatus = approvalStatus;
    }

    public Date getApprovalDate() {
        return this.iApprovalDate;
    }

    public void setApprovalDate(Date approvalDate) {
        this.iApprovalDate = approvalDate;
    }

    public Event getEvent() {
        return this.iEvent;
    }

    public void setEvent(Event event) {
        this.iEvent = event;
    }

    public Set<EventContact> getMeetingContacts() {
        return this.iMeetingContacts;
    }

    public void setMeetingContacts(Set<EventContact> meetingContacts) {
        this.iMeetingContacts = meetingContacts;
    }

    public void addTomeetingContacts(EventContact eventContact) {
        if (this.iMeetingContacts == null) {
            this.iMeetingContacts = new HashSet<EventContact>();
        }
        this.iMeetingContacts.add(eventContact);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Meeting)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Meeting)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Meeting)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "Meeting[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "Meeting[\n\tApprovalDate: " + this.getApprovalDate() + "\n\tApprovalStatus: " + this.getApprovalStatus() + "\n\tClassCanOverride: " + this.getClassCanOverride() + "\n\tEvent: " + this.getEvent() + "\n\tLocationPermanentId: " + this.getLocationPermanentId() + "\n\tMeetingDate: " + this.getMeetingDate() + "\n\tStartOffset: " + this.getStartOffset() + "\n\tStartPeriod: " + this.getStartPeriod() + "\n\tStopOffset: " + this.getStopOffset() + "\n\tStopPeriod: " + this.getStopPeriod() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

