/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;

public class Unavailability
implements SctAssignment {
    private Section iSection;
    private Student iStudent;
    private boolean iAllowOverlap;

    public Unavailability(Student student, Section section, boolean canOverlap) {
        this.iStudent = student;
        this.iSection = section;
        this.iAllowOverlap = canOverlap;
        this.iStudent.getUnavailabilities().add(this);
        this.iSection.getUnavailabilities().add(this);
    }

    public Student getStudent() {
        return this.iStudent;
    }

    public Section getSection() {
        return this.iSection;
    }

    @Override
    public long getId() {
        return this.getSection().getId();
    }

    @Override
    public TimeLocation getTime() {
        return this.getSection().getTime();
    }

    @Override
    public boolean isAllowOverlap() {
        return this.iAllowOverlap;
    }

    @Override
    public List<RoomLocation> getRooms() {
        return this.getSection().getRooms();
    }

    @Override
    public int getNrRooms() {
        return this.getSection().getNrRooms();
    }

    @Override
    public boolean isOverlapping(SctAssignment assignment) {
        if (this.isAllowOverlap() || assignment.isAllowOverlap()) {
            return false;
        }
        if (this.getTime() == null || assignment.getTime() == null) {
            return false;
        }
        return assignment instanceof Section && this.getTime().hasIntersection(assignment.getTime());
    }

    @Override
    public boolean isOverlapping(Set<? extends SctAssignment> assignments) {
        if (this.isAllowOverlap()) {
            return false;
        }
        if (this.getTime() == null) {
            return false;
        }
        for (SctAssignment sctAssignment : assignments) {
            if (sctAssignment.isAllowOverlap() || sctAssignment.getTime() == null || !(sctAssignment instanceof Section) || !this.getTime().hasIntersection(sctAssignment.getTime())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void assigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
    }

    @Override
    public void unassigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
    }

    @Override
    public Set<Enrollment> getEnrollments(Assignment<Request, Enrollment> assignment) {
        return null;
    }

    @Override
    public int compareById(SctAssignment a) {
        if (a instanceof Unavailability) {
            return Long.valueOf(this.getId()).compareTo(((Unavailability)a).getId());
        }
        return 1;
    }

    public Enrollment createEnrollment() {
        HashSet<Unavailability> assignments = new HashSet<Unavailability>();
        assignments.add(this);
        return new Enrollment(null, 0, null, assignments, null);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Unavailability)) {
            return false;
        }
        return this.getId() == ((Unavailability)o).getId();
    }

    public int hashCode() {
        return (int)(this.getId() ^ this.getId() >>> 32);
    }
}

