/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.model;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.exam.criteria.DistributionPenalty;
import org.cpsolver.exam.criteria.RoomPenalty;
import org.cpsolver.exam.criteria.RoomSizePenalty;
import org.cpsolver.exam.criteria.RoomSplitPenalty;
import org.cpsolver.exam.model.ExamDistributionConstraint;
import org.cpsolver.exam.model.ExamInstructor;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamOwner;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPeriodPlacement;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoom;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.exam.model.ExamRoomSharing;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ToolBox;

public class Exam
extends Variable<Exam, ExamPlacement> {
    private static boolean sAlterMaxSize = false;
    private static Logger sLog = LogManager.getLogger(Exam.class);
    protected static DecimalFormat sDoubleFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    private ArrayList<ExamStudent> iStudents = new ArrayList();
    private ArrayList<ExamInstructor> iInstructors = new ArrayList();
    private ArrayList<ExamDistributionConstraint> iDistConstraints = new ArrayList();
    private boolean iAllowDirectConflicts = true;
    private String iName = null;
    private int iLength = 0;
    private int iMaxRooms = 0;
    private int iMinSize = 0;
    private boolean iAltSeating = false;
    private int iAveragePeriod = -1;
    private Integer iSize = null;
    private Integer iPrintOffset = null;
    private ArrayList<ExamOwner> iOwners = new ArrayList();
    private List<ExamPeriodPlacement> iPeriodPlacements = null;
    private List<ExamPeriodPlacement> iAvailablePeriodPlacements = null;
    private List<ExamRoomPlacement> iRoomPlacements = null;
    private List<ExamRoomPlacement> iRoomPreferredPlacements = null;
    private HashSet<Exam> iCorrelatedExams = null;
    private Integer iEstimatedDomainSize = null;
    private HashMap<Exam, List<ExamStudent>> iJenrls = null;

    public Exam(long id, String name, int length, boolean altSeating, int maxRooms, int minSize, List<ExamPeriodPlacement> periodPlacements, List<ExamRoomPlacement> roomPlacements) {
        this.iId = id;
        this.iName = name;
        this.iLength = length;
        this.iAltSeating = altSeating;
        this.iMaxRooms = maxRooms;
        this.iMinSize = minSize;
        this.iPeriodPlacements = new ArrayList<ExamPeriodPlacement>(periodPlacements);
        Collections.sort(this.iPeriodPlacements, new Comparator<ExamPeriodPlacement>(){

            @Override
            public int compare(ExamPeriodPlacement p1, ExamPeriodPlacement p2) {
                return p1.getPeriod().compareTo(p2.getPeriod());
            }
        });
        this.iRoomPlacements = new ArrayList<ExamRoomPlacement>(roomPlacements);
        Collections.sort(this.iRoomPlacements, new Comparator<ExamRoomPlacement>(){

            @Override
            public int compare(ExamRoomPlacement p1, ExamRoomPlacement p2) {
                int cmp = -Double.compare(p1.getSize(Exam.this.hasAltSeating()), p2.getSize(Exam.this.hasAltSeating()));
                if (cmp != 0) {
                    return cmp;
                }
                return p1.getRoom().compareTo(p2.getRoom());
            }
        });
    }

    public int getSize() {
        return this.iSize == null ? Math.max(this.iMinSize, this.getStudents().size()) : this.iSize;
    }

    public void setSizeOverride(Integer size) {
        this.iSize = size;
    }

    public Integer getSizeOverride() {
        return this.iSize;
    }

    public Integer getPrintOffset() {
        return this.iPrintOffset;
    }

    public void setPrintOffset(Integer printOffset) {
        this.iPrintOffset = printOffset;
    }

    public int getMinSize() {
        return this.iMinSize;
    }

    public void setMinSize(int minSize) {
        this.iMinSize = minSize;
    }

    @Override
    public List<ExamPlacement> values(Assignment<Exam, ExamPlacement> assignment) {
        if (super.values(assignment) == null) {
            this.init();
        }
        return super.values(assignment);
    }

    public List<ExamRoomPlacement> getRoomPlacements() {
        return this.iRoomPlacements;
    }

    public synchronized List<ExamRoomPlacement> getPreferredRoomPlacements() {
        if (this.iRoomPreferredPlacements == null) {
            this.iRoomPreferredPlacements = new ArrayList<ExamRoomPlacement>();
            for (ExamRoomPlacement room : this.iRoomPlacements) {
                if (room.getPenalty() >= -2) continue;
                this.iRoomPreferredPlacements.add(room);
            }
        }
        return this.iRoomPreferredPlacements;
    }

    public List<ExamPeriodPlacement> getPeriodPlacements() {
        if (this.iAvailablePeriodPlacements == null) {
            this.iAvailablePeriodPlacements = new ArrayList<ExamPeriodPlacement>(this.iPeriodPlacements.size());
            for (ExamPeriodPlacement p : this.iPeriodPlacements) {
                boolean available = true;
                for (ExamInstructor i : this.getInstructors()) {
                    if (i.isAllowDirectConflicts() || i.isAvailable(p.getPeriod())) continue;
                    available = false;
                    break;
                }
                for (ExamStudent s : this.getStudents()) {
                    if (s.isAllowDirectConflicts() || s.isAvailable(p.getPeriod())) continue;
                    available = false;
                    break;
                }
                if (!available) continue;
                this.iAvailablePeriodPlacements.add(p);
            }
            if (this.iAvailablePeriodPlacements.isEmpty()) {
                sLog.error("  Exam " + this.getName() + " has no available periods.");
            }
        }
        return this.iAvailablePeriodPlacements;
    }

    private boolean init() {
        if (sAlterMaxSize && this.iRoomPlacements.size() > 50) {
            ExamRoomPlacement med = this.iRoomPlacements.get(Math.min(50, this.iRoomPlacements.size() / 2));
            this.setMaxRooms(Math.min(this.getMaxRooms(), 1 + this.getSize() / med.getSize(this.hasAltSeating())));
        }
        ArrayList<ExamPlacement> values = new ArrayList<ExamPlacement>();
        if (this.getMaxRooms() == 0) {
            for (ExamPeriodPlacement periodPlacement : this.getPeriodPlacements()) {
                values.add(new ExamPlacement(this, periodPlacement, new HashSet<ExamRoomPlacement>()));
            }
        } else {
            if (this.getRoomPlacements().isEmpty()) {
                sLog.error("  Exam " + this.getName() + " has no rooms.");
                this.setValues(new ArrayList(0));
                return false;
            }
            for (ExamPeriodPlacement periodPlacement : this.getPeriodPlacements()) {
                TreeSet<RoomSet> roomSets = new TreeSet<RoomSet>();
                this.genRoomSets(periodPlacement.getPeriod(), Math.min(100, this.iRoomPlacements.size()), roomSets, 0, this.getMaxRooms(), new HashSet<ExamRoomPlacement>(), 0, 0);
                for (RoomSet roomSet : roomSets) {
                    values.add(new ExamPlacement(this, periodPlacement, roomSet.rooms()));
                }
            }
        }
        if (values.isEmpty()) {
            sLog.error("Exam " + this.getName() + " has no placement.");
        }
        this.setValues(values);
        return !values.isEmpty();
    }

    private void genRoomSets(ExamPeriod period, int maxRoomSets, TreeSet<RoomSet> roomSets, int roomIdx, int maxRooms, Set<ExamRoomPlacement> roomsSoFar, int sizeSoFar, int penaltySoFar) {
        if (sizeSoFar >= this.getSize()) {
            double penalty = this.getModel().getCriterion(RoomSplitPenalty.class).getWeight() * (double)(roomsSoFar.size() - 1) * (double)(roomsSoFar.size() - 1) + this.getModel().getCriterion(RoomSizePenalty.class).getWeight() * (double)(sizeSoFar - this.getSize()) + this.getModel().getCriterion(RoomPenalty.class).getWeight() * (double)penaltySoFar;
            if (roomSets.size() >= maxRoomSets) {
                RoomSet last = roomSets.last();
                if (penalty < last.penalty()) {
                    roomSets.remove(last);
                    roomSets.add(new RoomSet(roomsSoFar, penalty));
                }
            } else {
                roomSets.add(new RoomSet(roomsSoFar, penalty));
            }
            return;
        }
        if (!roomSets.isEmpty()) {
            RoomSet roomSet = roomSets.first();
            maxRooms = Math.min(maxRooms, 1 + roomSet.rooms().size() - roomsSoFar.size());
        }
        if (maxRooms == 0) {
            return;
        }
        int sizeBound = sizeSoFar;
        for (int i = 0; i < maxRooms && roomIdx + i < this.iRoomPlacements.size(); ++i) {
            sizeBound += this.iRoomPlacements.get(roomIdx + i).getSize(this.hasAltSeating());
        }
        while (roomIdx < this.iRoomPlacements.size() && sizeBound >= this.getSize()) {
            RoomSet last;
            ExamRoomPlacement room = this.iRoomPlacements.get(roomIdx);
            if (room.isAvailable(period)) {
                roomsSoFar.add(room);
                this.genRoomSets(period, maxRoomSets, roomSets, roomIdx + 1, maxRooms - 1, roomsSoFar, sizeSoFar + room.getSize(this.hasAltSeating()), penaltySoFar + room.getPenalty(period));
                roomsSoFar.remove(room);
            }
            sizeBound -= room.getSize(this.hasAltSeating());
            if (roomIdx + maxRooms < this.iRoomPlacements.size()) {
                sizeBound += this.iRoomPlacements.get(roomIdx + maxRooms).getSize(this.hasAltSeating());
            }
            ++roomIdx;
            if (roomSets.size() != maxRoomSets || (last = roomSets.last()).rooms().size() >= roomsSoFar.size() + 1) continue;
            return;
        }
    }

    public boolean hasAltSeating() {
        return this.iAltSeating;
    }

    public int getLength() {
        return this.iLength;
    }

    public void setAveragePeriod(int period) {
        this.iAveragePeriod = period;
    }

    public int getAveragePeriod() {
        return this.iAveragePeriod;
    }

    public boolean hasAveragePeriod() {
        return this.iAveragePeriod >= 0;
    }

    public boolean isAllowDirectConflicts() {
        return this.iAllowDirectConflicts;
    }

    public void setAllowDirectConflicts(boolean allowDirectConflicts) {
        this.iAllowDirectConflicts = allowDirectConflicts;
    }

    @Override
    public void addContstraint(Constraint<Exam, ExamPlacement> constraint) {
        if (constraint instanceof ExamStudent) {
            this.iStudents.add((ExamStudent)constraint);
        }
        if (constraint instanceof ExamDistributionConstraint) {
            this.iDistConstraints.add((ExamDistributionConstraint)constraint);
        }
        if (constraint instanceof ExamInstructor) {
            this.iInstructors.add((ExamInstructor)constraint);
        }
        super.addContstraint(constraint);
        this.iAvailablePeriodPlacements = null;
    }

    @Override
    public void removeContstraint(Constraint<Exam, ExamPlacement> constraint) {
        if (constraint instanceof ExamStudent) {
            this.iStudents.remove(constraint);
        }
        if (constraint instanceof ExamDistributionConstraint) {
            this.iDistConstraints.remove(constraint);
        }
        if (constraint instanceof ExamInstructor) {
            this.iInstructors.remove(constraint);
        }
        super.removeContstraint(constraint);
        this.iAvailablePeriodPlacements = null;
    }

    public List<ExamStudent> getStudents() {
        return this.iStudents;
    }

    public List<ExamDistributionConstraint> getDistributionConstraints() {
        return this.iDistConstraints;
    }

    public List<ExamInstructor> getInstructors() {
        return this.iInstructors;
    }

    public boolean checkDistributionConstraints(Assignment<Exam, ExamPlacement> assignment, ExamPeriodPlacement period) {
        for (ExamDistributionConstraint dc : this.iDistConstraints) {
            if (!dc.isHard()) continue;
            boolean before = true;
            for (Exam exam : dc.variables()) {
                if (exam.equals(this)) {
                    before = false;
                    continue;
                }
                ExamPlacement placement = assignment.getValue(exam);
                if (placement == null) continue;
                switch (dc.getType()) {
                    case 2: {
                        if (period.getIndex() == placement.getPeriod().getIndex()) break;
                        return false;
                    }
                    case 3: {
                        if (period.getIndex() != placement.getPeriod().getIndex()) break;
                        return false;
                    }
                    case 4: {
                        if (!(before ? period.getIndex() <= placement.getPeriod().getIndex() : period.getIndex() >= placement.getPeriod().getIndex())) break;
                        return false;
                    }
                    case 5: {
                        if (!(before ? period.getIndex() >= placement.getPeriod().getIndex() : period.getIndex() <= placement.getPeriod().getIndex())) break;
                        return false;
                    }
                    case 6: {
                        if (period.getPeriod().getDay() == placement.getPeriod().getDay()) break;
                        return false;
                    }
                    case 7: {
                        if (period.getPeriod().getDay() != placement.getPeriod().getDay()) break;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean checkDistributionConstraints(Assignment<Exam, ExamPlacement> assignment, ExamRoomPlacement room) {
        for (ExamDistributionConstraint dc : this.iDistConstraints) {
            if (!dc.isHard()) continue;
            for (Exam exam : dc.variables()) {
                ExamPlacement placement;
                if (exam.equals(this) || (placement = assignment.getValue(exam)) == null) continue;
                switch (dc.getType()) {
                    case 0: {
                        if (placement.getRoomPlacements().contains(room)) break;
                        return false;
                    }
                    case 1: {
                        if (!placement.getRoomPlacements().contains(room)) break;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public int getDistributionConstraintPenalty(Assignment<Exam, ExamPlacement> assignment, ExamRoomPlacement room) {
        int penalty = 0;
        for (ExamDistributionConstraint dc : this.iDistConstraints) {
            if (dc.isHard()) continue;
            for (Exam exam : dc.variables()) {
                ExamPlacement placement;
                if (exam.equals(this) || (placement = assignment.getValue(exam)) == null) continue;
                switch (dc.getType()) {
                    case 0: {
                        if (placement.getRoomPlacements().contains(room)) break;
                        penalty += dc.getWeight();
                        break;
                    }
                    case 1: {
                        if (!placement.getRoomPlacements().contains(room)) break;
                        penalty += dc.getWeight();
                    }
                }
            }
        }
        return penalty;
    }

    public int getMaxRooms() {
        return this.iMaxRooms;
    }

    public void setMaxRooms(int maxRooms) {
        this.iMaxRooms = maxRooms;
    }

    public Set<ExamRoomPlacement> findBestAvailableRooms(Assignment<Exam, ExamPlacement> assignment, ExamPeriodPlacement period) {
        if (this.getMaxRooms() == 0) {
            return new HashSet<ExamRoomPlacement>();
        }
        double sw = this.getModel().getCriterion(RoomSizePenalty.class).getWeight();
        double pw = this.getModel().getCriterion(RoomPenalty.class).getWeight();
        double cw = this.getModel().getCriterion(DistributionPenalty.class).getWeight();
        ExamRoomSharing sharing = ((ExamModel)this.getModel()).getRoomSharing();
        block0: for (int nrRooms = 1; nrRooms <= this.getMaxRooms(); ++nrRooms) {
            int size;
            int bestSize;
            HashSet<ExamRoomPlacement> rooms = new HashSet<ExamRoomPlacement>();
            for (size = 0; rooms.size() < nrRooms && size < this.getSize(); size += bestSize) {
                int minSize = (this.getSize() - size) / (nrRooms - rooms.size());
                ExamRoomPlacement best = null;
                double bestWeight = 0.0;
                bestSize = 0;
                for (ExamRoomPlacement room : this.getRoomPlacements()) {
                    if (!room.isAvailable(period.getPeriod()) || (nrRooms != 1 || sharing == null ? !room.getRoom().getPlacements(assignment, period.getPeriod()).isEmpty() : sharing.inConflict(this, room.getRoom().getPlacements(assignment, period.getPeriod()), room.getRoom()))) continue;
                    if (rooms.contains(room) || !this.checkDistributionConstraints(assignment, room)) continue;
                    int s = room.getSize(this.hasAltSeating());
                    if (s < minSize) break;
                    int p = room.getPenalty(period.getPeriod());
                    double w = pw * (double)p + sw * (double)(s - minSize) + cw * (double)this.getDistributionConstraintPenalty(assignment, room);
                    double d = 0.0;
                    if (!rooms.isEmpty()) {
                        for (ExamRoomPlacement r : rooms) {
                            d += r.getDistanceInMeters(room);
                        }
                        w += d / (double)rooms.size();
                    }
                    if (best != null && !(bestWeight > w)) continue;
                    best = room;
                    bestSize = s;
                    bestWeight = w;
                }
                if (best == null) continue block0;
                rooms.add(best);
            }
            if (size < this.getSize()) continue;
            return rooms;
        }
        return null;
    }

    public Set<ExamRoomPlacement> findRoomsRandom(Assignment<Exam, ExamPlacement> assignment, ExamPeriodPlacement period) {
        return this.findRoomsRandom(assignment, period, true);
    }

    public Set<ExamRoomPlacement> findRoomsRandom(Assignment<Exam, ExamPlacement> assignment, ExamPeriodPlacement period, boolean checkConflicts) {
        if (this.getMaxRooms() == 0) {
            return new HashSet<ExamRoomPlacement>();
        }
        HashSet<ExamRoomPlacement> rooms = new HashSet<ExamRoomPlacement>();
        int size = 0;
        ExamRoomSharing sharing = ((ExamModel)this.getModel()).getRoomSharing();
        block0: while (rooms.size() < this.getMaxRooms()) {
            int rx = ToolBox.random(this.getRoomPlacements().size());
            int minSize = (this.getSize() - size + (this.getMaxRooms() - rooms.size() - 1)) / (this.getMaxRooms() - rooms.size());
            for (int r = 0; r < this.getRoomPlacements().size(); ++r) {
                ExamRoomPlacement room = this.getRoomPlacements().get((r + rx) % this.getRoomPlacements().size());
                int s = room.getSize(this.hasAltSeating());
                if (s < minSize || !room.isAvailable(period.getPeriod()) || checkConflicts && (!rooms.isEmpty() || sharing == null || room.getRoom().getPlacements(assignment, period.getPeriod()).isEmpty() ? !room.getRoom().getPlacements(assignment, period.getPeriod()).isEmpty() : sharing.inConflict(this, room.getRoom().getPlacements(assignment, period.getPeriod()), room.getRoom()))) continue;
                if (rooms.contains(room) || checkConflicts && !this.checkDistributionConstraints(assignment, room)) continue;
                rooms.add(room);
                if ((size += s) < this.getSize()) continue block0;
                Iterator j = rooms.iterator();
                while (j.hasNext()) {
                    ExamRoomPlacement rp = (ExamRoomPlacement)j.next();
                    if (size - rp.getSize(this.hasAltSeating()) < this.getSize()) continue;
                    j.remove();
                    size -= rp.getSize(this.hasAltSeating());
                }
                return rooms;
            }
        }
        return null;
    }

    public int nrStudentCorrelatedExams() {
        return this.getStudentCorrelatedExams().size();
    }

    public synchronized Set<Exam> getStudentCorrelatedExams() {
        if (this.iCorrelatedExams == null) {
            this.iCorrelatedExams = new HashSet();
            for (ExamStudent student : this.iStudents) {
                this.iCorrelatedExams.addAll(student.variables());
            }
            this.iCorrelatedExams.remove(this);
        }
        return this.iCorrelatedExams;
    }

    private synchronized int estimatedDomainSize() {
        if (this.iEstimatedDomainSize == null) {
            int periods = this.getPeriodPlacements().size();
            int rooms = -1;
            int split = 0;
            while (rooms < split && split <= this.getMaxRooms()) {
                rooms = 0;
                ++split;
                for (ExamRoomPlacement room : this.getRoomPlacements()) {
                    if (room.getSize(this.hasAltSeating()) < this.getSize() / split) continue;
                    ++rooms;
                }
            }
            this.iEstimatedDomainSize = periods * rooms / split;
        }
        return this.iEstimatedDomainSize;
    }

    @Override
    public int compareTo(Exam o) {
        Exam e = o;
        int cmp = Double.compare(this.estimatedDomainSize(), e.estimatedDomainSize());
        if (cmp != 0) {
            return cmp;
        }
        cmp = -Double.compare(this.nrStudentCorrelatedExams(), e.nrStudentCorrelatedExams());
        if (cmp != 0) {
            return cmp;
        }
        cmp = -Double.compare((double)this.getSize() / (double)this.getPeriodPlacements().size(), (double)e.getSize() / (double)e.getPeriodPlacements().size());
        if (cmp != 0) {
            return cmp;
        }
        return super.compareTo(o);
    }

    public boolean hasStudentConflictWithPreAssigned(Assignment<Exam, ExamPlacement> assignment, ExamPeriod period) {
        Map<ExamStudent, Set<Exam>> studentsOfPeriod = ((ExamModel)this.getModel()).getStudentsOfPeriod(assignment, period);
        for (ExamStudent s : this.getStudents()) {
            Set<Exam> exams = studentsOfPeriod.get(s);
            if (exams == null) continue;
            for (Exam exam : exams) {
                if (exam.equals(this) || s.canConflict(this, exam)) continue;
                return true;
            }
        }
        return false;
    }

    public int countStudentConflicts(Assignment<Exam, ExamPlacement> assignment, ExamPeriodPlacement period) {
        int conf = 0;
        Map<ExamStudent, Set<Exam>> studentsOfPeriod = ((ExamModel)this.getModel()).getStudentsOfPeriod(assignment, period.getPeriod());
        for (ExamStudent s : this.getStudents()) {
            Set<Exam> exams = studentsOfPeriod.get(s);
            if (exams == null) continue;
            for (Exam exam : exams) {
                if (exam.equals(this) || s.canConflict(this, exam)) continue;
                ++conf;
            }
        }
        return conf;
    }

    public int countInstructorConflicts(Assignment<Exam, ExamPlacement> assignment, ExamPeriodPlacement period) {
        int conf = 0;
        Map<ExamInstructor, Set<Exam>> instructorsOfPeriod = ((ExamModel)this.getModel()).getInstructorsOfPeriod(assignment, period.getPeriod());
        for (ExamInstructor i : this.getInstructors()) {
            Set<Exam> exams = instructorsOfPeriod.get(i);
            if (exams == null) continue;
            for (Exam exam : exams) {
                if (exam.equals(this) || i.canConflict(this, exam)) continue;
                ++conf;
            }
        }
        return conf;
    }

    public HashSet<Exam> getStudentConflicts(Assignment<Exam, ExamPlacement> assignment, ExamPeriod period) {
        HashSet<Exam> conf = new HashSet<Exam>();
        Map<ExamStudent, Set<Exam>> studentsOfPeriod = ((ExamModel)this.getModel()).getStudentsOfPeriod(assignment, period);
        for (ExamStudent s : this.getStudents()) {
            Set<Exam> exams = studentsOfPeriod.get(s);
            if (exams == null) continue;
            for (Exam exam : exams) {
                if (exam.equals(this) || s.canConflict(this, exam)) continue;
                conf.add(exam);
            }
        }
        return conf;
    }

    public void allowAllStudentConflicts(Assignment<Exam, ExamPlacement> assignment, ExamPeriod period) {
        Map<ExamStudent, Set<Exam>> studentsOfPeriod = ((ExamModel)this.getModel()).getStudentsOfPeriod(assignment, period);
        for (ExamStudent s : this.getStudents()) {
            Set<Exam> exams = studentsOfPeriod.get(s);
            if (exams == null) continue;
            for (Exam exam : exams) {
                if (exam.equals(this)) continue;
                exam.setAllowDirectConflicts(true);
                this.setAllowDirectConflicts(true);
                s.setAllowDirectConflicts(true);
            }
        }
    }

    @Override
    public String toString() {
        return this.getName() + " (periods:" + this.getPeriodPlacements().size() + ", rooms:" + this.getRoomPlacements().size() + ", size:" + this.getSize() + " ,maxRooms:" + this.getMaxRooms() + (this.hasAltSeating() ? ", alt" : "") + ")";
    }

    @Override
    public String getName() {
        return this.hasName() ? this.iName : String.valueOf(this.getId());
    }

    public void setName(String name) {
        this.iName = name;
    }

    public boolean hasName() {
        return this.iName != null && this.iName.length() > 0;
    }

    public Map<Exam, List<ExamStudent>> getJointEnrollments() {
        if (this.iJenrls != null) {
            return this.iJenrls;
        }
        this.iJenrls = new HashMap();
        for (ExamStudent student : this.getStudents()) {
            for (Exam other : student.variables()) {
                if (other.equals(this)) continue;
                List<ExamStudent> students = this.iJenrls.get(other);
                if (students == null) {
                    students = new ArrayList<ExamStudent>();
                    this.iJenrls.put(other, students);
                }
                students.add(student);
            }
        }
        return this.iJenrls;
    }

    public List<ExamOwner> getOwners() {
        return this.iOwners;
    }

    public Collection<ExamOwner> getOwners(ExamStudent student) {
        ArrayList<ExamOwner> ret = new ArrayList<ExamOwner>();
        for (ExamOwner owner : this.iOwners) {
            if (!owner.getStudents().contains(student)) continue;
            ret.add(owner);
        }
        return ret;
    }

    public Collection<ExamOwner> getOwners(ExamInstructor instructor) {
        ArrayList<ExamOwner> ret = new ArrayList<ExamOwner>();
        for (ExamOwner owner : this.iOwners) {
            if (!owner.getIntructors().contains(instructor)) continue;
            ret.add(owner);
        }
        return ret;
    }

    public ExamPeriodPlacement getPeriodPlacement(Long periodId) {
        for (ExamPeriodPlacement periodPlacement : this.getPeriodPlacements()) {
            if (!periodPlacement.getId().equals(periodId)) continue;
            return periodPlacement;
        }
        return null;
    }

    public ExamRoomPlacement getRoomPlacement(long roomId) {
        for (ExamRoomPlacement roomPlacement : this.iRoomPlacements) {
            if (roomPlacement.getId() != roomId) continue;
            return roomPlacement;
        }
        return null;
    }

    public ExamPeriodPlacement getPeriodPlacement(ExamPeriod period) {
        for (ExamPeriodPlacement periodPlacement : this.getPeriodPlacements()) {
            if (!periodPlacement.getPeriod().equals(period)) continue;
            return periodPlacement;
        }
        return null;
    }

    public ExamRoomPlacement getRoomPlacement(ExamRoom room) {
        for (ExamRoomPlacement roomPlacement : this.getRoomPlacements()) {
            if (!roomPlacement.getRoom().equals(room)) continue;
            return roomPlacement;
        }
        return null;
    }

    @Override
    public boolean hasValues() {
        return !this.getPeriodPlacements().isEmpty() && (this.getMaxRooms() == 0 || !this.getRoomPlacements().isEmpty());
    }

    @Override
    public void variableAssigned(Assignment<Exam, ExamPlacement> assignment, long iteration, ExamPlacement placement) {
        if (this.getMaxRooms() > 0) {
            int size = 0;
            for (ExamRoomPlacement room : placement.getRoomPlacements()) {
                size += room.getSize(this.hasAltSeating());
            }
            if (size < this.getSize() && !placement.getRoomPlacements().isEmpty()) {
                Progress.getInstance(this.getModel()).warn("Selected room(s) are too small " + size + "<" + this.getSize() + " (" + this.getName() + " " + placement.getName() + ")");
            }
        }
    }

    private class RoomSet
    implements Comparable<RoomSet> {
        private Set<ExamRoomPlacement> iRooms;
        private double iPenalty;

        public RoomSet(Set<ExamRoomPlacement> rooms, double penalty) {
            this.iRooms = new HashSet<ExamRoomPlacement>(rooms);
            this.iPenalty = penalty;
        }

        public Set<ExamRoomPlacement> rooms() {
            return this.iRooms;
        }

        public double penalty() {
            return this.iPenalty;
        }

        public int compareTo(Set<ExamRoomPlacement> rooms, double penalty) {
            int cmp = Double.compare(this.iRooms.size(), rooms.size());
            if (cmp != 0) {
                return cmp;
            }
            cmp = Double.compare(this.penalty(), penalty);
            if (cmp != 0) {
                return cmp;
            }
            return this.rooms().toString().compareTo(rooms.toString());
        }

        @Override
        public int compareTo(RoomSet r) {
            return this.compareTo(r.rooms(), r.penalty());
        }
    }
}

