/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.datepicker.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormatInfo;
import com.google.gwt.i18n.client.LocaleInfo;
import java.util.Date;

public class CalendarUtil {
    private static int firstDayOfWeekend;
    private static int lastDayOfWeekend;
    private static int startingDay;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void addDaysToDate(Date date, int days) {
        date.setDate(date.getDate() + days);
    }

    public static void addMonthsToDate(Date date, int months) {
        if (months != 0) {
            int month = date.getMonth();
            int year = date.getYear();
            int resultMonthCount = year * 12 + month + months;
            int resultYear = (int)Math.floor((double)resultMonthCount / 12.0);
            int resultMonth = resultMonthCount - resultYear * 12;
            date.setMonth(resultMonth);
            date.setYear(resultYear);
        }
    }

    public static Date copyDate(Date date) {
        if (date == null) {
            return null;
        }
        Date newDate = new Date();
        newDate.setTime(date.getTime());
        return newDate;
    }

    public static int getDaysBetween(Date start, Date finish) {
        start = CalendarUtil.copyDate(start);
        CalendarUtil.resetTime(start);
        finish = CalendarUtil.copyDate(finish);
        CalendarUtil.resetTime(finish);
        long aTime = start.getTime();
        long bTime = finish.getTime();
        long adjust = 3600000L;
        adjust = bTime > aTime ? adjust : -adjust;
        return (int)((bTime - aTime + adjust) / 86400000L);
    }

    public static int getStartingDayOfWeek() {
        return startingDay;
    }

    public static boolean isSameDate(Date date0, Date date1) {
        if (!$assertionsDisabled && date0 == null) {
            throw new AssertionError((Object)"date0 cannot be null");
        }
        if (!$assertionsDisabled && date1 == null) {
            throw new AssertionError((Object)"date1 cannot be null");
        }
        return date0.getYear() == date1.getYear() && date0.getMonth() == date1.getMonth() && date0.getDate() == date1.getDate();
    }

    public static void setToFirstDayOfMonth(Date date) {
        CalendarUtil.resetTime(date);
        date.setDate(1);
    }

    static boolean isWeekend(int dayOfWeek) {
        return dayOfWeek == firstDayOfWeekend || dayOfWeek == lastDayOfWeekend;
    }

    public static void resetTime(Date date) {
        long msec = CalendarUtil.resetMilliseconds(date.getTime());
        date.setTime(msec);
        date.setHours(0);
        date.setMinutes(0);
        date.setSeconds(0);
    }

    private static long resetMilliseconds(long msec) {
        int offset = (int)(msec % 1000L);
        if (offset < 0) {
            offset += 1000;
        }
        return msec - (long)offset;
    }

    static {
        boolean bl = $assertionsDisabled = !CalendarUtil.class.desiredAssertionStatus();
        if (GWT.isClient()) {
            DateTimeFormatInfo dateTimeFormatInfo = LocaleInfo.getCurrentLocale().getDateTimeFormatInfo();
            firstDayOfWeekend = dateTimeFormatInfo.weekendStart();
            lastDayOfWeekend = dateTimeFormatInfo.weekendEnd();
            startingDay = dateTimeFormatInfo.firstDayOfTheWeek();
        }
    }
}

