/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.model;

import org.cpsolver.coursett.constraint.RoomConstraint;
import org.cpsolver.ifs.util.DistanceMetric;

public class RoomLocation
implements Comparable<RoomLocation> {
    private int iPreference;
    private String iName;
    private Long iId;
    private Long iBldgId;
    private int iRoomSize;
    private Double iPosX = null;
    private Double iPosY = null;
    private RoomConstraint iRoomConstraint = null;
    private boolean iIgnoreTooFar = false;

    public RoomLocation(Long id, String name, Long bldgId, int preference, int size, Double x, Double y, boolean ignoreTooFar, RoomConstraint rc) {
        this.iId = id;
        this.iName = name;
        this.iPreference = preference;
        this.iRoomSize = size;
        this.iPosX = x;
        this.iPosY = y;
        this.iBldgId = bldgId;
        this.iRoomConstraint = rc;
        this.iIgnoreTooFar = ignoreTooFar;
    }

    public Long getId() {
        return this.iId;
    }

    public Long getBuildingId() {
        return this.iBldgId;
    }

    public String getName() {
        return this.iName;
    }

    public int getPreference() {
        return this.iPreference;
    }

    public void setPreference(int preference) {
        this.iPreference = preference;
    }

    public int getRoomSize() {
        return this.iRoomSize;
    }

    public void setCoordinates(Double x, Double y) {
        this.iPosX = x;
        this.iPosY = y;
    }

    public Double getPosX() {
        return this.iPosX;
    }

    public Double getPosY() {
        return this.iPosY;
    }

    public boolean getIgnoreTooFar() {
        return this.iIgnoreTooFar;
    }

    public RoomConstraint getRoomConstraint() {
        return this.iRoomConstraint;
    }

    public String toString() {
        return "Room{name=" + this.iName + ", pref=" + this.iPreference + "}";
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RoomLocation)) {
            return false;
        }
        return this.getId().equals(((RoomLocation)o).getId());
    }

    public double getDistanceInMeters(DistanceMetric m, RoomLocation roomLocation) {
        if (this.getId().equals(roomLocation.getId())) {
            return 0.0;
        }
        if (this.getIgnoreTooFar() || roomLocation.getIgnoreTooFar()) {
            return 0.0;
        }
        return m.getDistanceInMeters(this.getId(), this.getPosX(), this.getPosY(), roomLocation.getId(), roomLocation.getPosX(), roomLocation.getPosY());
    }

    public int getDistanceInMinutes(DistanceMetric m, RoomLocation roomLocation) {
        if (this.getId().equals(roomLocation.getId())) {
            return 0;
        }
        if (this.getIgnoreTooFar() || roomLocation.getIgnoreTooFar()) {
            return 0;
        }
        return m.getDistanceInMinutes(this.getId(), this.getPosX(), this.getPosY(), roomLocation.getId(), roomLocation.getPosX(), roomLocation.getPosY());
    }

    @Override
    public int compareTo(RoomLocation o) {
        int cmp = -Long.valueOf(this.getRoomSize()).compareTo(Long.valueOf(o.getRoomSize()));
        if (cmp != 0) {
            return cmp;
        }
        return this.getName().compareTo(o.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

