/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.dao._RootDAO;

public class AssignFirstAvailableTimePattern {
    protected static Log sLog = LogFactory.getLog(AssignFirstAvailableTimePattern.class);

    public static void main(String[] args) {
        try {
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            org.hibernate.Session hibSession = new _RootDAO().getSession();
            Session session = Session.getSessionUsingInitiativeYearTerm(ApplicationProperties.getProperty("initiative", "MUNI FI"), ApplicationProperties.getProperty("year", "2010"), ApplicationProperties.getProperty("term", "Podzim"));
            if (session == null) {
                sLog.error((Object)"Academic session not found, use properties initiative, year, and term to set academic session.");
                System.exit(0);
            } else {
                sLog.info((Object)("Session: " + session));
            }
            for (SchedulingSubpart s : hibSession.createQuery("select distinct s from SchedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co where co.subjectArea.department.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                List<TimePattern> patterns;
                if (!s.getTimePreferences().isEmpty() || (patterns = TimePattern.findApplicable(session, false, false, false, (int)s.getMinutesPerWk(), s.effectiveDatePattern(), s.getInstrOfferingConfig().getDurationModel(), null)).isEmpty()) continue;
                TimePattern pattern = patterns.get(0);
                TimePref tp = new TimePref();
                tp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                tp.setTimePatternModel(pattern.getTimePatternModel());
                tp.setOwner(s);
                hibSession.save((Object)tp);
                sLog.info((Object)(s.getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getCourseName() + " " + s.getItypeDesc() + " := " + pattern.getName()));
            }
            hibSession.flush();
            sLog.info((Object)"All done.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

