/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jgroups.Address;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.instructor.InstructorSchedulingProxy;
import org.unitime.timetable.solver.jgroups.SolverContainer;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;
import org.unitime.timetable.util.queue.QueueProcessor;

public interface SolverServer {
    public static final short SCOPE_SERVER = 0;
    public static final short SCOPE_COURSE = 1;
    public static final short SCOPE_EXAM = 2;
    public static final short SCOPE_STUDENT = 3;
    public static final short SCOPE_AVAILABILITY = 4;
    public static final short SCOPE_ONLINE = 5;
    public static final short SCOPE_INSTRUCTOR = 6;
    public static final short SCOPE_QUEUE_PROCESSOR = 7;

    public void start();

    public void stop();

    public boolean isLocal();

    public boolean isCoordinator();

    public boolean isLocalCoordinator();

    public Address getAddress();

    public Address getLocalAddress();

    public String getHost();

    public Date getStartTime();

    public int getUsage();

    public String getVersion();

    public void setUsageBase(int var1);

    public long getAvailableMemory();

    public int getAvailableProcessors();

    public long getMemoryLimit();

    public boolean isActive();

    public boolean isAvailable();

    public void shutdown();

    public SolverContainer<SolverProxy> getCourseSolverContainer();

    public SolverContainer<ExamSolverProxy> getExamSolverContainer();

    public SolverContainer<StudentSolverProxy> getStudentSolverContainer();

    public SolverContainer<InstructorSchedulingProxy> getInstructorSchedulingContainer();

    public SolverContainer<OnlineSectioningServer> getOnlineStudentSchedulingContainer();

    public RoomAvailabilityInterface getRoomAvailability();

    public void refreshCourseSolution(Long ... var1);

    public void refreshExamSolution(Long var1, Long var2);

    public void refreshInstructorSolution(Collection<Long> var1);

    public void setApplicationProperty(Long var1, String var2, String var3);

    public void setLoggingLevel(String var1, String var2);

    public void unloadSolver(SolverParameterGroup.SolverType var1, String var2);

    public void reset();

    public List<SolverServer> getServers(boolean var1);

    public SolverServer crateServerProxy(Address var1);

    public QueueProcessor getQueueProcessor();
}

