/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.List;
import java.util.Vector;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.base.BaseSolverPredefinedSetting;
import org.unitime.timetable.model.dao.SolverPredefinedSettingDAO;

public class SolverPredefinedSetting
extends BaseSolverPredefinedSetting {
    private static final long serialVersionUID = 1L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    public SolverPredefinedSetting() {
    }

    public SolverPredefinedSetting(Long uniqueId) {
        super(uniqueId);
    }

    public static SolverPredefinedSetting findByName(String name) {
        List list = new SolverPredefinedSettingDAO().getSession().createCriteria(SolverPredefinedSetting.class).add((Criterion)Restrictions.eq((String)"name", (Object)name)).setCacheable(true).list();
        if (list.isEmpty()) {
            return null;
        }
        return (SolverPredefinedSetting)list.get(0);
    }

    public static String[] getNames(Integer appearance) {
        List list = new SolverPredefinedSettingDAO().getSession().createCriteria(SolverPredefinedSetting.class).add((Criterion)Restrictions.eq((String)"appearance", (Object)appearance)).addOrder(Order.asc((String)"name")).setCacheable(true).list();
        if (list.isEmpty()) {
            return new String[0];
        }
        String[] names = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            SolverPredefinedSetting set = (SolverPredefinedSetting)list.get(i);
            names[i] = set.getName();
        }
        return names;
    }

    public static Vector getIdValueList(Integer appearance) {
        List list = new SolverPredefinedSettingDAO().getSession().createCriteria(SolverPredefinedSetting.class).add((Criterion)Restrictions.eq((String)"appearance", (Object)appearance)).addOrder(Order.asc((String)"name")).setCacheable(true).list();
        Vector<IdValue> idValueList = new Vector<IdValue>();
        for (SolverPredefinedSetting set : list) {
            idValueList.add(new IdValue(set.getUniqueId(), set.getDescription()));
        }
        return idValueList;
    }

    public Appearance getAppearanceType() {
        if (this.getAppearance() == null) {
            return null;
        }
        return Appearance.values()[this.getAppearance()];
    }

    public void setAppearanceType(Appearance appearance) {
        if (appearance == null) {
            this.setAppearance(null);
        } else {
            this.setAppearance(appearance.ordinal());
        }
    }

    public static class IdValue {
        private Long iId;
        private String iValue;
        private String iType;
        private boolean iEnabled;

        public IdValue(Long id, String value) {
            this(id, value, null, true);
        }

        public IdValue(Long id, String value, String type) {
            this(id, value, type, true);
        }

        public IdValue(Long id, String value, String type, boolean enabled) {
            this.iId = id;
            this.iValue = value;
            this.iType = type;
            this.iEnabled = enabled;
        }

        public Long getId() {
            return this.iId;
        }

        public String getValue() {
            return this.iValue;
        }

        public String getType() {
            return this.iType;
        }

        public boolean getEnabled() {
            return this.iEnabled;
        }

        public boolean getDisabled() {
            return !this.iEnabled;
        }
    }

    public static enum Appearance {
        TIMETABLES,
        SOLVER,
        EXAM_SOLVER,
        STUDENT_SOLVER,
        INSTRUCTOR_SOLVER;


        public String getLabel() {
            switch (this) {
                case TIMETABLES: {
                    return MSG.solverConfigAppearanceTimetables();
                }
                case SOLVER: {
                    return MSG.solverConfigAppearanceSolver();
                }
                case EXAM_SOLVER: {
                    return MSG.solverConfigAppearanceExamSolver();
                }
                case STUDENT_SOLVER: {
                    return MSG.solverConfigAppearanceStudentSolver();
                }
                case INSTRUCTOR_SOLVER: {
                    return MSG.solverConfigAppearanceInstructorSolver();
                }
            }
            return this.name();
        }

        public SolverParameterGroup.SolverType getSolverType() {
            switch (this) {
                case TIMETABLES: 
                case SOLVER: {
                    return SolverParameterGroup.SolverType.COURSE;
                }
                case EXAM_SOLVER: {
                    return SolverParameterGroup.SolverType.EXAM;
                }
                case STUDENT_SOLVER: {
                    return SolverParameterGroup.SolverType.STUDENT;
                }
                case INSTRUCTOR_SOLVER: {
                    return SolverParameterGroup.SolverType.INSTRUCTOR;
                }
            }
            return SolverParameterGroup.SolverType.COURSE;
        }
    }
}

