/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaSuggestBox;

public class SearchableListBox
extends Composite {
    private ListBox iListBox;
    private AriaSuggestBox iSuggestBox = new AriaSuggestBox(new SearchableListBoxOracle());

    public SearchableListBox() {
        this.initWidget((Widget)this.iSuggestBox);
        this.iSuggestBox.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>(){

            public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                if (event.getSelectedItem() != null) {
                    SearchableListBox.this.iListBox.setSelectedIndex(((ListItem)event.getSelectedItem()).getIndex());
                } else {
                    SearchableListBox.this.iListBox.setSelectedIndex(0);
                }
                ChangeEvent.fireNativeEvent((NativeEvent)Document.get().createChangeEvent(), (HasHandlers)SearchableListBox.this.iListBox);
            }
        });
        this.iSuggestBox.getTextBox().addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                SearchableListBox.this.iSuggestBox.showSuggestionList();
            }
        });
        this.iSuggestBox.getTextBox().addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                SearchableListBox.this.iSuggestBox.setText(SearchableListBox.this.iListBox.getSelectedItemText());
            }
        });
    }

    public SearchableListBox(ListBox box) {
        this();
        this.setListBox(box);
        this.iSuggestBox.getElement().getStyle().clearWidth();
    }

    public void setListBox(ListBox box) {
        this.iListBox = box;
        this.iSuggestBox.getElement().getStyle().setWidth((double)this.iListBox.getOffsetWidth(), Style.Unit.PX);
        this.iListBox.setVisible(false);
        this.iListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                SearchableListBox.this.iSuggestBox.setValue(SearchableListBox.this.iListBox.getSelectedItemText());
            }
        });
        this.iSuggestBox.setValue(this.iListBox.getSelectedItemText());
    }

    ListItem item(int index) {
        if (index < 0 || index > this.iListBox.getItemCount()) {
            return null;
        }
        return new ListItem(index, this.iListBox.getValue(index), this.iListBox.getItemText(index));
    }

    public void insert(RootPanel panel) {
        this.setListBox(ListBox.wrap((Element)panel.getElement().getFirstChildElement()));
        panel.add((Widget)this);
        final String onchange = panel.getElement().getFirstChildElement().getAttribute("onchange");
        if (onchange != null) {
            this.iListBox.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ToolBox.eval(onchange);
                }
            });
        }
    }

    class SearchableListBoxOracle
    extends SuggestOracle {
        SearchableListBoxOracle() {
        }

        public void requestSuggestions(SuggestOracle.Request request, SuggestOracle.Callback callback) {
            if (SearchableListBox.this.iListBox.getSelectedItemText().equals(request.getQuery())) {
                this.requestDefaultSuggestions(request, callback);
                return;
            }
            ArrayList<ListItem> items = new ArrayList<ListItem>();
            for (int i = 0; i < SearchableListBox.this.iListBox.getItemCount(); ++i) {
                if (!SearchableListBox.this.iListBox.getItemText(i).toLowerCase().contains(request.getQuery().toLowerCase())) continue;
                items.add(SearchableListBox.this.item(i));
            }
            SuggestOracle.Response response = new SuggestOracle.Response(items);
            callback.onSuggestionsReady(request, response);
        }

        public void requestDefaultSuggestions(SuggestOracle.Request request, SuggestOracle.Callback callback) {
            ArrayList<ListItem> items = new ArrayList<ListItem>();
            for (int i = 0; i < SearchableListBox.this.iListBox.getItemCount(); ++i) {
                items.add(SearchableListBox.this.item(i));
            }
            SuggestOracle.Response response = new SuggestOracle.Response(items);
            callback.onSuggestionsReady(request, response);
        }
    }

    public static class ListItem
    implements IsSerializable,
    Comparable<ListItem>,
    SuggestOracle.Suggestion {
        private String iValue;
        private String iText;
        private int iIndex;

        public ListItem() {
        }

        public ListItem(int index, String value, String text) {
            this.iIndex = index;
            this.iValue = value;
            this.iText = text;
        }

        public int getIndex() {
            return this.iIndex;
        }

        public String getValue() {
            return this.iValue;
        }

        public String getText() {
            return this.iText;
        }

        public String toString() {
            return this.iText;
        }

        @Override
        public int compareTo(ListItem o) {
            return this.getText().compareTo(o.getText());
        }

        public int hashCode() {
            return this.getText().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ListItem)) {
                return false;
            }
            ListItem i = (ListItem)o;
            return this.getValue().equals(i.getValue());
        }

        public String getDisplayString() {
            return this.getText();
        }

        public String getReplacementString() {
            return this.getText();
        }
    }
}

