/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.HibernateException;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.BlankForm;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.security.rights.Right;

@Action(value="distributionTypeList", results={@Result(name={"showDistributionTypeList"}, type="tiles", location="distributionTypeList.tiles")})
@TilesDefinition(name="distributionTypeList.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Distribution Types"), @TilesPutAttribute(name="body", value="/admin/distributionTypeList.jsp")})
public class DistributionTypeListAction
extends UniTimeAction<BlankForm> {
    private static final long serialVersionUID = -5869733478310566508L;
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);

    public String execute() throws HibernateException {
        this.sessionContext.checkPermission(Right.DistributionTypes);
        return "showDistributionTypeList";
    }

    public String getTable() {
        ArrayList<DistributionType> distTypes = new ArrayList<DistributionType>();
        distTypes.addAll(DistributionType.findAll(false, false, null));
        distTypes.addAll(DistributionType.findAll(false, true, null));
        WebTable webTable = new WebTable(11, MSG.sectDistributionTypes(), "distributionTypeList.action?ord=%%", new String[]{MSG.fieldId(), MSG.fieldReference(), MSG.fieldAbbreviation(), MSG.fieldName(), MSG.fieldType(), MSG.fieldVisible(), MSG.fieldAllowInstructorPreference(), MSG.fieldSequencingRequired(), MSG.fieldAllowPreferences(), MSG.fieldDepartments(), MSG.fieldDescription()}, new String[]{"left", "left", "left", "left", "left", "center", "center", "center", "center", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true, true, true, true});
        WebTable.setOrder(this.sessionContext, "DistributionTypeList.ord", this.request.getParameter("ord"), 1);
        boolean edit = this.sessionContext.hasPermission(Right.DistributionTypeEdit);
        for (DistributionType d : distTypes) {
            String allowPref = null;
            if ("".equals(d.getAllowedPref())) {
                allowPref = "<i>" + MSG.itemNone() + "</i>";
            } else if ("P43210R".equals(d.getAllowedPref()) || "R01234P".equals(d.getAllowedPref())) {
                allowPref = "<i>" + MSG.itemAll() + "</i>";
            } else {
                for (PreferenceLevel p : PreferenceLevel.getPreferenceLevelList()) {
                    if (d.getAllowedPref().indexOf(PreferenceLevel.prolog2char(p.getPrefProlog())) < 0) continue;
                    allowPref = allowPref == null ? "" : allowPref + "<br>";
                    if (PreferenceLevel.sNeutral.equals(p.getPrefProlog())) {
                        allowPref = allowPref + p.getPrefName();
                        continue;
                    }
                    allowPref = allowPref + "<span style='color:" + p.prefcolor() + ";'>" + p.getPrefName().replaceAll(" ", "&nbsp;") + "</span>";
                }
            }
            String deptStr = "";
            String deptCmp = "";
            Iterator<Department> i = d.getDepartments(this.sessionContext.getUser().getCurrentAcademicSessionId()).iterator();
            while (i.hasNext()) {
                Department x = i.next();
                deptStr = deptStr + x.getManagingDeptAbbv().trim();
                deptCmp = deptCmp + x.getDeptCode();
                if (!i.hasNext()) continue;
                deptStr = deptStr + ", ";
                deptCmp = deptCmp + ",";
            }
            String[] stringArray = new String[11];
            stringArray[0] = d.getRequirementId().toString();
            stringArray[1] = d.getReference();
            stringArray[2] = d.getAbbreviation();
            stringArray[3] = d.getLabel();
            stringArray[4] = d.isExamPref() != false ? MSG.itemDistTypeExams() : MSG.itemDistTypeCourses();
            String string = stringArray[5] = d.isVisible() != false ? MSG.yes() : MSG.no();
            stringArray[6] = d.isExamPref() != false ? MSG.notApplicable() : (d.isInstructorPref() != false ? MSG.yes() : MSG.no());
            stringArray[7] = d.isSequencingRequired() != false ? MSG.yes() : MSG.no();
            stringArray[8] = allowPref;
            stringArray[9] = deptStr.length() == 0 ? "<i>" + MSG.itemAll() + "</i>" : deptStr;
            stringArray[10] = d.getDescr();
            WebTable.WebTableLine line = webTable.addLine(edit ? "onClick=\"document.location='distributionTypeEdit.action?id=" + d.getUniqueId() + "';\"" : null, stringArray, new Comparable[]{d.getRequirementId(), d.getReference(), d.getAbbreviation(), d.getLabel(), Integer.valueOf(d.isExamPref() != false ? 1 : 0), d.isVisible(), Integer.valueOf(d.isInstructorPref() != false ? 1 : 0), Integer.valueOf(d.isSequencingRequired() != false ? 1 : 0), null, deptCmp, d.getDescr()}, null);
            if (d.getRequirementId() != null) {
                line.setUniqueId(d.getRequirementId().toString());
            }
            if (d.isVisible().booleanValue()) continue;
            line.setStyle("color:gray;");
        }
        return webTable.printTable(WebTable.getOrder(this.sessionContext, "DistributionTypeList.ord"));
    }
}

