/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.model.base.BaseTeachingRequest;

public class TeachingRequest
extends BaseTeachingRequest
implements Comparable<TeachingRequest> {
    private static final long serialVersionUID = 1L;

    @Override
    public String htmlLabel() {
        TreeSet<TeachingClassRequest> requests = new TreeSet<TeachingClassRequest>(this.getClassRequests());
        String classes = null;
        for (TeachingClassRequest r : requests) {
            if (classes == null) {
                classes = r.getTeachingClass().htmlLabel();
                continue;
            }
            classes = classes + ", " + r.getTeachingClass().htmlLabel();
        }
        return this.getOffering().getCourseName() + (classes == null ? "" : " " + classes);
    }

    @Override
    public Session getSession() {
        return this.getOffering().getSession();
    }

    @Override
    public Department getDepartment() {
        return this.getOffering().getDepartment();
    }

    public Map<SchedulingSubpart, List<TeachingClassRequest>> getSubparMap() {
        HashMap<SchedulingSubpart, List<TeachingClassRequest>> map = new HashMap<SchedulingSubpart, List<TeachingClassRequest>>();
        for (TeachingClassRequest r : this.getClassRequests()) {
            ArrayList<TeachingClassRequest> requests = (ArrayList<TeachingClassRequest>)map.get(r.getTeachingClass().getSchedulingSubpart());
            if (requests == null) {
                requests = new ArrayList<TeachingClassRequest>();
                map.put(r.getTeachingClass().getSchedulingSubpart(), requests);
            }
            requests.add(r);
        }
        return map;
    }

    public TeachingClassRequest getMasterRequest(boolean checkClassRequests) {
        Map<SchedulingSubpart, List<TeachingClassRequest>> map = this.getSubparMap();
        TeachingClassRequest master = null;
        for (Map.Entry<SchedulingSubpart, List<TeachingClassRequest>> e : map.entrySet()) {
            if (e.getValue().size() > 1) {
                if (!checkClassRequests) continue;
                TeachingClassRequest r1 = e.getValue().get(0);
                for (int i = 1; i < e.getValue().size(); ++i) {
                    TeachingClassRequest r2 = e.getValue().get(i);
                    if (!ToolBox.equals((Object)r1.isAssignInstructor(), (Object)r2.isAssignInstructor())) {
                        return null;
                    }
                    if (!ToolBox.equals((Object)r1.isCommon(), (Object)r2.isCommon())) {
                        return null;
                    }
                    if (!ToolBox.equals((Object)r1.getPercentShare(), (Object)r2.getPercentShare())) {
                        return null;
                    }
                    if (!ToolBox.equals((Object)r1.isLead(), (Object)r2.isLead())) {
                        return null;
                    }
                    if (ToolBox.equals((Object)r1.isCanOverlap(), (Object)r2.isCanOverlap())) continue;
                    return null;
                }
                continue;
            }
            TeachingClassRequest adept = e.getValue().get(0);
            if (master == null) {
                master = adept;
                continue;
            }
            if (master.isParentOf(adept)) {
                master = adept;
                continue;
            }
            if (adept.isParentOf(master) || adept.getTeachingClass().getSchedulingSubpart().getClasses().size() <= master.getTeachingClass().getSchedulingSubpart().getClasses().size()) continue;
            master = adept;
        }
        return master;
    }

    public static List<Class_> getClasses(Class_ master, Set<SchedulingSubpart> subparts) {
        ArrayList<Class_> classes = new ArrayList<Class_>();
        for (SchedulingSubpart subpart : subparts) {
            Class_ parent;
            if (subpart.equals(master.getSchedulingSubpart())) {
                classes.add(master);
                continue;
            }
            if (subpart.isParentOf(master.getSchedulingSubpart())) {
                for (Class_ c : subpart.getClasses()) {
                    if (!c.isParentOf(master)) continue;
                    classes.add(c);
                }
                continue;
            }
            if (master.getSchedulingSubpart().isParentOf(subpart)) {
                for (Class_ c : subpart.getClasses()) {
                    if (!master.isParentOf(c)) continue;
                    classes.add(c);
                }
                continue;
            }
            for (parent = master.getParentClass(); parent != null && !parent.getSchedulingSubpart().isParentOf(subpart); parent = parent.getParentClass()) {
            }
            if (parent != null) {
                for (Class_ c : subpart.getClasses()) {
                    if (!parent.isParentOf(c)) continue;
                    classes.add(c);
                }
                continue;
            }
            classes.addAll(subpart.getClasses());
        }
        return classes;
    }

    public boolean isStandard(TeachingClassRequest master) {
        if (master == null) {
            return false;
        }
        HashSet<SchedulingSubpart> subparts = new HashSet<SchedulingSubpart>();
        HashSet<Class_> classes = new HashSet<Class_>();
        for (TeachingClassRequest r : this.getClassRequests()) {
            classes.add(r.getTeachingClass());
            subparts.add(r.getTeachingClass().getSchedulingSubpart());
        }
        List<Class_> std = TeachingRequest.getClasses(master.getTeachingClass(), subparts);
        if (std.size() != classes.size()) {
            return false;
        }
        for (Class_ c : std) {
            if (classes.contains(c)) continue;
            return false;
        }
        return true;
    }

    public boolean canCombine(TeachingRequest other) {
        TeachingClassRequest m1 = this.getMasterRequest(true);
        if (m1 == null || !this.isStandard(m1)) {
            return false;
        }
        TeachingClassRequest m2 = other.getMasterRequest(true);
        if (m2 == null || m1.getTeachingClass().equals(m2.getTeachingClass()) || !other.isStandard(m2) || !m1.getTeachingClass().getSchedulingSubpart().equals(m2.getTeachingClass().getSchedulingSubpart())) {
            return false;
        }
        if (!ToolBox.equals((Object)this.getTeachingLoad(), (Object)other.getTeachingLoad())) {
            return false;
        }
        if (!ToolBox.equals((Object)this.getResponsibility(), (Object)other.getResponsibility())) {
            return false;
        }
        if (!ToolBox.equals((Object)this.getSameCoursePreference(), (Object)other.getSameCoursePreference())) {
            return false;
        }
        if (!ToolBox.equals((Object)this.getSameCommonPart(), (Object)other.getSameCommonPart())) {
            return false;
        }
        if (!ToolBox.equals((Object)this.isAssignCoordinator(), (Object)other.isAssignCoordinator())) {
            return false;
        }
        Set<Preference> p1 = this.getPreferences();
        Set<Preference> p2 = other.getPreferences();
        if (p1.size() != p2.size()) {
            return false;
        }
        block0: for (Preference p : p1) {
            for (Preference q : p2) {
                if (!p.isSame(q) || !p.getPrefLevel().equals(q.getPrefLevel())) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(TeachingRequest r) {
        int cmp = this.getOffering().getControllingCourseOffering().compareTo(r.getOffering().getControllingCourseOffering());
        if (cmp != 0) {
            return cmp;
        }
        Iterator<TeachingClassRequest> i1 = new TreeSet<TeachingClassRequest>(this.getClassRequests()).iterator();
        Iterator<TeachingClassRequest> i2 = new TreeSet<TeachingClassRequest>(r.getClassRequests()).iterator();
        while (i1.hasNext() && i2.hasNext()) {
            cmp = i1.next().compareTo(i2.next());
            if (cmp == 0) continue;
            return cmp;
        }
        if (i2.hasNext()) {
            return -1;
        }
        if (i1.hasNext()) {
            return 1;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(r.getUniqueId() == null ? -1L : r.getUniqueId());
    }

    public boolean isCancelled() {
        if (this.isAssignCoordinator().booleanValue()) {
            return false;
        }
        for (TeachingClassRequest tcr : this.getClassRequests()) {
            if (!tcr.isAssignInstructor().booleanValue() || tcr.getTeachingClass().isCancelled().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isCommitted() {
        for (TeachingClassRequest tcr : this.getClassRequests()) {
            if (!tcr.isAssignInstructor().booleanValue()) continue;
            for (ClassInstructor ci : tcr.getTeachingClass().getClassInstructors()) {
                if (!this.equals(ci.getTeachingRequest()) || !this.getAssignedInstructors().contains(ci.getInstructor())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getOffering().getCourseName() + " " + this.getClassRequests();
    }
}

