/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Hashtable;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.unitime.timetable.model.ExternalRoom;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseExternalBuilding;
import org.unitime.timetable.model.dao.ExternalBuildingDAO;

public class ExternalBuilding
extends BaseExternalBuilding {
    private static final long serialVersionUID = 1L;

    public ExternalBuilding() {
    }

    public ExternalBuilding(Long uniqueId) {
        super(uniqueId);
    }

    public static Hashtable getBuildings(Long sessionId) {
        List bldgs = new ExternalBuildingDAO().getQuery("from ExternalBuilding as b where b.session.uniqueId = " + sessionId).list();
        Hashtable<String, ExternalBuilding> buildings = new Hashtable<String, ExternalBuilding>((int)((double)bldgs.size() * 1.25));
        for (ExternalBuilding bldg : bldgs) {
            buildings.put(bldg.getExternalUniqueId(), bldg);
        }
        return buildings;
    }

    public static ExternalBuilding findExternalBuildingForSession(String externalUniqueId, Session session) {
        ExternalBuildingDAO bDao = new ExternalBuildingDAO();
        List extBldgs = bDao.getSession().createCriteria(ExternalBuilding.class).add((Criterion)Restrictions.eq((String)"externalUniqueId", (Object)externalUniqueId)).add((Criterion)Restrictions.eq((String)"session.uniqueId", (Object)session.getUniqueId())).setCacheable(true).list();
        if (extBldgs.size() == 1) {
            return (ExternalBuilding)extBldgs.get(0);
        }
        return null;
    }

    public static ExternalBuilding findByAbbv(Long sessionId, String bldgAbbr) {
        ExternalBuildingDAO bldgDAO = new ExternalBuildingDAO();
        List bldgs = bldgDAO.getSession().createCriteria(ExternalBuilding.class).add((Criterion)Restrictions.eq((String)"session.uniqueId", (Object)sessionId)).add((Criterion)Restrictions.eq((String)"abbreviation", (Object)bldgAbbr)).list();
        if (bldgs == null || bldgs.size() == 0) {
            return null;
        }
        return (ExternalBuilding)bldgs.get(0);
    }

    public ExternalRoom findRoom(String roomNbr) {
        ExternalRoom room = null;
        for (ExternalRoom rm : this.getRooms()) {
            if (!roomNbr.trim().equalsIgnoreCase(rm.getRoomNumber().trim())) continue;
            room = rm;
            break;
        }
        return room;
    }
}

