/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.unitime.timetable.gwt.client.aria.AriaHiddenLabel;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.aria.AriaTabBar;
import org.unitime.timetable.gwt.client.sectioning.CourseRequestLine;
import org.unitime.timetable.gwt.client.widgets.CourseFinder;
import org.unitime.timetable.gwt.client.widgets.CourseFinderClasses;
import org.unitime.timetable.gwt.client.widgets.CourseFinderDetails;
import org.unitime.timetable.gwt.client.widgets.DataProvider;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;

public class WaitListedRequestPreferences
extends UniTimeDialogBox
implements HasValue<CourseRequestInterface.Request>,
HasSelectionHandlers<CourseRequestInterface.Request>,
KeyUpHandler {
    protected static StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static GwtMessages GWT_MSG = (GwtMessages)GWT.create(GwtMessages.class);
    protected static SectioningServiceAsync sSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    protected static Logger sLogger = Logger.getLogger(WaitListedRequestPreferences.class.getName());
    public static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    private static DateTimeFormat sDF = DateTimeFormat.getFormat((String)CONSTANTS.requestWaitListedDateFormat());
    private OnlineSectioningInterface.StudentSectioningContext iContext;
    private Map<Character, Integer> iTabAccessKeys = new HashMap<Character, Integer>();
    private SimpleForm iForm;
    private UniTimeTable<ClassAssignmentInterface.CourseAssignment> iCourses;
    private FocusPanel iCoursesPanel;
    private AriaTabBar iCourseDetailsTabBar;
    private ScrollPanel iCourseDetailsPanel;
    private CourseFinder.CourseFinderCourseDetails[] iDetails = null;
    private P iInstructionalMethodsPanel = null;
    private Map<CourseRequestInterface.Preference, CheckBox> iInstructionalMethods = new HashMap<CourseRequestInterface.Preference, CheckBox>();
    private UniTimeHeaderPanel iButtons;
    private ClassAssignmentInterface.CourseAssignment iLastDetails = null;
    private CourseRequestInterface.Request iRequest = null;
    private ListBox iEnrolledCoursesList = null;
    private CourseRequestLine iLine = null;
    private CheckBox iWaitListed;
    private Long iSelectCourseId = null;

    public WaitListedRequestPreferences(OnlineSectioningInterface.StudentSectioningContext context) {
        super(true, true);
        this.addStyleName("unitime-WaitListedRequestPreferences");
        this.setText(MESSAGES.dialogWaitListedRequestPreferences());
        this.iContext = context;
        this.iForm = new SimpleForm();
        this.iWaitListed = new CheckBox(MESSAGES.checkWaitListSwapWithNewWaitList());
        this.iForm.addRow(MESSAGES.propWaitListSwapWithWaitListed(), (Widget)this.iWaitListed);
        this.iCourses = new UniTimeTable();
        this.iCourses.setAllowMultiSelect(false);
        this.iCourses.setAllowSelection(true);
        ArrayList<UniTimeTableHeader> head = new ArrayList<UniTimeTableHeader>();
        head.add(new UniTimeTableHeader(MESSAGES.colSubject()));
        head.add(new UniTimeTableHeader(MESSAGES.colCourse()));
        head.add(new UniTimeTableHeader(MESSAGES.colLimit()));
        head.add(new UniTimeTableHeader(MESSAGES.colTitle()));
        head.add(new UniTimeTableHeader(MESSAGES.colCredit()));
        head.add(new UniTimeTableHeader(MESSAGES.colNote()));
        head.add(new UniTimeTableHeader(MESSAGES.colWaitListAndAllowedOverrides()));
        this.iCourses.addRow(null, head);
        this.iCourses.addMouseClickListener(new UniTimeTable.MouseClickListener<ClassAssignmentInterface.CourseAssignment>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<ClassAssignmentInterface.CourseAssignment> event) {
                WaitListedRequestPreferences.this.updateCourseDetails();
            }
        });
        this.iCoursesPanel = new FocusPanel(this.iCourses);
        this.iCoursesPanel.setStyleName("unitime-ScrollPanel");
        this.iCoursesPanel.addStyleName("course-table");
        this.iCoursesPanel.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (WaitListedRequestPreferences.this.iCourses.getRowCount() < 2 || WaitListedRequestPreferences.this.iCourses.getData(1) == null) {
                    return;
                }
                int row = WaitListedRequestPreferences.this.iCourses.getSelectedRow();
                if (event.getNativeKeyCode() == 40) {
                    if (row < 0 || WaitListedRequestPreferences.this.iCourses.getSelectedRow() + 1 >= WaitListedRequestPreferences.this.iCourses.getRowCount()) {
                        WaitListedRequestPreferences.this.iCourses.setSelected(1, true);
                    } else {
                        WaitListedRequestPreferences.this.iCourses.setSelected(row + 1, true);
                    }
                    WaitListedRequestPreferences.this.scrollToSelectedRow();
                    WaitListedRequestPreferences.this.updateCourseDetails();
                }
                if (event.getNativeKeyCode() == 38) {
                    if (row - 1 < 1) {
                        WaitListedRequestPreferences.this.iCourses.setSelected(WaitListedRequestPreferences.this.iCourses.getRowCount() - 1, true);
                    } else {
                        WaitListedRequestPreferences.this.iCourses.setSelected(row - 1, true);
                    }
                    WaitListedRequestPreferences.this.scrollToSelectedRow();
                    WaitListedRequestPreferences.this.updateCourseDetails();
                }
                if (event.isControlKeyDown() || event.isAltKeyDown()) {
                    for (Map.Entry entry : WaitListedRequestPreferences.this.iTabAccessKeys.entrySet()) {
                        if (event.getNativeKeyCode() != Character.toLowerCase(((Character)entry.getKey()).charValue()) && event.getNativeKeyCode() != Character.toUpperCase(((Character)entry.getKey()).charValue())) continue;
                        WaitListedRequestPreferences.this.iCourseDetailsTabBar.selectTab((Integer)entry.getValue(), true);
                        event.preventDefault();
                        event.stopPropagation();
                    }
                }
            }
        });
        this.iCourseDetailsTabBar = new AriaTabBar();
        this.iCourseDetailsTabBar.addStyleName("course-details-tabs");
        this.iCourseDetailsPanel = new ScrollPanel();
        this.iCourseDetailsPanel.addStyleName("course-details");
        this.iCourseDetailsTabBar.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                Cookies.setCookie((String)"UniTime:WLPrefsTab", (String)String.valueOf(event.getSelectedItem()));
                WaitListedRequestPreferences.this.iCourseDetailsPanel.setWidget((IsWidget)WaitListedRequestPreferences.this.iDetails[(Integer)event.getSelectedItem()]);
            }
        });
        this.iInstructionalMethodsPanel = new P("instructional-methods");
        this.iCourseDetailsTabBar.setRestWidget((Widget)this.iInstructionalMethodsPanel);
        this.iForm.addRow((Widget)this.iCoursesPanel);
        P courseDetailsPanel = new P("course-details-panel");
        courseDetailsPanel.add((Widget)this.iCourseDetailsTabBar);
        courseDetailsPanel.add((Widget)this.iCourseDetailsPanel);
        this.iForm.addRow((Widget)courseDetailsPanel);
        P swapCoursePanel = new P("swap-courses-panel");
        this.iEnrolledCoursesList = new ListBox();
        this.iEnrolledCoursesList.addItem(MESSAGES.itemWaitListSwapWithNoCourseOffering(), "");
        swapCoursePanel.add((Widget)this.iEnrolledCoursesList);
        swapCoursePanel.add((Widget)new Label(MESSAGES.descWaitListSwapWithCourseOffering()));
        this.iForm.addRow(MESSAGES.propWaitListSwapWithCourseOffering(), (Widget)swapCoursePanel);
        this.iButtons = new UniTimeHeaderPanel();
        this.iButtons.addButton("submit", MESSAGES.buttonSubmitWaitListedRequestPreferences(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                WaitListedRequestPreferences.this.onSubmit();
            }
        });
        this.iButtons.addButton("cancel", MESSAGES.buttonCloseWaitListedRequestPreferences(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                WaitListedRequestPreferences.this.hide();
            }
        });
        this.iForm.addBottomRow((Widget)this.iButtons);
        this.setWidget((Widget)this.iForm);
        CourseFinderDetails details = new CourseFinderDetails();
        details.setDataProvider(new DataProvider<ClassAssignmentInterface.CourseAssignment, String>(){

            @Override
            public void getData(ClassAssignmentInterface.CourseAssignment source, AsyncCallback<String> callback) {
                sSectioningService.retrieveCourseDetails(WaitListedRequestPreferences.this.iContext, source.hasUniqueName() ? source.getCourseName() : source.getCourseNameWithTitle(), callback);
            }
        });
        CourseFinderClasses classes = new CourseFinderClasses(true, null, null);
        classes.setDataProvider(new DataProvider<ClassAssignmentInterface.CourseAssignment, Collection<ClassAssignmentInterface.ClassAssignment>>(){

            @Override
            public void getData(ClassAssignmentInterface.CourseAssignment source, AsyncCallback<Collection<ClassAssignmentInterface.ClassAssignment>> callback) {
                sSectioningService.listClasses(WaitListedRequestPreferences.this.iContext, source.hasUniqueName() ? source.getCourseName() : source.getCourseNameWithTitle(), callback);
            }
        });
        this.setCourseDetails(classes, details);
        this.sinkEvents(512);
    }

    protected void onSubmit() {
        this.hide();
        this.iLine.setValue(this.getValue());
    }

    public void show(CourseRequestLine line) {
        this.show(line, null);
    }

    public void show(CourseRequestLine line, Long courseId) {
        if (line == null) {
            return;
        }
        this.iLine = line;
        this.iSelectCourseId = courseId;
        CourseRequestInterface.Request r = line.getValue();
        this.setValue(r);
        this.iEnrolledCoursesList.setEnabled(true);
        if (r != null && r.hasRequestedCourse()) {
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.ENROLLED) continue;
                this.iEnrolledCoursesList.setEnabled(false);
                break;
            }
        }
        this.center();
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                WaitListedRequestPreferences.this.iCoursesPanel.setFocus(true);
            }
        });
    }

    public void showWaitListAssigned(CourseRequestLine line, Long courseId) {
        if (line == null) {
            return;
        }
        this.iLine = line;
        this.iSelectCourseId = courseId;
        CourseRequestInterface.Request req = line.getValue();
        req.setWaitList(true);
        req.setWaitListSwapWithCourseOfferingId(courseId);
        this.setValue(req);
        this.iEnrolledCoursesList.setEnabled(false);
        this.center();
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                WaitListedRequestPreferences.this.iCoursesPanel.setFocus(true);
            }
        });
    }

    public void showChecked(CourseRequestLine line) {
        if (line == null) {
            return;
        }
        this.iLine = line;
        this.setValue(line.getValue());
        this.iWaitListed.setValue(Boolean.valueOf(true));
        this.iEnrolledCoursesList.setEnabled(true);
        this.center();
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                WaitListedRequestPreferences.this.iCoursesPanel.setFocus(true);
            }
        });
    }

    private void selectLastTab() {
        try {
            int tab = Integer.valueOf(Cookies.getCookie((String)"UniTime:WLPrefsTab"));
            if (tab >= 0 || tab < this.iCourseDetailsTabBar.getTabCount() && tab != this.iCourseDetailsTabBar.getSelectedTab()) {
                this.iCourseDetailsTabBar.selectTab(tab, true);
            } else {
                this.iCourseDetailsTabBar.selectTab(0, true);
            }
        }
        catch (Exception e) {
            this.iCourseDetailsTabBar.selectTab(0, true);
        }
    }

    public void setCourseDetails(CourseFinder.CourseFinderCourseDetails ... details) {
        this.iDetails = details;
        int tabIndex = 0;
        for (CourseFinder.CourseFinderCourseDetails detail : this.iDetails) {
            ScrollPanel panel = new ScrollPanel(detail.asWidget());
            panel.setStyleName("unitime-ScrollPanel-inner");
            panel.addStyleName("course-info");
            this.iCourseDetailsTabBar.addTab(detail.getName(), true);
            Character ch = UniTimeHeaderPanel.guessAccessKey(detail.getName());
            if (ch != null) {
                this.iTabAccessKeys.put(ch, tabIndex);
            }
            ++tabIndex;
        }
        this.selectLastTab();
    }

    protected void updateCourseDetails() {
        ClassAssignmentInterface.CourseAssignment record;
        if (this.iLastDetails != null) {
            for (CourseRequestInterface.RequestedCourse rc : this.iRequest.getRequestedCourse()) {
                if (!rc.equals(this.iLastDetails)) continue;
                rc.clearSelection();
                for (Map.Entry entry : this.iInstructionalMethods.entrySet()) {
                    if (!((CheckBox)entry.getValue()).isEnabled() || !((CheckBox)entry.getValue()).getValue().booleanValue()) continue;
                    rc.setSelectedIntructionalMethod((CourseRequestInterface.Preference)entry.getKey(), true);
                }
                if (this.iDetails == null) continue;
                for (CourseFinder.CourseFinderCourseDetails d : this.iDetails) {
                    d.onGetValue(rc);
                }
            }
        }
        int row = this.iCourses.getSelectedRow();
        this.iLastDetails = record = this.iCourses.getData(row);
        if (record == null) {
            if (this.iDetails != null) {
                for (CourseFinder.CourseFinderCourseDetails detail : this.iDetails) {
                    detail.setValue(null);
                }
            }
            if (this.isVisible() && this.isAttached()) {
                AriaStatus.getInstance().setHTML(ARIA.courseFinderNoCourse());
            }
            this.iInstructionalMethodsPanel.clear();
            this.iInstructionalMethods.clear();
        } else {
            CourseRequestInterface.RequestedCourse rc = this.iRequest.getRequestedCourse(row - 1);
            for (CourseFinder.CourseFinderCourseDetails detail : this.iDetails) {
                detail.setValue(record);
            }
            if (record.hasTitle()) {
                if (record.hasNote()) {
                    AriaStatus.getInstance().setHTML(ARIA.courseFinderSelectedWithTitleAndNote(this.iCourses.getSelectedRow(), this.iCourses.getRowCount() - 1, record.getSubject(), record.getCourseNbr(), record.getTitle(), record.getNote()));
                } else {
                    AriaStatus.getInstance().setHTML(ARIA.courseFinderSelectedWithTitle(this.iCourses.getSelectedRow(), this.iCourses.getRowCount() - 1, record.getSubject(), record.getCourseNbr(), record.getTitle()));
                }
            } else if (record.hasNote()) {
                AriaStatus.getInstance().setHTML(ARIA.courseFinderSelectedWithNote(this.iCourses.getSelectedRow(), this.iCourses.getRowCount() - 1, record.getSubject(), record.getCourseNbr(), record.getNote()));
            } else {
                AriaStatus.getInstance().setHTML(ARIA.courseFinderSelected(this.iCourses.getSelectedRow(), this.iCourses.getRowCount() - 1, record.getSubject(), record.getCourseNbr()));
            }
            this.iInstructionalMethodsPanel.clear();
            this.iInstructionalMethods.clear();
            if (record.hasInstructionalMethodSelection()) {
                P p = new P("preference-label");
                p.setText(MESSAGES.labelInstructionalMethodPreference());
                this.iInstructionalMethodsPanel.add((Widget)p);
                for (ClassAssignmentInterface.IdValue m : record.getInstructionalMethods()) {
                    CheckBox ch = new CheckBox(m.getValue());
                    ch.setValue(Boolean.valueOf(rc.isSelectedIntructionalMethod(m.getId(), true)));
                    ch.addStyleName("instructional-method");
                    this.iInstructionalMethodsPanel.add((Widget)ch);
                    CourseRequestInterface.Preference p2 = new CourseRequestInterface.Preference(m.getId(), m.getValue(), true);
                    ch.addStyleName("instructional-method");
                    this.iInstructionalMethods.put(p2, ch);
                }
            }
        }
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<CourseRequestInterface.Request> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<CourseRequestInterface.Request> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public CourseRequestInterface.Request getValue() {
        if (this.iLastDetails != null) {
            for (CourseRequestInterface.RequestedCourse rc : this.iRequest.getRequestedCourse()) {
                if (!rc.equals(this.iLastDetails)) continue;
                rc.clearSelection();
                for (Map.Entry<CourseRequestInterface.Preference, CheckBox> e : this.iInstructionalMethods.entrySet()) {
                    if (!e.getValue().isEnabled() || !e.getValue().getValue().booleanValue()) continue;
                    rc.setSelectedIntructionalMethod(e.getKey(), true);
                }
                if (this.iDetails != null) {
                    for (CourseFinder.CourseFinderCourseDetails d : this.iDetails) {
                        d.onGetValue(rc);
                    }
                }
                if (!rc.hasSelectedClasses()) continue;
                for (CourseRequestInterface.Preference p : rc.getSelectedClasses()) {
                    p.setRequired(true);
                }
            }
        }
        this.iRequest.setWaitList(this.iWaitListed.getValue());
        this.iRequest.setWaitListSwapWithCourseOfferingId(this.iEnrolledCoursesList.getSelectedIndex() <= 0 ? null : Long.valueOf(this.iEnrolledCoursesList.getSelectedValue()));
        return this.iRequest;
    }

    public void setSchedule(ClassAssignmentInterface lastEnrollment) {
        this.iEnrolledCoursesList.clear();
        this.iEnrolledCoursesList.addItem(MESSAGES.itemWaitListSwapWithNoCourseOffering(), "");
        for (ClassAssignmentInterface.CourseAssignment course : lastEnrollment.getCourseAssignments()) {
            if (!course.isAssigned() || course.isTeachingAssignment() || course.isFreeTime()) continue;
            this.iEnrolledCoursesList.addItem(course.getCourseNameWithTitle(), course.getCourseId().toString());
        }
    }

    public void setValue(CourseRequestInterface.Request value) {
        this.setValue(value, false);
    }

    public void setValue(CourseRequestInterface.Request value, final boolean fireEvents) {
        this.iRequest = new CourseRequestInterface.Request(value);
        if (this.iRequest.getWaitListedTimeStamp() == null) {
            this.iWaitListed.setText(MESSAGES.checkWaitListSwapWithNewWaitList());
            this.iWaitListed.addStyleName("new-wait-list");
        } else {
            this.iWaitListed.setText(sDF.format(this.iRequest.getWaitListedTimeStamp()));
            this.iWaitListed.removeStyleName("new-wait-list");
        }
        this.iWaitListed.setValue(Boolean.valueOf(this.iRequest.isWaitList()));
        this.iLastDetails = null;
        for (CourseRequestInterface.RequestedCourse rc : this.iRequest.getRequestedCourse()) {
            CourseRequestInterface.Preference p;
            Iterator<CourseRequestInterface.Preference> i;
            if (rc.hasSelectedClasses()) {
                i = rc.getSelectedClasses().iterator();
                while (i.hasNext()) {
                    p = i.next();
                    if (p.isRequired()) continue;
                    i.remove();
                }
            }
            if (!rc.hasSelectedIntructionalMethods()) continue;
            i = rc.getSelectedIntructionalMethods().iterator();
            while (i.hasNext()) {
                p = i.next();
                if (p.isRequired()) continue;
                i.remove();
            }
        }
        for (CourseFinder.CourseFinderCourseDetails detail : this.iDetails) {
            detail.onSetValue(this.iRequest.getRequestedCourse().toArray(new CourseRequestInterface.RequestedCourse[0]));
        }
        this.iEnrolledCoursesList.setSelectedIndex(0);
        if (this.iRequest.hasWaitListSwapWithCourseOfferingId()) {
            for (int i = 1; i < this.iEnrolledCoursesList.getItemCount(); ++i) {
                if (!this.iEnrolledCoursesList.getValue(i).equals(this.iRequest.getWaitListSwapWithCourseOfferingId().toString())) continue;
                this.iEnrolledCoursesList.setSelectedIndex(i);
                break;
            }
        }
        sSectioningService.getCoursesFromRequest(this.iContext, value, new AsyncCallback<Collection<ClassAssignmentInterface.CourseAssignment>>(){

            public void onSuccess(Collection<ClassAssignmentInterface.CourseAssignment> result) {
                WaitListedRequestPreferences.this.iCourses.clearTable(1);
                boolean hasCredit = false;
                boolean hasNote = false;
                boolean hasWaitList = false;
                int selectLineIndex = 1;
                for (ClassAssignmentInterface.CourseAssignment record : result) {
                    ArrayList<Object> line = new ArrayList<Object>();
                    line.add(new Label(record.getSubject(), false));
                    line.add(new Label(record.getCourseNbr(), false));
                    line.add(new HTML(record.getLimit() == null || record.getLimit() == 0 || record.getEnrollment() == null ? "" : (record.getLimit() < 0 ? "&infin;" : record.getLimit() - record.getEnrollment() + " / " + record.getLimit()), false));
                    line.add(new Label(record.getTitle() == null ? "" : record.getTitle(), false));
                    if (record.hasCredit()) {
                        Label credit = new Label(record.getCreditAbbv(), false);
                        if (record.hasCredit()) {
                            credit.setTitle(record.getCreditText());
                        }
                        line.add(credit);
                        hasCredit = true;
                    } else {
                        line.add(new Label());
                    }
                    line.add(new Label(record.getNote() == null ? "" : record.getNote()));
                    if (record.hasNote()) {
                        hasNote = true;
                    }
                    P wl = new P("courses-wl");
                    if (record.isCanWaitList()) {
                        Label l = new Label(MESSAGES.courseAllowsForWaitListing());
                        l.setTitle(MESSAGES.courseAllowsForWaitListingTitle(record.getCourseName()));
                        wl.add((Widget)l);
                        hasWaitList = true;
                    }
                    if (record.hasOverrides()) {
                        for (ClassAssignmentInterface.CodeLabel override : record.getOverrides()) {
                            Label l = new Label(override.getCode());
                            l.setTitle(override.getLabel());
                            wl.add((Widget)l);
                            hasWaitList = true;
                        }
                    }
                    line.add((Object)wl);
                    if (record.hasTitle()) {
                        if (record.hasNote()) {
                            line.add((Object)new AriaHiddenLabel(ARIA.courseFinderCourseWithTitleAndNote(record.getSubject(), record.getCourseNbr(), record.getTitle(), record.getNote())));
                        } else {
                            line.add((Object)new AriaHiddenLabel(ARIA.courseFinderCourseWithTitle(record.getSubject(), record.getCourseNbr(), record.getTitle())));
                        }
                    } else if (record.hasNote()) {
                        line.add((Object)new AriaHiddenLabel(ARIA.courseFinderCourseWithNote(record.getSubject(), record.getCourseNbr(), record.getNote())));
                    } else {
                        line.add((Object)new AriaHiddenLabel(ARIA.courseFinderCourse(record.getSubject(), record.getCourseNbr())));
                    }
                    int lineIdx = WaitListedRequestPreferences.this.iCourses.addRow(record, line);
                    if (WaitListedRequestPreferences.this.iSelectCourseId == null || !WaitListedRequestPreferences.this.iSelectCourseId.equals(record.getCourseId())) continue;
                    selectLineIndex = lineIdx;
                }
                WaitListedRequestPreferences.this.iCourses.setColumnVisible(5, hasCredit);
                WaitListedRequestPreferences.this.iCourses.setColumnVisible(6, hasNote);
                WaitListedRequestPreferences.this.iCourses.setColumnVisible(7, hasWaitList);
                WaitListedRequestPreferences.this.iCourses.setSelected(selectLineIndex, true);
                WaitListedRequestPreferences.this.scrollToSelectedRow();
                if (fireEvents) {
                    ValueChangeEvent.fire((HasValueChangeHandlers)WaitListedRequestPreferences.this, (Object)WaitListedRequestPreferences.this.getValue());
                }
                WaitListedRequestPreferences.this.updateCourseDetails();
                CourseFinder.ResponseEvent.fire((HasHandlers)WaitListedRequestPreferences.this, !result.isEmpty());
            }

            public void onFailure(Throwable caught) {
                WaitListedRequestPreferences.this.iCourses.clearTable(1);
                WaitListedRequestPreferences.this.iCourses.setEmptyMessage(caught.getMessage());
                if (WaitListedRequestPreferences.this.isVisible()) {
                    AriaStatus.getInstance().setText(caught.getMessage());
                }
                WaitListedRequestPreferences.this.updateCourseDetails();
                CourseFinder.ResponseEvent.fire((HasHandlers)WaitListedRequestPreferences.this, false);
            }
        });
        this.iInstructionalMethods.clear();
    }

    public void scrollToSelectedRow() {
        int row = this.iCourses.getSelectedRow();
        if (row >= 0) {
            this.iCourses.getRowFormatter().getElement(row).scrollIntoView();
        }
    }

    public void onKeyUp(KeyUpEvent event) {
        if (event.isControlKeyDown() || event.isAltKeyDown()) {
            for (Map.Entry<Character, Integer> entry : this.iTabAccessKeys.entrySet()) {
                if (event.getNativeKeyCode() != Character.toLowerCase(entry.getKey().charValue()) && event.getNativeKeyCode() != Character.toUpperCase(entry.getKey().charValue())) continue;
                this.iCourseDetailsTabBar.selectTab(entry.getValue(), true);
                event.preventDefault();
                event.stopPropagation();
            }
        }
    }
}

