/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.PreferencesAction2;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.ClassEditForm;
import org.unitime.timetable.interfaces.ExternalClassEditAction;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.comparators.InstructorComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.TeachingResponsibilityDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;

@Action(value="classEdit", results={@Result(name={"editClass"}, type="tiles", location="classEditTile.tiles"), @Result(name={"instructionalOfferingSearch"}, type="redirect", location="/instructionalOfferingSearch.action"), @Result(name={"addDistributionPrefs"}, type="redirect", location="/distributionPrefs.action", params={"classId", "${form.classId}", "op", "${op}"}), @Result(name={"displayClassDetail"}, type="redirect", location="/classDetail.action", params={"cid", "${form.classId}"})})
@TilesDefinition(name="classEditTile.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Class Edit"), @TilesPutAttribute(name="body", value="/user/classEdit.jsp"), @TilesPutAttribute(name="showNavigation", value="true")})
public class ClassEditAction
extends PreferencesAction2<ClassEditForm> {
    private static final long serialVersionUID = 8307712785352190036L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected String classId = null;
    protected String op2 = null;
    protected String deleteType = null;
    protected Long deleteId = null;
    public final String HASH_INSTRUCTORS = "Instructors";

    public String getCid() {
        return this.classId;
    }

    public void setCid(String classId) {
        this.classId = classId;
    }

    public String getOp2() {
        return this.op2;
    }

    public void setOp2(String op2) {
        this.op2 = op2;
    }

    public String getDeleteType() {
        return this.deleteType;
    }

    public void setDeleteType(String deleteType) {
        this.deleteType = deleteType;
    }

    public Long getDeleteId() {
        return this.deleteId;
    }

    public void setDeleteId(Long deleteId) {
        this.deleteId = deleteId;
    }

    @Override
    public String execute() throws Exception {
        if (this.form == null) {
            this.form = new ClassEditForm();
        }
        super.execute();
        if (this.classId == null && this.request.getAttribute("cid") != null) {
            this.classId = (String)this.request.getAttribute("cid");
        }
        if (this.op == null) {
            this.op = ((ClassEditForm)this.form).getOp();
        }
        if (this.op2 != null && !this.op2.isEmpty()) {
            this.op = this.op2;
        }
        if (MSG.actionAddTimePreference().equals(this.op) || MSG.actionAddRoomPreference().equals(this.op) || MSG.actionAddBuildingPreference().equals(this.op) || MSG.actionAddRoomFeaturePreference().equals(this.op) || MSG.actionAddDistributionPreference().equals(this.op) || MSG.actionAddInstructor().equals(this.op) || MSG.actionUpdatePreferences().equals(this.op) || MSG.actionAddDatePatternPreference().equals(this.op) || MSG.actionAddAttributePreference().equals(this.op) || MSG.actionAddInstructorPreference().equals(this.op) || MSG.actionClearClassPreferences().equals(this.op) || MSG.actionRemoveBuildingPreference().equals(this.op) || MSG.actionRemoveDistributionPreference().equals(this.op) || MSG.actionRemoveRoomFeaturePreference().equals(this.op) || MSG.actionRemoveRoomGroupPreference().equals(this.op) || MSG.actionRemoveRoomPreference().equals(this.op) || MSG.actionRemoveDatePatternPreference().equals(this.op) || MSG.actionRemoveTimePattern().equals(this.op) || MSG.actionRemoveInstructor().equals(this.op) || MSG.actionRemoveAttributePreference().equals(this.op) || MSG.actionRemoveInstructorPreference().equals(this.op) || MSG.actionAddRoomGroupPreference().equals(this.op) || MSG.actionBackToDetail().equals(this.op) || MSG.actionNextClass().equals(this.op) || MSG.actionPreviousClass().equals(this.op) || "updateDatePattern".equals(this.op) || "updatePref".equals(this.op)) {
            this.classId = ((ClassEditForm)this.form).getClassId().toString();
        }
        if (this.op == null || this.op.trim().isEmpty()) {
            this.op = "init";
        }
        boolean timeVertical = CommonValues.VerticalGrid.eq(this.sessionContext.getUser().getProperty(UserProperty.GridOrientation));
        Debug.debug("op: " + this.op);
        Debug.debug("class: " + this.classId);
        if (this.classId == null || this.classId.trim().isEmpty()) {
            if (BackTracker.doBack(this.request, this.response)) {
                return null;
            }
            throw new Exception(MSG.errorClassInfoNotSupplied());
        }
        this.sessionContext.checkPermission((Serializable)((Object)this.classId), "Class_", Right.ClassEdit);
        if (MSG.actionBackToDetail().equals(this.op)) {
            return "displayClassDetail";
        }
        Class_DAO cdao = new Class_DAO();
        Class_ c = (Class_)cdao.get(Long.valueOf(this.classId));
        if (MSG.actionAddDistributionPreference().equals(this.op)) {
            this.sessionContext.checkPermission(c, Right.DistributionPreferenceClass);
            return "addDistributionPrefs";
        }
        if (MSG.actionAddInstructor().equals(this.op)) {
            this.addInstructor();
        }
        if (MSG.actionRemoveInstructor().equals(this.op) && "instructor".equals(this.deleteType)) {
            this.deleteInstructor();
        }
        if (MSG.actionClearClassPreferences().equals(this.op)) {
            this.sessionContext.checkPermission(c, Right.ClassEditClearPreferences);
            Set<Preference> s = c.getPreferences();
            this.doClear(s, Preference.Type.TIME, Preference.Type.ROOM, Preference.Type.ROOM_FEATURE, Preference.Type.ROOM_GROUP, Preference.Type.BUILDING, Preference.Type.DATE);
            c.setPreferences(s);
            cdao.update(c);
            this.op = "init";
            ChangeLog.addChange(null, this.sessionContext, c, ChangeLog.Source.CLASS_EDIT, ChangeLog.Operation.CLEAR_PREF, c.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), c.getManagingDept());
            return "displayClassDetail";
        }
        if ("init".equals(this.op)) {
            ((ClassEditForm)this.form).reset();
        }
        this.doLoad(c, this.op);
        if (MSG.actionUpdatePreferences().equals(this.op) || MSG.actionNextClass().equals(this.op) || MSG.actionPreviousClass().equals(this.op)) {
            ((ClassEditForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                Session hibSession = cdao.getSession();
                Transaction tx = hibSession.beginTransaction();
                try {
                    Set<Preference> s = c.getPreferences();
                    this.doClear(s, Preference.Type.TIME, Preference.Type.ROOM, Preference.Type.ROOM_FEATURE, Preference.Type.ROOM_GROUP, Preference.Type.BUILDING, Preference.Type.DATE);
                    this.doUpdate(c, hibSession);
                    super.doUpdate(c, s, timeVertical, Preference.Type.TIME, Preference.Type.ROOM, Preference.Type.ROOM_FEATURE, Preference.Type.ROOM_GROUP, Preference.Type.BUILDING, Preference.Type.DATE);
                    hibSession.saveOrUpdate((Object)c);
                    tx.commit();
                    String className = ApplicationProperty.ExternalActionClassEdit.value();
                    if (className != null && className.trim().length() > 0) {
                        ExternalClassEditAction editAction = (ExternalClassEditAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        editAction.performExternalClassEditAction(c, hibSession);
                    }
                    if (MSG.actionNextClass().equals(this.op)) {
                        this.response.sendRedirect(this.response.encodeURL("classEdit.action?cid=" + ((ClassEditForm)this.form).getNextId()));
                        return null;
                    }
                    if (MSG.actionPreviousClass().equals(this.op)) {
                        this.response.sendRedirect(this.response.encodeURL("classEdit.action?cid=" + ((ClassEditForm)this.form).getPreviousId()));
                        return null;
                    }
                    return "displayClassDetail";
                }
                catch (Exception e) {
                    tx.rollback();
                    throw e;
                }
            }
        }
        Vector leadInstructors = new Vector();
        if ("updatePref".equals(this.op)) {
            try {
                List<String> instrLead = ((ClassEditForm)this.form).getInstrLead();
                List<String> instructors = ((ClassEditForm)this.form).getInstructors();
                for (int i = 0; i < instructors.size(); ++i) {
                    boolean lead;
                    String instrId = instructors.get(i).toString();
                    if ("-".equals(instrId)) continue;
                    boolean bl = lead = "on".equals(instrLead.get(i)) || "true".equals(instrLead.get(i));
                    if (!lead) continue;
                    leadInstructors.add(new DepartmentalInstructorDAO().get(Long.valueOf(instrId)));
                }
                this.op = "init";
            }
            catch (NumberFormatException instrLead) {
                // empty catch block
            }
        }
        if ("updateDatePattern".equals(this.op)) {
            DatePattern selectedDatePattern;
            this.initPrefs(c, leadInstructors, true);
            ((ClassEditForm)this.form).getDatePatternPrefs().clear();
            ((ClassEditForm)this.form).getDatePatternPrefLevels().clear();
            DatePattern datePattern = selectedDatePattern = ((ClassEditForm)this.form).getDatePattern() < 0L ? c.getSchedulingSubpart().effectiveDatePattern() : (DatePattern)DatePatternDAO.getInstance().get(((ClassEditForm)this.form).getDatePattern());
            if (selectedDatePattern != null) {
                for (DatePattern dp : selectedDatePattern.findChildren()) {
                    boolean found = false;
                    for (DatePatternPref dpp : c.getPreferences(DatePatternPref.class)) {
                        if (!dp.equals(dpp.getDatePattern())) continue;
                        ((ClassEditForm)this.form).addToDatePatternPrefs(dp.getUniqueId().toString(), dpp.getPrefLevel().getUniqueId().toString());
                        found = true;
                    }
                    if (!found) {
                        for (DatePatternPref dpp : c.getSchedulingSubpart().getPreferences(DatePatternPref.class)) {
                            if (!dp.equals(dpp.getDatePattern())) continue;
                            ((ClassEditForm)this.form).addToDatePatternPrefs(dp.getUniqueId().toString(), dpp.getPrefLevel().getUniqueId().toString());
                            found = true;
                        }
                    }
                    if (found) continue;
                    ((ClassEditForm)this.form).addToDatePatternPrefs(dp.getUniqueId().toString(), PreferenceLevel.PREF_LEVEL_NEUTRAL);
                }
            }
        }
        ((ClassEditForm)this.form).setAvailableTimePatterns(TimePattern.findApplicable(this.sessionContext.getUser(), c.getSchedulingSubpart().getMinutesPerWk(), ((ClassEditForm)this.form).getDatePattern() < 0L ? c.getSchedulingSubpart().effectiveDatePattern() : (DatePattern)DatePatternDAO.getInstance().get(((ClassEditForm)this.form).getDatePattern()), c.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel(), true, c.getManagingDept()));
        Set timePatterns = null;
        if ("init".equals(this.op)) {
            this.initPrefs(c, leadInstructors, true);
            timePatterns = c.effectiveTimePatterns();
            DatePattern selectedDatePattern = c.effectiveDatePattern();
            if (selectedDatePattern != null) {
                for (DatePattern dp : selectedDatePattern.findChildren()) {
                    if (((ClassEditForm)this.form).getDatePatternPrefs().contains(dp.getUniqueId().toString())) continue;
                    ((ClassEditForm)this.form).addToDatePatternPrefs(dp.getUniqueId().toString(), PreferenceLevel.PREF_LEVEL_NEUTRAL);
                }
            }
        }
        this.processPrefAction();
        super.generateTimePatternGrids(c, c.getSchedulingSubpart().getMinutesPerWk(), c.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel(), ((ClassEditForm)this.form).getDatePattern() < 0L ? c.getSchedulingSubpart().effectiveDatePattern() : (DatePattern)DatePatternDAO.getInstance().get(((ClassEditForm)this.form).getDatePattern()), timePatterns, this.op, timeVertical, true, leadInstructors);
        this.setupInstructors(c);
        this.setupChildren(c);
        LookupTables.setupDatePatterns(this.request, this.sessionContext.getUser(), MSG.dropDefaultDatePattern(), c.getSchedulingSubpart().effectiveDatePattern(), c.getManagingDept(), c.effectiveDatePattern());
        LookupTables.setupRooms(this.request, c);
        LookupTables.setupBldgs(this.request, c);
        LookupTables.setupRoomFeatures(this.request, c);
        LookupTables.setupRoomGroups(this.request, c);
        ((ClassEditForm)this.form).setAllowHardPrefs(this.sessionContext.hasPermission(c, Right.CanUseHardRoomPrefs));
        BackTracker.markForBack(this.request, "classDetail.action?cid=" + ((ClassEditForm)this.form).getClassId(), MSG.backClass(((ClassEditForm)this.form).getClassName()), true, false);
        return "editClass";
    }

    private void doLoad(Class_ c, String op) {
        Department managingDept = c.getManagingDept();
        String parentClassName = "-";
        Long parentClassId = null;
        if (c.getParentClass() != null) {
            parentClassName = c.getParentClass().toString();
            parentClassId = c.getParentClass().getUniqueId();
        }
        CourseOffering cco = c.getSchedulingSubpart().getControllingCourseOffering();
        ((ClassEditForm)this.form).setClassId(c.getUniqueId());
        ((ClassEditForm)this.form).setSection(c.getSectionNumberString());
        ((ClassEditForm)this.form).setClassName(c.getClassLabel());
        SchedulingSubpart ss = c.getSchedulingSubpart();
        String itypeDesc = c.getItypeDesc();
        if (ss.getInstrOfferingConfig().getInstructionalOffering().hasMultipleConfigurations()) {
            itypeDesc = itypeDesc + " [" + ss.getInstrOfferingConfig().getName() + "]";
        }
        ((ClassEditForm)this.form).setItypeDesc(itypeDesc);
        ((ClassEditForm)this.form).setParentClassName(parentClassName);
        ((ClassEditForm)this.form).setParentClassId(parentClassId);
        ((ClassEditForm)this.form).setSubjectAreaId(cco.getSubjectArea().getUniqueId().toString());
        ((ClassEditForm)this.form).setInstrOfferingId(cco.getInstructionalOffering().getUniqueId().toString());
        ((ClassEditForm)this.form).setSubpart(c.getSchedulingSubpart().getUniqueId());
        ((ClassEditForm)this.form).setCourseName(cco.getInstructionalOffering().getCourseName());
        ((ClassEditForm)this.form).setCourseTitle(cco.getTitle());
        ((ClassEditForm)this.form).setManagingDept(managingDept.getUniqueId());
        ((ClassEditForm)this.form).setControllingDept(c.getControllingDept().getUniqueId());
        ((ClassEditForm)this.form).setManagingDeptLabel(managingDept.getManagingDeptLabel());
        ((ClassEditForm)this.form).setUnlimitedEnroll(c.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment());
        ((ClassEditForm)this.form).setAccommodation(StudentAccomodation.toHtml(StudentAccomodation.getAccommodations(c)));
        Class_ next = c.getNextClass(this.sessionContext, Right.ClassEdit);
        ((ClassEditForm)this.form).setNextId(next == null ? null : next.getUniqueId().toString());
        Class_ previous = c.getPreviousClass(this.sessionContext, Right.ClassEdit);
        ((ClassEditForm)this.form).setPreviousId(previous == null ? null : previous.getUniqueId().toString());
        ((ClassEditForm)this.form).setMinRoomLimit(c.getMinRoomLimit());
        ((ClassEditForm)this.form).setEnrollment(c.getEnrollment());
        ((ClassEditForm)this.form).setSnapshotLimit(c.getSnapshotLimit());
        if ("init".equals(op)) {
            ((ClassEditForm)this.form).setExpectedCapacity(c.getExpectedCapacity());
            ((ClassEditForm)this.form).setDatePattern(c.getDatePattern() == null ? Long.valueOf(-1L) : c.getDatePattern().getUniqueId());
            ((ClassEditForm)this.form).setDatePatternEditable(ApplicationProperty.WaitListCanChangeDatePattern.isTrue() || c.getEnrollment() == 0 || !c.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().effectiveReScheduleNow());
            ((ClassEditForm)this.form).setNbrRooms(c.getNbrRooms());
            ((ClassEditForm)this.form).setNotes(c.getNotes());
            ((ClassEditForm)this.form).setManagingDept(c.getManagingDept().getUniqueId());
            ((ClassEditForm)this.form).setSchedulePrintNote(c.getSchedulePrintNote());
            ((ClassEditForm)this.form).setClassSuffix(c.getDivSecNumber());
            ((ClassEditForm)this.form).setMaxExpectedCapacity(c.getMaxExpectedCapacity());
            ((ClassEditForm)this.form).setRoomRatio(c.getRoomRatio());
            ((ClassEditForm)this.form).setLms(c.getLms() == null ? "" : c.getLms().getLabel());
            if (ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue()) {
                ((ClassEditForm)this.form).setFundingDept(c.getEffectiveFundingDept().getLabel());
            } else {
                ((ClassEditForm)this.form).setFundingDept("");
            }
            ((ClassEditForm)this.form).setEnabledForStudentScheduling(c.isEnabledForStudentScheduling());
            ((ClassEditForm)this.form).setDisplayInstructor(c.isDisplayInstructor());
            ArrayList<ClassInstructor> instructors = new ArrayList<ClassInstructor>(c.getClassInstructors());
            Collections.sort(instructors, new InstructorComparator(this.sessionContext));
            for (ClassInstructor classInstr : instructors) {
                ((ClassEditForm)this.form).addToInstructors(classInstr);
            }
            if (instructors.isEmpty()) {
                ((ClassEditForm)this.form).addToInstructors(null);
            }
        }
    }

    private void doUpdate(Class_ c, Session hibSession) {
        c.setExpectedCapacity(((ClassEditForm)this.form).getExpectedCapacity());
        if (((ClassEditForm)this.form).getDatePattern() == null || ((ClassEditForm)this.form).getDatePattern().intValue() < 0) {
            c.setDatePattern(null);
        } else {
            c.setDatePattern((DatePattern)new DatePatternDAO().get(((ClassEditForm)this.form).getDatePattern()));
        }
        c.setNbrRooms(((ClassEditForm)this.form).getNbrRooms());
        c.setNotes(((ClassEditForm)this.form).getNotes());
        c.setSchedulePrintNote(((ClassEditForm)this.form).getSchedulePrintNote());
        c.setMaxExpectedCapacity(((ClassEditForm)this.form).getMaxExpectedCapacity());
        c.setRoomRatio(((ClassEditForm)this.form).getRoomRatio());
        Boolean disb = ((ClassEditForm)this.form).getEnabledForStudentScheduling();
        c.setEnabledForStudentScheduling(disb == null ? Boolean.valueOf(false) : disb);
        Boolean di = ((ClassEditForm)this.form).getDisplayInstructor();
        c.setDisplayInstructor(di == null ? Boolean.valueOf(false) : di);
        boolean assignTeachingRequest = Department.isInstructorSchedulingCommitted(c.getControllingDept().getUniqueId());
        HashSet<ClassInstructor> classInstrs = new HashSet<ClassInstructor>(c.getClassInstructors());
        List<String> instrLead = ((ClassEditForm)this.form).getInstrLead();
        List<String> instructors = ((ClassEditForm)this.form).getInstructors();
        List<String> instrPctShare = ((ClassEditForm)this.form).getInstrPctShare();
        List<String> instrResponsibility = ((ClassEditForm)this.form).getInstrResponsibility();
        for (int i = 0; i < instructors.size(); ++i) {
            String instrId = instructors.get(i).toString();
            if ("-".equals(instrId)) continue;
            String pctShare = instrPctShare.get(i).toString();
            boolean lead = "on".equals(instrLead.get(i)) || "true".equals(instrLead.get(i));
            String resp = instrResponsibility.get(i).toString();
            DepartmentalInstructor deptInstr = (DepartmentalInstructor)new DepartmentalInstructorDAO().get(Long.valueOf(instrId));
            ClassInstructor classInstr = null;
            Iterator<Object> j = classInstrs.iterator();
            while (j.hasNext()) {
                ClassInstructor adept = (ClassInstructor)j.next();
                if (!adept.getInstructor().equals(deptInstr)) continue;
                classInstr = adept;
                j.remove();
                break;
            }
            if (classInstr == null) {
                classInstr = new ClassInstructor();
                classInstr.setClassInstructing(c);
                classInstr.setInstructor(deptInstr);
                deptInstr.getClasses().add(classInstr);
                c.getClassInstructors().add(classInstr);
                if (assignTeachingRequest) {
                    for (TeachingClassRequest tcr : c.getTeachingRequests()) {
                        if (!tcr.getAssignInstructor().booleanValue() || !tcr.getTeachingRequest().getAssignedInstructors().contains(deptInstr)) continue;
                        classInstr.setTeachingRequest(tcr.getTeachingRequest());
                        break;
                    }
                }
            }
            classInstr.setLead(lead);
            try {
                classInstr.setPercentShare(Integer.valueOf(pctShare));
            }
            catch (NumberFormatException e) {
                classInstr.setPercentShare(0);
            }
            try {
                classInstr.setResponsibility((TeachingResponsibility)TeachingResponsibilityDAO.getInstance().get(Long.valueOf(resp), hibSession));
            }
            catch (NumberFormatException e) {
                classInstr.setResponsibility(null);
            }
            hibSession.saveOrUpdate((Object)deptInstr);
        }
        for (ClassInstructor ci : classInstrs) {
            DepartmentalInstructor instr = ci.getInstructor();
            instr.getClasses().remove(ci);
            c.getClassInstructors().remove(ci);
            hibSession.saveOrUpdate((Object)instr);
            hibSession.delete((Object)ci);
        }
        ChangeLog.addChange(hibSession, this.sessionContext, c, ChangeLog.Source.CLASS_EDIT, ChangeLog.Operation.UPDATE, c.getSchedulingSubpart().getInstrOfferingConfig().getControllingCourseOffering().getSubjectArea(), c.getManagingDept());
    }

    protected void setupInstructors(Class_ c) throws Exception {
        List<String> instructors = ((ClassEditForm)this.form).getInstructors();
        if (instructors.size() == 0) {
            return;
        }
        LookupTables.setupInstructors(this.request, this.sessionContext, c.getDepartmentForSubjectArea().getUniqueId());
        LookupTables.setupInstructorTeachingResponsibilities(this.request);
    }

    protected void addInstructor() {
        if (this.request.getParameter("instrListTypeAction") != null && this.request.getParameter("instrListTypeAction").toString().length() > 0) {
            return;
        }
        ((ClassEditForm)this.form).addToInstructors(null);
        this.request.setAttribute("hash", (Object)"Instructors");
    }

    protected void deleteInstructor() {
        if (this.deleteId != null) {
            ((ClassEditForm)this.form).removeInstructor(this.deleteId.intValue());
            this.request.setAttribute("hash", (Object)"Instructors");
        }
    }

    protected void setupChildren(Class_ c) {
        DatePattern selectedDatePattern;
        DatePattern datePattern = selectedDatePattern = ((ClassEditForm)this.form).getDatePattern() < 0L ? c.getSchedulingSubpart().effectiveDatePattern() : (DatePattern)DatePatternDAO.getInstance().get(((ClassEditForm)this.form).getDatePattern());
        if (selectedDatePattern != null) {
            List<DatePattern> v = selectedDatePattern.findChildren();
            this.request.setAttribute(DatePattern.DATE_PATTERN_CHILDREN_LIST_ATTR, v);
            ((ClassEditForm)this.form).sortDatePatternPrefs(((ClassEditForm)this.form).getDatePatternPrefs(), ((ClassEditForm)this.form).getDatePatternPrefLevels(), v);
        }
    }
}

