/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.servlet.jsp.JspWriter;
import org.springframework.web.util.HtmlUtils;
import org.unitime.commons.web.htmlgen.TableCell;
import org.unitime.commons.web.htmlgen.TableStream;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.ClassListForm;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.LearningManagementSystemInfo;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseSubjectArea;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.ClassCourseComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.CachedClassAssignmentProxy;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamAssignmentProxy;
import org.unitime.timetable.webutil.Navigation;
import org.unitime.timetable.webutil.WebInstructionalOfferingTableBuilder;

public class WebClassListTableBuilder
extends WebInstructionalOfferingTableBuilder {
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);

    @Override
    protected String getSchedulePrintNoteLabel() {
        return MSG.columnStudentScheduleNote();
    }

    protected String additionalNote() {
        return new String();
    }

    protected String labelForTable(SubjectArea subjectArea) {
        StringBuffer sb = new StringBuffer();
        sb.append("<p style=\"page-break-before: always\" class=\"WelcomeRowHead\"><b><font size=\"+1\">");
        sb.append(subjectArea.getSubjectAreaAbbreviation());
        sb.append(" - ");
        sb.append(subjectArea.getSession().getLabel());
        sb.append(this.additionalNote());
        sb.append("</font></b></p>");
        return sb.toString();
    }

    public void htmlTableForClasses(SessionContext context, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, ClassListForm form, JspWriter outputStream, String backType, String backId) {
        this.setVisibleColumns(form);
        this.setBackType(backType);
        this.setBackId(backId);
        TreeSet classes = (TreeSet)form.getClasses();
        Navigation.set(context, Navigation.sClassLevel, classes);
        if (this.isShowTimetable()) {
            boolean hasTimetable = false;
            if (context.hasPermission(Right.ClassAssignments) && classAssignment != null) {
                try {
                    if (classAssignment instanceof CachedClassAssignmentProxy) {
                        ((CachedClassAssignmentProxy)classAssignment).setCache(classes);
                    }
                    for (Object[] o : classes) {
                        Class_ clazz = (Class_)o[0];
                        if (classAssignment.getAssignment(clazz) == null) continue;
                        hasTimetable = true;
                        break;
                    }
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
            this.setDisplayTimetable(hasTimetable);
        }
        this.setUserSettings(context.getUser());
        if (this.isShowExam()) {
            this.setShowExamTimetable(examAssignment != null || Exam.hasTimetable(context.getUser().getCurrentAcademicSessionId()));
        }
        TableStream table = null;
        int ct = 0;
        Iterator it = classes.iterator();
        BaseSubjectArea subjectArea = null;
        String prevLabel = null;
        while (it.hasNext()) {
            Object[] o = (Object[])it.next();
            Class_ c = (Class_)o[0];
            CourseOffering co = (CourseOffering)o[1];
            if (subjectArea == null || !subjectArea.getUniqueId().equals(co.getSubjectArea().getUniqueId())) {
                if (table != null) {
                    table.tableComplete();
                    try {
                        outputStream.print("<br>");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                subjectArea = co.getSubjectArea();
                ct = 0;
                try {
                    outputStream.print(this.labelForTable((SubjectArea)subjectArea));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                table = this.initTable((Writer)outputStream, context.getUser().getCurrentAcademicSessionId());
            }
            this.buildClassRow(classAssignment, examAssignment, ++ct, table, co, c, 0, context, prevLabel);
            prevLabel = c.getClassLabel(co);
        }
        table.tableComplete();
    }

    @Override
    protected TableCell buildPrefGroupLabel(CourseOffering co, PreferenceGroup prefGroup, int indentSpaces, boolean isEditable, String prevLabel, String icon) {
        if (prefGroup instanceof Class_) {
            InstructionalMethod im;
            TableCell cell = this.initNormalCell("", isEditable);
            if (indentSpaces > 0) {
                int pad = indentSpaces * indent;
                if (icon != null) {
                    pad -= indent;
                }
                cell.setStyle("padding-left: " + pad + "px;");
            }
            if (icon != null) {
                cell.addContent(icon);
            }
            Class_ aClass = (Class_)prefGroup;
            if (!isEditable) {
                cell.addContent("<font color='" + this.disabledColor + "'>");
            }
            if ("PreferenceGroup".equals(this.getBackType()) && prefGroup.getUniqueId().toString().equals(this.getBackId())) {
                cell.addContent("<A name=\"back\"></A>");
            }
            if (co.isIsControl().booleanValue()) {
                cell.addContent("<b>");
            }
            cell.addContent("<A name=\"A" + prefGroup.getUniqueId().toString() + "\"></A>");
            String label = aClass.getClassLabel(co);
            String title = aClass.getClassLabelWithTitle(co);
            if (prevLabel != null && label.equals(prevLabel)) {
                label = " &nbsp;";
            }
            if (!aClass.isEnabledForStudentScheduling().booleanValue()) {
                title = title + " - Do Not Display In Schedule Book.";
                label = "<i>" + label + "</i>";
            }
            cell.addContent(label);
            cell.setTitle(title);
            if (co.isIsControl().booleanValue()) {
                cell.addContent("</b>");
            }
            cell.setNoWrap(true);
            if (!isEditable) {
                cell.addContent("</font>");
            }
            if ((im = aClass.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod()) != null) {
                cell.addContent(" (<span title='" + im.getLabel() + "'>" + im.getReference() + ")");
            }
            return cell;
        }
        return super.buildPrefGroupLabel(co, prefGroup, indentSpaces, isEditable, prevLabel, icon);
    }

    public void htmlTableForClasses(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, CourseOffering co, TreeSet classes, Long subjectAreaId, SessionContext context, Writer outputStream) {
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add(LABEL);
        if (StudentClassEnrollment.sessionHasEnrollments(context.getUser().getCurrentAcademicSessionId())) {
            columnList.add(MSG.columnDemand());
        }
        columnList.add(MSG.columnLimit());
        if (co.getInstructionalOffering().getSession().getCurrentSnapshotDate() != null) {
            columnList.add(MSG.columnSnapshotLimit());
        }
        columnList.add(MSG.columnRoomRatio());
        columnList.add(MSG.columnDatePattern());
        columnList.add(MSG.columnTimePattern());
        columnList.add(MSG.columnPreferences());
        columnList.add(MSG.columnInstructor());
        columnList.add(MSG.columnTimetable());
        columnList.add(MSG.columnSchedulePrintNote());
        if (LearningManagementSystemInfo.isLmsInfoDefinedForSession(co.getInstructionalOffering().getSessionId())) {
            columnList.add(MSG.columnLms());
        }
        this.setVisibleColumns(columnList);
        if (this.isShowTimetable()) {
            boolean hasTimetable = false;
            if (context.hasPermission(Right.ClassAssignments) && classAssignment != null) {
                try {
                    if (classAssignment instanceof CachedClassAssignmentProxy) {
                        ((CachedClassAssignmentProxy)classAssignment).setCache(classes);
                    }
                    for (Class_ clazz : classes) {
                        if (classAssignment.getAssignment(clazz) == null) continue;
                        hasTimetable = true;
                        break;
                    }
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
            this.setDisplayTimetable(hasTimetable);
            this.setShowDivSec(hasTimetable);
        }
        this.setUserSettings(context.getUser());
        TableStream table = this.initTable(outputStream, context.getUser().getCurrentAcademicSessionId());
        Iterator it = classes.iterator();
        Class_ cls = null;
        String prevLabel = null;
        int ct = 0;
        while (it.hasNext()) {
            cls = (Class_)it.next();
            this.buildClassRow(classAssignment, examAssignment, ++ct, table, co, cls, 0, context, prevLabel);
            prevLabel = cls.getClassLabel(co);
        }
        table.tableComplete();
    }

    public void htmlTableForSubpartClasses(SessionContext context, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, Long schedulingSubpartId, Writer outputStream, String backType, String backId) {
        this.setBackType(backType);
        this.setBackId(backId);
        if (schedulingSubpartId != null) {
            SchedulingSubpartDAO ssDao = new SchedulingSubpartDAO();
            SchedulingSubpart ss = (SchedulingSubpart)ssDao.get(schedulingSubpartId);
            TreeSet<Class_> ts = new TreeSet<Class_>(new ClassComparator(5));
            if (CommonValues.Yes.eq(context.getUser().getProperty(UserProperty.ClassesKeepSort))) {
                ts = new TreeSet(new ClassCourseComparator(context.getUser().getProperty("ClassList.sortBy", ClassCourseComparator.getName(ClassCourseComparator.SortBy.NAME)), classAssignment, "1".equals(context.getUser().getProperty("ClassList.sortByKeepSubparts", "0"))));
            }
            ts.addAll(ss.getClasses());
            Navigation.set(context, Navigation.sClassLevel, ts);
            this.htmlTableForClasses(classAssignment, examAssignment, ss.getControllingCourseOffering(), ts, ss.getControllingCourseOffering().getSubjectArea().getUniqueId(), context, outputStream);
        }
    }

    @Override
    protected TreeSet getExams(Class_ clazz) {
        TreeSet ret = new TreeSet(Exam.findAll(3, clazz.getUniqueId()));
        SchedulingSubpart subpart = clazz.getSchedulingSubpart();
        if (subpart.getParentSubpart() != null) {
            return ret;
        }
        InstrOfferingConfig config = subpart.getInstrOfferingConfig();
        SchedulingSubpartComparator cmp = new SchedulingSubpartComparator();
        for (SchedulingSubpart s : config.getSchedulingSubparts()) {
            if (cmp.compare(s, subpart) >= 0) continue;
            return ret;
        }
        InstructionalOffering offering = config.getInstructionalOffering();
        ret.addAll(Exam.findAll(2, config.getUniqueId()));
        ret.addAll(Exam.findAll(0, offering.getUniqueId()));
        for (CourseOffering co : offering.getCourseOfferings()) {
            ret.addAll(Exam.findAll(1, co.getUniqueId()));
        }
        return ret;
    }

    @Override
    protected TableCell buildNote(PreferenceGroup prefGroup, boolean isEditable, UserContext user) {
        TableCell cell = null;
        if (prefGroup instanceof Class_) {
            String note;
            Class_ c = (Class_)prefGroup;
            String offeringNote = c.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getNotes();
            String classNote = c.getNotes();
            String string = offeringNote == null || offeringNote.isEmpty() ? classNote : (note = offeringNote + (classNote == null || classNote.isEmpty() ? "" : "\n" + classNote));
            if (note != null && !note.isEmpty()) {
                if (CommonValues.NoteAsShortText.eq(user.getProperty(UserProperty.ManagerNoteDisplay))) {
                    if (classNote != null && !classNote.isEmpty()) {
                        note = classNote;
                    }
                    if (note.length() > 20) {
                        note = note.substring(0, 20) + "...";
                    }
                    cell = this.initNormalCell(note.replaceAll("\n", "<br>"), isEditable);
                    cell.setAlign("left");
                } else if (CommonValues.NoteAsFullText.eq(user.getProperty(UserProperty.ManagerNoteDisplay))) {
                    cell = this.initNormalCell(note.replaceAll("\n", "<br>"), isEditable);
                    cell.setAlign("left");
                } else {
                    cell = this.initNormalCell("<IMG border='0' alt='" + MSG.altHasNoteToMgr() + "' title='" + HtmlUtils.htmlEscape((String)note) + "' align='absmiddle' src='images/note.png'>", isEditable);
                    cell.setAlign("center");
                }
            } else {
                cell = this.initNormalCell("&nbsp;", isEditable);
            }
        } else {
            cell = this.initNormalCell("&nbsp;", isEditable);
        }
        return cell;
    }
}

