/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.util.ArrayList;
import org.unitime.timetable.util.RoomSummaryReportsHelper;

public class RoomUtilizationHelper
extends RoomSummaryReportsHelper {
    public RoomUtilizationHelper(int iMinutesInPeriod, int iPeriodsInHour, int iAllDayStartPeriod, int iAllDayEndPeriod, int iStandardDayStartPeriod, int iStandardDayEndPeriod, int iWeekendDayStartPeriod, int iWeekendDayEndPeriod, int iFirstFullHourStartPeriod, int iLastFullHourStopPeriod, String iSchema) {
        super(iMinutesInPeriod, iPeriodsInHour, iAllDayStartPeriod, iAllDayEndPeriod, iStandardDayStartPeriod, iStandardDayEndPeriod, iWeekendDayStartPeriod, iWeekendDayEndPeriod, iFirstFullHourStartPeriod, iLastFullHourStopPeriod, iSchema);
    }

    public RoomUtilizationHelper() {
    }

    @Override
    protected String getSummaryCalculationForPeriod(String first5MinutePeriod, String last5MinutePeriod, String additionalQueryField) {
        StringBuffer utilCal = new StringBuffer();
        if (additionalQueryField != null) {
            utilCal.append("(");
        }
        utilCal.append("((((case when z.stop_period > ");
        utilCal.append(last5MinutePeriod);
        utilCal.append(" then ");
        utilCal.append(last5MinutePeriod);
        utilCal.append(" else z.stop_period end) - (case when z.start_period < ");
        utilCal.append(first5MinutePeriod);
        utilCal.append(" then ");
        utilCal.append(first5MinutePeriod);
        utilCal.append(" else z.start_period end)) * ");
        utilCal.append(this.getMinutesInPeriod());
        utilCal.append(")  * 1/z.weeks_divisor_for_day_of_week/60.0)");
        if (additionalQueryField != null) {
            utilCal.append(" * ");
            utilCal.append(additionalQueryField);
            utilCal.append(")");
        }
        return utilCal.toString();
    }

    @Override
    protected String getBaseQueryAdditionalSelectColumns() {
        return "";
    }

    @Override
    public String getPivotedQuery(ArrayList<Integer> allDays, ArrayList<Integer> weekDays, Integer saturday, String campus, String year, String term, ArrayList<Object> headerRow, boolean includeDayOfWkTimeOfDayInHeaderRow, boolean includeSubjectArea, boolean includeDept) {
        StringBuffer sb = new StringBuffer();
        sb.append("select ");
        this.appendSelectedField(sb, "zz", MESSAGES.utilSqlAcademicInitiative(), false, true);
        this.newline(sb, 4);
        this.appendSelectedField(sb, "zz", MESSAGES.utilSqlAcademicTerm(), false, true);
        this.newline(sb, 4);
        this.appendSelectedField(sb, "zz", MESSAGES.utilSqlAcademicYear(), false, true);
        this.newline(sb, 4);
        this.appendSelectedField(sb, "zz", MESSAGES.utilSqlRoomType(), false, true);
        this.newline(sb, 4);
        this.appendSelectedField(sb, "zz", MESSAGES.utilSqlBuilding(), false, true);
        this.newline(sb, 4);
        this.appendSelectedField(sb, "zz", MESSAGES.utilSqlRoom(), false, true);
        this.newline(sb, 4);
        this.appendSelectedField(sb, "zz", MESSAGES.utilSqlRoomSize(), false, true);
        if (this.isShowAdditionalPurdueData().booleanValue()) {
            this.newline(sb, 4);
            this.appendSelectedField(sb, "zz", MESSAGES.utilSqlCampusRegion(), false, true);
            this.newline(sb, 4);
            this.appendSelectedField(sb, "zz", MESSAGES.utilSqlLlrLalrPool(), false, true);
            this.newline(sb, 4);
            this.appendSelectedField(sb, "zz", MESSAGES.utilSqlClassroomSubtype(), false, true);
        }
        this.newline(sb, 4);
        this.appendSelectedField(sb, "zz", MESSAGES.utilSqlRangeOfSizes(), false, true);
        if (includeDept) {
            this.newline(sb, 4);
            this.appendSelectedField(sb, "zz", MESSAGES.utilSqlDepartment(), false, true);
        }
        if (includeSubjectArea) {
            this.newline(sb, 4);
            this.appendSelectedField(sb, "zz", MESSAGES.utilSqlSubject(), false, true);
        }
        this.newline(sb, 4);
        this.appendSelectedField(sb, "zz", MESSAGES.utilSqlEventType(), false, true);
        this.newline(sb, 4);
        this.appendSelectedField(sb, "zz", MESSAGES.utilSqlEventTypeDescription(), false, true);
        this.newline(sb, 4);
        this.appendSelectedField(sb, "zz", MESSAGES.utilSqlUtilizationType(), false, false);
        this.newline(sb, 4);
        for (RoomSummaryReportsHelper.LabelFieldPair labelFieldPair : this.getLabelPrefixToAdditionalQueryFieldMapping()) {
            this.buildWeekdayStandardHoursSummarySum(sb, true, labelFieldPair.getLabel());
            this.buildStandardHoursSummarySum(sb, true, labelFieldPair.getLabel());
            this.buildAllHoursSummarySum(sb, true, labelFieldPair.getLabel());
        }
        for (RoomSummaryReportsHelper.LabelFieldPair labelFieldPair : this.getLabelPrefixToAdditionalQueryFieldMapping()) {
            this.buildAllHoursLabelsCommaSeparated(sb, true, labelFieldPair.getLabel());
        }
        this.newline(sb, 0);
        sb.append("from ( ");
        this.newline(sb, 4);
        sb.append(this.getPivotedBaseSummaryQuery(allDays, weekDays, saturday, campus, year, term, headerRow, includeDayOfWkTimeOfDayInHeaderRow, includeSubjectArea, includeDept));
        this.newline(sb, 4);
        sb.append(" ) zz ");
        return sb.toString();
    }

    @Override
    protected ArrayList<RoomSummaryReportsHelper.LabelFieldPair> getLabelPrefixToAdditionalQueryFieldMapping() {
        ArrayList<RoomSummaryReportsHelper.LabelFieldPair> mapping = new ArrayList<RoomSummaryReportsHelper.LabelFieldPair>();
        mapping.add(new RoomSummaryReportsHelper.LabelFieldPair(MESSAGES.utilSqlUsage(), null));
        mapping.add(new RoomSummaryReportsHelper.LabelFieldPair(MESSAGES.utilSqlUsageSeatHours(), "z." + MESSAGES.utilSqlRoomSize()));
        return mapping;
    }

    protected void buildAllHoursSummaryBaseSum(StringBuffer sb, String labelPrefix) {
        sb.append("(");
        boolean first = true;
        for (Integer day : this.getAllDays()) {
            String label = this.getDayTimeLabel(day, this.getAllDayStartPeriod(), labelPrefix);
            if (first) {
                first = false;
            } else {
                sb.append(" +");
            }
            this.newline(sb, 12);
            sb.append(label);
            int startPeriod = this.getFirstFullHourStartPeriod();
            while (startPeriod < this.getLastFullHourStopPeriod()) {
                int stopPeriod = startPeriod + this.getPeriodsInHour();
                label = this.getDayTimeLabel(day, startPeriod, labelPrefix);
                sb.append(" +");
                this.newline(sb, 12);
                sb.append(label);
                startPeriod = stopPeriod;
            }
            label = this.getDayTimeLabel(day, this.getLastFullHourStopPeriod(), labelPrefix);
            sb.append(" +");
            this.newline(sb, 12);
            sb.append(label);
        }
        this.newline(sb, 8);
        sb.append(")");
    }

    protected void buildAllHoursSummarySum(StringBuffer sb, boolean leadingComma, String labelPrefix) {
        if (leadingComma) {
            sb.append(",");
        }
        this.newline(sb, 8);
        this.buildAllHoursSummaryBaseSum(sb, labelPrefix);
        sb.append(" as ").append(labelPrefix).append(MESSAGES.utilSqlTotalAllHoursSuffix());
    }

    protected void buildWeekdayStandardHoursSummaryBaseSum(StringBuffer sb, String labelPrefix) {
        sb.append("(");
        boolean first = true;
        for (Integer day : this.getWeekDays()) {
            String label = null;
            int startPeriod = this.getStandardDayStartPeriod();
            while (startPeriod < this.getStandardDayEndPeriod()) {
                int stopPeriod = startPeriod + this.getPeriodsInHour();
                label = this.getDayTimeLabel(day, startPeriod, labelPrefix);
                if (first) {
                    first = false;
                } else {
                    sb.append(" +");
                }
                this.newline(sb, 12);
                sb.append(label);
                startPeriod = stopPeriod;
            }
        }
        this.newline(sb, 8);
        sb.append(")");
    }

    protected void buildWeekdayStandardHoursSummarySum(StringBuffer sb, boolean leadingComma, String labelPrefix) {
        if (leadingComma) {
            sb.append(",");
        }
        this.newline(sb, 8);
        this.buildWeekdayStandardHoursSummaryBaseSum(sb, labelPrefix);
        sb.append(" as ").append(labelPrefix).append(MESSAGES.utilSqlTotalStandardWeekdayHoursSuffix());
    }

    protected void buildStandardHoursSummaryBaseSum(StringBuffer sb, String labelPrefix) {
        sb.append("(");
        boolean first = true;
        for (Integer day : this.getWeekDays()) {
            String label = null;
            int startPeriod = this.getStandardDayStartPeriod();
            while (startPeriod < this.getStandardDayEndPeriod()) {
                int stopPeriod = startPeriod + this.getPeriodsInHour();
                label = this.getDayTimeLabel(day, startPeriod, labelPrefix);
                if (first) {
                    first = false;
                } else {
                    sb.append(" +");
                }
                this.newline(sb, 12);
                sb.append(label);
                startPeriod = stopPeriod;
            }
        }
        Integer day = this.getSaturday();
        int startPeriod = this.getWeekendDayStartPeriod();
        while (startPeriod < this.getWeekendDayEndPeriod()) {
            int stopPeriod = startPeriod + this.getPeriodsInHour();
            String label = null;
            label = this.getDayTimeLabel(day, startPeriod, labelPrefix);
            if (first) {
                first = false;
            } else {
                sb.append(" +");
            }
            this.newline(sb, 12);
            sb.append(label);
            startPeriod = stopPeriod;
        }
        this.newline(sb, 8);
        sb.append(")");
    }

    protected void buildStandardHoursSummarySum(StringBuffer sb, boolean leadingComma, String labelPrefix) {
        if (leadingComma) {
            sb.append(",");
        }
        this.newline(sb, 8);
        this.buildStandardHoursSummaryBaseSum(sb, labelPrefix);
        sb.append(" as ").append(labelPrefix).append(MESSAGES.utilSqlTotalStandardHoursSuffix());
    }

    protected void buildAllHoursLabelsCommaSeparated(StringBuffer sb, boolean leadingComma, String labelPrefix) {
        if (leadingComma) {
            sb.append(",");
        }
        this.newline(sb, 8);
        boolean first = true;
        for (Integer day : this.getAllDays()) {
            String label = this.getDayTimeLabel(day, this.getAllDayStartPeriod(), labelPrefix);
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            this.newline(sb, 8);
            sb.append(label);
            int startPeriod = this.getFirstFullHourStartPeriod();
            while (startPeriod < this.getLastFullHourStopPeriod()) {
                int stopPeriod = startPeriod + this.getPeriodsInHour();
                label = this.getDayTimeLabel(day, startPeriod, labelPrefix);
                sb.append(", ");
                this.newline(sb, 8);
                sb.append(label);
                startPeriod = stopPeriod;
            }
            label = this.getDayTimeLabel(day, this.getLastFullHourStopPeriod(), labelPrefix);
            sb.append(", ");
            this.newline(sb, 8);
            sb.append(label);
        }
    }

    @Override
    protected void addSumStatementToStringBuffer(StringBuffer sb, String sum, String label, boolean leadingComma) {
        if (leadingComma) {
            sb.append(",");
        }
        this.newline(sb, 8);
        sb.append("case");
        this.newline(sb, 8);
        sb.append("when");
        this.newline(sb, 8);
        sb.append(sum);
        if (sum.contains("z." + MESSAGES.utilSqlRoomSize())) {
            sb.append(" > z.").append(MESSAGES.utilSqlRoomSize());
        } else {
            sb.append(" > 1");
        }
        this.newline(sb, 8);
        sb.append("then");
        this.newline(sb, 8);
        if (sum.contains("z." + MESSAGES.utilSqlRoomSize())) {
            sb.append("z.").append(MESSAGES.utilSqlRoomSize());
        } else {
            sb.append(1);
        }
        this.newline(sb, 8);
        sb.append("else");
        this.newline(sb, 8);
        sb.append(sum);
        this.newline(sb, 8);
        sb.append("end");
        this.newline(sb, 8);
        sb.append(" as ").append(label);
    }
}

