/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.NameInterface;

public enum NameFormat {
    LAST_FIRST("last-first", new Formatter(){

        @Override
        public String format(NameInterface name) {
            return Constants.toInitialCase((name.getLastName() != null && !name.getLastName().isEmpty() ? name.getLastName() : "") + (name.getFirstName() != null && !name.getFirstName().isEmpty() ? ", " + name.getFirstName() : "")).trim();
        }
    }),
    FIRST_LAST("first-last", new Formatter(){

        @Override
        public String format(NameInterface name) {
            return Constants.toInitialCase((name.getFirstName() != null && !name.getFirstName().isEmpty() ? name.getFirstName() : "") + (name.getLastName() != null && !name.getLastName().isEmpty() ? " " + name.getLastName() : "")).trim();
        }
    }),
    INITIAL_LAST("initial-last", new Formatter(){

        @Override
        public String format(NameInterface name) {
            return ((name.getFirstName() != null && !name.getFirstName().isEmpty() ? name.getFirstName().trim().substring(0, 1).toUpperCase() : "") + (name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? " " + name.getMiddleName().trim().substring(0, 1).toUpperCase() : "") + (name.getLastName() != null && !name.getLastName().isEmpty() ? " " + Constants.toInitialCase(name.getLastName()) : "")).trim();
        }
    }),
    LAST_INITIAL("last-initial", new Formatter(){

        @Override
        public String format(NameInterface name) {
            return (name.getLastName() != null && !name.getLastName().isEmpty() ? Constants.toInitialCase(name.getLastName()) : "").trim() + (name.getFirstName() != null && !name.getFirstName().isEmpty() || name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? "," : "") + (name.getFirstName() != null && !name.getFirstName().isEmpty() ? " " + name.getFirstName().substring(0, 1).toUpperCase() : "") + (name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? " " + name.getMiddleName().substring(0, 1).toUpperCase() : "");
        }
    }),
    FIRST_MIDDLE_LAST("first-middle-last", new Formatter(){

        @Override
        public String format(NameInterface name) {
            return Constants.toInitialCase((name.getFirstName() != null && !name.getFirstName().isEmpty() ? name.getFirstName() : "") + (name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? " " + name.getMiddleName() : "") + (name.getLastName() != null && !name.getLastName().isEmpty() ? " " + name.getLastName() : "")).trim();
        }
    }),
    LAST_FIRST_MIDDLE("last-first-middle", new Formatter(){

        @Override
        public String format(NameInterface name) {
            return Constants.toInitialCase((name.getLastName() != null && !name.getLastName().isEmpty() ? name.getLastName() : "") + (name.getFirstName() != null && !name.getFirstName().isEmpty() || name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? "," : "") + (name.getFirstName() != null && !name.getFirstName().isEmpty() ? " " + name.getFirstName() : "") + (name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? " " + name.getMiddleName() : "")).trim();
        }
    }),
    SHORT("short", new Formatter(){

        @Override
        public String format(NameInterface name) {
            return (name.getFirstName() != null && !name.getFirstName().isEmpty() ? name.getFirstName().substring(0, 1).toUpperCase() + ". " : "") + (name.getLastName() != null && !name.getLastName().isEmpty() ? name.getLastName().substring(0, 1).toUpperCase() + name.getLastName().substring(1, Math.min(10, name.getLastName().length())).toLowerCase() : "").trim();
        }
    }),
    TITLE_FIRST_MIDDLE_LAST("title-first-middle-last", new Formatter(){

        @Override
        public String format(NameInterface name) {
            return (name.getAcademicTitle() != null && !name.getAcademicTitle().isEmpty() ? name.getAcademicTitle() + " " : "") + Constants.toInitialCase((name.getFirstName() != null && !name.getFirstName().isEmpty() ? name.getFirstName() : "") + (name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? " " + name.getMiddleName() : "") + (name.getLastName() != null && !name.getLastName().isEmpty() ? " " + name.getLastName() : "")).trim();
        }
    }),
    LAST_FIRST_MIDDLE_TITLE("last-first-middle-title", new Formatter(){

        @Override
        public String format(NameInterface name) {
            return Constants.toInitialCase((name.getLastName() != null && !name.getLastName().isEmpty() ? name.getLastName() : "") + (name.getFirstName() != null && !name.getFirstName().isEmpty() || name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? "," : "") + (name.getFirstName() != null && !name.getFirstName().isEmpty() ? " " + name.getFirstName() : "") + (name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? " " + name.getMiddleName() : "")).trim() + (name.getAcademicTitle() != null && !name.getAcademicTitle().isEmpty() ? " " + name.getAcademicTitle() : "");
        }
    }),
    TITLE_INITIAL_LAST("title-initial-last", new Formatter(){

        @Override
        public String format(NameInterface name) {
            return (name.getAcademicTitle() != null && !name.getAcademicTitle().isEmpty() ? name.getAcademicTitle() + " " : "") + ((name.getFirstName() != null && !name.getFirstName().isEmpty() ? name.getFirstName().trim().substring(0, 1).toUpperCase() : "") + (name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? " " + name.getMiddleName().trim().substring(0, 1).toUpperCase() : "") + (name.getLastName() != null && !name.getLastName().isEmpty() ? " " + Constants.toInitialCase(name.getLastName()) : "")).trim();
        }
    }),
    TITLE_LAST_INITIAL("title-last-initial", new Formatter(){

        @Override
        public String format(NameInterface name) {
            return (name.getAcademicTitle() != null && !name.getAcademicTitle().isEmpty() ? name.getAcademicTitle() + " " : "") + (name.getLastName() != null && !name.getLastName().isEmpty() ? Constants.toInitialCase(name.getLastName()) : "").trim() + (name.getFirstName() != null && !name.getFirstName().isEmpty() || name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? "," : "") + (name.getFirstName() != null && !name.getFirstName().isEmpty() ? " " + name.getFirstName().substring(0, 1).toUpperCase() : "") + (name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? " " + name.getMiddleName().substring(0, 1).toUpperCase() : "");
        }
    }),
    EXTERNAL_LAST_FIRST_MIDDLE("ext-last-first-middle", new Formatter(){

        @Override
        public String format(NameInterface name) {
            return (name.getExternalUniqueId() != null && !name.getExternalUniqueId().isEmpty() ? name.getExternalUniqueId() + " - " : "") + Constants.toInitialCase((name.getLastName() != null && !name.getLastName().isEmpty() ? name.getLastName() : "") + (name.getFirstName() != null && !name.getFirstName().isEmpty() || name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? "," : "") + (name.getFirstName() != null && !name.getFirstName().isEmpty() ? " " + name.getFirstName() : "") + (name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? " " + name.getMiddleName() : "")).trim();
        }
    }),
    EXTERNAL_FIRST_MIDDLE_LAST("ext-first-middle-last", new Formatter(){

        @Override
        public String format(NameInterface name) {
            return (name.getExternalUniqueId() != null && !name.getExternalUniqueId().isEmpty() ? name.getExternalUniqueId() + " - " : "") + Constants.toInitialCase((name.getFirstName() != null && !name.getFirstName().isEmpty() ? name.getFirstName() : "") + (name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? " " + name.getMiddleName() : "") + (name.getLastName() != null && !name.getLastName().isEmpty() ? " " + name.getLastName() : "")).trim();
        }
    }),
    EXTERNAL_LAST_FIRST_MIDDLE_TITLE("ext-last-first-middle-title", new Formatter(){

        @Override
        public String format(NameInterface name) {
            return (name.getExternalUniqueId() != null && !name.getExternalUniqueId().isEmpty() ? name.getExternalUniqueId() + " - " : "") + Constants.toInitialCase((name.getLastName() != null && !name.getLastName().isEmpty() ? name.getLastName() : "") + (name.getFirstName() != null && !name.getFirstName().isEmpty() || name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? "," : "") + (name.getFirstName() != null && !name.getFirstName().isEmpty() ? " " + name.getFirstName() : "") + (name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? " " + name.getMiddleName() : "")).trim() + (name.getAcademicTitle() != null && !name.getAcademicTitle().isEmpty() ? " " + name.getAcademicTitle() : "");
        }
    }),
    EXTERNAL_TITLE_FIRST_MIDDLE_LAST("ext-title-first-middle-last", new Formatter(){

        @Override
        public String format(NameInterface name) {
            return (name.getExternalUniqueId() != null && !name.getExternalUniqueId().isEmpty() ? name.getExternalUniqueId() + " - " : "") + (name.getAcademicTitle() != null && !name.getAcademicTitle().isEmpty() ? name.getAcademicTitle() + " " : "") + Constants.toInitialCase((name.getFirstName() != null && !name.getFirstName().isEmpty() ? name.getFirstName() : "") + (name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? " " + name.getMiddleName() : "") + (name.getLastName() != null && !name.getLastName().isEmpty() ? " " + name.getLastName() : "")).trim();
        }
    }),
    EXTERNAL_TITLE_INITIAL_LAST("ext-title-initial-last", new Formatter(){

        @Override
        public String format(NameInterface name) {
            return (name.getExternalUniqueId() != null && !name.getExternalUniqueId().isEmpty() ? name.getExternalUniqueId() + " - " : "") + (name.getAcademicTitle() != null && !name.getAcademicTitle().isEmpty() ? name.getAcademicTitle() + " " : "") + ((name.getFirstName() != null && !name.getFirstName().isEmpty() ? name.getFirstName().trim().substring(0, 1).toUpperCase() : "") + (name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? " " + name.getMiddleName().trim().substring(0, 1).toUpperCase() : "") + (name.getLastName() != null && !name.getLastName().isEmpty() ? " " + Constants.toInitialCase(name.getLastName()) : "")).trim();
        }
    }),
    EXTERNAL_TITLE_LAST_INITIAL("ext-title-last-initial", new Formatter(){

        @Override
        public String format(NameInterface name) {
            return (name.getExternalUniqueId() != null && !name.getExternalUniqueId().isEmpty() ? name.getExternalUniqueId() + " - " : "") + (name.getAcademicTitle() != null && !name.getAcademicTitle().isEmpty() ? name.getAcademicTitle() + " " : "") + (name.getLastName() != null && !name.getLastName().isEmpty() ? Constants.toInitialCase(name.getLastName()) : "").trim() + (name.getFirstName() != null && !name.getFirstName().isEmpty() || name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? "," : "") + (name.getFirstName() != null && !name.getFirstName().isEmpty() ? " " + name.getFirstName().substring(0, 1).toUpperCase() : "") + (name.getMiddleName() != null && !name.getMiddleName().isEmpty() ? " " + name.getMiddleName().substring(0, 1).toUpperCase() : "");
        }
    });

    private String iRefernence;
    private Formatter iFormatter;

    private NameFormat(String reference, Formatter formatter) {
        this.iRefernence = reference;
        this.iFormatter = formatter;
    }

    public String reference() {
        return this.iRefernence;
    }

    public static NameFormat defaultFormat() {
        return LAST_FIRST_MIDDLE;
    }

    public static NameFormat fromReference(String reference) {
        for (NameFormat f : NameFormat.values()) {
            if (!f.reference().equals(reference)) continue;
            return f;
        }
        return NameFormat.defaultFormat();
    }

    public String format(NameInterface name) {
        return this.iFormatter.format(name);
    }

    private static interface Formatter {
        public String format(NameInterface var1);
    }
}

