/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.util.DistanceMetric;
import org.hibernate.Transaction;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.RoomSharingModel;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BaseClassInstructor;
import org.unitime.timetable.model.base.BaseDistributionPref;
import org.unitime.timetable.model.base.BasePreference;
import org.unitime.timetable.model.base.BaseTimePref;
import org.unitime.timetable.model.dao._RootDAO;

public class FixCourseTimetablingInconsistencies {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static Log sLog = LogFactory.getLog(FixCourseTimetablingInconsistencies.class);
    private Long iSessionId;
    private org.hibernate.Session iHibSession;
    private DistanceMetric iDistanceMetric;

    public FixCourseTimetablingInconsistencies(Long sessionId) {
        this.iSessionId = sessionId;
        this.iDistanceMetric = new DistanceMetric(DistanceMetric.Ellipsoid.valueOf((String)ApplicationProperty.DistanceEllipsoid.value()));
    }

    public void fixAll(org.hibernate.Session hibSession) {
        this.iHibSession = hibSession;
        List assignments = hibSession.createQuery("select a from Assignment a where a.solution.commited = true and a.solution.owner.session.uniqueId = :sessionId").setLong("sessionId", this.iSessionId.longValue()).list();
        Hashtable<Location, List<Assignment>> roomAssignments = new Hashtable<Location, List<Assignment>>();
        Hashtable<String, List<Assignment>> instructorAssignments = new Hashtable<String, List<Assignment>>();
        for (Assignment a : assignments) {
            List<Assignment> ax;
            Class_ c = a.getClazz();
            boolean save = false;
            this.fixInstructors(c, a);
            this.fixRoomSharing(c, a);
            if (this.fixDatePattern(c, a)) {
                save = true;
            }
            if (this.fixRequiredTime(c, a)) {
                save = true;
            }
            if (this.fixNrAssignedRooms(c, a)) {
                save = true;
            }
            if (this.fixRequiredRoom(c, a)) {
                save = true;
            }
            if (this.fixRequiredBuilding(c, a)) {
                save = true;
            }
            if (this.fixRoomSize(c, a)) {
                save = true;
            }
            this.fixRequiredFeatures(c, a);
            this.fixRequiredGroups(c, a);
            for (Location loc : a.getRooms()) {
                ax = roomAssignments.get(loc);
                if (ax == null) {
                    ax = new ArrayList<Assignment>();
                    roomAssignments.put(loc, ax);
                }
                ax.add(a);
            }
            for (DepartmentalInstructor ins : a.getInstructors()) {
                if (ins.getExternalUniqueId() == null || ins.getExternalUniqueId().isEmpty()) continue;
                ax = instructorAssignments.get(ins.getExternalUniqueId());
                if (ax == null) {
                    ax = new ArrayList<Assignment>();
                    instructorAssignments.put(ins.getExternalUniqueId(), ax);
                }
                ax.add(a);
            }
            if (!save) continue;
            hibSession.saveOrUpdate((Object)c);
        }
        this.checkRoomConstraints(roomAssignments);
        this.checkInstructorAssignments(instructorAssignments);
        hibSession.flush();
    }

    private void checkRoomConstraints(Hashtable<Location, List<Assignment>> roomAssignments) {
        for (Map.Entry<Location, List<Assignment>> entry : roomAssignments.entrySet()) {
            Location location = entry.getKey();
            if (location.isIgnoreRoomCheck().booleanValue()) continue;
            List<Assignment> ax = entry.getValue();
            DistributionType canShareRoomType = (DistributionType)this.iHibSession.createQuery("select d from DistributionType d where d.reference = :type").setString("type", "CAN_SHARE_ROOM").uniqueResult();
            for (Assignment a : ax) {
                block2: for (Assignment b : ax) {
                    if (a.getUniqueId() >= b.getUniqueId() || !a.getTimeLocation().hasIntersection(b.getTimeLocation())) continue;
                    Set dist = a.getClazz().effectivePreferences(DistributionPref.class);
                    for (DistributionPref d : dist) {
                        if (!d.getDistributionType().getReference().equals("CAN_SHARE_ROOM") && !d.getDistributionType().getReference().equals("MEET_WITH")) continue;
                        for (DistributionObject o : d.getDistributionObjects()) {
                            if (!o.getPrefGroup().equals(b.getClazz()) && !o.getPrefGroup().equals(b.getClazz().getSchedulingSubpart())) continue;
                            int minSize = Math.round(a.getClazz().getRoomRatio().floatValue() * (float)a.getClazz().getExpectedCapacity().intValue() + b.getClazz().getRoomRatio().floatValue() * (float)b.getClazz().getExpectedCapacity().intValue());
                            if (location.getCapacity() >= minSize) continue block2;
                            sLog.info((Object)("Allowed overlap of classes in room " + location.getLabel() + ":\n  " + a.getClazz().getClassLabel() + " " + a.getTimeLocation().getLongName(CONSTANTS.useAmPm()) + "\n  " + b.getClazz().getClassLabel() + " " + b.getTimeLocation().getLongName(CONSTANTS.useAmPm())));
                            sLog.warn((Object)("But the he room is too small (" + location.getCapacity() + " < " + minSize + ")"));
                            float ratio = (float)location.getCapacity().intValue() / (float)minSize;
                            a.getClazz().setRoomRatio(Float.valueOf(a.getClazz().getRoomRatio().floatValue() * ratio));
                            b.getClazz().setRoomRatio(Float.valueOf(b.getClazz().getRoomRatio().floatValue() * ratio));
                            this.iHibSession.saveOrUpdate((Object)a.getClazz());
                            this.iHibSession.saveOrUpdate((Object)b.getClazz());
                            continue block2;
                        }
                    }
                    sLog.warn((Object)("Overlapping classes in room " + location.getLabel() + ":\n  " + a.getClazz().getClassLabel() + " " + a.getTimeLocation().getLongName(CONSTANTS.useAmPm()) + "\n  " + b.getClazz().getClassLabel() + " " + b.getTimeLocation().getLongName(CONSTANTS.useAmPm())));
                    int minSize = Math.round(a.getClazz().getRoomRatio().floatValue() * (float)a.getClazz().getExpectedCapacity().intValue()) + Math.round(b.getClazz().getRoomRatio().floatValue() * (float)b.getClazz().getExpectedCapacity().intValue());
                    if (location.getCapacity() < minSize) {
                        sLog.warn((Object)("Also the room is too small (" + location.getCapacity() + " < " + minSize + ")"));
                        float ratio = (float)location.getCapacity().intValue() / (float)minSize;
                        a.getClazz().setRoomRatio(Float.valueOf(a.getClazz().getRoomRatio().floatValue() * ratio));
                        b.getClazz().setRoomRatio(Float.valueOf(b.getClazz().getRoomRatio().floatValue() * ratio));
                        this.iHibSession.saveOrUpdate((Object)a.getClazz());
                        this.iHibSession.saveOrUpdate((Object)b.getClazz());
                    }
                    DistributionPref dp = new DistributionPref();
                    dp.setDistributionType(canShareRoomType);
                    dp.setOwner(a.getClazz().getManagingDept());
                    dp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                    dp.setDistributionObjects(new HashSet<DistributionObject>());
                    dp.setStructure(DistributionPref.Structure.AllClasses);
                    DistributionObject o1 = new DistributionObject();
                    o1.setDistributionPref(dp);
                    o1.setPrefGroup(a.getClazz());
                    o1.setSequenceNumber(1);
                    dp.getDistributionObjects().add(o1);
                    DistributionObject o2 = new DistributionObject();
                    o2.setDistributionPref(dp);
                    o2.setPrefGroup(b.getClazz());
                    o2.setSequenceNumber(2);
                    dp.getDistributionObjects().add(o2);
                    this.iHibSession.saveOrUpdate((Object)dp);
                }
            }
        }
    }

    private void checkInstructorAssignments(Hashtable<String, List<Assignment>> instructorAssignments) {
        for (Map.Entry<String, List<Assignment>> entry : instructorAssignments.entrySet()) {
            String instructorExternalId = entry.getKey();
            List<Assignment> ax = entry.getValue();
            for (Assignment a : ax) {
                block2: for (Assignment b : ax) {
                    if (a.getUniqueId() >= b.getUniqueId() || !a.getTimeLocation().hasIntersection(b.getTimeLocation())) continue;
                    Set dist = a.getClazz().effectivePreferences(DistributionPref.class);
                    for (DistributionPref d : dist) {
                        if (!d.getDistributionType().getReference().equals("CAN_SHARE_ROOM") && !d.getDistributionType().getReference().equals("MEET_WITH")) continue;
                        for (DistributionObject o : d.getDistributionObjects()) {
                            if (!o.getPrefGroup().equals(b.getClazz()) && !o.getPrefGroup().equals(b.getClazz().getSchedulingSubpart())) continue;
                            continue block2;
                        }
                    }
                    ClassInstructor ca = null;
                    BaseClassInstructor cb = null;
                    for (ClassInstructor ci : a.getClazz().getClassInstructors()) {
                        if (!instructorExternalId.equals(ci.getInstructor().getExternalUniqueId())) continue;
                        ca = ci;
                    }
                    for (ClassInstructor ci : b.getClazz().getClassInstructors()) {
                        if (!instructorExternalId.equals(ci.getInstructor().getExternalUniqueId())) continue;
                        cb = ci;
                    }
                    if (ca == null || !ca.isLead().booleanValue() || cb == null || !cb.isLead().booleanValue()) continue;
                    sLog.warn((Object)("Overlapping classes for instructor " + instructorExternalId + ":\n  " + a.getClazz().getClassLabel() + " " + a.getPlacement().getLongName(CONSTANTS.useAmPm()) + "\n  " + b.getClazz().getClassLabel() + " " + b.getPlacement().getLongName(CONSTANTS.useAmPm())));
                    ca.setLead(false);
                    this.iHibSession.saveOrUpdate((Object)ca);
                }
            }
        }
    }

    private boolean fixDatePattern(Class_ clazz, Assignment assignment) {
        if (assignment.getDatePattern() == null) {
            return false;
        }
        DatePattern dp = clazz.effectiveDatePattern();
        if (dp == null || !dp.equals(assignment.getDatePattern())) {
            sLog.info((Object)("Class " + clazz.getClassLabel() + " had an inconsistent date pattern " + dp.getName() + " != " + assignment.getDatePattern().getName()));
            clazz.setDatePattern(assignment.getDatePattern());
            return true;
        }
        return false;
    }

    private boolean fixRequiredTime(Class_ clazz, Assignment assignment) {
        TimePatternModel pattern;
        TimePref p;
        TimeLocation time = assignment.getTimeLocation();
        if (time == null) {
            return false;
        }
        Set timePrefs = clazz.effectivePreferences(TimePref.class);
        boolean onlyReq = false;
        int nrExact = 0;
        for (Object p2 : timePrefs) {
            TimePatternModel pattern2 = ((TimePref)p2).getTimePatternModel();
            if (pattern2.isExactTime() || pattern2.countPreferences(PreferenceLevel.sRequired) > 0) {
                onlyReq = true;
            }
            if (pattern2.isExactTime()) {
                if (assignment.getDays().intValue() == pattern2.getExactDays() && assignment.getStartSlot().intValue() == pattern2.getExactStartSlot()) {
                    return false;
                }
                ++nrExact;
            }
            for (int t = 0; t < pattern2.getNrTimes(); ++t) {
                for (int d = 0; d < pattern2.getNrDays(); ++d) {
                    String pref = pattern2.getPreference(d, t);
                    if (pattern2.getDayCode(d) != assignment.getDays().intValue() || pattern2.getStartSlot(t) != assignment.getStartSlot().intValue()) continue;
                    if (onlyReq) {
                        if (!PreferenceLevel.sRequired.equals(pref)) continue;
                        return false;
                    }
                    if (!PreferenceLevel.sProhibited.equals(pref)) {
                        return false;
                    }
                    sLog.warn((Object)("Clazz " + clazz.getClassLabel() + " prohibits assigned time " + time.getName(CONSTANTS.useAmPm())));
                    pattern2.setPreference(d, t, PreferenceLevel.sStronglyDiscouraged);
                    ((BaseTimePref)p2).setPreference(pattern2.getPreferences());
                    if (((BasePreference)p2).getOwner() == null) {
                        ((BasePreference)p2).setOwner(clazz);
                    }
                    this.iHibSession.saveOrUpdate(p2);
                    return true;
                }
            }
        }
        if (onlyReq) {
            boolean found = false;
            for (TimePref p3 : timePrefs) {
                TimePatternModel pattern3 = p3.getTimePatternModel();
                if (pattern3.isExactTime()) continue;
                pattern3.clear();
                for (int t = 0; t < pattern3.getNrTimes(); ++t) {
                    for (int d = 0; d < pattern3.getNrDays(); ++d) {
                        if (pattern3.getDayCode(d) != assignment.getDays().intValue() || pattern3.getStartSlot(t) != assignment.getStartSlot().intValue()) continue;
                        sLog.warn((Object)("Clazz " + clazz.getClassLabel() + " requires a different time " + pattern3.getDayHeader(d) + " " + pattern3.getTimeHeaderShort(t) + " than assigned " + time.getName(CONSTANTS.useAmPm())));
                        pattern3.setPreference(d, t, PreferenceLevel.sRequired);
                        found = true;
                    }
                }
                p3.setPreference(pattern3.getPreferences());
                if (p3.getOwner() == null) {
                    p3.setOwner(clazz);
                }
                this.iHibSession.saveOrUpdate((Object)p3);
            }
            if (found) {
                return true;
            }
        }
        if (timePrefs.isEmpty()) {
            sLog.warn((Object)("Clazz " + clazz.getClassLabel() + " has no time preferences but assigned time " + time.getLongName(CONSTANTS.useAmPm())));
        } else {
            sLog.warn((Object)("Clazz " + clazz.getClassLabel() + " has no time pattern for the assigned time " + time.getLongName(CONSTANTS.useAmPm())));
            if (nrExact == 1 && timePrefs.size() == 1) {
                p = (TimePref)timePrefs.iterator().next();
                pattern = p.getTimePatternModel();
                pattern.setExactDays(assignment.getDays());
                pattern.setExactStartSlot(assignment.getStartSlot());
                p.setPreference(pattern.getPreferences());
                this.iHibSession.saveOrUpdate((Object)p);
                return true;
            }
        }
        p = new TimePref();
        p.setOwner(clazz);
        p.setTimePattern(TimePattern.findExactTime(this.iSessionId));
        pattern = p.getTimePatternModel();
        pattern.setExactDays(assignment.getDays());
        pattern.setExactStartSlot(assignment.getStartSlot());
        p.setPreference(pattern.getPreferences());
        p.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
        clazz.getPreferences().add(p);
        return true;
    }

    private boolean fixNrAssignedRooms(Class_ clazz, Assignment assignment) {
        if (clazz.getNbrRooms().intValue() != assignment.getRooms().size()) {
            sLog.warn((Object)("Clazz " + clazz.getClassLabel() + " has assigned a wrong number of rooms " + clazz.getNbrRooms() + " != " + assignment.getRooms().size()));
            clazz.setNbrRooms(assignment.getRooms().size());
            return true;
        }
        return false;
    }

    private boolean fixRequiredRoom(Class_ clazz, Assignment assignment) {
        if (clazz.getNbrRooms() == 0) {
            return false;
        }
        Set roomPrefs = clazz.effectivePreferences(RoomPref.class);
        HashSet<Location> remaining = new HashSet<Location>(assignment.getRooms());
        boolean hasReq = false;
        for (RoomPref p : roomPrefs) {
            if (p.getPrefLevel().getPrefProlog().equals(PreferenceLevel.sRequired)) {
                hasReq = true;
                if (!remaining.remove(p.getRoom())) {
                    sLog.warn((Object)("Clazz " + clazz.getClassLabel() + " requires a room " + p.getRoom().getLabel() + " different from the assigned room " + assignment.getPlacement().getRoomName(",")));
                    p.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    if (p.getOwner() == null) {
                        p.setOwner(clazz);
                    }
                    this.iHibSession.save((Object)p);
                }
            }
            if (!p.getPrefLevel().getPrefProlog().equals(PreferenceLevel.sProhibited) || !assignment.getRooms().contains(p.getRoom())) continue;
            sLog.warn((Object)("Clazz " + clazz.getClassLabel() + " prohibits the assigned room " + p.getRoom().getLabel()));
            p.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyDiscouraged));
            if (p.getOwner() == null) {
                p.setOwner(clazz);
            }
            this.iHibSession.save((Object)p);
        }
        for (RoomPref p : roomPrefs) {
            if (!hasReq || p.getPrefLevel().getPrefProlog().equals(PreferenceLevel.sRequired) || !remaining.remove(p.getRoom())) continue;
            p.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
            if (p.getOwner() == null) {
                p.setOwner(clazz);
            }
            this.iHibSession.save((Object)p);
        }
        boolean ret = false;
        if (hasReq && !remaining.isEmpty()) {
            for (Location room : remaining) {
                RoomPref p = new RoomPref();
                p.setOwner(clazz);
                p.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                p.setRoom(room);
                clazz.getPreferences().add(p);
                roomPrefs.add(p);
            }
            ret = true;
        }
        block3: for (Location loc : assignment.getRooms()) {
            for (RoomPref px : clazz.getManagingDept().getPreferences(RoomPref.class)) {
                if (!px.getRoom().equals(loc)) continue;
                if (px.getPrefLevel().getPrefProlog().equals(PreferenceLevel.sProhibited)) {
                    sLog.info((Object)("Class " + clazz.getClassLabel() + " is assigned to a room " + loc.getLabel() + " that is prohibited on a departmental level."));
                    px.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyDiscouraged));
                    this.iHibSession.saveOrUpdate((Object)px);
                }
                if (!px.getPrefLevel().getPrefProlog().equals(PreferenceLevel.sStronglyDiscouraged)) continue;
                for (RoomPref p : roomPrefs) {
                    if (!p.getRoom().equals(loc)) continue;
                    continue block3;
                }
                sLog.info((Object)("Class " + clazz.getClassLabel() + " is assigned to a room " + loc.getLabel() + " that is strongly discouraged on a departmental level."));
                RoomPref p = new RoomPref();
                p.setOwner(clazz);
                p.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyDiscouraged));
                p.setRoom(loc);
                clazz.getPreferences().add(p);
                ret = true;
            }
        }
        return ret;
    }

    private boolean fixRoomSize(Class_ clazz, Assignment assignment) {
        if (clazz.getNbrRooms() == 0) {
            return false;
        }
        int minSize = Math.round(clazz.getRoomRatio().floatValue() * (float)clazz.getExpectedCapacity().intValue());
        boolean ret = false;
        for (Location loc : assignment.getRooms()) {
            if (loc.getCapacity() >= minSize) continue;
            sLog.warn((Object)("Clazz " + clazz.getClassLabel() + " has assigned a room " + loc.getLabel() + " that is too small (" + loc.getCapacity() + " < " + minSize + ")"));
            minSize = loc.getCapacity();
            clazz.setRoomRatio(Float.valueOf((float)loc.getCapacity().intValue() / (float)clazz.getExpectedCapacity().intValue()));
            ret = true;
        }
        return ret;
    }

    private boolean fixRequiredBuilding(Class_ clazz, Assignment assignment) {
        if (clazz.getNbrRooms() == 0) {
            return false;
        }
        Set bldgPrefs = clazz.effectivePreferences(BuildingPref.class);
        HashSet<Building> remaining = new HashSet<Building>();
        for (Location room : assignment.getRooms()) {
            if (!(room instanceof Room)) continue;
            remaining.add(((Room)room).getBuilding());
        }
        boolean hasReq = false;
        for (BuildingPref p : bldgPrefs) {
            if (p.getPrefLevel().getPrefProlog().equals(PreferenceLevel.sRequired)) {
                hasReq = true;
                if (!remaining.remove(p.getBuilding())) {
                    sLog.warn((Object)("Clazz " + clazz.getClassLabel() + " requires a building " + p.getBuilding().getAbbreviation() + " different from the assigned building " + assignment.getPlacement().getRoomName(",")));
                    p.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    if (p.getOwner() == null) {
                        p.setOwner(clazz);
                    }
                    this.iHibSession.save((Object)p);
                }
            }
            if (!p.getPrefLevel().getPrefProlog().equals(PreferenceLevel.sProhibited) || !remaining.contains(p.getBuilding())) continue;
            sLog.warn((Object)("Clazz " + clazz.getClassLabel() + " prohibits the assigned building " + p.getBuilding().getAbbreviation()));
            p.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyDiscouraged));
            if (p.getOwner() == null) {
                p.setOwner(clazz);
            }
            this.iHibSession.save((Object)p);
        }
        for (BuildingPref p : bldgPrefs) {
            if (!hasReq || p.getPrefLevel().getPrefProlog().equals(PreferenceLevel.sRequired) || !remaining.remove(p.getBuilding())) continue;
            p.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
            if (p.getOwner() == null) {
                p.setOwner(clazz);
            }
            this.iHibSession.save((Object)p);
        }
        if (hasReq && !remaining.isEmpty()) {
            for (Building bldg : remaining) {
                BuildingPref p = new BuildingPref();
                p.setOwner(clazz);
                p.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                p.setBuilding(bldg);
                clazz.getPreferences().add(p);
            }
            return true;
        }
        return false;
    }

    public boolean isBackToBackTooFar(Placement p1, Placement p2) {
        if (!p1.getTimeLocation().shareDays(p2.getTimeLocation())) {
            return false;
        }
        if (!p1.getTimeLocation().shareWeeks(p2.getTimeLocation())) {
            return false;
        }
        int s1 = p1.getTimeLocation().getStartSlot() % 288;
        int s2 = p2.getTimeLocation().getStartSlot() % 288;
        if (s1 + p1.getTimeLocation().getLength() != s2 && s2 + p2.getTimeLocation().getLength() != s1) {
            return false;
        }
        double distance = Placement.getDistanceInMeters((DistanceMetric)this.iDistanceMetric, (Placement)p1, (Placement)p2);
        return distance > this.iDistanceMetric.getInstructorProhibitedLimit();
    }

    private void fixInstructors(Class_ clazz, Assignment a) {
        for (ClassInstructor ci : clazz.getClassInstructors()) {
            if (ci.getLead().booleanValue() == a.getInstructors().contains(ci.getInstructor())) continue;
            sLog.info((Object)("Correcting lead info from assignment for " + clazz.getClassLabel() + ", instructor " + ci.getInstructor().getName(DepartmentalInstructor.sNameFormatShort) + " (" + ci.getLead() + " -> " + a.getInstructors().contains(ci.getInstructor()) + ")"));
            ci.setLead(a.getInstructors().contains(ci.getInstructor()));
            this.iHibSession.saveOrUpdate((Object)ci);
        }
        for (ClassInstructor ci : clazz.getClassInstructors()) {
            if (!ci.isLead().booleanValue()) continue;
            block2: for (ClassInstructor other : ci.getInstructor().getClasses()) {
                Assignment b;
                if (other.equals(ci) || !other.isLead().booleanValue() || (b = other.getClassInstructing().getCommittedAssignment()) == null) continue;
                if (b.getTimeLocation().hasIntersection(a.getTimeLocation())) {
                    sLog.info((Object)("Class " + clazz.getClassLabel() + " " + a.getTimeLocation().getName(CONSTANTS.useAmPm()) + " " + a.getPlacement().getRoomName(",") + " has an instructor " + ci.getInstructor().getName(DepartmentalInstructor.sNameFormatShort) + " overlapping with " + other.getClassInstructing().getClassLabel() + " " + b.getTimeLocation().getName(CONSTANTS.useAmPm()) + "  " + b.getPlacement().getRoomName(",") + "."));
                    if (a.getTimeLocation().getLongName(CONSTANTS.useAmPm()).equals(b.getTimeLocation().getLongName(CONSTANTS.useAmPm())) && a.getPlacement().getRoomName(",").equals(b.getPlacement().getRoomName(","))) {
                        Object d2;
                        sLog.info((Object)"  checking meet with constraint...");
                        Set dist = a.getClazz().effectivePreferences(DistributionPref.class);
                        for (Object d2 : dist) {
                            if (!((BaseDistributionPref)d2).getDistributionType().getReference().equals("CAN_SHARE_ROOM") && !((BaseDistributionPref)d2).getDistributionType().getReference().equals("MEET_WITH")) continue;
                            for (DistributionObject o : ((BaseDistributionPref)d2).getDistributionObjects()) {
                                if (!o.getPrefGroup().equals(b.getClazz()) && !o.getPrefGroup().equals(b.getClazz().getSchedulingSubpart())) continue;
                                int minSize = Math.round(a.getClazz().getRoomRatio().floatValue() * (float)a.getClazz().getExpectedCapacity().intValue() + b.getClazz().getRoomRatio().floatValue() * (float)b.getClazz().getExpectedCapacity().intValue());
                                for (Location location : a.getRooms()) {
                                    sLog.info((Object)("Allowed overlap of classes in room " + location.getLabel() + ":\n  " + a.getClazz().getClassLabel() + " " + a.getTimeLocation().getLongName(CONSTANTS.useAmPm()) + "\n  " + b.getClazz().getClassLabel() + " " + b.getTimeLocation().getLongName(CONSTANTS.useAmPm())));
                                    if (location.getCapacity() >= minSize) continue;
                                    sLog.warn((Object)("But the he room is too small (" + location.getCapacity() + " < " + minSize + ")"));
                                    float ratio = (float)location.getCapacity().intValue() / (float)minSize;
                                    a.getClazz().setRoomRatio(Float.valueOf(a.getClazz().getRoomRatio().floatValue() * ratio));
                                    b.getClazz().setRoomRatio(Float.valueOf(b.getClazz().getRoomRatio().floatValue() * ratio));
                                    this.iHibSession.saveOrUpdate((Object)a.getClazz());
                                    this.iHibSession.saveOrUpdate((Object)b.getClazz());
                                }
                                continue block2;
                            }
                        }
                        int minSize = Math.round(a.getClazz().getRoomRatio().floatValue() * (float)a.getClazz().getExpectedCapacity().intValue()) + Math.round(b.getClazz().getRoomRatio().floatValue() * (float)b.getClazz().getExpectedCapacity().intValue());
                        d2 = a.getRooms().iterator();
                        while (d2.hasNext()) {
                            Location location = (Location)d2.next();
                            if (location.getCapacity() >= minSize) continue;
                            sLog.warn((Object)("Also the room is too small (" + location.getCapacity() + " < " + minSize + ")"));
                            float ratio = (float)location.getCapacity().intValue() / (float)minSize;
                            a.getClazz().setRoomRatio(Float.valueOf(a.getClazz().getRoomRatio().floatValue() * ratio));
                            b.getClazz().setRoomRatio(Float.valueOf(b.getClazz().getRoomRatio().floatValue() * ratio));
                            this.iHibSession.saveOrUpdate((Object)a.getClazz());
                            this.iHibSession.saveOrUpdate((Object)b.getClazz());
                        }
                        DistributionType meetWithType = (DistributionType)this.iHibSession.createQuery("select d from DistributionType d where d.reference = :type").setString("type", "MEET_WITH").uniqueResult();
                        DistributionPref dp = new DistributionPref();
                        dp.setDistributionType(meetWithType);
                        dp.setOwner(a.getClazz().getManagingDept());
                        dp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                        dp.setDistributionObjects(new HashSet<DistributionObject>());
                        dp.setStructure(DistributionPref.Structure.AllClasses);
                        DistributionObject o1 = new DistributionObject();
                        o1.setDistributionPref(dp);
                        o1.setPrefGroup(a.getClazz());
                        o1.setSequenceNumber(1);
                        dp.getDistributionObjects().add(o1);
                        DistributionObject o2 = new DistributionObject();
                        o2.setDistributionPref(dp);
                        o2.setPrefGroup(b.getClazz());
                        o2.setSequenceNumber(2);
                        dp.getDistributionObjects().add(o2);
                        this.iHibSession.saveOrUpdate((Object)dp);
                        continue;
                    }
                    ci.setLead(false);
                    this.iHibSession.saveOrUpdate((Object)ci);
                    continue;
                }
                if (ci.getInstructor().isIgnoreToFar().booleanValue() || !this.isBackToBackTooFar(a.getPlacement(), b.getPlacement())) continue;
                sLog.info((Object)("Class " + clazz.getClassLabel() + " " + a.getTimeLocation().getName(CONSTANTS.useAmPm()) + " " + a.getPlacement().getRoomName(",") + " has an instructor " + ci.getInstructor().getName(DepartmentalInstructor.sNameFormatShort) + " and is too far back-to-back with " + other.getClassInstructing().getClassLabel() + " " + b.getTimeLocation().getName(CONSTANTS.useAmPm()) + "  " + b.getPlacement().getRoomName(",") + "."));
                ci.getInstructor().setIgnoreToFar(true);
                this.iHibSession.saveOrUpdate((Object)ci.getInstructor());
            }
        }
    }

    public void fixRequiredFeatures(Class_ clazz, Assignment a) {
        Set featurePrefs = clazz.effectivePreferences(RoomFeaturePref.class);
        for (RoomFeaturePref p : featurePrefs) {
            if (p.getPrefLevel().getPrefProlog().equals(PreferenceLevel.sRequired)) {
                for (Location loc : a.getRooms()) {
                    if (loc.getFeatures().contains(p.getRoomFeature())) continue;
                    sLog.info((Object)("Class " + clazz.getClassLabel() + " requires feature " + p.getRoomFeature().getLabel() + " but assigned room " + loc.getLabel() + " does not have it."));
                    p.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyPreferred));
                    if (p.getOwner() == null) {
                        p.setOwner(clazz);
                    }
                    this.iHibSession.saveOrUpdate((Object)p);
                }
            }
            if (!p.getPrefLevel().getPrefProlog().equals(PreferenceLevel.sProhibited)) continue;
            for (Location loc : a.getRooms()) {
                if (!loc.getFeatures().contains(p.getRoomFeature())) continue;
                sLog.info((Object)("Class " + clazz.getClassLabel() + " prohibits feature " + p.getRoomFeature().getLabel() + " but assigned room " + loc.getLabel() + " does have it."));
                p.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyDiscouraged));
                if (p.getOwner() == null) {
                    p.setOwner(clazz);
                }
                this.iHibSession.saveOrUpdate((Object)p);
            }
        }
    }

    public void fixRequiredGroups(Class_ clazz, Assignment a) {
        Set roomGroopPrefs = clazz.effectivePreferences(RoomGroupPref.class);
        for (RoomGroupPref p : roomGroopPrefs) {
            if (p.getPrefLevel().getPrefProlog().equals(PreferenceLevel.sRequired)) {
                for (Location loc : a.getRooms()) {
                    if (loc.getRoomGroups().contains(p.getRoomGroup())) continue;
                    sLog.info((Object)("Class " + clazz.getClassLabel() + " requires feature " + p.getRoomGroup().getName() + " but assigned room " + loc.getLabel() + " does not have it."));
                    p.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyPreferred));
                    if (p.getOwner() == null) {
                        p.setOwner(clazz);
                    }
                    this.iHibSession.saveOrUpdate((Object)p);
                }
            }
            if (!p.getPrefLevel().getPrefProlog().equals(PreferenceLevel.sProhibited)) continue;
            for (Location loc : a.getRooms()) {
                if (!loc.getRoomGroups().contains(p.getRoomGroup())) continue;
                sLog.info((Object)("Class " + clazz.getClassLabel() + " prohibits feature " + p.getRoomGroup().getName() + " but assigned room " + loc.getLabel() + " does have it."));
                p.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyDiscouraged));
                if (p.getOwner() == null) {
                    p.setOwner(clazz);
                }
                this.iHibSession.saveOrUpdate((Object)p);
            }
        }
    }

    public void fixRoomSharing(Class_ clazz, Assignment a) {
        Set<Location> locs = clazz.getAvailableRooms();
        for (Location loc : a.getRooms()) {
            if (!locs.contains(loc)) {
                sLog.info((Object)("Class " + clazz.getClassLabel() + " is assigned into a room " + loc.getLabel() + " that is not available for " + clazz.getManagingDept().getDeptCode() + " - " + clazz.getManagingDept().getName()));
                RoomDept rd = new RoomDept();
                rd.setControl(false);
                rd.setDepartment(clazz.getManagingDept());
                rd.setRoom(loc);
                clazz.getManagingDept().getRoomDepts().add(rd);
                loc.getRoomDepts().add(rd);
                this.iHibSession.saveOrUpdate((Object)rd);
                RoomPref rp = new RoomPref();
                rp.setOwner(clazz.getManagingDept());
                rp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyDiscouraged));
                rp.setRoom(loc);
                clazz.getManagingDept().getPreferences().add(rp);
                this.iHibSession.saveOrUpdate((Object)clazz.getManagingDept());
            }
            RoomSharingModel m = loc.getRoomSharingModel();
            boolean changed = false;
            Department d = clazz.getManagingDept();
            TimeLocation.IntEnumeration e = a.getTimeLocation().getSlots();
            while (e.hasMoreElements()) {
                int slot = (Integer)e.nextElement();
                if (m.isFreeForAll(slot) || !m.isNotAvailable(slot) && d.getUniqueId().equals(m.getDepartmentId(slot))) continue;
                m.setPreference(slot / 288, slot % 288 / 6, d.getUniqueId().toString());
                changed = true;
            }
            if (!changed) continue;
            sLog.info((Object)("Room sharing changed for room " + loc.getLabel() + " to allow class " + clazz.getClassLabel() + " " + a.getTimeLocation().getLongName(CONSTANTS.useAmPm()) + " in."));
            loc.setRoomSharingModel(m);
            this.iHibSession.saveOrUpdate((Object)loc);
        }
    }

    public static void main(String[] args) {
        try {
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            org.hibernate.Session hibSession = new _RootDAO().getSession();
            Transaction tx = null;
            try {
                tx = hibSession.beginTransaction();
                Session session = Session.getSessionUsingInitiativeYearTerm(ApplicationProperties.getProperty("initiative", "PWL"), ApplicationProperties.getProperty("year", "2014"), ApplicationProperties.getProperty("term", "Spring"));
                if (session == null) {
                    sLog.error((Object)"Academic session not found, use properties initiative, year, and term to set academic session.");
                    System.exit(0);
                } else {
                    sLog.info((Object)("Session: " + session));
                }
                new FixCourseTimetablingInconsistencies(session.getUniqueId()).fixAll(hibSession);
                tx.commit();
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

