/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.ui;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;

public class ViolatedDistrPreferencesReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashSet iGroups = new HashSet();

    public ViolatedDistrPreferencesReport(Solver solver) {
        TimetableModel model = (TimetableModel)solver.currentSolution().getModel();
        Assignment assignment = solver.currentSolution().getAssignment();
        for (GroupConstraint gc : model.getGroupConstraints()) {
            if (gc.isSatisfied(assignment)) continue;
            this.iGroups.add(new ViolatedDistrPreference(solver, gc));
        }
        for (FlexibleConstraint fc : model.getFlexibleConstraints()) {
            if (fc.isHard() || !(((FlexibleConstraint.FlexibleConstraintContext)fc.getContext(assignment)).getPreference() > 0.0)) continue;
            this.iGroups.add(new ViolatedDistrPreference(solver, fc));
        }
    }

    public Set getGroups() {
        return this.iGroups;
    }

    public class ViolatedDistrPreference
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Vector iClasses = new Vector();
        int iPreference = 0;
        int iViolations = 0;
        String iType = null;
        String iName = null;

        public ViolatedDistrPreference(Solver solver, GroupConstraint gc) {
            Assignment assignment = solver.currentSolution().getAssignment();
            this.iPreference = gc.getPreference();
            this.iType = gc.getType().reference();
            this.iName = gc.getName();
            this.iViolations = gc.getCurrentPreference(assignment) / Math.abs(this.iPreference);
            for (Lecture lecture : gc.variables()) {
                if (assignment.getValue((Variable)lecture) == null) continue;
                this.iClasses.add(new ClassAssignmentDetails(solver, lecture, false));
            }
            Collections.sort(this.iClasses);
        }

        public ViolatedDistrPreference(Solver solver, FlexibleConstraint fc) {
            Assignment assignment = solver.currentSolution().getAssignment();
            this.iPreference = Constants.preference2preferenceLevel((String)fc.getPrologPreference());
            this.iType = fc.getReference();
            this.iName = fc.getName();
            this.iViolations = (int)Math.round(fc.getNrViolations(assignment, null, null));
            for (Lecture lecture : fc.variables()) {
                if (assignment.getValue((Variable)lecture) == null) continue;
                this.iClasses.add(new ClassAssignmentDetails(solver, lecture, false));
            }
            Collections.sort(this.iClasses);
        }

        public int getPreference() {
            return this.iPreference;
        }

        public int getNrViolations() {
            return this.iViolations;
        }

        public String getName() {
            return this.iName;
        }

        public String getType() {
            return this.iType;
        }

        public Vector getClasses() {
            return this.iClasses;
        }
    }
}

