/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.ui;

import java.util.ArrayList;
import java.util.Collection;
import org.hibernate.Session;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.solver.ui.UnassignedClassRow;
import org.unitime.timetable.solver.ui.UnassignedClassesModel;

public class SolutionUnassignedClassesModel
extends UnassignedClassesModel {
    private static final long serialVersionUID = 8222974077941239586L;

    public SolutionUnassignedClassesModel(Collection<Solution> solutions, Session hibSession, String instructorFormat, String ... prefix) {
        boolean checkDisplay = ApplicationProperty.TimetableGridUseClassInstructorsCheckClassDisplayInstructors.isTrue();
        boolean checkLead = ApplicationProperty.TimetableGridUseClassInstructorsCheckLead.isTrue();
        for (Solution solution : solutions) {
            for (Class_ clazz : solution.getOwner().getNotAssignedClasses(solution)) {
                String name = clazz.getClassLabel(ApplicationProperty.SolverShowClassSufix.isTrue(), ApplicationProperty.SolverShowConfiguratioName.isTrue());
                if (prefix != null && prefix.length > 0) {
                    boolean hasPrefix = false;
                    for (String p : prefix) {
                        if (p != null && !name.startsWith(p)) continue;
                        hasPrefix = true;
                        break;
                    }
                    if (!hasPrefix) continue;
                }
                ArrayList<String> instructors = new ArrayList<String>();
                if (!checkDisplay || clazz.isDisplayInstructor().booleanValue()) {
                    for (ClassInstructor ci : clazz.getClassInstructors()) {
                        if (!ci.isLead().booleanValue() && checkLead) continue;
                        instructors.add(ci.getInstructor().getName(instructorFormat));
                    }
                }
                int nrStudents = ((Number)hibSession.createQuery("select count(s) from StudentEnrollment as s where s.clazz.uniqueId=:classId and s.solution.uniqueId=:solutionId").setLong("classId", clazz.getUniqueId().longValue()).setInteger("solutionId", solution.getUniqueId().intValue()).uniqueResult()).intValue();
                this.rows().add(new UnassignedClassRow(clazz.getUniqueId(), name, instructors, nrStudents, null, clazz));
            }
        }
    }
}

