/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.instructor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ProblemLoader;
import org.cpsolver.ifs.util.ProblemSaver;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.instructor.model.Attribute;
import org.cpsolver.instructor.model.Course;
import org.cpsolver.instructor.model.EnrolledClass;
import org.cpsolver.instructor.model.Instructor;
import org.cpsolver.instructor.model.InstructorSchedulingModel;
import org.cpsolver.instructor.model.Preference;
import org.cpsolver.instructor.model.Section;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;
import org.dom4j.Document;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.TeachingRequestDAO;
import org.unitime.timetable.server.instructor.InstructorSchedulingBackendHelper;
import org.unitime.timetable.server.instructor.TeachingRequestsFilterBackend;
import org.unitime.timetable.solver.AbstractSolver;
import org.unitime.timetable.solver.SolverDisposeListener;
import org.unitime.timetable.solver.instructor.InstructorSchedulingDatabaseLoader;
import org.unitime.timetable.solver.instructor.InstructorSchedulingDatabaseSaver;
import org.unitime.timetable.solver.instructor.InstructorSchedulingProxy;
import org.unitime.timetable.solver.instructor.InstructorSchedulingSuggestions;

public class InstructorSchedulingSolver
extends AbstractSolver<TeachingRequest.Variable, TeachingAssignment, InstructorSchedulingModel>
implements InstructorSchedulingProxy {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);

    public InstructorSchedulingSolver(DataProperties properties, SolverDisposeListener disposeListener) {
        super(properties, disposeListener);
    }

    @Override
    public SolverParameterGroup.SolverType getType() {
        return SolverParameterGroup.SolverType.INSTRUCTOR;
    }

    @Override
    protected ProblemSaver<TeachingRequest.Variable, TeachingAssignment, InstructorSchedulingModel> getDatabaseSaver(Solver<TeachingRequest.Variable, TeachingAssignment> solver) {
        return new InstructorSchedulingDatabaseSaver(solver);
    }

    @Override
    protected ProblemLoader<TeachingRequest.Variable, TeachingAssignment, InstructorSchedulingModel> getDatabaseLoader(InstructorSchedulingModel model, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
        return new InstructorSchedulingDatabaseLoader(model, assignment);
    }

    @Override
    protected InstructorSchedulingModel createModel(DataProperties properties) {
        return new InstructorSchedulingModel(properties);
    }

    @Override
    protected Document createCurrentSolutionBackup(boolean anonymize, boolean idconv) {
        Progress p;
        if (anonymize) {
            this.getProperties().setProperty("Xml.Anonymize", "true");
            this.getProperties().setProperty("Xml.ShowNames", "false");
            this.getProperties().setProperty("Xml.ConvertIds", idconv ? "true" : "false");
            this.getProperties().setProperty("Xml.SaveInitial", "false");
            this.getProperties().setProperty("Xml.SaveBest", "false");
            this.getProperties().setProperty("Xml.SaveSolution", "true");
        } else {
            this.getProperties().setProperty("Xml.Anonymize", "false");
            this.getProperties().setProperty("Xml.ShowNames", "true");
            this.getProperties().setProperty("Xml.ConvertIds", "false");
            this.getProperties().setProperty("Xml.SaveInitial", "true");
            this.getProperties().setProperty("Xml.SaveBest", "true");
            this.getProperties().setProperty("Xml.SaveSolution", "true");
        }
        InstructorSchedulingModel model = (InstructorSchedulingModel)this.currentSolution().getModel();
        Document document = model.save(this.currentSolution().getAssignment());
        if (document == null) {
            return null;
        }
        if (!anonymize && (p = Progress.getInstance((Object)model)) != null) {
            p.save(document.getRootElement());
        }
        return document;
    }

    @Override
    protected void restureCurrentSolutionFromBackup(Document document) {
        InstructorSchedulingModel model = (InstructorSchedulingModel)this.currentSolution().getModel();
        model.load(document, this.currentSolution().getAssignment());
        Progress p = Progress.getInstance((Object)model);
        if (p != null) {
            p.load(document.getRootElement(), true);
            p.message(4, "Restoring from backup ...");
        }
    }

    protected InstructorInterface.TeachingRequestInfo toRequestInfo(org.cpsolver.instructor.model.TeachingRequest request) {
        InstructorInterface.TeachingRequestInfo info = new InstructorInterface.TeachingRequestInfo();
        info.setRequestId(request.getRequestId());
        info.setLoad(request.getLoad());
        info.setNrInstructors(request.getNrInstructors());
        for (Preference p : request.getAttributePreferences()) {
            info.addAttributePreference(new InstructorInterface.PreferenceInfo(((Attribute)p.getTarget()).getAttributeId(), ((Attribute)p.getTarget()).getAttributeName(), Constants.preferenceLevel2preference((int)p.getPreference())));
        }
        for (Preference p : request.getInstructorPreferences()) {
            info.addInstructorPreference(new InstructorInterface.PreferenceInfo(((Instructor)p.getTarget()).getInstructorId(), ((Instructor)p.getTarget()).getName(), Constants.preferenceLevel2preference((int)p.getPreference())));
        }
        InstructorInterface.CourseInfo course = new InstructorInterface.CourseInfo();
        course.setCourseId(request.getCourse().getCourseId());
        course.setCourseName(request.getCourse().getCourseName());
        info.setCourse(course);
        boolean useAmPm = this.getProperties().getPropertyBoolean("General.UseAmPm", true);
        for (Section section : request.getSections()) {
            InstructorInterface.SectionInfo si = new InstructorInterface.SectionInfo();
            si.setSectionId(section.getSectionId());
            si.setExternalId(section.getExternalId());
            si.setSectionName(section.getSectionName());
            si.setSectionType(section.getSectionType());
            si.setCommon(section.isCommon());
            si.setTime(section.hasTime() ? section.getTimeName(useAmPm) : null);
            si.setDate(section.hasTime() ? section.getTime().getDatePatternName() : null);
            si.setRoom(section.getRoom());
            info.addSection(si);
        }
        return info;
    }

    protected InstructorInterface.InstructorInfo toInstructorInfo(Instructor instructor) {
        boolean useAmPm = this.getProperties().getPropertyBoolean("General.UseAmPm", true);
        InstructorInterface.InstructorInfo info = new InstructorInterface.InstructorInfo();
        info.setInstructorId(instructor.getInstructorId());
        info.setInstructorName(instructor.getName());
        info.setExternalId(instructor.getExternalId());
        info.setMaxLoad(instructor.getMaxLoad());
        for (Preference p : instructor.getCoursePreferences()) {
            info.addCoursePreference(new InstructorInterface.PreferenceInfo(((Course)p.getTarget()).getCourseId(), ((Course)p.getTarget()).getCourseName(), Constants.preferenceLevel2preference((int)p.getPreference())));
        }
        int[][] slot2pref = new int[Constants.NR_DAYS * 288][];
        for (int i = 0; i < slot2pref.length; ++i) {
            slot2pref[i] = new int[]{0, 0, 0};
        }
        for (Preference p : instructor.getTimePreferences()) {
            InstructorInterface.PreferenceInfo pi = new InstructorInterface.PreferenceInfo(Long.valueOf(((TimeLocation)p.getTarget()).hashCode()), ((TimeLocation)p.getTarget()).getLongName(useAmPm), Constants.preferenceLevel2preference((int)p.getPreference()));
            pi.setComparable(String.format("%03d:%05d", ((TimeLocation)p.getTarget()).getDayCode(), ((TimeLocation)p.getTarget()).getStartSlot()));
            info.addTimePreference(pi);
            if (p.getTarget() instanceof EnrolledClass) {
                EnrolledClass ec = (EnrolledClass)p.getTarget();
                InstructorInterface.ClassInfo ci = new InstructorInterface.ClassInfo();
                ci.setCourseId(ec.getCourseId());
                ci.setCourse(ec.getCourse());
                ci.setClassId(ec.getClassId());
                ci.setSection(ec.getSection());
                ci.setExternalId(ec.getExternalId());
                ci.setType(ec.getType());
                ci.setInstructor(ec.isInstructor());
                ci.setRoom(ec.getRoom());
                ci.setTime(ec.getDayHeader() + " " + ec.getStartTimeHeader(useAmPm) + " - " + ec.getEndTimeHeader(useAmPm));
                ci.setDate(ec.getDatePatternName());
                info.addEnrollment(ci);
                TimeLocation.IntEnumeration i = ((TimeLocation)p.getTarget()).getSlots();
                while (i.hasMoreElements()) {
                    int slot = (Integer)i.nextElement();
                    slot2pref[slot][0] = Math.min(slot2pref[slot][0], p.getPreference());
                    slot2pref[slot][1] = Math.max(slot2pref[slot][1], p.getPreference());
                    slot2pref[slot][2] = 1;
                }
                continue;
            }
            TimeLocation.IntEnumeration i = ((TimeLocation)p.getTarget()).getSlots();
            while (i.hasMoreElements()) {
                int slot = (Integer)i.nextElement();
                slot2pref[slot][0] = Math.min(slot2pref[slot][0], p.getPreference());
                slot2pref[slot][1] = Math.max(slot2pref[slot][1], p.getPreference());
                slot2pref[slot][2] = 0;
            }
        }
        StringBuffer pattern = new StringBuffer(slot2pref.length);
        for (int i = 0; i < slot2pref.length; ++i) {
            int pref;
            int max = slot2pref[i][1];
            int min = slot2pref[i][0];
            int n = max > -min ? max : (pref = -min > max ? min : max);
            if (slot2pref[i][2] == 1) {
                pattern.append(PreferenceLevel.prolog2char(PreferenceLevel.sNotAvailable));
                continue;
            }
            pattern.append(PreferenceLevel.prolog2char(Constants.preferenceLevel2preference((int)pref)));
        }
        info.setAvailability(pattern.toString());
        for (Attribute a : instructor.getAttributes()) {
            InstructorInterface.AttributeInterface attribute = new InstructorInterface.AttributeInterface();
            attribute.setId(a.getAttributeId());
            attribute.setName(a.getAttributeName());
            InstructorInterface.AttributeTypeInterface type = new InstructorInterface.AttributeTypeInterface();
            type.setId(a.getType().getTypeId());
            type.setLabel(a.getType().getTypeName());
            type.setConjunctive(a.getType().isConjunctive());
            type.setRequired(a.getType().isRequired());
            attribute.setType(type);
            info.addAttribute(attribute);
        }
        if (instructor.getPreference() != 0) {
            info.setTeachingPreference(Constants.preferenceLevel2preference((int)instructor.getPreference()));
        }
        if (instructor.getBackToBackPreference() != 0) {
            info.addDistributionPreference(new InstructorInterface.PreferenceInfo(1L, CONSTANTS.instructorBackToBack(), Constants.preferenceLevel2preference((int)instructor.getBackToBackPreference())));
        }
        if (instructor.getSameDaysPreference() != 0) {
            info.addDistributionPreference(new InstructorInterface.PreferenceInfo(1L, CONSTANTS.instructorSameDays(), Constants.preferenceLevel2preference((int)instructor.getSameDaysPreference())));
        }
        if (instructor.getSameRoomPreference() != 0) {
            info.addDistributionPreference(new InstructorInterface.PreferenceInfo(1L, CONSTANTS.instructorSameRoom(), Constants.preferenceLevel2preference((int)instructor.getSameRoomPreference())));
        }
        return info;
    }

    protected InstructorInterface.InstructorInfo toInstructorInfo(TeachingAssignment assignment) {
        InstructorInterface.InstructorInfo info = this.toInstructorInfo(assignment.getInstructor());
        info.setAssignmentIndex(((TeachingRequest.Variable)assignment.variable()).getInstructorIndex());
        Instructor.Context context = (Instructor.Context)assignment.getInstructor().getContext(this.currentSolution().getAssignment());
        if (context != null) {
            info.setAssignedLoad(context.getLoad());
        }
        for (Criterion c : ((TeachingRequest.Variable)assignment.variable()).getModel().getCriteria()) {
            double value = c.getValue(this.currentSolution().getAssignment(), (Value)assignment, null);
            if (value == 0.0) continue;
            info.setValue(c.getName(), value);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InstructorInterface.TeachingRequestInfo> getTeachingRequests(EventInterface.FilterRpcRequest filter) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Query q = TeachingRequestsFilterBackend.toQuery(filter);
            ArrayList<InstructorInterface.TeachingRequestInfo> ret = new ArrayList<InstructorInterface.TeachingRequestInfo>();
            for (org.cpsolver.instructor.model.TeachingRequest request : ((InstructorSchedulingModel)this.getModel()).getRequests()) {
                CourseOffering course;
                if (filter.hasOption("offeringId") ? (course = (CourseOffering)CourseOfferingDAO.getInstance().get(request.getCourse().getCourseId())) == null || !filter.getOption("offeringId").equals(course.getInstructionalOffering().getUniqueId().toString()) : (filter.hasOption("subjectId") ? (course = (CourseOffering)CourseOfferingDAO.getInstance().get(request.getCourse().getCourseId())) == null || !filter.getOption("subjectId").equals(course.getSubjectArea().getUniqueId().toString()) : filter.hasOption("subject") && ((course = (CourseOffering)CourseOfferingDAO.getInstance().get(request.getCourse().getCourseId())) == null || !filter.getOption("subject").equalsIgnoreCase(course.getSubjectAreaAbbv())))) continue;
                InstructorInterface.TeachingRequestInfo info = this.toRequestInfo(request);
                for (TeachingRequest.Variable var : request.getVariables()) {
                    TeachingAssignment placement = (TeachingAssignment)this.currentSolution().getAssignment().getValue((Variable)var);
                    if (placement == null) continue;
                    InstructorInterface.InstructorInfo ii = this.toInstructorInfo(placement);
                    ii.setMatchingFilter(q.match(new TeachingRequestsFilterBackend.TeachingRequestMatcher(info, ii, filter)));
                    info.addInstructor(ii);
                }
                if (!q.match(new TeachingRequestsFilterBackend.TeachingRequestMatcher(info, filter))) continue;
                ret.add(info);
            }
            ArrayList<InstructorInterface.TeachingRequestInfo> arrayList = ret;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InstructorInterface.InstructorInfo> getInstructors(EventInterface.FilterRpcRequest filter) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Query q = TeachingRequestsFilterBackend.toQuery(filter);
            ArrayList<InstructorInterface.InstructorInfo> ret = new ArrayList<InstructorInterface.InstructorInfo>();
            HashSet<Long> instructorIds = null;
            if (filter.hasOption("instructorId")) {
                instructorIds = new HashSet<Long>();
                instructorIds.add(Long.valueOf(filter.getOption("instructorId")));
            } else if (filter.hasOption("departmentId")) {
                instructorIds = new HashSet(CourseOfferingDAO.getInstance().getSession().createQuery("select i.uniqueId from DepartmentalInstructor i where i.department.uniqueId = :departmentId").setLong("departmentId", Long.valueOf(filter.getOption("departmentId")).longValue()).list());
            } else if (filter.hasOption("department")) {
                instructorIds = new HashSet(CourseOfferingDAO.getInstance().getSession().createQuery("select i.uniqueId from DepartmentalInstructor i where i.department.deptCode = :deptCode and i.department.session.uniqueId = :sessionId").setString("deptCode", filter.getOption("department")).setLong("sessionId", filter.getSessionId().longValue()).list());
            }
            InstructorSchedulingModel model = (InstructorSchedulingModel)this.currentSolution().getModel();
            for (Instructor instructor : model.getInstructors()) {
                if (instructorIds != null && !instructorIds.contains(instructor.getInstructorId())) continue;
                Instructor.Context context = (Instructor.Context)instructor.getContext(this.currentSolution().getAssignment());
                InstructorInterface.InstructorInfo info = this.toInstructorInfo(instructor);
                info.setAssignedLoad(context.getLoad());
                for (TeachingAssignment assignment : context.getAssignments()) {
                    InstructorInterface.TeachingRequestInfo request = this.toRequestInfo(((TeachingRequest.Variable)assignment.variable()).getRequest());
                    for (Criterion c : model.getCriteria()) {
                        double value = c.getValue(this.currentSolution().getAssignment(), (Value)assignment, null);
                        if (value == 0.0) continue;
                        request.setValue(c.getName(), value);
                        info.addValue(c.getName(), value);
                    }
                    request.setMatchingFilter(q.match(new TeachingRequestsFilterBackend.TeachingRequestMatcher(request, info, filter)));
                    info.addAssignedRequest(request);
                }
                if (!q.match(new TeachingRequestsFilterBackend.TeachingRequestMatcher(info, filter))) continue;
                ret.add(info);
            }
            ArrayList<InstructorInterface.InstructorInfo> arrayList = ret;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstructorInterface.TeachingRequestInfo getTeachingRequestInfo(Long requestId) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            for (org.cpsolver.instructor.model.TeachingRequest request : ((InstructorSchedulingModel)this.getModel()).getRequests()) {
                if (request.getRequestId() != requestId.longValue()) continue;
                InstructorInterface.TeachingRequestInfo info = this.toRequestInfo(request);
                for (TeachingRequest.Variable var : request.getVariables()) {
                    TeachingAssignment placement = (TeachingAssignment)this.currentSolution().getAssignment().getValue((Variable)var);
                    if (placement == null) continue;
                    info.addInstructor(this.toInstructorInfo(placement));
                }
                InstructorInterface.TeachingRequestInfo teachingRequestInfo = info;
                return teachingRequestInfo;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            lock.unlock();
        }
    }

    protected String toHtml(TeachingAssignment assignment) {
        return "<a href='instructorDetail.action?instructorId=" + assignment.getInstructor().getInstructorId() + "'>" + assignment.getInstructor().getName() + "</a>";
    }

    protected String toHtml(org.cpsolver.instructor.model.TeachingRequest request) {
        return "<a href='classDetail.action?cid=" + ((Section)request.getSections().get(0)).getSectionId() + "'>" + request.getCourse().getCourseName() + " " + request.getSections() + "</a>";
    }

    protected String toHtml(TeachingRequest.Variable variable) {
        return "<a href='classDetail.action?cid=" + ((Section)variable.getRequest().getSections().get(0)).getSectionId() + "'>" + variable.getRequest().getCourse().getCourseName() + (variable.getRequest().getNrInstructors() != 1 ? "[" + variable.getInstructorIndex() + "]" : "") + " " + variable.getRequest().getSections() + "</a>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(List<InstructorInterface.AssignmentInfo> assignments) {
        Lock lock = this.currentSolution().getLock().writeLock();
        lock.lock();
        try {
            Progress p = Progress.getInstance(this.getModel());
            ArrayList<TeachingRequest.Variable> variables = new ArrayList<TeachingRequest.Variable>();
            ArrayList<TeachingAssignment> values = new ArrayList<TeachingAssignment>();
            block3: for (InstructorInterface.AssignmentInfo assignment : assignments) {
                for (org.cpsolver.instructor.model.TeachingRequest request : ((InstructorSchedulingModel)this.getModel()).getRequests()) {
                    if (request.getRequestId() != assignment.getRequest().getRequestId().longValue()) continue;
                    TeachingRequest.Variable var = request.getVariable(assignment.getIndex());
                    TeachingAssignment cur = (TeachingAssignment)this.currentSolution().getAssignment().getValue((Variable)var);
                    variables.add(var);
                    if (assignment.getInstructor() == null) continue;
                    for (TeachingAssignment val : var.values(this.currentSolution().getAssignment())) {
                        if (val.getInstructor().getInstructorId() != assignment.getInstructor().getInstructorId().longValue()) continue;
                        values.add(val);
                        p.info(this.toHtml(var) + ": " + (cur == null ? "not assigned" : this.toHtml(cur)) + " &rarr; " + this.toHtml(val));
                        continue block3;
                    }
                    p.info(this.toHtml(var) + ": " + (cur == null ? "not assigned" : this.toHtml(cur)) + " &rarr; not assigned");
                }
            }
            for (TeachingRequest.Variable var : variables) {
                this.currentSolution().getAssignment().unassign(0L, (Variable)var);
            }
            for (TeachingAssignment val : values) {
                this.currentSolution().getAssignment().assign(0L, (Value)val);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstructorInterface.SuggestionsResponse computeSuggestions(InstructorInterface.ComputeSuggestionsRequest request) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            InstructorInterface.SuggestionsResponse suggestionsResponse = new InstructorSchedulingSuggestions(this).computeSuggestions(request);
            return suggestionsResponse;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstructorInterface.InstructorInfo getInstructorInfo(Long instructorId) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            ArrayList<Variable> vars = new ArrayList<Variable>();
            for (Instructor instructor : ((InstructorSchedulingModel)this.getModel()).getInstructors()) {
                if (instructor.getInstructorId() != instructorId.longValue()) continue;
                InstructorInterface.InstructorInfo info = this.toInstructorInfo(instructor);
                Instructor.Context context = (Instructor.Context)instructor.getContext(this.currentSolution().getAssignment());
                if (context != null) {
                    info.setAssignedLoad(context.getLoad());
                    for (TeachingAssignment assignment : context.getAssignments()) {
                        vars.add(assignment.variable());
                        InstructorInterface.TeachingRequestInfo req = this.toRequestInfo(((TeachingRequest.Variable)assignment.variable()).getRequest());
                        for (Criterion c : ((InstructorSchedulingModel)this.getModel()).getCriteria()) {
                            double value = c.getValue(this.currentSolution().getAssignment(), (Value)assignment, null);
                            if (value == 0.0) continue;
                            req.setValue(c.getName(), value);
                        }
                        info.addAssignedRequest(req);
                    }
                }
                if (!vars.isEmpty()) {
                    for (Criterion c : ((InstructorSchedulingModel)this.getModel()).getCriteria()) {
                        double value = c.getValue(this.currentSolution().getAssignment(), vars);
                        if (value == 0.0) continue;
                        info.setValue(c.getName(), value);
                    }
                }
                Iterator iterator = info;
                return iterator;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstructorInterface.AssignmentChangesResponse getAssignmentChanges(InstructorInterface.AssignmentChangesRequest rq) {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            InstructorInterface.AssignmentChangesResponse ret = new InstructorInterface.AssignmentChangesResponse();
            for (org.cpsolver.instructor.model.TeachingRequest request : ((InstructorSchedulingModel)this.getModel()).getRequests()) {
                InstructorInterface.TeachingRequestInfo info = this.toRequestInfo(request);
                if (rq.getType() == InstructorInterface.ChangesType.SAVED) {
                    ArrayList<DepartmentalInstructor> instructors;
                    InstructorSchedulingBackendHelper helper = new InstructorSchedulingBackendHelper();
                    InstructorSchedulingBackendHelper.Context cx = helper.createContext(null, this);
                    TeachingRequest tr = (TeachingRequest)TeachingRequestDAO.getInstance().get(request.getRequestId());
                    ArrayList<DepartmentalInstructor> arrayList = instructors = tr == null ? null : new ArrayList<DepartmentalInstructor>(tr.getAssignedInstructors());
                    if (instructors != null) {
                        Collections.sort(instructors);
                    }
                    for (TeachingRequest.Variable var : request.getVariables()) {
                        InstructorInterface.AssignmentInfo ai;
                        DepartmentalInstructor instructor;
                        TeachingAssignment placement = (TeachingAssignment)this.currentSolution().getAssignment().getValue((Variable)var);
                        if (placement != null) {
                            info.addInstructor(this.toInstructorInfo(placement));
                        }
                        DepartmentalInstructor departmentalInstructor = instructor = var.getInstructorIndex() < instructors.size() ? (DepartmentalInstructor)instructors.get(var.getInstructorIndex()) : null;
                        if (instructor == null) {
                            if (placement == null) continue;
                            ai = new InstructorInterface.AssignmentInfo();
                            ai.setRequest(info);
                            ai.setIndex(var.getInstructorIndex());
                            ret.addChange(ai);
                            continue;
                        }
                        if (placement != null && instructor.getUniqueId().equals(placement.getInstructor().getInstructorId())) continue;
                        ai = new InstructorInterface.AssignmentInfo();
                        ai.setRequest(info);
                        ai.setIndex(var.getInstructorIndex());
                        Instructor instr = null;
                        for (Instructor i : ((InstructorSchedulingModel)this.getModel()).getInstructors()) {
                            if (i.getInstructorId() != instructor.getUniqueId().longValue()) continue;
                            instr = i;
                            break;
                        }
                        if (instr != null) {
                            ai.setInstructor(this.toInstructorInfo(new TeachingAssignment(var, instr)));
                        } else {
                            ai.setInstructor(helper.getInstructorInfo(instructor, cx));
                        }
                        ret.addChange(ai);
                    }
                    continue;
                }
                for (TeachingRequest.Variable var : request.getVariables()) {
                    TeachingAssignment other;
                    TeachingAssignment placement = (TeachingAssignment)this.currentSolution().getAssignment().getValue((Variable)var);
                    if (placement != null) {
                        info.addInstructor(this.toInstructorInfo(placement));
                    }
                    TeachingAssignment teachingAssignment = other = rq.getType() == InstructorInterface.ChangesType.BEST ? (TeachingAssignment)var.getBestAssignment() : (TeachingAssignment)var.getInitialAssignment();
                    if (ToolBox.equals((Object)placement, (Object)other)) continue;
                    InstructorInterface.AssignmentInfo ai = new InstructorInterface.AssignmentInfo();
                    ai.setRequest(info);
                    ai.setIndex(var.getInstructorIndex());
                    ai.setInstructor(other == null ? null : this.toInstructorInfo(other));
                    ret.addChange(ai);
                }
            }
            InstructorInterface.AssignmentChangesResponse assignmentChangesResponse = ret;
            return assignmentChangesResponse;
        }
        finally {
            lock.unlock();
        }
    }
}

