/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.exam.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamInstructor;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.model.Constraint;
import org.hibernate.Session;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.ExamOwnerDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;

public class ExamInfo
implements Serializable,
Comparable<ExamInfo> {
    private static final long serialVersionUID = -4407299089673481581L;
    protected String iExamLabel = null;
    protected Long iExamId = null;
    protected transient org.unitime.timetable.model.Exam iExam = null;
    protected Long iExamTypeId;
    protected transient ExamType iExamType = null;
    protected int iNrStudents;
    protected int iLength;
    protected int iMaxRooms;
    protected int iSeatingType;
    protected int iPrintOffset;
    protected Vector<ExamSectionInfo> iSections = null;
    protected Vector<ExamInstructorInfo> iInstructors = null;
    protected Vector<ExamSectionInfo> iSectionsIncludeCrosslistedDummies = null;

    private ExamInfo() {
    }

    public ExamInfo(Exam exam) {
        this.iExamTypeId = ((ExamModel)exam.getModel()).getProperties().getPropertyLong("Exam.Type", null);
        this.iExamId = exam.getId();
        this.iExamLabel = exam.getName();
        this.iLength = exam.getLength();
        this.iMaxRooms = exam.getMaxRooms();
        this.iNrStudents = exam.getSize();
        int n = this.iSeatingType = exam.hasAltSeating() ? 1 : 0;
        if (!exam.getOwners().isEmpty()) {
            this.iSections = new Vector();
            for (org.cpsolver.exam.model.ExamOwner ecs : exam.getOwners()) {
                HashSet<Long> studentIds = new HashSet<Long>();
                Iterator i = ecs.getStudents().iterator();
                while (i.hasNext()) {
                    studentIds.add(((ExamStudent)i.next()).getId());
                }
                this.iSections.add(new ExamSectionInfo(ecs.getId(), ecs.getName(), studentIds));
            }
        }
        this.iInstructors = new Vector();
        for (Constraint c : exam.constraints()) {
            if (!(c instanceof ExamInstructor)) continue;
            ExamInstructor instructor = (ExamInstructor)c;
            this.iInstructors.add(new ExamInstructorInfo(instructor.getId(), null, instructor.getName()));
        }
        this.iPrintOffset = exam.getPrintOffset() == null ? 0 : exam.getPrintOffset();
    }

    public ExamInfo(org.unitime.timetable.model.Exam exam) {
        this.iExamType = exam.getExamType();
        this.iExamTypeId = exam.getExamType().getUniqueId();
        this.iExamId = exam.getUniqueId();
        this.iExamLabel = exam.getLabel();
        this.iMaxRooms = exam.getMaxNbrRooms();
        this.iExam = exam;
        this.iLength = exam.getLength();
        this.iNrStudents = exam.getExamSize() == null ? -1 : exam.getExamSize();
        this.iSeatingType = exam.getSeatingType();
        this.iPrintOffset = exam.examOffset();
    }

    public Long getExamTypeId() {
        return this.iExamTypeId;
    }

    public String getExamTypeLabel() {
        if (this.iExamType == null && this.iExamTypeId != null) {
            this.iExamType = (ExamType)ExamTypeDAO.getInstance().get(this.iExamTypeId);
        }
        return this.iExamType == null ? "Unknown" : this.iExamType.getLabel();
    }

    public ExamType getExamType() {
        if (this.iExamType == null && this.iExamTypeId != null) {
            this.iExamType = (ExamType)ExamTypeDAO.getInstance().get(this.iExamTypeId);
        }
        return this.iExamType;
    }

    public Long getExamId() {
        return this.iExamId;
    }

    public int getPrintOffset() {
        return this.iPrintOffset;
    }

    public org.unitime.timetable.model.Exam getExam() {
        if (this.iExam == null) {
            this.iExam = (org.unitime.timetable.model.Exam)new ExamDAO().get(this.iExamId);
        }
        return this.iExam;
    }

    public org.unitime.timetable.model.Exam getExam(Session hibSession) {
        return (org.unitime.timetable.model.Exam)new ExamDAO().get(this.iExamId, hibSession);
    }

    public String getExamName() {
        return this.iExamLabel == null ? this.getExam().getLabel() : this.iExamLabel;
    }

    public String getExamNameHtml() {
        String name = this.getExamName();
        if (name.length() > 50) {
            return "<span title='" + name + "'>" + name.substring(0, 50) + "...</span>";
        }
        return name;
    }

    public int getNrStudents() {
        if (this.iNrStudents < 0) {
            HashSet<Long> studentIds = new HashSet<Long>();
            for (ExamSectionInfo section : this.getSections()) {
                studentIds.addAll(section.getStudentIds());
            }
            this.iNrStudents = studentIds.size();
        }
        return this.iNrStudents;
    }

    public int getSeatingType() {
        return this.iSeatingType;
    }

    public String getSeatingTypeLabel() {
        return org.unitime.timetable.model.Exam.getSeatingTypeLabel(this.iSeatingType);
    }

    public int getLength() {
        return this.iLength;
    }

    public int getMaxRooms() {
        return this.iMaxRooms;
    }

    public void createSections(Hashtable<Long, Set<Long>> students) {
        this.iSections = new Vector();
        Iterator<ExamOwner> i = new TreeSet<ExamOwner>(this.getExam().getOwners()).iterator();
        while (i.hasNext()) {
            ExamSectionInfo section = new ExamSectionInfo(i.next());
            if (students != null) {
                HashSet studentsOfOwner = students.get(section.getOwner().getUniqueId());
                section.setStudentIds(studentsOfOwner == null ? new HashSet() : studentsOfOwner);
            }
            this.iSections.add(section);
        }
    }

    public Vector<ExamSectionInfo> getSections() {
        if (this.iSections == null) {
            this.createSections(null);
        }
        return this.iSections;
    }

    public void createSectionsIncludeCrosslistedDummies(Hashtable<Long, Hashtable<Long, Set<Long>>> students) {
        block15: {
            block14: {
                this.iSectionsIncludeCrosslistedDummies = new Vector();
                for (ExamSectionInfo original : this.getSections()) {
                    ExamOwner owner = original.getOwner();
                    if (owner.getCourse().getInstructionalOffering().getCourseOfferings().size() > 1 && owner.getOwnerType() != 1) {
                        Hashtable<Long, Set<Long>> studentsOfOwner = students == null ? null : students.get(owner.getUniqueId());
                        ExamSectionInfo section = new ExamSectionInfo(owner);
                        this.iSectionsIncludeCrosslistedDummies.add(section);
                        for (CourseOffering course : owner.getCourse().getInstructionalOffering().getCourseOfferings()) {
                            if (course.isIsControl().booleanValue()) continue;
                            ExamOwner dummy = new ExamOwner();
                            dummy.setOwnerId(owner.getOwnerId());
                            dummy.setOwnerType(owner.getOwnerType());
                            dummy.setCourse(course);
                            ExamSectionInfo dummySection = new ExamSectionInfo(dummy);
                            dummySection.setMaster(section);
                            if (!section.getSubject().equals(dummy.getSubject()) && "cross-list".equalsIgnoreCase(ApplicationProperty.ExaminationReportsIncludeDifferentSubject.value())) {
                                section.addDifferentSubjectChild(dummySection);
                            }
                            if (students != null) {
                                if (studentsOfOwner != null) {
                                    HashSet studentsOfCourse = studentsOfOwner.get(course.getUniqueId());
                                    dummySection.setStudentIds(studentsOfCourse == null ? new HashSet() : studentsOfCourse);
                                } else {
                                    dummySection.setStudentIds(new HashSet<Long>());
                                }
                            }
                            this.iSectionsIncludeCrosslistedDummies.add(dummySection);
                        }
                        if (students != null) {
                            if (studentsOfOwner != null) {
                                HashSet studentsOfCourse = studentsOfOwner.get(owner.getCourse().getUniqueId());
                                section.setStudentIds(studentsOfCourse == null ? new HashSet() : studentsOfCourse);
                            } else {
                                section.setStudentIds(new HashSet<Long>());
                            }
                        }
                        section.setMaster(section);
                        continue;
                    }
                    this.iSectionsIncludeCrosslistedDummies.add(original);
                }
                if (!"all".equalsIgnoreCase(ApplicationProperty.ExaminationReportsIncludeDifferentSubject.value())) break block14;
                for (ExamSectionInfo s1 : this.iSectionsIncludeCrosslistedDummies) {
                    for (ExamSectionInfo s2 : this.iSectionsIncludeCrosslistedDummies) {
                        if (s1.getSubject().equals(s2.getSubject())) continue;
                        s1.addDifferentSubjectChild(s2);
                    }
                }
                break block15;
            }
            if (!"cross-list all".equalsIgnoreCase(ApplicationProperty.ExaminationReportsIncludeDifferentSubject.value())) break block15;
            for (ExamSectionInfo s1 : this.iSectionsIncludeCrosslistedDummies) {
                for (ExamSectionInfo s2 : this.iSectionsIncludeCrosslistedDummies) {
                    if (s1.getSubject().equals(s2.getSubject()) || s1.getMaster() == null || !s1.getMaster().equals(s2.getMaster())) continue;
                    s1.addDifferentSubjectChild(s2);
                }
            }
        }
    }

    public Vector<ExamSectionInfo> getSectionsIncludeCrosslistedDummies() {
        if (this.iSectionsIncludeCrosslistedDummies == null) {
            this.createSectionsIncludeCrosslistedDummies(null);
        }
        return this.iSectionsIncludeCrosslistedDummies;
    }

    public Set<Long> getStudentIds() {
        HashSet<Long> studentIds = new HashSet<Long>();
        for (ExamSectionInfo section : this.getSections()) {
            studentIds.addAll(section.getStudentIds());
        }
        return studentIds;
    }

    public String getSectionName(String delim) {
        String name = "";
        Enumeration<ExamSectionInfo> e = this.getSections().elements();
        while (e.hasMoreElements()) {
            ExamSectionInfo info = e.nextElement();
            name = name + info.getName();
            if (!e.hasMoreElements()) continue;
            name = name + delim;
        }
        return name;
    }

    public Vector<ExamInstructorInfo> getInstructors() {
        if (this.iInstructors == null) {
            this.iInstructors = new Vector();
            Iterator<DepartmentalInstructor> i = new TreeSet<DepartmentalInstructor>(this.getExam().getInstructors()).iterator();
            while (i.hasNext()) {
                this.iInstructors.add(new ExamInstructorInfo(i.next()));
            }
        }
        return this.iInstructors;
    }

    public boolean hasInstructor(Long instructorId) {
        if (this.iInstructors != null) {
            for (ExamInstructorInfo instructor : this.iInstructors) {
                if (!instructor.getId().equals(instructorId)) continue;
                return true;
            }
        } else {
            Iterator<DepartmentalInstructor> i = this.getExam().getInstructors().iterator();
            while (i.hasNext()) {
                if (!i.next().getUniqueId().equals(instructorId)) continue;
                return true;
            }
        }
        return false;
    }

    public String getInstructorName(String delim) {
        String name = "";
        Enumeration<ExamInstructorInfo> e = this.getInstructors().elements();
        while (e.hasMoreElements()) {
            ExamInstructorInfo info = e.nextElement();
            name = name + info.getName();
            if (!e.hasMoreElements()) continue;
            name = name + delim;
        }
        return name;
    }

    public int hashCode() {
        return this.getExamId().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExamInfo)) {
            return false;
        }
        return ((ExamInfo)o).getExamId().equals(this.getExamId());
    }

    @Override
    public int compareTo(ExamInfo info) {
        int cmp = this.getExamName().compareTo(info.getExamName());
        if (cmp != 0) {
            return cmp;
        }
        return this.getExamId().compareTo(info.getExamId());
    }

    public String toString() {
        return this.getExamName();
    }

    private ExamInstructorInfo instructorInfo(DepartmentalInstructor i) {
        return new ExamInstructorInfo(i);
    }

    public static ExamInstructorInfo createInstructorInfo(DepartmentalInstructor i) {
        return new ExamInfo().instructorInfo(i);
    }

    public boolean isOfSubjectArea(SubjectArea subject) {
        if (subject == null) {
            return true;
        }
        for (ExamSectionInfo section : this.getSections()) {
            if (!subject.equals(section.getOwner().getCourse().getSubjectArea())) continue;
            return true;
        }
        return false;
    }

    public class ExamInstructorInfo
    implements Serializable,
    Comparable<ExamInstructorInfo> {
        private static final long serialVersionUID = -6843290015053081071L;
        protected Long iId;
        protected String iExternalUniqueId = null;
        protected String iName = null;
        protected transient DepartmentalInstructor iInstructor;

        public ExamInstructorInfo(Long id, String externalUniqueId, String name) {
            this.iId = id;
            this.iExternalUniqueId = externalUniqueId;
            this.iName = name;
        }

        public ExamInstructorInfo(DepartmentalInstructor instructor) {
            this.iId = instructor.getUniqueId();
            this.iName = instructor.getNameLastFirst();
            this.iExternalUniqueId = instructor.getExternalUniqueId();
            this.iInstructor = instructor;
        }

        public Long getId() {
            return this.iId;
        }

        public String getName() {
            return this.iName;
        }

        public String getExternalUniqueId() {
            if (this.iExternalUniqueId == null && this.iInstructor == null) {
                this.iExternalUniqueId = this.getInstructor().getExternalUniqueId();
            }
            return this.iExternalUniqueId;
        }

        public DepartmentalInstructor getInstructor() {
            if (this.iInstructor == null) {
                this.iInstructor = (DepartmentalInstructor)new DepartmentalInstructorDAO().get(this.getId());
            }
            return this.iInstructor;
        }

        public ExamInfo getExam() {
            return ExamInfo.this;
        }

        @Override
        public int compareTo(ExamInstructorInfo i) {
            int cmp = this.getName().compareTo(i.getName());
            if (cmp != 0) {
                return cmp;
            }
            return this.getId().compareTo(i.getId());
        }

        public int hashCode() {
            if (this.getExternalUniqueId() != null) {
                return this.getExternalUniqueId().hashCode();
            }
            return this.getId().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ExamInstructorInfo)) {
                return false;
            }
            ExamInstructorInfo i = (ExamInstructorInfo)o;
            if (this.getExternalUniqueId() != null && this.getExternalUniqueId().equals(i.getExternalUniqueId())) {
                return true;
            }
            return this.getId().equals(i.getId());
        }
    }

    public class ExamSectionInfo
    implements Serializable,
    Comparable<ExamSectionInfo> {
        private static final long serialVersionUID = 6052996415395186994L;
        protected Long iId;
        protected String iName;
        protected int iNrStudents = -1;
        protected transient ExamOwner iOwner = null;
        protected Set<Long> iStudentIds = null;
        protected ExamSectionInfo iMaster = null;
        protected List<ExamSectionInfo> iDifferentSubjectChildren = null;

        public ExamSectionInfo(Long id, String name, Set<Long> studentIds) {
            this.iId = id;
            this.iName = name;
            this.iNrStudents = studentIds.size();
            this.iStudentIds = studentIds;
        }

        public ExamSectionInfo(ExamOwner owner) {
            this.iOwner = owner;
            this.iId = owner.getUniqueId();
            this.iName = owner.getLabel();
            this.iStudentIds = null;
        }

        public ExamSectionInfo(ExamOwner owner, Set<Long> studentIds) {
            this(owner);
            if (studentIds != null) {
                this.iNrStudents = studentIds.size();
                this.iStudentIds = studentIds;
            }
        }

        public Set<Long> getStudentIds() {
            if (this.iStudentIds == null) {
                this.iStudentIds = this.getMaster() != null ? new HashSet<Long>(this.getMaster().getOwner().getStudentIds(this.getOwner().getCourse())) : new HashSet<Long>(this.getOwner().getStudentIds());
            }
            this.iNrStudents = this.iStudentIds.size();
            return this.iStudentIds;
        }

        public void setStudentIds(Set<Long> studentIds) {
            this.iStudentIds = studentIds;
            this.iNrStudents = studentIds.size();
        }

        public Long getId() {
            return this.iId;
        }

        public Long getOwnerId() {
            return this.getOwner().getOwnerId();
        }

        public Integer getOwnerType() {
            return this.getOwner().getOwnerType();
        }

        public ExamOwner getOwner() {
            if (this.iOwner == null) {
                this.iOwner = (ExamOwner)new ExamOwnerDAO().get(this.getId());
            }
            return this.iOwner;
        }

        public String getName() {
            return this.iName;
        }

        public int getNrStudents() {
            if (this.iNrStudents < 0) {
                this.iNrStudents = this.getMaster() != null ? this.getMaster().getOwner().getSize(this.getOwner().getCourse()) : this.getOwner().getSize();
            }
            return this.iNrStudents;
        }

        public ExamInfo getExam() {
            return ExamInfo.this;
        }

        public ExamAssignment getExamAssignment() {
            if (ExamInfo.this instanceof ExamAssignment) {
                return (ExamAssignment)ExamInfo.this;
            }
            return null;
        }

        public ExamAssignmentInfo getExamAssignmentInfo() {
            if (ExamInfo.this instanceof ExamAssignmentInfo) {
                return (ExamAssignmentInfo)ExamInfo.this;
            }
            return null;
        }

        public String getSubject() {
            return this.getOwner().getSubject();
        }

        public String getCourseNbr() {
            return this.getOwner().getCourseNbr();
        }

        public String getItype() {
            return this.getOwner().getItype();
        }

        public String getSection() {
            return this.getOwner().getSection();
        }

        @Override
        public int compareTo(ExamSectionInfo info) {
            int cmp = this.getOwner().compareTo(info.getOwner());
            if (cmp != 0) {
                return cmp;
            }
            return this.getExam().compareTo(info.getExam());
        }

        public int hasCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ExamSectionInfo)) {
                return false;
            }
            return this.getId().equals(((ExamSectionInfo)o).getId());
        }

        public String toString() {
            return this.getName();
        }

        public ExamSectionInfo getMaster() {
            return this.iMaster;
        }

        public void setMaster(ExamSectionInfo master) {
            this.iMaster = master;
        }

        public void addDifferentSubjectChild(ExamSectionInfo child) {
            if (this.iDifferentSubjectChildren == null) {
                this.iDifferentSubjectChildren = new ArrayList<ExamSectionInfo>();
            }
            this.iDifferentSubjectChildren.add(child);
        }

        public boolean hasDifferentSubjectChildren() {
            return this.iDifferentSubjectChildren != null && !this.iDifferentSubjectChildren.isEmpty();
        }

        public List<ExamSectionInfo> getDifferentSubjectChildren() {
            return this.iDifferentSubjectChildren;
        }
    }
}

