/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.course.ui;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.Query;
import org.hibernate.Session;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.solver.course.ui.ClassAssignment;
import org.unitime.timetable.solver.course.ui.ClassInstructorInfo;

public class ClassInfo
implements Serializable,
Comparable<ClassInfo> {
    private static final long serialVersionUID = 7324981486913342471L;
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);
    protected String iClassName = null;
    protected String iClassTitle = null;
    protected Long iClassId = null;
    protected transient Class_ iClass = null;
    protected int iNrRooms;
    protected int iLimit;
    protected int iEnrollment;
    protected TreeSet<ClassInstructorInfo> iInstructors = new TreeSet();
    protected Set<Long> iParents = new HashSet<Long>();
    protected Set<Long> iStudents = new HashSet<Long>();
    protected Long iConfigId = null;
    protected boolean iSingleClass = false;

    public ClassInfo(Class_ clazz) {
        this.iClassId = clazz.getUniqueId();
        this.iClassName = clazz.getClassLabel(ApplicationProperty.SolverShowClassSufix.isTrue(), ApplicationProperty.SolverShowConfiguratioName.isTrue());
        this.iClassTitle = clazz.getClassLabelWithTitle();
        this.iClass = clazz;
        this.iNrRooms = clazz.getNbrRooms() == null ? 1 : clazz.getNbrRooms();
        this.iLimit = clazz.getClassLimit();
        this.iEnrollment = clazz.getEnrollment() == null ? 0 : clazz.getEnrollment();
        Iterator<ClassInstructor> i = clazz.getClassInstructors().iterator();
        while (i.hasNext()) {
            this.iInstructors.add(new ClassInstructorInfo(i.next()));
        }
        for (Class_ parent = clazz.getParentClass(); parent != null; parent = parent.getParentClass()) {
            this.iParents.add(parent.getUniqueId());
        }
        this.iStudents.addAll(clazz.getEnrolledStudentIds());
        this.iSingleClass = clazz.getSchedulingSubpart().getClasses().size() == 1;
        this.iConfigId = clazz.getSchedulingSubpart().getInstrOfferingConfig().getUniqueId();
    }

    public Set<Long> getParents() {
        return this.iParents;
    }

    public Set<Long> getStudents() {
        return this.iStudents;
    }

    public Set<ClassInstructorInfo> getInstructors() {
        return this.iInstructors;
    }

    public boolean isSingleClass() {
        return this.iSingleClass;
    }

    public Long getConfligId() {
        return this.iConfigId;
    }

    public String getLeadingInstructorNames(String delim) {
        if (this.getInstructors().isEmpty()) {
            return "";
        }
        String s = "";
        for (ClassInstructorInfo inst : this.getInstructors()) {
            if (!inst.isLead()) continue;
            if (s.length() > 0) {
                s = s + delim;
            }
            s = s + inst.getName();
        }
        return s;
    }

    public String getClassName() {
        return this.iClassName;
    }

    public String getClassNameHtml() {
        return "<span title='" + this.iClassTitle + "'>" + this.iClassName + "</span>";
    }

    public Long getClassId() {
        return this.iClassId;
    }

    public int hashCode() {
        return this.getClassId().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ClassInfo)) {
            return false;
        }
        return this.getClassId().equals(((ClassInfo)o).getClassId());
    }

    @Override
    public int compareTo(ClassInfo classInfo) {
        int cmp = this.getClassName().compareTo(classInfo.getClassName());
        if (cmp != 0) {
            return cmp;
        }
        return this.getClassId().compareTo(classInfo.getClassId());
    }

    public Class_ getClazz() {
        if (this.iClass == null) {
            this.iClass = (Class_)Class_DAO.getInstance().get(this.getClassId());
        }
        return this.iClass;
    }

    public Class_ getClazz(Session hibSession) {
        return (Class_)new Class_DAO().get(this.getClassId(), hibSession);
    }

    public int getNumberOfRooms() {
        return this.iNrRooms;
    }

    public int getClassLimit() {
        return this.iLimit;
    }

    public int getEnrollment() {
        return this.iEnrollment;
    }

    public String getClassDivSec() {
        return this.getClazz().getDivSecNumber();
    }

    public String getRoomRatio() {
        return new DecimalFormat("0.0").format(this.getClazz().getRoomRatio() == null ? 1.0 : (double)this.getClazz().getRoomRatio().floatValue());
    }

    public int getMinRoomCapacity() {
        return this.getClazz().getMinRoomLimit();
    }

    public String getManager() {
        return this.getClazz().getManagingDept().getLabel();
    }

    public boolean shareInstructor(ClassInfo info) {
        for (ClassInstructorInfo i1 : this.getInstructors()) {
            if (!i1.isLead()) continue;
            for (ClassInstructorInfo i2 : info.getInstructors()) {
                if (!i2.isLead() || !i1.equals(i2)) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<ClassAssignment, Set<Long>> findAllRelatedAssignments(Long classId, boolean useRealStudents) {
        HashMap<Long, ClassAssignment> assignments = new HashMap<Long, ClassAssignment>();
        HashMap<ClassAssignment, Set<Long>> conflicts = new HashMap<ClassAssignment, Set<Long>>();
        Query q = null;
        q = !useRealStudents ? LocationDAO.getInstance().getSession().createQuery("select e.clazz.committedAssignment, e.studentId from StudentEnrollment e, StudentEnrollment x where x.clazz.uniqueId = :classId and x.studentId = e.studentId and e.clazz != x.clazz and e.solution.commited = true and x.solution.commited = true and x.solution.owner.session = e.solution.owner.session").setLong("classId", classId.longValue()) : LocationDAO.getInstance().getSession().createQuery("select e.clazz.committedAssignment, e.student.uniqueId from StudentClassEnrollment e, StudentClassEnrollment x where x.clazz.uniqueId = :classId and x.student = e.student and e.clazz != x.clazz ").setLong("classId", classId.longValue());
        for (Object[] line : q.setCacheable(true).list()) {
            HashSet<Long> studentIds;
            Assignment assignment = (Assignment)line[0];
            Long studentId = (Long)line[1];
            ClassAssignment ca = (ClassAssignment)assignments.get(assignment.getClassId());
            if (ca == null) {
                ca = new ClassAssignment(assignment);
                assignments.put(assignment.getClassId(), ca);
            }
            if ((studentIds = (HashSet<Long>)conflicts.get(ca)) == null) {
                studentIds = new HashSet<Long>();
                conflicts.put(ca, studentIds);
            }
            studentIds.add(studentId);
        }
        return conflicts;
    }
}

