/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.sectioning;

import java.util.ArrayList;
import java.util.TreeSet;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.StudentGroup;
import org.cpsolver.studentsct.report.StudentSectioningReport;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;

public class ZeroBreakTimeBackToBacksReport
implements StudentSectioningReport {
    private StudentSectioningModel iModel = null;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    public ZeroBreakTimeBackToBacksReport(StudentSectioningModel model) {
        this.iModel = model;
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    protected String rooms(SctAssignment section) {
        if (section.getNrRooms() == 0) {
            return "";
        }
        String ret = "";
        for (RoomLocation r : section.getRooms()) {
            ret = ret + (ret.isEmpty() ? "" : ",\n") + r.getName();
        }
        return ret;
    }

    protected String curriculum(Student student) {
        String curriculum = "";
        for (AreaClassificationMajor acm : student.getAreaClassificationMajors()) {
            curriculum = curriculum + (curriculum.isEmpty() ? "" : ",\n") + acm.toString();
        }
        return curriculum;
    }

    protected String group(Student student) {
        String group = "";
        TreeSet<String> groups = new TreeSet<String>();
        for (StudentGroup studentGroup : student.getGroups()) {
            groups.add(studentGroup.getReference());
        }
        for (String string : groups) {
            group = group + (group.isEmpty() ? "" : ",\n") + string;
        }
        return group;
    }

    protected String advisor(Student student) {
        String advisors = "";
        for (Instructor instructor : student.getAdvisors()) {
            advisors = advisors + (advisors.isEmpty() ? "" : ",\n") + instructor.getName();
        }
        return advisors;
    }

    public CSVFile createTable(Assignment<Request, Enrollment> assignment, boolean includeLastLikeStudents, boolean includeRealStudents, boolean useAmPm) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)MSG.reportStudentId()), new CSVFile.CSVField((Object)MSG.reportStudentName()), new CSVFile.CSVField((Object)MSG.reportStudentCurriculum()), new CSVFile.CSVField((Object)MSG.reportStudentGroup()), new CSVFile.CSVField((Object)MSG.reportStudentAdvisor()), new CSVFile.CSVField((Object)MSG.reportCourse()), new CSVFile.CSVField((Object)MSG.reportClass()), new CSVFile.CSVField((Object)MSG.reportMeetingTime()), new CSVFile.CSVField((Object)MSG.colRoom()), new CSVFile.CSVField((Object)MSG.reportBTB(MSG.reportCourse())), new CSVFile.CSVField((Object)MSG.reportBTB(MSG.reportClass())), new CSVFile.CSVField((Object)MSG.reportBTB(MSG.reportMeetingTime())), new CSVFile.CSVField((Object)MSG.reportBTB(MSG.colRoom()))});
        for (Student student : this.getModel().getStudents()) {
            if (student.isDummy() && !includeLastLikeStudents || !student.isDummy() && !includeRealStudents) continue;
            for (Request request : student.getRequests()) {
                Enrollment enrollment = (Enrollment)assignment.getValue((Variable)request);
                if (enrollment == null || !enrollment.isCourseRequest()) continue;
                for (Section section : enrollment.getSections()) {
                    TimeLocation time = section.getTime();
                    if (time == null || time.getBreakTime() > 0) continue;
                    for (Request btbRequest : student.getRequests()) {
                        Enrollment btbEnrollment = (Enrollment)assignment.getValue((Variable)btbRequest);
                        if (btbEnrollment == null || !btbEnrollment.isCourseRequest()) continue;
                        for (Section btbSection : btbEnrollment.getSections()) {
                            TimeLocation btbTime = btbSection.getTime();
                            if (btbTime == null || !time.shareWeeks(btbTime) || !time.shareDays(btbTime) || time.getStartSlot() + time.getLength() != btbTime.getStartSlot()) continue;
                            ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                            line.add(new CSVFile.CSVField(student.getId()));
                            line.add(new CSVFile.CSVField((Object)student.getExternalId()));
                            line.add(new CSVFile.CSVField((Object)student.getName()));
                            line.add(new CSVFile.CSVField((Object)this.curriculum(student)));
                            line.add(new CSVFile.CSVField((Object)this.group(student)));
                            line.add(new CSVFile.CSVField((Object)this.advisor(student)));
                            line.add(new CSVFile.CSVField((Object)enrollment.getCourse().getName()));
                            line.add(new CSVFile.CSVField((Object)section.getName(enrollment.getCourse().getId())));
                            line.add(new CSVFile.CSVField((Object)(time.getDayHeader() + " " + time.getStartTimeHeader(useAmPm) + " - " + time.getEndTimeHeader(useAmPm))));
                            line.add(new CSVFile.CSVField((Object)this.rooms((SctAssignment)section)));
                            line.add(new CSVFile.CSVField((Object)btbEnrollment.getCourse().getName()));
                            line.add(new CSVFile.CSVField((Object)btbSection.getName(btbEnrollment.getCourse().getId())));
                            line.add(new CSVFile.CSVField((Object)(btbTime.getDayHeader() + " " + btbTime.getStartTimeHeader(useAmPm) + " - " + btbTime.getEndTimeHeader(useAmPm))));
                            line.add(new CSVFile.CSVField((Object)this.rooms((SctAssignment)btbSection)));
                            csv.addLine(line);
                        }
                    }
                }
            }
        }
        return csv;
    }

    public CSVFile create(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        return this.createTable(assignment, properties.getPropertyBoolean("lastlike", false), properties.getPropertyBoolean("real", true), properties.getPropertyBoolean("useAmPm", true));
    }
}

