/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.interfaces.ExternalCourseOfferingEditAction;
import org.unitime.timetable.interfaces.ExternalInstrOfferingConfigAssignInstructorsAction;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.TeachingRequestDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.instructor.InstructorSchedulingBackendHelper;
import org.unitime.timetable.solver.instructor.InstructorSchedulingProxy;
import org.unitime.timetable.solver.service.SolverService;

@GwtRpcImplements(value=InstructorInterface.InstructorAssignmentRequest.class)
public class InstructorAssignmentBackend
extends InstructorSchedulingBackendHelper
implements GwtRpcImplementation<InstructorInterface.InstructorAssignmentRequest, GwtRpcResponseNull> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    SolverService<InstructorSchedulingProxy> instructorSchedulingSolverService;

    @Override
    public GwtRpcResponseNull execute(InstructorInterface.InstructorAssignmentRequest request, SessionContext context) {
        String className;
        org.hibernate.Session hibSession;
        Hashtable<Long, ArrayList<Long>> touchedOfferingIds;
        HashSet<InstructionalOffering> updateOfferings;
        HashSet<InstrOfferingConfig> updateConfigs;
        block38: {
            context.checkPermission(Right.InstructorSchedulingSolver);
            InstructorSchedulingProxy solver = this.instructorSchedulingSolverService.getSolver();
            if (solver != null) {
                solver.assign(request.getAssignments());
                return new GwtRpcResponseNull();
            }
            Boolean commit = null;
            HashSet<DepartmentalInstructor> updateInstructors = new HashSet<DepartmentalInstructor>();
            updateConfigs = new HashSet<InstrOfferingConfig>();
            updateOfferings = new HashSet<InstructionalOffering>();
            touchedOfferingIds = new Hashtable<Long, ArrayList<Long>>();
            hibSession = DepartmentalInstructorDAO.getInstance().getSession();
            Transaction tx = hibSession.beginTransaction();
            try {
                ArrayList<Long> classIds;
                InstructorSchedulingBackendHelper.InstructorAssignment c;
                InstructorSchedulingBackendHelper.Context cx = new InstructorSchedulingBackendHelper.Context(context, solver);
                InstructorSchedulingBackendHelper.Suggestion s = new InstructorSchedulingBackendHelper.Suggestion(this);
                for (InstructorInterface.AssignmentInfo assignmentInfo : request.getAssignments()) {
                    DepartmentalInstructor instructor;
                    TeachingRequest tr = (TeachingRequest)TeachingRequestDAO.getInstance().get(assignmentInfo.getRequest().getRequestId());
                    if (tr == null) continue;
                    if (commit == null) {
                        commit = Department.isInstructorSchedulingCommitted(tr.getOffering().getDepartment().getUniqueId());
                    }
                    if ((instructor = assignmentInfo.getInstructor() == null ? null : (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(assignmentInfo.getInstructor().getInstructorId())) == null) continue;
                    InstructorInterface.InstructorInfo prev = assignmentInfo.getRequest().getInstructor(assignmentInfo.getIndex());
                    s.set(tr, assignmentInfo.getIndex(), instructor, prev == null ? null : (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(prev.getInstructorId()));
                }
                Iterator conflicts = new HashSet();
                if (!request.isIgnoreConflicts()) {
                    for (InstructorSchedulingBackendHelper.InstructorAssignment a : s.getAssignments()) {
                        s.computeConflicts(a, (Set<InstructorSchedulingBackendHelper.InstructorAssignment>)((Object)conflicts), cx);
                    }
                }
                for (InstructorSchedulingBackendHelper.InstructorAssignment a : s.getAssignments()) {
                    this.unassign(hibSession, a.getTeachingRequest(), a.getCurrentAssignment(), commit);
                }
                Iterator iterator = conflicts.iterator();
                while (iterator.hasNext()) {
                    c = (InstructorSchedulingBackendHelper.InstructorAssignment)iterator.next();
                    this.unassign(hibSession, c.getTeachingRequest(), c.getAssigment(), commit);
                    if (!commit.booleanValue() || c.getAssigment() == null) continue;
                    updateInstructors.add(c.getAssigment());
                    if (c.getTeachingRequest().isAssignCoordinator().booleanValue()) {
                        updateOfferings.add(c.getTeachingRequest().getOffering());
                    }
                    for (TeachingClassRequest tcr : c.getTeachingRequest().getClassRequests()) {
                        if (!tcr.isAssignInstructor().booleanValue()) continue;
                        updateConfigs.add(tcr.getTeachingClass().getSchedulingSubpart().getInstrOfferingConfig());
                        classIds = (ArrayList<Long>)touchedOfferingIds.get(c.getTeachingRequest().getOffering().getUniqueId());
                        if (classIds == null) {
                            classIds = new ArrayList<Long>();
                            touchedOfferingIds.put(c.getTeachingRequest().getOffering().getUniqueId(), classIds);
                        }
                        classIds.add(tcr.getTeachingClass().getUniqueId());
                    }
                }
                for (InstructorSchedulingBackendHelper.InstructorAssignment a : s.getAssignments()) {
                    this.assign(hibSession, a.getTeachingRequest(), a.getAssigment(), commit);
                    if (!commit.booleanValue()) continue;
                    if (a.getCurrentAssignment() != null) {
                        updateInstructors.add(a.getCurrentAssignment());
                    }
                    if (a.getAssigment() != null) {
                        updateInstructors.add(a.getAssigment());
                    }
                    if (a.getTeachingRequest().isAssignCoordinator().booleanValue()) {
                        updateOfferings.add(a.getTeachingRequest().getOffering());
                    }
                    for (TeachingClassRequest tcr : a.getTeachingRequest().getClassRequests()) {
                        if (!tcr.isAssignInstructor().booleanValue()) continue;
                        updateConfigs.add(tcr.getTeachingClass().getSchedulingSubpart().getInstrOfferingConfig());
                        classIds = (List)touchedOfferingIds.get(a.getTeachingRequest().getOffering().getUniqueId());
                        if (classIds == null) {
                            classIds = new ArrayList();
                            touchedOfferingIds.put(a.getTeachingRequest().getOffering().getUniqueId(), classIds);
                        }
                        classIds.add(tcr.getTeachingClass().getUniqueId());
                    }
                }
                Iterator iterator2 = conflicts.iterator();
                while (iterator2.hasNext()) {
                    c = (InstructorSchedulingBackendHelper.InstructorAssignment)iterator2.next();
                    this.changelog(hibSession, c.getTeachingRequest(), c.getAssigment(), null, cx);
                }
                for (InstructorSchedulingBackendHelper.InstructorAssignment a : s.getAssignments()) {
                    this.changelog(hibSession, a.getTeachingRequest(), a.getCurrentAssignment(), a.getAssigment(), cx);
                }
                tx.commit();
                tx = null;
            }
            catch (Exception e) {
                if (tx == null || !tx.isActive()) break block38;
                tx.rollback();
                throw new GwtRpcException(e.getMessage(), e);
            }
        }
        if (!updateConfigs.isEmpty()) {
            try {
                className = ApplicationProperty.ExternalActionInstrOfferingConfigAssignInstructors.value();
                if (className != null && className.trim().length() > 0) {
                    ExternalInstrOfferingConfigAssignInstructorsAction assignAction = (ExternalInstrOfferingConfigAssignInstructorsAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    for (InstrOfferingConfig instrOfferingConfig : updateConfigs) {
                        assignAction.performExternalInstrOfferingConfigAssignInstructorsAction(instrOfferingConfig, hibSession);
                    }
                }
            }
            catch (Exception e) {
                Debug.error("Failed to call external action: " + e.getMessage(), e);
            }
        }
        if (!updateOfferings.isEmpty()) {
            try {
                className = ApplicationProperty.ExternalActionCourseOfferingEdit.value();
                if (className != null && className.trim().length() > 0) {
                    ExternalCourseOfferingEditAction editAction = (ExternalCourseOfferingEditAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    for (InstructionalOffering instructionalOffering : updateOfferings) {
                        editAction.performExternalCourseOfferingEditAction(instructionalOffering, hibSession);
                    }
                }
            }
            catch (Exception e) {
                Debug.error("Failed to call external action: " + e.getMessage(), e);
            }
        }
        if (!touchedOfferingIds.isEmpty()) {
            Long sessionId = context.getUser().getCurrentAcademicSessionId();
            Session session = (Session)SessionDAO.getInstance().get(sessionId, hibSession);
            if (!session.getStatusType().isTestSession()) {
                if (session.getStatusType().canOnlineSectionStudents()) {
                    ArrayList<Long> unlockedOfferings = new ArrayList<Long>();
                    for (Long offeringId : touchedOfferingIds.keySet()) {
                        if (session.isOfferingLocked(offeringId)) continue;
                        unlockedOfferings.add(offeringId);
                    }
                    if (!unlockedOfferings.isEmpty()) {
                        StudentSectioningQueue.offeringChanged(hibSession, context.getUser(), sessionId, unlockedOfferings);
                    }
                } else if (session.getStatusType().canSectionAssistStudents()) {
                    for (Map.Entry entry : touchedOfferingIds.entrySet()) {
                        if (session.isOfferingLocked((Long)entry.getKey())) continue;
                        StudentSectioningQueue.classAssignmentChanged(hibSession, context.getUser(), sessionId, (Collection)entry.getValue());
                    }
                }
            }
            hibSession.flush();
        }
        return new GwtRpcResponseNull();
    }

    protected void unassign(org.hibernate.Session hibSession, TeachingRequest request, DepartmentalInstructor instructor, boolean commit) {
        if (instructor == null) {
            return;
        }
        request.getAssignedInstructors().remove(instructor);
        if (commit) {
            Iterator<Comparable<ClassInstructor>> i;
            if (request.isAssignCoordinator().booleanValue()) {
                i = request.getOffering().getOfferingCoordinators().iterator();
                while (i.hasNext()) {
                    OfferingCoordinator oc = (OfferingCoordinator)i.next();
                    if (!request.equals(oc.getTeachingRequest()) || !instructor.equals(oc.getInstructor())) continue;
                    Debug.info(request.getOffering().getCourseName() + ": UNASSIGN " + instructor.getNameLastFirst());
                    i.remove();
                    hibSession.delete((Object)oc);
                }
            }
            i = instructor.getClasses().iterator();
            while (i.hasNext()) {
                ClassInstructor ci = (ClassInstructor)i.next();
                if (!request.equals(ci.getTeachingRequest())) continue;
                Debug.info(ci.getClassInstructing().getClassLabel(hibSession) + ": UNASSIGN " + instructor.getNameLastFirst());
                ci.getClassInstructing().getClassInstructors().remove(ci);
                i.remove();
                hibSession.delete((Object)ci);
            }
        }
    }

    protected void assign(org.hibernate.Session hibSession, TeachingRequest request, DepartmentalInstructor instructor, boolean commit) {
        if (instructor == null) {
            return;
        }
        request.getAssignedInstructors().add(instructor);
        if (commit) {
            if (request.isAssignCoordinator().booleanValue()) {
                Debug.info(request.getOffering().getCourseName() + ": ASSIGN " + instructor.getNameLastFirst());
                OfferingCoordinator oc = new OfferingCoordinator();
                oc.setInstructor(instructor);
                oc.setOffering(request.getOffering());
                oc.setResponsibility(request.getResponsibility());
                oc.setTeachingRequest(request);
                oc.setPercentShare(request.getPercentShare());
                request.getOffering().getOfferingCoordinators().add(oc);
                hibSession.save((Object)oc);
            }
            for (TeachingClassRequest cr : request.getClassRequests()) {
                if (!cr.isAssignInstructor().booleanValue()) continue;
                Debug.info(cr.getTeachingClass().getClassLabel(hibSession) + ": ASSIGN " + instructor.getNameLastFirst());
                ClassInstructor ci = new ClassInstructor();
                ci.setClassInstructing(cr.getTeachingClass());
                ci.setInstructor(instructor);
                ci.setLead(cr.isLead());
                ci.setPercentShare(cr.getPercentShare());
                ci.setResponsibility(request.getResponsibility());
                ci.setTeachingRequest(request);
                cr.getTeachingClass().getClassInstructors().add(ci);
                instructor.getClasses().add(ci);
                hibSession.saveOrUpdate((Object)ci);
            }
        }
    }

    protected void changelog(org.hibernate.Session hibSession, TeachingRequest request, DepartmentalInstructor oldInstructor, DepartmentalInstructor newInstructor, InstructorSchedulingBackendHelper.Context context) {
        if (oldInstructor != null || newInstructor != null) {
            if (request.isAssignCoordinator().booleanValue()) {
                CourseOffering co = request.getOffering().getControllingCourseOffering();
                ChangeLog.addChange(hibSession, context.getSessionContext(), co, co.getCourseName() + ": " + (oldInstructor == null ? "<i>Not Assigned</i>" : oldInstructor.getName(context.getNameFormat())) + " &rarr; " + (newInstructor == null ? "<i>Not Assigned</i>" : newInstructor.getName(context.getNameFormat())), ChangeLog.Source.INSTRUCTOR_ASSIGNMENT, ChangeLog.Operation.ASSIGN, co.getSubjectArea(), co.getDepartment());
            }
            for (TeachingClassRequest cr : request.getClassRequests()) {
                if (!cr.isAssignInstructor().booleanValue()) continue;
                Class_ clazz = cr.getTeachingClass();
                ChangeLog.addChange(hibSession, context.getSessionContext(), clazz, clazz.getClassLabel(hibSession) + ": " + (oldInstructor == null ? "<i>Not Assigned</i>" : oldInstructor.getName(context.getNameFormat())) + " &rarr; " + (newInstructor == null ? "<i>Not Assigned</i>" : newInstructor.getName(context.getNameFormat())), ChangeLog.Source.INSTRUCTOR_ASSIGNMENT, ChangeLog.Operation.ASSIGN, clazz.getSchedulingSubpart().getInstrOfferingConfig().getControllingCourseOffering().getSubjectArea(), clazz.getControllingDept());
            }
        }
    }
}

