/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.ArrayList;
import java.util.TreeSet;
import org.cpsolver.ifs.util.ToolBox;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.EventServiceProvider;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.EventServiceProviderDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=serviceProviders]")
public class ServiceProviders
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageServiceProvider(), MESSAGES.pageServiceProviders());
    }

    @Override
    @PreAuthorize(value="checkPermission('EventServiceProviders')")
    public SimpleEditInterface load(SessionContext context, org.hibernate.Session hibSession) {
        Long sessionId = context.getUser().getCurrentAcademicSessionId();
        ArrayList<SimpleEditInterface.ListItem> appliesTo = new ArrayList<SimpleEditInterface.ListItem>();
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldAbbreviation(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 60, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldMessage(), SimpleEditInterface.FieldType.textarea, 50, 3, 1000, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldEmailAddress(), SimpleEditInterface.FieldType.text, 300, 200, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldAppliesTo(), SimpleEditInterface.FieldType.list, 300, appliesTo, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldAllRooms(), SimpleEditInterface.FieldType.toggle, 40, SimpleEditInterface.Flag.DEFAULT_CHECKED), new SimpleEditInterface.Field(MESSAGES.fieldVisible(), SimpleEditInterface.FieldType.toggle, 40, SimpleEditInterface.Flag.DEFAULT_CHECKED));
        data.setSortBy(1);
        boolean editGlobal = context.hasPermission(Right.EventServiceProviderEditGlobal);
        if (editGlobal) {
            appliesTo.add(new SimpleEditInterface.ListItem("_global", MESSAGES.levelGlobal()));
        }
        data.setSessionId(sessionId);
        data.setSessionName(((Session)SessionDAO.getInstance().get(sessionId)).getLabel());
        boolean editSession = context.hasPermission(sessionId, "Session", Right.EventServiceProviderEditSession);
        if (editSession) {
            appliesTo.add(new SimpleEditInterface.ListItem("_session", data.getSessionName()));
        }
        data.setEditable(editGlobal || editSession);
        TreeSet<Department> departments = Department.getUserDepartments(context.getUser());
        for (Department department : departments) {
            boolean editDept;
            if (!department.isAllowEvents().booleanValue() || !(editDept = context.hasPermission(department, Right.EventServiceProviderEditDepartment))) continue;
            appliesTo.add(new SimpleEditInterface.ListItem(department.getDeptCode(), department.getDeptCode() + " - " + department.getName()));
            data.setEditable(true);
        }
        for (EventServiceProvider provider : EventServiceProviderDAO.getInstance().getSession().createQuery("from EventServiceProvider where session is null or session = :sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list()) {
            if (provider.getSession() == null) {
                SimpleEditInterface.Record r = data.addRecord(provider.getUniqueId());
                r.setField(0, provider.getReference(), editGlobal);
                r.setField(1, provider.getLabel(), editGlobal);
                r.setField(2, provider.getNote(), editGlobal);
                r.setField(3, provider.getEmail(), editGlobal);
                r.setField(4, editGlobal ? "_global" : MESSAGES.levelGlobal(), false);
                r.setField(5, provider.isAllRooms() != false ? "true" : "false", editGlobal);
                r.setField(6, provider.isVisible() != false ? "true" : "false", editGlobal);
                r.setDeletable(editGlobal && !provider.isUsed());
                continue;
            }
            if (provider.getDepartment() == null) {
                SimpleEditInterface.Record r = data.addRecord(provider.getUniqueId());
                r.setField(0, provider.getReference(), editSession);
                r.setField(1, provider.getLabel(), editSession);
                r.setField(2, provider.getNote(), editSession);
                r.setField(3, provider.getEmail(), editSession);
                r.setField(4, editSession ? "_session" : data.getSessionName(), false);
                r.setField(5, provider.isAllRooms() != false ? "true" : "false", editSession);
                r.setField(6, provider.isVisible() != false ? "true" : "false", editSession);
                r.setDeletable(editSession && !provider.isUsed());
                continue;
            }
            if (!departments.contains(provider.getDepartment())) continue;
            boolean editDept = context.hasPermission(provider.getDepartment(), Right.EventServiceProviderEditDepartment);
            SimpleEditInterface.Record r = data.addRecord(provider.getUniqueId());
            r.setField(0, provider.getReference(), editDept);
            r.setField(1, provider.getLabel(), editDept);
            r.setField(2, provider.getNote(), editDept);
            r.setField(3, provider.getEmail(), editDept);
            r.setField(4, editDept ? provider.getDepartment().getDeptCode() : provider.getDepartment().getDeptCode() + " - " + provider.getDepartment().getName(), false);
            r.setField(5, provider.isAllRooms() != false ? "true" : "false", editDept);
            r.setField(6, provider.isVisible() != false ? "true" : "false", editDept);
            r.setDeletable(editDept && !provider.isUsed());
        }
        return data;
    }

    @Override
    public void save(SimpleEditInterface data, SessionContext context, org.hibernate.Session hibSession) {
        for (EventServiceProvider provider : EventServiceProviderDAO.getInstance().getSession().createQuery("from EventServiceProvider where session is null or session = :sessionId").setLong("sessionId", context.getUser().getCurrentAcademicSessionId().longValue()).setCacheable(true).list()) {
            if (provider.getSession() != null ? (provider.getDepartment() != null ? !context.hasPermission(provider.getDepartment(), Right.EventServiceProviderEditDepartment) : !context.hasPermission(context.getUser().getCurrentAcademicSessionId(), "Session", Right.EventServiceProviderEditSession)) : !context.hasPermission(Right.EventServiceProviderEditGlobal)) continue;
            SimpleEditInterface.Record r = data.getRecord(provider.getUniqueId());
            if (r == null) {
                this.delete(provider, context, hibSession);
                continue;
            }
            this.update(provider, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    public void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        EventServiceProvider provider = new EventServiceProvider();
        provider.setReference(record.getField(0));
        provider.setLabel(record.getField(1));
        provider.setNote(record.getField(2));
        provider.setEmail(record.getField(3));
        provider.setAllRooms(!"false".equalsIgnoreCase(record.getField(5)));
        provider.setVisible(!"false".equalsIgnoreCase(record.getField(6)));
        if ("_global".equals(record.getField(4))) {
            context.checkPermission(Right.EventServiceProviderEditGlobal);
        } else if ("_session".equals(record.getField(4))) {
            provider.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId()));
            context.checkPermission(provider.getSession(), Right.EventServiceProviderEditSession);
        } else {
            provider.setDepartment(Department.findByDeptCode(record.getField(4), context.getUser().getCurrentAcademicSessionId()));
            provider.setSession(provider.getDepartment().getSession());
            context.checkPermission(provider.getDepartment(), Right.EventServiceProviderEditDepartment);
        }
        record.setUniqueId((Long)hibSession.save((Object)provider));
        ChangeLog.addChange(hibSession, context, provider, provider.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(EventServiceProvider provider, SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        if (provider == null) {
            return;
        }
        if (ToolBox.equals((Object)provider.getReference(), (Object)record.getField(0)) && ToolBox.equals((Object)provider.getLabel(), (Object)record.getField(1)) && ToolBox.equals((Object)provider.getNote(), (Object)record.getField(2)) && ToolBox.equals((Object)provider.getEmail(), (Object)record.getField(3)) && ToolBox.equals((Object)provider.isAllRooms(), (Object)"true".equalsIgnoreCase(record.getField(5))) && ToolBox.equals((Object)provider.isAllRooms(), (Object)"true".equalsIgnoreCase(record.getField(6)))) {
            return;
        }
        provider.setReference(record.getField(0));
        provider.setLabel(record.getField(1));
        provider.setNote(record.getField(2));
        provider.setEmail(record.getField(3));
        provider.setAllRooms("true".equalsIgnoreCase(record.getField(5)));
        provider.setVisible("true".equalsIgnoreCase(record.getField(6)));
        hibSession.saveOrUpdate((Object)provider);
        ChangeLog.addChange(hibSession, context, provider, provider.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    public void update(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.update((EventServiceProvider)EventServiceProviderDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(EventServiceProvider provider, SessionContext context, org.hibernate.Session hibSession) {
        if (provider == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, provider, provider.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)provider);
    }

    @Override
    public void delete(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.delete((EventServiceProvider)EventServiceProviderDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

