/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.CourseCreditUnitType;
import org.unitime.timetable.model.dao.CourseCreditUnitTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=creditUnit]")
public class CourseCreditUnits
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageCourseCreditUnit(), MESSAGES.pageCourseCreditUnits());
    }

    @Override
    @PreAuthorize(value="checkPermission('CourseCreditUnits')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 60, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldAbbreviation(), SimpleEditInterface.FieldType.text, 80, 10, new SimpleEditInterface.Flag[0]));
        data.setSortBy(0, 1, 2);
        for (CourseCreditUnitType credit : CourseCreditUnitTypeDAO.getInstance().findAll()) {
            int used = ((Number)hibSession.createQuery("select count(c) from CourseCreditUnitConfig c where c.creditUnitType.uniqueId = :uniqueId").setLong("uniqueId", credit.getUniqueId().longValue()).uniqueResult()).intValue();
            SimpleEditInterface.Record r = data.addRecord(credit.getUniqueId(), used == 0);
            r.setField(0, credit.getReference());
            r.setField(1, credit.getLabel());
            r.setField(2, credit.getAbbreviation());
        }
        data.setEditable(context.hasPermission(Right.CourseCreditUnitEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('CourseCreditUnitEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (CourseCreditUnitType credit : CourseCreditUnitTypeDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.getRecord(credit.getUniqueId());
            if (r == null) {
                this.delete(credit, context, hibSession);
                continue;
            }
            this.update(credit, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('CourseCreditUnitEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        CourseCreditUnitType credit = new CourseCreditUnitType();
        credit.setReference(record.getField(0));
        credit.setLabel(record.getField(1));
        credit.setAbbreviation(record.getField(2));
        record.setUniqueId((Long)hibSession.save((Object)credit));
        ChangeLog.addChange(hibSession, context, credit, credit.getReference() + " " + credit.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(CourseCreditUnitType credit, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (credit == null) {
            return;
        }
        if (ToolBox.equals((Object)credit.getReference(), (Object)record.getField(0)) && ToolBox.equals((Object)credit.getLabel(), (Object)record.getField(1)) && ToolBox.equals((Object)credit.getAbbreviation(), (Object)record.getField(2))) {
            return;
        }
        credit.setReference(record.getField(0));
        credit.setLabel(record.getField(1));
        credit.setAbbreviation(record.getField(2));
        hibSession.saveOrUpdate((Object)credit);
        ChangeLog.addChange(hibSession, context, credit, credit.getReference() + " " + credit.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('CourseCreditUnitEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((CourseCreditUnitType)CourseCreditUnitTypeDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(CourseCreditUnitType credit, SessionContext context, Session hibSession) {
        if (credit == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, credit, credit.getReference() + " " + credit.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)credit);
    }

    @Override
    @PreAuthorize(value="checkPermission('CourseCreditUnitEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((CourseCreditUnitType)CourseCreditUnitTypeDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

