/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.enrollment;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.unitime.commons.Debug;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.StudentClassEnrollmentDAO;
import org.unitime.timetable.reports.AbstractReport;
import org.unitime.timetable.reports.enrollment.PdfEnrollmentAuditReport;

public class MultipleCourseEnrollmentsAuditReport
extends PdfEnrollmentAuditReport {
    public MultipleCourseEnrollmentsAuditReport(int mode, File file, Session session, TreeSet<SubjectArea> subjectAreas, String subTitle) throws DocumentException, IOException {
        super(mode, MultipleCourseEnrollmentsAuditReport.getTitle(), file, session, subjectAreas, subTitle);
    }

    public MultipleCourseEnrollmentsAuditReport(int mode, File file, Session session) throws DocumentException, IOException {
        super(mode, MultipleCourseEnrollmentsAuditReport.getTitle(), file, session);
    }

    @Override
    public void printReport() throws DocumentException {
        this.setHeaderLine(this.buildHeaderString());
        List results = this.getAuditResults(this.getSubjectAreas());
        Vector<AbstractReport.Line> lines = new Vector<AbstractReport.Line>();
        Iterator it = results.iterator();
        while (it.hasNext()) {
            MultipleCourseEnrollmentsAuditResult result = new MultipleCourseEnrollmentsAuditResult((Object[])it.next());
            lines.add(this.buildLineString(result));
        }
        this.printHeader();
        for (AbstractReport.Line str : lines) {
            this.println(str);
        }
        if (!lines.isEmpty()) {
            this.lastPage();
        }
    }

    @Override
    protected List getAuditResults(TreeSet<SubjectArea> subjectAreas) {
        TreeSet<SubjectArea> subjects = new TreeSet<SubjectArea>();
        if (subjectAreas != null && !subjectAreas.isEmpty()) {
            subjects.addAll(subjectAreas);
        } else {
            subjects.addAll(SubjectArea.getSubjectAreaList(this.getSession().getUniqueId()));
        }
        String query = this.createQueryString(subjects);
        Vector results = new Vector();
        for (SubjectArea sa : subjects) {
            Debug.info(MultipleCourseEnrollmentsAuditReport.getTitle() + " - Checking Subject Area:  " + sa.getSubjectAreaAbbreviation());
            results.addAll(StudentClassEnrollmentDAO.getInstance().getQuery(query).setLong("sessId", this.getSession().getUniqueId().longValue()).setLong("subjectId", sa.getUniqueId().longValue()).list());
        }
        return results;
    }

    public static String getTitle() {
        return MSG.reportMultipleCourseEnrollmentsAudit();
    }

    @Override
    protected String createQueryString(TreeSet<SubjectArea> subjectAreas) {
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct s.externalUniqueId, s.lastName, s.firstName, s.middleName,").append(" sce.courseOffering.subjectArea.subjectAreaAbbreviation, sce.courseOffering.courseNbr, sce.courseOffering.title,").append(" s.uniqueId, ss.itype.abbv, ss.uniqueId,").append(" ( select count(sce1) from StudentClassEnrollment sce1").append(" where sce1.clazz.schedulingSubpart.uniqueId = ss.uniqueId and sce1.student.uniqueId = s.uniqueId and sce1.courseOffering = sce.courseOffering) ").append(", sce.courseOffering.uniqueId").append(" from Student s inner join s.classEnrollments as sce, SchedulingSubpart ss").append(" where  ss.instrOfferingConfig.uniqueId = sce.clazz.schedulingSubpart.instrOfferingConfig.uniqueId").append(" and s.session.uniqueId = :sessId").append(" and sce.courseOffering.subjectArea.uniqueId = :subjectId").append(" and 1 < ( select count(sce1) from StudentClassEnrollment sce1").append(" where sce1.clazz.schedulingSubpart.uniqueId = ss.uniqueId and sce1.student.uniqueId = s.uniqueId and sce1.courseOffering = sce.courseOffering)").append(" order by sce.courseOffering.subjectArea.subjectAreaAbbreviation, sce.courseOffering.courseNbr,").append(" sce.courseOffering.title, ss.itype.abbv");
        if (this.isShowId()) {
            sb.append(", s.externalUniqueId");
        } else if (this.isShowName()) {
            sb.append(", s.lastName, s.firstName, s.middleName");
        }
        return sb.toString();
    }

    private AbstractReport.Line buildLineString(MultipleCourseEnrollmentsAuditResult result) {
        return new AbstractReport.Line(this.buildBaseAuditLine(result), new AbstractReport.Line(this.rpad(result.classesListStr(), ' ', multipleClassesLength)));
    }

    private AbstractReport.Line[] buildHeaderString() {
        AbstractReport.Line[] baseHdr = this.getBaseHeader();
        return new AbstractReport.Line[]{new AbstractReport.Line(baseHdr[0], new AbstractReport.Line(this.rpad(MSG.lrMultipleClasses(), ' ', multipleClassesLength))), new AbstractReport.Line(baseHdr[1], new AbstractReport.Line(this.rpad(MSG.lrOfSameSubpart(), ' ', multipleClassesLength))), new AbstractReport.Line(baseHdr[2], new AbstractReport.Line(this.rpad("", '-', multipleClassesLength)))};
    }

    private class MultipleCourseEnrollmentsAuditResult
    extends PdfEnrollmentAuditReport.EnrollmentAuditResult {
        private Long studentUniqueId;
        private Long subpartId;
        private Long courseId;
        private Vector<String> classes;

        public MultipleCourseEnrollmentsAuditResult(Object[] result) {
            super(MultipleCourseEnrollmentsAuditReport.this, result);
            this.classes = new Vector();
            if (result[7] != null) {
                this.studentUniqueId = Long.valueOf(result[7].toString());
            }
            if (result[9] != null) {
                this.subpartId = Long.valueOf(result[9].toString());
            }
            if (result[11] != null) {
                this.courseId = Long.valueOf(result[11].toString());
            }
            this.findClasses();
        }

        private void findClasses() {
            StringBuilder sb = new StringBuilder();
            sb.append("select sce.clazz.schedulingSubpart.itype.abbv, sce.clazz.sectionNumberCache,  sce.clazz.schedulingSubpart.schedulingSubpartSuffixCache").append(" from StudentClassEnrollment sce where sce.student.uniqueId = :studId and sce.clazz.schedulingSubpart.uniqueId = :subpartId and sce.courseOffering.uniqueId = :courseId").append(" order by sce.clazz.sectionNumberCache,  sce.clazz.schedulingSubpart.schedulingSubpartSuffixCache");
            Iterator it = StudentClassEnrollmentDAO.getInstance().getQuery(sb.toString()).setLong("studId", this.studentUniqueId.longValue()).setLong("subpartId", this.subpartId.longValue()).setLong("courseId", this.courseId.longValue()).iterate();
            while (it.hasNext()) {
                Object[] result = (Object[])it.next();
                String className = this.createClassString(result[0].toString(), result[1].toString(), result[2].toString());
                this.classes.add(className);
            }
        }

        public String classesListStr() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String clazz : this.classes) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(clazz);
            }
            return sb.toString();
        }
    }
}

