/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.enrollment;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.unitime.commons.Debug;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.StudentClassEnrollmentDAO;
import org.unitime.timetable.reports.AbstractReport;
import org.unitime.timetable.reports.enrollment.PdfEnrollmentAuditReport;

public class MultipleConfigEnrollmentsAuditReport
extends PdfEnrollmentAuditReport {
    public MultipleConfigEnrollmentsAuditReport(int mode, File file, Session session, TreeSet<SubjectArea> subjectAreas, String subTitle) throws DocumentException, IOException {
        super(mode, MultipleConfigEnrollmentsAuditReport.getTitle(), file, session, subjectAreas, subTitle);
    }

    public MultipleConfigEnrollmentsAuditReport(int mode, File file, Session session) throws DocumentException, IOException {
        super(mode, MultipleConfigEnrollmentsAuditReport.getTitle(), file, session);
    }

    @Override
    public void printReport() throws DocumentException {
        this.setHeaderLine(this.buildHeaderString());
        List results = this.getAuditResults(this.getSubjectAreas());
        Vector<AbstractReport.Line> lines = new Vector<AbstractReport.Line>();
        Iterator it = results.iterator();
        while (it.hasNext()) {
            MultipleConfigEnrollmentsAuditResult result = new MultipleConfigEnrollmentsAuditResult((Object[])it.next());
            lines.add(this.buildLineString(result));
        }
        this.printHeader();
        for (AbstractReport.Line str : lines) {
            this.println(str);
        }
        if (!lines.isEmpty()) {
            this.lastPage();
        }
    }

    @Override
    protected List getAuditResults(TreeSet<SubjectArea> subjectAreas) {
        TreeSet<SubjectArea> subjects = new TreeSet<SubjectArea>();
        if (subjectAreas != null && !subjectAreas.isEmpty()) {
            subjects.addAll(subjectAreas);
        } else {
            subjects.addAll(SubjectArea.getSubjectAreaList(this.getSession().getUniqueId()));
        }
        String query = this.createQueryString(subjects);
        Vector results = new Vector();
        for (SubjectArea sa : subjects) {
            Debug.info(MultipleConfigEnrollmentsAuditReport.getTitle() + " - Checking Subject Area:  " + sa.getSubjectAreaAbbreviation());
            results.addAll(StudentClassEnrollmentDAO.getInstance().getQuery(query).setLong("sessId", this.getSession().getUniqueId().longValue()).setLong("subjectId", sa.getUniqueId().longValue()).list());
        }
        return results;
    }

    public static String getTitle() {
        return MSG.reportMultipleConfigEnrollmentsAudit();
    }

    @Override
    protected String createQueryString(TreeSet<SubjectArea> subjectAreas) {
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct s.externalUniqueId, s.lastName, s.firstName, s.middleName,").append(" sce.courseOffering.subjectArea.subjectAreaAbbreviation, sce.courseOffering.courseNbr, sce.courseOffering.title,").append(" s.uniqueId, sce.courseOffering.uniqueId").append(" from Student s inner join s.classEnrollments as sce").append(" where s.session.uniqueId = :sessId").append(" and sce.courseOffering.subjectArea.uniqueId = :subjectId").append(" and 1 < ( select count(distinct cfg1) from StudentClassEnrollment sce1").append(" inner join sce1.clazz.schedulingSubpart.instrOfferingConfig cfg1").append(" where sce1.courseOffering = sce.courseOffering and sce1.student = sce.student)").append(" order by sce.courseOffering.subjectArea.subjectAreaAbbreviation, sce.courseOffering.courseNbr,").append(" sce.courseOffering.title");
        if (this.isShowId()) {
            sb.append(", s.externalUniqueId");
        } else if (this.isShowName()) {
            sb.append(", s.lastName, s.firstName, s.middleName");
        }
        return sb.toString();
    }

    private AbstractReport.Line buildLineString(MultipleConfigEnrollmentsAuditResult result) {
        return new AbstractReport.Line(this.buildBaseAuditLine(result), new AbstractReport.Line(this.rpad(result.configsListStr(), ' ', multipleClassesLength)));
    }

    private AbstractReport.Line[] buildHeaderString() {
        AbstractReport.Line[] baseHdr = this.getBaseHeader();
        return new AbstractReport.Line[]{new AbstractReport.Line(baseHdr[0], new AbstractReport.Line(this.rpad(MSG.lrMultipleConfigs(), ' ', multipleClassesLength))), new AbstractReport.Line(baseHdr[1], new AbstractReport.Line(this.rpad(MSG.lrOfSameCourse(), ' ', multipleClassesLength))), new AbstractReport.Line(baseHdr[2], new AbstractReport.Line(this.rpad("", '-', multipleClassesLength)))};
    }

    private class MultipleConfigEnrollmentsAuditResult
    extends PdfEnrollmentAuditReport.EnrollmentAuditResult {
        private Long studentUniqueId;
        private Long courseId;
        private TreeSet<String> configs;

        public MultipleConfigEnrollmentsAuditResult(Object[] result) {
            super(MultipleConfigEnrollmentsAuditReport.this, result);
            this.configs = new TreeSet();
            if (result[7] != null) {
                this.studentUniqueId = Long.valueOf(result[7].toString());
            }
            if (result[8] != null) {
                this.courseId = Long.valueOf(result[8].toString());
            }
            this.findConfigs();
        }

        private void findConfigs() {
            StringBuilder sb = new StringBuilder();
            sb.append("select distinct sce.clazz.schedulingSubpart.instrOfferingConfig").append(" from StudentClassEnrollment sce where sce.student.uniqueId = :studId and sce.courseOffering.uniqueId = :courseId");
            Iterator it = StudentClassEnrollmentDAO.getInstance().getQuery(sb.toString()).setLong("studId", this.studentUniqueId.longValue()).setLong("courseId", this.courseId.longValue()).iterate();
            while (it.hasNext()) {
                InstrOfferingConfig result = (InstrOfferingConfig)it.next();
                this.configs.add(result.getName());
            }
        }

        public String configsListStr() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String config : this.configs) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(config);
            }
            return sb.toString();
        }
    }
}

