/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.onlinesectioning.updates.CheckOfferingAction;

@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class ExpireReservationsAction
extends CheckOfferingAction {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        HashSet<Long> recheck = new HashSet<Long>();
        helper.beginTransaction();
        try {
            helper.info("Checking for expired reservations...");
            Hashtable<XOffering, ArrayList<XReservation>> reservations2expire = new Hashtable<XOffering, ArrayList<XReservation>>();
            for (Reservation reservation : helper.getHibSession().createQuery("select r from Reservation r where r.instructionalOffering.session.uniqueId = :sessionId and r.expirationDate is not null and r.expirationDate < current_timestamp()").setLong("sessionId", server.getAcademicSession().getUniqueId().longValue()).list()) {
                XOffering offering = server.getOffering(reservation.getInstructionalOffering().getUniqueId());
                if (offering == null) continue;
                XReservation reservation2 = null;
                for (XReservation r : offering.getReservations()) {
                    if (!r.getReservationId().equals(reservation.getUniqueId())) continue;
                    reservation2 = r;
                    break;
                }
                if (reservation2 == null || reservation2.isExpired()) continue;
                ArrayList<XReservation> reservations = (ArrayList<XReservation>)reservations2expire.get(offering);
                if (reservations == null) {
                    reservations = new ArrayList<XReservation>();
                    reservations2expire.put(offering, reservations);
                }
                reservations.add(reservation2);
            }
            helper.commitTransaction();
            for (Map.Entry entry : reservations2expire.entrySet()) {
                this.expireReservation((XOffering)entry.getKey(), (List)entry.getValue(), recheck, server, helper);
            }
        }
        catch (Exception e) {
            helper.rollbackTransaction();
            if (e instanceof SectioningException) {
                throw (SectioningException)e;
            }
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
        if (!recheck.isEmpty()) {
            helper.info("Re-checking " + recheck.size() + " offerings...");
            server.execute(server.createAction(CheckOfferingAction.class).forOfferings(recheck), helper.getUser());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireReservation(XOffering offering, List<XReservation> reservations, Set<Long> recheckOfferingIds, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (server.isOfferingLocked(offering.getOfferingId())) {
            return;
        }
        OnlineSectioningServer.Lock lock = server.lockOffering(offering.getOfferingId(), null, this.name());
        try {
            for (XReservation reservation : reservations) {
                helper.getAction().addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(reservation.getReservationId()).setType(OnlineSectioningLog.Entity.EntityType.RESERVATION));
                helper.debug("Expiring reservation " + reservation.getReservationId() + "...");
                assert (reservation.isExpired());
            }
            if (server.getAcademicSession().isSectioningEnabled()) {
                this.checkOffering(server, helper, offering, recheckOfferingIds);
            }
        }
        finally {
            lock.release();
        }
    }

    @Override
    public String name() {
        return "expire-reservations";
    }
}

