/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status;

import java.io.Externalizable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentComparator;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusFilterBox;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentSectioningStatusDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GetAssignment;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XOverride;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.status.SectioningStatusFilterAction;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;
import org.unitime.timetable.onlinesectioning.updates.WaitlistedOnlineSectioningAction;
import org.unitime.timetable.solver.studentsct.StudentSolver;

public class FindEnrollmentAction
extends WaitlistedOnlineSectioningAction<List<ClassAssignmentInterface.Enrollment>> {
    private static final long serialVersionUID = 1L;
    protected static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    protected Query iQuery;
    protected Long iCourseId;
    protected Long iClassId;
    protected boolean iConsentToDoCourse;
    protected boolean iCanShowExtIds = false;
    protected boolean iCanRegister = false;
    protected boolean iCanUseAssistant = false;
    protected Set<Long> iMyStudents;
    protected boolean iIsAdmin = false;
    protected boolean iIsAdvisor = false;
    protected boolean iCanEditMyStudents = false;
    protected boolean iCanEditOtherStudents = false;
    protected boolean iCanSelect = false;
    protected SectioningStatusFilterBox.SectioningStatusFilterRpcRequest iFilter = null;

    public FindEnrollmentAction withParams(String query, Long courseId, Long classId, boolean isConsentToDoCourse, boolean canShowExtIds, boolean canRegister, boolean canUseAssistant, Set<Long> myStudents) {
        this.iQuery = new Query(query);
        this.iCourseId = courseId;
        this.iClassId = classId;
        this.iConsentToDoCourse = isConsentToDoCourse;
        this.iCanShowExtIds = canShowExtIds;
        this.iCanRegister = canRegister;
        this.iCanUseAssistant = canUseAssistant;
        this.iMyStudents = myStudents;
        return this;
    }

    public FindEnrollmentAction withPermissions(boolean isAdmin, boolean isAdvisor, boolean canEditMyStudents, boolean canEditOtherStudents, boolean canSelectOtherRole) {
        this.iIsAdmin = isAdmin;
        this.iIsAdvisor = isAdvisor;
        this.iCanEditMyStudents = canEditMyStudents;
        this.iCanEditOtherStudents = canEditOtherStudents;
        this.iCanSelect = canSelectOtherRole;
        return this;
    }

    public FindEnrollmentAction withFilter(SectioningStatusFilterBox.SectioningStatusFilterRpcRequest filter) {
        this.iFilter = filter;
        return this;
    }

    public Query query() {
        return this.iQuery;
    }

    public Long courseId() {
        return this.iCourseId;
    }

    public Long classId() {
        return this.iClassId;
    }

    public boolean isConsentToDoCourse() {
        return this.iConsentToDoCourse;
    }

    public boolean isMyStudent(XStudentId student) {
        return this.iMyStudents != null && this.iMyStudents.contains(student.getStudentId());
    }

    public boolean isCanSelect(XStudentId student) {
        if (this.iIsAdmin) {
            return true;
        }
        return this.iIsAdvisor ? this.iCanEditOtherStudents || this.iCanEditMyStudents && this.isMyStudent(student) : this.iCanSelect;
    }

    @Override
    public List<ClassAssignmentInterface.Enrollment> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        ArrayList<ClassAssignmentInterface.Enrollment> ret = new ArrayList<ClassAssignmentInterface.Enrollment>();
        XCourse course = server.getCourse(this.courseId());
        if (course == null) {
            return ret;
        }
        XOffering offering = server.getOffering(course.getOfferingId());
        if (offering == null) {
            return ret;
        }
        XEnrollments enrollments = server.getEnrollments(course.getOfferingId());
        DistanceMetric m = server.getDistanceMetric();
        XExpectations expectations = server.getExpectations(offering.getOfferingId());
        OverExpectedCriterion overExp = server.getOverExpectedCriterion();
        AcademicSessionInfo session = server.getAcademicSession();
        StatusPageSuggestionsAction.CourseLookup lookup = new StatusPageSuggestionsAction.CourseLookup(session);
        boolean solver = server instanceof StudentSolver;
        Set<Long> studentIds = null;
        if (!solver) {
            studentIds = this.iFilter == null ? null : server.createAction(SectioningStatusFilterAction.class).forRequest(this.iFilter).getStudentIds(server, helper);
        }
        HashSet<String> regStates = new HashSet<String>();
        HashSet<String> assStates = new HashSet<String>();
        HashSet<String> wlStates = new HashSet<String>();
        HashSet<String> noSubStates = new HashSet<String>();
        Session dbSession = (Session)SessionDAO.getInstance().get(session.getUniqueId());
        for (StudentSectioningStatus status : StudentSectioningStatusDAO.getInstance().findAll(helper.getHibSession())) {
            if (StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.enabled) || this.iIsAdmin && StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.admin) || this.iIsAdvisor && StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.advisor)) {
                assStates.add(status.getReference());
            }
            if (StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.regenabled) || this.iIsAdmin && StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.regadmin) || this.iIsAdvisor && StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.regadvisor)) {
                regStates.add(status.getReference());
            }
            if (StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.waitlist)) {
                wlStates.add(status.getReference());
                continue;
            }
            if (!StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.nosubs)) continue;
            noSubStates.add(status.getReference());
        }
        OnlineSectioningInterface.WaitListMode defaultWL = null;
        if (server instanceof StudentSolver) {
            defaultWL = OnlineSectioningInterface.WaitListMode.NoSubs;
        }
        for (XCourseRequest request : enrollments.getRequests()) {
            XStudent student;
            if (request.getEnrollment() != null && !request.getEnrollment().getCourseId().equals(this.courseId()) || this.classId() != null && request.getEnrollment() != null && !request.getEnrollment().getSectionIds().contains(this.classId()) || request.getEnrollment() == null && !request.getCourseIds().contains(course) || studentIds != null && !studentIds.contains(request.getStudentId()) || (student = server.getStudent(request.getStudentId())) == null) continue;
            String status = student.getStatus() == null ? session.getDefaultSectioningStatus() : student.getStatus();
            OnlineSectioningInterface.WaitListMode wl = OnlineSectioningInterface.WaitListMode.None;
            if (defaultWL != null) {
                wl = defaultWL;
            } else if (status == null || wlStates.contains(status)) {
                wl = OnlineSectioningInterface.WaitListMode.WaitList;
            } else if (noSubStates.contains(status)) {
                wl = OnlineSectioningInterface.WaitListMode.NoSubs;
            }
            if (request.getEnrollment() == null && !student.canAssign(request, wl) || !this.query().match(new StatusPageSuggestionsAction.CourseRequestMatcher(session, course, student, offering, request, this.isConsentToDoCourse(), this.isMyStudent(student), lookup, server, wl))) continue;
            if (this.classId() != null && request.getEnrollment() == null) {
                boolean hasEnrollment = false;
                AssignmentMap assignment = new AssignmentMap();
                CourseRequest r = SectioningRequest.convert((Assignment<Request, Enrollment>)assignment, request, server, wl);
                Section s = r.getSection(this.classId().longValue());
                block22: for (Enrollment en : r.values((Assignment)assignment)) {
                    if (!en.getSections().contains(s) || !this.query().match(new StatusPageSuggestionsAction.CourseRequestMatcher(session, course, student, offering, request, this.isConsentToDoCourse(), this.isMyStudent(student), lookup, server, wl).setEnrollment(new XEnrollment(en)))) continue;
                    for (Request x : r.getStudent().getRequests()) {
                        Enrollment xe = (Enrollment)assignment.getValue((Variable)x);
                        if (x.equals((Object)r) || xe == null || !xe.isOverlapping(en)) continue;
                        continue block22;
                    }
                    hasEnrollment = true;
                    break;
                }
                if (!hasEnrollment) continue;
            }
            ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
            st.setId(student.getStudentId());
            st.setSessionId(session.getUniqueId());
            st.setExternalId(student.getExternalId());
            st.setCanShowExternalId(this.iCanShowExtIds);
            st.setWaitListMode(wl);
            st.setCanRegister(this.iCanRegister && (status == null || regStates.contains(status)));
            st.setCanUseAssistant(this.iCanUseAssistant && (status == null || assStates.contains(status)));
            st.setCanSelect(this.isCanSelect(student));
            st.setName(student.getName());
            for (XAreaClassificationMajor acm : student.getMajors()) {
                st.addArea(acm.getArea(), acm.getAreaLabel());
                st.addClassification(acm.getClassification(), acm.getClassificationLabel());
                st.addMajor(acm.getMajor(), acm.getMajorLabel());
                st.addConcentration(acm.getConcentration(), acm.getConcentrationLabel());
                st.addDegree(acm.getDegree(), acm.getDegreeLabel());
                st.addProgram(acm.getProgram(), acm.getProgramLabel());
                st.addCampus(acm.getCampus(), acm.getCampusLabel());
            }
            st.setDefaultCampus(server.getAcademicSession().getCampus());
            for (XAreaClassificationMajor acm : student.getMinors()) {
                st.addMinor(acm.getMajor(), acm.getMajorLabel());
            }
            for (XStudent.XGroup gr : student.getGroups()) {
                st.addGroup(gr.getType(), gr.getAbbreviation(), gr.getTitle());
            }
            for (XStudent.XGroup acc : student.getAccomodations()) {
                st.addAccommodation(acc.getAbbreviation(), acc.getTitle());
            }
            for (XStudent.XAdvisor a : student.getAdvisors()) {
                if (a.getName() == null) continue;
                st.addAdvisor(a.getName());
            }
            ClassAssignmentInterface.Enrollment e = new ClassAssignmentInterface.Enrollment();
            e.setStudent(st);
            e.setPriority(1 + request.getPriority());
            ClassAssignmentInterface.CourseAssignment c = new ClassAssignmentInterface.CourseAssignment();
            c.setCourseId(course.getCourseId());
            c.setSubject(course.getSubjectArea());
            c.setCourseNbr(course.getCourseNumber());
            c.setTitle(course.getTitle());
            c.setHasCrossList(offering.hasCrossList());
            c.setCanWaitList(offering.isWaitList());
            e.setCourse(c);
            e.setWaitList(request.isWaitlist(wl));
            e.setNoSub(request.isNoSub(wl));
            if (request.getEnrollment() == null) {
                XOverride override;
                e.setEnrollmentMessage(request.getEnrollmentMessage());
                if (request.getEnrollment() == null && request.hasOverrides() && (override = request.getOverride(course)) != null && override.getStatus() != null) {
                    switch (CourseRequest.CourseRequestOverrideStatus.values()[override.getStatus()]) {
                        case PENDING: {
                            e.addEnrollmentMessage(MSG.overridePendingShort(course.getCourseName()));
                            break;
                        }
                        case REJECTED: {
                            e.addEnrollmentMessage(MSG.overrideRejectedWaitList(course.getCourseName()));
                            break;
                        }
                        case CANCELLED: {
                            e.addEnrollmentMessage(MSG.overrideCancelledWaitList(course.getCourseName()));
                            break;
                        }
                        case NOT_CHECKED: {
                            e.addEnrollmentMessage(MSG.overrideNotRequested());
                            break;
                        }
                        case NOT_NEEDED: {
                            e.addEnrollmentMessage(MSG.overrideNotNeeded(course.getCourseName()));
                        }
                    }
                }
                if (request.getEnrollment() == null && student.getMaxCreditOverride() != null && student.getMaxCreditOverride().getStatus() != null && student.getMaxCredit() != null && course.hasCredit()) {
                    float credit = 0.0f;
                    for (XRequest r : student.getRequests()) {
                        if (!(r instanceof XCourseRequest) || ((XCourseRequest)r).getEnrollment() == null) continue;
                        credit += ((XCourseRequest)r).getEnrollment().getCredit(server);
                    }
                    if (credit + course.getMinCredit().floatValue() > student.getMaxCredit().floatValue()) {
                        switch (CourseRequest.CourseRequestOverrideStatus.values()[student.getMaxCreditOverride().getStatus()]) {
                            case PENDING: {
                                e.addEnrollmentMessage(MSG.creditStatusPendingShort());
                                break;
                            }
                            case REJECTED: {
                                e.addEnrollmentMessage(MSG.creditStatusDenied());
                                break;
                            }
                            case CANCELLED: {
                                e.addEnrollmentMessage(MSG.creditStatusCancelledWaitList());
                                break;
                            }
                            case NOT_CHECKED: {
                                e.addEnrollmentMessage(MSG.overrideNotRequested());
                            }
                        }
                    }
                }
                if (request.isWaitlist(wl) && offering.isWaitList()) {
                    AssignmentMap assignment = new AssignmentMap();
                    CourseRequest courseRequest = SectioningRequest.convert((Assignment<Request, Enrollment>)assignment, request, server, wl);
                    List enrls = courseRequest.getEnrollmentsSkipSameTime((Assignment)assignment);
                    Iterator<Externalizable> overlap = new TreeSet<Enrollment>(new Comparator<Enrollment>(){

                        @Override
                        public int compare(Enrollment o1, Enrollment o2) {
                            return o1.getRequest().compareTo(o2.getRequest());
                        }
                    });
                    Hashtable<CourseRequest, TreeSet<Section>> overlapingSections = new Hashtable<CourseRequest, TreeSet<Section>>();
                    Object noConfEnrl = null;
                    int nbrEnrl = 0;
                    for (Object enrl : enrls) {
                        if (!course.getCourseId().equals(enrl.getCourse().getId())) continue;
                        ++nbrEnrl;
                        boolean overlaps = false;
                        for (Request q : enrl.getStudent().getRequests()) {
                            if (q.equals((Object)request)) continue;
                            Enrollment x = (Enrollment)assignment.getValue((Variable)q);
                            if (q instanceof FreeTimeRequest) {
                                if (!GetAssignment.isFreeTimeOverlapping((FreeTimeRequest)q, (Enrollment)enrl)) continue;
                                overlaps = true;
                                ((TreeSet)((Object)overlap)).add((Externalizable)((FreeTimeRequest)q).createEnrollment());
                                continue;
                            }
                            if (x == null || x.getAssignments() == null || x.getAssignments().isEmpty()) continue;
                            for (SctAssignment a : x.getAssignments()) {
                                if (!a.isOverlapping(enrl.getAssignments())) continue;
                                overlaps = true;
                                ((TreeSet)((Object)overlap)).add((Externalizable)x);
                                if (!(x.getRequest() instanceof CourseRequest)) continue;
                                CourseRequest cr = (CourseRequest)x.getRequest();
                                TreeSet<Section> ss = (TreeSet<Section>)overlapingSections.get(cr);
                                if (ss == null) {
                                    ss = new TreeSet<Section>((Comparator<Section>)new AssignmentComparator((Assignment)assignment));
                                    overlapingSections.put(cr, ss);
                                }
                                ss.add((Section)a);
                            }
                        }
                        if (overlaps || noConfEnrl != null) continue;
                        noConfEnrl = enrl;
                    }
                    if (noConfEnrl == null) {
                        Object enrl;
                        TreeSet<String> overlaps = new TreeSet<String>();
                        enrl = ((TreeSet)((Object)overlap)).iterator();
                        while (enrl.hasNext()) {
                            Enrollment q = (Enrollment)enrl.next();
                            if (q.getRequest() instanceof FreeTimeRequest) {
                                overlaps.add(OnlineSectioningHelper.toString((FreeTimeRequest)q.getRequest()));
                                continue;
                            }
                            CourseRequest cr = (CourseRequest)q.getRequest();
                            Course o = q.getCourse();
                            String ov = MSG.course(o.getSubjectArea(), o.getCourseNumber());
                            if (((TreeSet)overlapingSections.get(cr)).size() == 1) {
                                Iterator i = ((TreeSet)overlapingSections.get(cr)).iterator();
                                while (i.hasNext()) {
                                    Section s = (Section)i.next();
                                    ov = ov + " " + s.getSubpart().getName();
                                    if (!i.hasNext()) continue;
                                    ov = ov + ",";
                                }
                            }
                            overlaps.add(ov);
                        }
                        if (nbrEnrl == 0) {
                            enrl = courseRequest.getStudent().getUnavailabilities().iterator();
                            block35: while (enrl.hasNext()) {
                                Unavailability unavailability = (Unavailability)enrl.next();
                                for (Config config : courseRequest.getCourse(course.getCourseId().longValue()).getOffering().getConfigs()) {
                                    for (Subpart subpart : config.getSubparts()) {
                                        for (Section section : subpart.getSections()) {
                                            if (!unavailability.isOverlapping((SctAssignment)section)) continue;
                                            overlaps.add(MSG.teachingAssignment(unavailability.getSection().getName()));
                                            continue block35;
                                        }
                                    }
                                }
                            }
                        }
                        if (overlaps != null && !overlaps.isEmpty()) {
                            Object message = null;
                            Iterator i = overlaps.iterator();
                            while (i.hasNext()) {
                                String ov = (String)i.next();
                                if (message == null) {
                                    message = MSG.conflictWithFirst(ov);
                                    continue;
                                }
                                if (i.hasNext()) {
                                    message = (String)message + MSG.conflictWithMiddle(ov);
                                    continue;
                                }
                                message = (String)message + MSG.conflictWithLast(ov);
                            }
                            e.addEnrollmentMessage(message + ".");
                        }
                    }
                }
            }
            if (!request.getCourseIds().get(0).equals(course)) {
                e.setAlternative(request.getCourseIds().get(0).getCourseName());
            }
            if (request.isAlternative()) {
                for (XRequest r : student.getRequests()) {
                    if (!(r instanceof XCourseRequest) || r.isAlternative() || ((XCourseRequest)r).getEnrollment() != null) continue;
                    e.setAlternative(((XCourseRequest)r).getCourseIds().get(0).getCourseName());
                }
            }
            if (request.getTimeStamp() != null) {
                e.setRequestedDate(request.getTimeStamp());
            }
            e.setCritical(request.getCritical());
            if (e.isWaitList() && request.getWaitListedTimeStamp() != null) {
                e.setWaitListedDate(request.getWaitListedTimeStamp());
            }
            e.setWaitListedPosition(this.getWaitListPosition(offering, student, request, course, server, helper));
            if (student.isEnrolled(request.getWaitListSwapWithCourseOffering())) {
                e.setWaitListedReplacement(request.getWaitListSwapWithCourseOffering().getCourseName());
            }
            if (request.getEnrollment() != null) {
                if (request.getEnrollment().getReservation() != null) {
                    switch (request.getEnrollment().getReservation().getType()) {
                        case Individual: 
                        case IndividualOverride: {
                            e.setReservation(MSG.reservationIndividual());
                            break;
                        }
                        case Group: 
                        case GroupOverride: {
                            e.setReservation(MSG.reservationGroup());
                            break;
                        }
                        case Course: {
                            e.setReservation(MSG.reservationCourse());
                            break;
                        }
                        case Curriculum: 
                        case CurriculumOverride: {
                            e.setReservation(MSG.reservationCurriculum());
                            break;
                        }
                        case LearningCommunity: {
                            e.setReservation(MSG.reservationLearningCommunity());
                        }
                    }
                }
                if (request.getEnrollment().getTimeStamp() != null) {
                    e.setEnrolledDate(request.getEnrollment().getTimeStamp());
                }
                if (request.getEnrollment().getApproval() != null) {
                    e.setApprovedDate(request.getEnrollment().getApproval().getTimeStamp());
                    e.setApprovedBy(request.getEnrollment().getApproval().getName());
                }
                for (XSection section : offering.getSections(request.getEnrollment())) {
                    ClassAssignmentInterface.ClassAssignment a = e.getCourse().addClassAssignment();
                    a.setAlternative(request.isAlternative());
                    a.setClassId(section.getSectionId());
                    a.setSubpart(section.getSubpartName());
                    a.setSection(section.getName(course.getCourseId()));
                    a.setExternalId(section.getExternalId(course.getCourseId()));
                    a.setClassNumber(section.getName(-1L));
                    a.setCancelled(section.isCancelled());
                    a.setLimit(new int[]{enrollments.countEnrollmentsForSection(section.getSectionId()), section.getLimit()});
                    if (section.getTime() != null) {
                        for (DayCode d : DayCode.toDayCodes(section.getTime().getDays())) {
                            a.addDay(d.getIndex());
                        }
                        a.setStart(section.getTime().getSlot());
                        a.setLength(section.getTime().getLength());
                        a.setBreakTime(section.getTime().getBreakTime());
                        a.setDatePattern(section.getTime().getDatePatternName());
                    }
                    if (section.getNrRooms() > 0) {
                        for (XRoom rm : section.getRooms()) {
                            a.addRoom(rm.getUniqueId(), rm.getName());
                        }
                    }
                    if (section.getInstructors() != null) {
                        for (XInstructor instructor : section.getInstructors()) {
                            a.addInstructor(instructor.getName());
                            a.addInstructoEmail(instructor.getEmail());
                        }
                    }
                    if (section.getParentId() != null) {
                        a.setParentSection(offering.getSection(section.getParentId()).getName(course.getCourseId()));
                    }
                    a.setSubpartId(section.getSubpartId());
                    a.addNote(course.getNote());
                    a.addNote(section.getNote());
                    XSubpart subpart = offering.getSubpart(section.getSubpartId());
                    a.setCredit(subpart.getCredit(course.getCourseId()));
                    a.setCreditRange(Float.valueOf(subpart.getCreditMin(course.getCourseId())), Float.valueOf(subpart.getCreditMax(course.getCourseId())));
                    Float creditOverride = section.getCreditOverride(c.getCourseId());
                    if (creditOverride != null) {
                        a.setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                    }
                    int dist = 0;
                    String from = null;
                    TreeSet<String> overlap = new TreeSet<String>();
                    for (XRequest q : student.getRequests()) {
                        XEnrollment otherEnrollment;
                        if (!(q instanceof XCourseRequest) || (otherEnrollment = ((XCourseRequest)q).getEnrollment()) == null) continue;
                        XOffering otherOffering = server.getOffering(otherEnrollment.getOfferingId());
                        for (XSection otherSection : otherOffering.getSections(otherEnrollment)) {
                            if (otherSection.equals(section) || otherSection.getTime() == null) continue;
                            int d = otherSection.getDistanceInMinutes(section, m);
                            if (d > dist) {
                                dist = d;
                                from = "";
                                Iterator<XRoom> k = otherSection.getRooms().iterator();
                                while (k.hasNext()) {
                                    from = from + k.next().getName() + (k.hasNext() ? ", " : "");
                                }
                            }
                            if (otherSection.isDistanceConflict(student, section, m)) {
                                a.setDistanceConflict(true);
                            }
                            if (section.getTime() == null || !section.getTime().hasIntersection(otherSection.getTime()) || section.isToIgnoreStudentConflictsWith(offering.getDistributions(), otherSection.getSectionId())) continue;
                            XCourse otherCourse = otherOffering.getCourse(otherEnrollment.getCourseId());
                            XSubpart otherSubpart = otherOffering.getSubpart(otherSection.getSubpartId());
                            overlap.add(MSG.clazz(otherCourse.getSubjectArea(), otherCourse.getCourseNumber(), otherSubpart.getName(), otherSection.getName(otherCourse.getCourseId())));
                        }
                    }
                    if (!overlap.isEmpty()) {
                        String note = null;
                        Iterator j = overlap.iterator();
                        while (j.hasNext()) {
                            String n = (String)j.next();
                            if (note == null) {
                                note = MSG.noteAllowedOverlapFirst(n);
                                continue;
                            }
                            if (j.hasNext()) {
                                note = note + MSG.noteAllowedOverlapMiddle(n);
                                continue;
                            }
                            note = note + MSG.noteAllowedOverlapLast(n);
                        }
                        a.setOverlapNote(note);
                    }
                    a.setBackToBackDistance(dist);
                    a.setBackToBackRooms(from);
                    a.setSaved(true);
                    if (a.getParentSection() == null) {
                        a.setParentSection(course.getConsentLabel());
                    }
                    a.setExpected(overExp.getExpected(section.getLimit(), expectations.getExpectedSpace(section.getSectionId()).doubleValue()));
                }
            }
            ret.add(e);
        }
        return ret;
    }

    @Override
    public String name() {
        return "find-enrollments";
    }
}

