/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.specreg;

import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.base.BaseCourseRequest;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.custom.WaitListValidationProvider;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.updates.ReloadAllData;

public class WaitListSubmitOverrides
implements OnlineSectioningAction<CourseRequestInterface> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private CourseRequestInterface iRequest = null;
    private Float iNeededCredit = null;

    public WaitListSubmitOverrides withRequest(CourseRequestInterface request) {
        this.iRequest = request;
        return this;
    }

    public WaitListSubmitOverrides withCredit(Float neededCredit) {
        this.iNeededCredit = neededCredit;
        return this;
    }

    public Long getStudentId() {
        return this.iRequest.getStudentId();
    }

    public CourseRequestInterface getRequest() {
        return this.iRequest;
    }

    @Override
    public CourseRequestInterface execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (!server.getAcademicSession().isSectioningEnabled() || !Customization.WaitListValidationProvider.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        OnlineSectioningServer.Lock lock = server.lockStudent(this.getStudentId(), null, this.name());
        try {
            helper.beginTransaction();
            try {
                Student student = (Student)StudentDAO.getInstance().get(this.getStudentId(), helper.getHibSession());
                if (student == null) {
                    throw new SectioningException(MSG.exceptionBadStudentId());
                }
                OnlineSectioningLog.Action.Builder action = helper.getAction();
                action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getStudentId()).setExternalId(student.getExternalUniqueId()).setName(helper.getStudentNameFormat().format(student)));
                WaitListValidationProvider provider = (WaitListValidationProvider)Customization.WaitListValidationProvider.getProvider();
                provider.submit(server, helper, this.iRequest, this.iNeededCredit);
                for (CourseDemand courseRequestInterface : student.getCourseDemands()) {
                    if (Boolean.TRUE.equals(courseRequestInterface.getWaitlist()) && !Boolean.TRUE.equals(courseRequestInterface.isAlternative()) && !courseRequestInterface.isEnrolled(true)) continue;
                    for (CourseRequest courseRequest : courseRequestInterface.getCourseRequests()) {
                        if (courseRequest.getCourseRequestOverrideIntent() != CourseRequest.CourseRequestOverrideIntent.WAITLIST) continue;
                        courseRequest.setOverrideExternalId(null);
                        courseRequest.setOverrideTimeStamp(null);
                        courseRequest.setOverrideIntent(null);
                        courseRequest.setOverrideStatus(null);
                        helper.getHibSession().update((Object)courseRequest);
                    }
                }
                for (CourseRequestInterface.Request request : this.getRequest().getCourses()) {
                    if (!request.hasRequestedCourse() || !request.isWaitList()) continue;
                    for (CourseRequestInterface.RequestedCourse requestedCourse : request.getRequestedCourse()) {
                        XCourseId course = server.getCourse(requestedCourse.getCourseId(), requestedCourse.getCourseName());
                        if (course == null) continue;
                        BaseCourseRequest courseRequest = null;
                        block12: for (CourseDemand cd : student.getCourseDemands()) {
                            for (CourseRequest cr : cd.getCourseRequests()) {
                                if (!cr.getCourseOffering().getUniqueId().equals(course.getCourseId())) continue;
                                courseRequest = cr;
                                break block12;
                            }
                        }
                        if (courseRequest == null) continue;
                        if (CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED == requestedCourse.getStatus()) {
                            courseRequest.setOverrideExternalId(null);
                            courseRequest.setOverrideTimeStamp(null);
                            ((CourseRequest)courseRequest).setCourseRequestOverrideIntent(null);
                            ((CourseRequest)courseRequest).setCourseRequestOverrideStatus(null);
                        } else {
                            courseRequest.setOverrideExternalId(requestedCourse.getOverrideExternalId());
                            courseRequest.setOverrideTimeStamp(requestedCourse.getOverrideTimeStamp());
                            ((CourseRequest)courseRequest).setCourseRequestOverrideIntent(CourseRequest.CourseRequestOverrideIntent.WAITLIST);
                            ((CourseRequest)courseRequest).setCourseRequestOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED == requestedCourse.getStatus() ? CourseRequest.CourseRequestOverrideStatus.APPROVED : (CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING == requestedCourse.getStatus() ? CourseRequest.CourseRequestOverrideStatus.PENDING : (CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED == requestedCourse.getStatus() ? CourseRequest.CourseRequestOverrideStatus.CANCELLED : (CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED == requestedCourse.getStatus() ? CourseRequest.CourseRequestOverrideStatus.REJECTED : null))));
                        }
                        if ("TBD".equals(courseRequest.getOverrideExternalId()) && ((CourseRequest)courseRequest).getCourseRequestOverrideIntent() == CourseRequest.CourseRequestOverrideIntent.WAITLIST) {
                            courseRequest.setOverrideExternalId(null);
                            courseRequest.setOverrideTimeStamp(null);
                            ((CourseRequest)courseRequest).setCourseRequestOverrideIntent(null);
                            ((CourseRequest)courseRequest).setCourseRequestOverrideStatus(null);
                        }
                        helper.getHibSession().update((Object)courseRequest);
                    }
                }
                if (student.getMaxCreditOverrideIntent() == CourseRequest.CourseRequestOverrideIntent.WAITLIST || this.getRequest().getMaxCreditOverrideExternalId() != null) {
                    student.setOverrideExternalId(this.getRequest().getMaxCreditOverrideExternalId());
                    student.setOverrideTimeStamp(this.getRequest().getMaxCreditOverrideTimeStamp());
                    student.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED == this.getRequest().getMaxCreditOverrideStatus() ? CourseRequest.CourseRequestOverrideStatus.APPROVED : (CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING == this.getRequest().getMaxCreditOverrideStatus() ? CourseRequest.CourseRequestOverrideStatus.PENDING : (CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED == this.getRequest().getMaxCreditOverrideStatus() ? CourseRequest.CourseRequestOverrideStatus.CANCELLED : (CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED == this.getRequest().getMaxCreditOverrideStatus() ? CourseRequest.CourseRequestOverrideStatus.REJECTED : null))));
                    student.setOverrideMaxCredit(this.getRequest().getMaxCreditOverride());
                    student.setMaxCreditOverrideIntent(this.getRequest().getMaxCreditOverrideExternalId() == null ? null : CourseRequest.CourseRequestOverrideIntent.WAITLIST);
                    helper.getHibSession().update((Object)student);
                }
                XStudent newStudent = null;
                try {
                    newStudent = ReloadAllData.loadStudentNoCheck(student, server, helper);
                    server.update(newStudent, true);
                    for (XRequest r : newStudent.getRequests()) {
                        XCourseRequest xCourseRequest;
                        if (!(r instanceof XCourseRequest) || (xCourseRequest = (XCourseRequest)r).getEnrollment() != null || !xCourseRequest.isWaitlist() || xCourseRequest.isAlternative()) continue;
                        action.addRequest(OnlineSectioningHelper.toProto(r));
                    }
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new SectioningException(MSG.exceptionUnknown(exception.getMessage()), exception);
                }
                if (this.getRequest().hasConfirmations()) {
                    for (CourseRequestInterface.CourseMessage m : this.getRequest().getConfirmations()) {
                        if (!m.hasCourse()) continue;
                        action.addMessageBuilder().setText(m.toString()).setLevel(m.isError() ? OnlineSectioningLog.Message.Level.ERROR : (m.isConfirm() ? OnlineSectioningLog.Message.Level.WARN : OnlineSectioningLog.Message.Level.INFO));
                    }
                }
                if (this.getRequest().hasCreditNote()) {
                    action.addMessageBuilder().setText(this.getRequest().getCreditNote()).setLevel(OnlineSectioningLog.Message.Level.INFO);
                }
                if (this.getRequest().hasCreditWarning()) {
                    action.addMessageBuilder().setText(this.getRequest().getCreditWarning()).setLevel(OnlineSectioningLog.Message.Level.WARN);
                }
                if (this.getRequest().hasErrorMessage()) {
                    action.addMessageBuilder().setText(this.getRequest().getErrorMessaeg()).setLevel(OnlineSectioningLog.Message.Level.ERROR);
                }
                CourseRequestInterface courseRequestInterface = this.iRequest;
                return courseRequestInterface;
            }
            catch (Exception e) {
                helper.error("Failed to save wait-lists: " + e.getMessage(), e);
                helper.rollbackTransaction();
                if (e instanceof SectioningException) {
                    throw (SectioningException)e;
                }
                throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
            }
        }
        finally {
            lock.release();
        }
    }

    @Override
    public String name() {
        return "wait-submit";
    }
}

